<?php
require_once("modules/Trad_desglose/Trad_desglose.php");
require_once("modules/Kardex/Kardex.php");
require_once("modules/Existencias/Existencias.php");
require_once("modules/Flota_renta/Flota_renta.php");
require_once("modules/Flota_renta_det/Flota_renta_det.php");
require_once("modules/Ordenes_trabajo/Ordenes_trabajo.php");
require("duenos.php");
global $adb;

//vd("emitir");
//vd($this->column_fields);

$dueno = $duenos["kdxexi"];
$folio = $this->column_fields["folio"];
$fecha = $this->column_fields["fecha_efectiva"];
$cantidad = 1;
$tra_id = $this->obtener_id();

echo("<h1>Emitiendo $folio...</h1>");

/***************
Pasos:

Completar detalle (trad).
Completar desglose (tdd).
Actualizar desglose.

Completar registros flr.
Inicializar registros flr.

Completar registros de kardex.
Actualizar datos kardex.

Completar registros de existencias.
Actualizar datos sucursal y producto existencias.
Actualizar cantidades existencias.
Actualizar existencias de flr acumulada.

Por cada código en el desglose:
Actualizar saldos kdx.

Completar registros ot.
Actualizar datos ot y equipo.

Completar registros flrd.
Actualizar datos flrd.

Por cada código en el desglose:
Actualizar acumulado flrd.

Actualizar estado y códigos documento.
***************/


echo("<h3>Completando detalle...</h3>");
$incluir = "modules/Traspasos/bd/completar_detalle.php";
require("clyfn/inc/inc.php");
q($consulta);
echo("<b>Listo.</b>");

echo("<h3>Completando desglose...</h3>");
$incluir = "modules/Traspasos/bd/reconstruir_desglose.php";
require("clyfn/inc/inc.php");
//qd($consulta);

$resultado = qr($consulta);
while ($renglon = $adb->fetch_array($resultado))
{
	$desglose = json_decode(utf8($renglon["desglose_equipos"]), true);
	$trad_id = $renglon["traspasos_detid"];
	if ($renglon["cantidad_alta_flota"] == "Acumulada")
	{
		$desglose["enviado"][] = "";
	}
//vd($desglose["enviado"]);

	if ($renglon["tdd_trad_id"] == "")
	{
		//vd("crear");
		foreach ((array)$desglose["enviado"] as $ns_id)
		{
//vd($ns_id);
			$tdd = new Trad_desglose;
			$tdd->column_fields["assigned_user_id"] = $dueno;
			$tdd->column_fields["traspaso"] = $tra_id;
			$tdd->column_fields["partida_traspaso"] = $trad_id;
			$tdd->column_fields["numero_serie"] = $ns_id;
			$tdd->save("Trad_desglose");
		}
	}
	else
	{
		//vd("actualizar");
	}
}
echo("<b>Listo.</b>");

echo("<h3>Actualizando desglose...</h3>");
$incluir = "modules/Traspasos/bd/actualizar_desglose.php";
require("clyfn/inc/inc.php");
//qd($consulta);
q($consulta);
echo("<b>Listo.</b>");


echo("<h3>Completando flota de renta...</h3>");
$incluir = "modules/Traspasos/bd/completar_flr.php";
require("clyfn/inc/inc.php");
$resultado = qr($consulta);
while ($renglon = $adb->fetch_array($resultado))
{
//vd("*");
	$flr_id = $renglon["flota_rentaid"];
	$obr_id = $renglon["obrasid"];
	$tipo_acumulado = $renglon["cantidad_alta_flota"];
	$codigo = $renglon["codigo"];
	$estado = $renglon["estado"];

	if ($flr_id == "" && $tipo_acumulado == "Acumulada")
	{
//vd("crear");
		$flr = new Flota_renta;
		$flr->column_fields["assigned_user_id"] = $duenos["flota"];
		$flr->column_fields["obra"] = $obr_id;
		$flr->column_fields["numero_interno"] = $codigo;
		$flr->column_fields["estado"] = $estado;
		$flr->save("Flota_renta");
	}
	else
	{
//vd("actualizar o ignorar");
	}
}
echo("<b>Listo.</b>");

echo("<h3>Inicializando flota de renta...</h3>");
$incluir = "modules/Traspasos/bd/inicializar_flr.php";
require("clyfn/inc/inc.php");
q($consulta);
echo("<b>Listo.</b>");


echo("<h3>Completando kardex...</h3>");
$incluir = "modules/Traspasos/bd/completar_kardex.php";
require("clyfn/inc/inc.php");
$resultado = qr($consulta);
while ($renglon = $adb->fetch_array($resultado))
{
	$alm_id = $renglon["alm_id"];
	$codigo = $renglon["codigo"];

	if ($renglon["kardexid"] == "")
	{
		//vd("crear");
		$kdx = new Kardex;
		$kdx->column_fields["assigned_user_id"] = $dueno;
		$kdx->column_fields["almacen"] = $alm_id;
		$kdx->column_fields["movimiento"] = $folio;
		$kdx->column_fields["codigo"] = $codigo;
		$kdx->save("Kardex");
	}
	else
	{
		//vd("actualizar");
	}
}
echo("<b>Listo.</b>");

echo("<h3>Actualizando kardex...</h3>");
$incluir = "modules/Traspasos/bd/actualizar_kardex.php";
require("clyfn/inc/inc.php");
q($consulta);
echo("<b>Listo.</b>");


echo("<h3>Completando existencias...</h3>");
$incluir = "modules/Traspasos/bd/completar_existencias.php";
require("clyfn/inc/inc.php");
$resultado = qr($consulta);
while ($renglon = $adb->fetch_array($resultado))
{
//vd("*");
	$alm_id = $renglon["almacenesid"];
	$codigo = $renglon["codigo"];

	if ($renglon["exi_id"] == "")
	{
//vd("crear");
		$exi = new Existencias;
		$exi->column_fields["assigned_user_id"] = $dueno;
		$exi->column_fields["almacen"] = $alm_id;
		$exi->column_fields["codigo_producto"] = $codigo;
		$exi->save("Existencias");
	}
	else
	{
//vd("actualizar");
	}
}
echo("<b>Listo.</b>");


echo("<h3>Reconstruyendo datos relacionados de existencias...</h3>");
$incluir = "modules/Traspasos/bd/reconstruir_existencias.php";
require("clyfn/inc/inc.php");
q($consulta);
echo("<b>Listo.</b>");

echo("<h3>Actualizando existencias...</h3>");
$incluir = "modules/Traspasos/bd/actualizar_existencias.php";
require("clyfn/inc/inc.php");
q($consulta);
echo("<b>Listo.</b>");

echo("<h3>Actualizando existencias de flota de tipo acumulado...</h3>");
$incluir = "modules/Traspasos/bd/actualizar_flr_exi.php";
require("clyfn/inc/inc.php");
q($consulta);
echo("<b>Listo.</b>");

echo("<h3>Actualizando saldos de kardex...</h3>");
// Se reutiliza consulta completar kardex para barrido y se usa función para evitar conflicto con variables existentes.
$incluir = "modules/Traspasos/bd/completar_kardex.php";
require("clyfn/inc/inc.php");
$resultado = qr($consulta);
while ($renglon = $adb->fetch_array($resultado))
{
	$parametros["folio"] = $folio;
	$parametros["alm_id"] = $renglon["alm_id"];
	$parametros["codigo"] = $renglon["codigo"];
	$this->actualizar_saldos_kdx($parametros);
}
echo("<b>Listo.</b>");


echo("<h3>Completando órdenes de trabajo...</h3>");
$incluir = "modules/Traspasos/bd/completar_ot.php";
require("clyfn/inc/inc.php");
$resultado = qr($consulta);
while ($renglon = $adb->fetch_array($resultado))
{
//vd("*");
	$ot_id = $renglon["ordenes_trabajoid"];
	$flr_id = $renglon["flota_rentaid"];
	$suc_id = $renglon["sucursalesid"];
	$obr_id = $renglon["obrasid"];
	//$tipo_acumulado = $renglon["cantidad_alta_flota"];
	$folio = $renglon["folio"];
	//$estado = $renglon["estado"];

	if ($ot_id == "")
	{
//vd("crear");
		$ot = new Ordenes_trabajo;
		$ot->column_fields["assigned_user_id"] = $duenos["servicio"];
		$ot->column_fields["movimiento"] = $folio;
		$ot->column_fields["sucursal"] = $suc_id;
		$ot->column_fields["obra"] = $obr_id;
		$ot->column_fields["equipo"] = $flr_id;
		$ot->save("Ordenes_trabajo");
		$ot->asignar_folio();
	}
	else
	{
//vd("actualizar");
	}
}
echo("<b>Listo.</b>");

echo("<h3>Actualizando órdenes de trabajo y estados de equipos...</h3>");
$incluir = "modules/Traspasos/bd/actualizar_ot.php";
require("clyfn/inc/inc.php");
q($consulta);
echo("<b>Listo.</b>");


echo("<h3>Completando detalle de flota...</h3>");
$incluir = "modules/Traspasos/bd/completar_flrd.php";
require("clyfn/inc/inc.php");
$resultado = qr($consulta);
while ($renglon = $adb->fetch_array($resultado))
{
//vd("*");
	$flrd_id = $renglon["flota_renta_detid"];

	if ($flrd_id == "")
	{
//vd("crear");
		$flrd = new Flota_renta_det;
		$flrd->column_fields["assigned_user_id"] = $duenos["flota"];
		$flrd->column_fields["flota_renta"] = $renglon["flota_rentaid"];
		$flrd->column_fields["documento"] = $folio;
		$flrd->column_fields["cantidad"] = $renglon["flrd_cantidad"];
		$flrd->column_fields["cliente"] = $renglon["accountid"];
		$flrd->column_fields["obra"] = $renglon["obrasid"];
		$flrd->column_fields["fecha_efectiva"] = $fecha;
		$flrd->save("Flota_renta_det");
	}
	else
	{
//vd("actualizar");
	}
}
echo("<b>Listo.</b>");

echo("<h3>Actualizando detalle de flota...</h3>");
$incluir = "modules/Traspasos/bd/actualizar_flrd.php";
require("clyfn/inc/inc.php");
q($consulta);
echo("<b>Listo.</b>");

echo("<h3>Actualizando acumulado de detalle de flota...</h3>");
// Se barre flrd y se usa función para evitar conflicto con variables existentes.
$incluir = "modules/Traspasos/bd/barrer_flrd.php";
require("clyfn/inc/inc.php");
$resultado = qr($consulta);
while ($renglon = $adb->fetch_array($resultado))
{
	$parametros["fecha"] = $fecha;
	$parametros["obr_id"] = $renglon["obrasid"];
	//$parametros["flr_id"] = $renglon["flota_rentaid"];
	$parametros["numero_interno"] = $renglon["numero_interno"];
	$this->actualizar_flrd_acumulado($parametros);
}
echo("<b>Listo.</b>");
//vdd("pausa");

echo("<h3>Actualizando estado documento y códigos de búsqueda...</h3>");
$incluir = "modules/Traspasos/bd/actualizar_traspaso.php";
require("clyfn/inc/inc.php");
q($consulta);
echo("<b>Listo.</b>");

//vd("emitido");
$this->dirigir("DetailView");
?>
