<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/
require_once('data/CRMEntity.php');
require_once('data/Tracker.php');
require_once("modules/Accounts/Accounts.php");
require_once("modules/Obras/Obras.php");
require_once("modules/Almacenes/Almacenes.php");

class Sucursales extends CRMEntity {
	var $db, $log; // Used in class functions of CRMEntity

	var $table_name = 'vtiger_sucursales';
	var $table_index= 'sucursalesid';
	var $column_fields = Array();

	/** Indicator if this is a custom module or standard module */
	var $IsCustomModule = true;

	/**
	 * Mandatory table for supporting custom fields.
	 */
	var $customFieldTable = Array('vtiger_sucursalescf', 'sucursalesid');

	/**
	 * Mandatory for Saving, Include tables related to this module.
	 */
	var $tab_name = Array('vtiger_crmentity', 'vtiger_sucursales', 'vtiger_sucursalescf');

	/**
	 * Mandatory for Saving, Include tablename and tablekey columnname here.
	 */
	var $tab_name_index = Array(
		'vtiger_crmentity' => 'crmid',
		'vtiger_sucursales'   => 'sucursalesid',
	    'vtiger_sucursalescf' => 'sucursalesid');

	/**
	 * Mandatory for Listing (Related listview)
	 */
	var $list_fields = Array (
		/* Format: Field Label => Array(tablename, columnname) */
		// tablename should not have prefix 'vtiger_'
		//'Sucursales Name'=> Array('sucursales', 'idv'),
		//'Assigned To' => Array('crmentity','smownerid')
		'Nombre'=> Array('sucursales', 'nombre'),
		'Domicilio'=> Array('sucursales', 'domicilio'),
	);
	var $list_fields_name = Array(
		/* Format: Field Label => fieldname */
		//'Sucursales Name'=> 'idv',
		//'Assigned To' => 'assigned_user_id'
		'Nombre'=> 'nombre',
		'Domicilio'=> 'domicilio',
	);

	// Make the field link to detail view from list view (Fieldname)
	//var $list_link_field = 'idv';
	var $list_link_field = 'nombre';

	// For Popup listview and UI type support
	var $search_fields = Array(
		/* Format: Field Label => Array(tablename, columnname) */
		// tablename should not have prefix 'vtiger_'
		//'Sucursales Name'=> Array('sucursales', 'idv')
		'Nombre'=> Array('sucursales', 'nombre'),
		//'Folio'=> Array('sucursales', 'idv'),
		'Domicilio'=> Array('sucursales', 'domicilio'),
	);
	var $search_fields_name = Array(
		/* Format: Field Label => fieldname */
		//'Sucursales Name'=> 'idv'
		'Nombre'=> 'nombre',
		//'Folio'=> 'idv',
		'Domicilio'=> 'domicilio',
	);

	// For Popup window record selection
	//var $popup_fields = Array('idv');
	var $popup_fields = Array('nombre');

	// Placeholder for sort fields - All the fields will be initialized for Sorting through initSortFields
	var $sortby_fields = Array();

	// For Alphabetical search
	var $def_basicsearch_col = 'idv';

	// Column value to use on detail view record text display
	var $def_detailview_recname = 'idv';

	// Required Information for enabling Import feature
	var $required_fields = Array('idv'=>1);

	// Callback function list during Importing
	var $special_functions = Array('set_import_assigned_user');

	var $default_order_by = 'idv';
	var $default_sort_order='ASC';
	// Used when enabling/disabling the mandatory fields for the module.
	// Refers to vtiger_field.fieldname values.
	var $mandatory_fields = Array('createdtime', 'modifiedtime', 'idv');
	
	function __construct() {
		global $log, $currentModule;
		$this->column_fields = getColumnFields($currentModule);
		$this->db = PearDatabase::getInstance();
		$this->log = $log;
	}

	function getSortOrder() {
		global $currentModule;

		$sortorder = $this->default_sort_order;
		if($_REQUEST['sorder']) $sortorder = $this->db->sql_escape_string($_REQUEST['sorder']);
		else if($_SESSION[$currentModule.'_Sort_Order']) 
			$sortorder = $_SESSION[$currentModule.'_Sort_Order'];

		return $sortorder;
	}

	function getOrderBy() {
		global $currentModule;
		
		$use_default_order_by = '';		
		if(PerformancePrefs::getBoolean('LISTVIEW_DEFAULT_SORTING', true)) {
			$use_default_order_by = $this->default_order_by;
		}
		
		$orderby = $use_default_order_by;
		if($_REQUEST['order_by']) $orderby = $this->db->sql_escape_string($_REQUEST['order_by']);
		else if($_SESSION[$currentModule.'_Order_By'])
			$orderby = $_SESSION[$currentModule.'_Order_By'];
		return $orderby;
	}

	function save_module($module) {
	}

	/**
	 * Return query to use based on given modulename, fieldname
	 * Useful to handle specific case handling for Popup
	 */
	function getQueryByModuleField($module, $fieldname, $srcrecord, $query='') {
		// $srcrecord could be empty
	}

	/**
	 * Get list view query (send more WHERE clause condition if required)
	 */
	function getListQuery($module, $usewhere='') {
		// Ideas WWW.
		$codigo_programa = "m/Suc/Suc";
	
		// 20150522. Todos pueden ver.
/********************************
		$par = new Parametros;
		$perfil_mecanico = $par->valor("perfil_mecanico");
		$perfiles = explode("|", $perfil_mecanico);
//var_dump($perfil_mecanico);
********************************/
		// Ideas WWW.

		$query = "SELECT vtiger_crmentity.*, $this->table_name.*";
		
		// Keep track of tables joined to avoid duplicates
		$joinedTables = array();

		// Select Custom Field Table Columns if present
		if(!empty($this->customFieldTable)) $query .= ", " . $this->customFieldTable[0] . ".* ";

		$query .= " FROM $this->table_name";

		$query .= "	INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index";

		$joinedTables[] = $this->table_name;
		$joinedTables[] = 'vtiger_crmentity';
		
		// Consider custom table join as well.
		if(!empty($this->customFieldTable)) {
			$query .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index";
			$joinedTables[] = $this->customFieldTable[0]; 
		}
		$query .= " LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid";
		$query .= " LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";

		$joinedTables[] = 'vtiger_users';
		$joinedTables[] = 'vtiger_groups';
		
		$linkedModulesQuery = $this->db->pquery("SELECT distinct fieldname, columnname, relmodule FROM vtiger_field" .
				" INNER JOIN vtiger_fieldmodulerel ON vtiger_fieldmodulerel.fieldid = vtiger_field.fieldid" .
				" WHERE uitype='10' AND vtiger_fieldmodulerel.module=?", array($module));
		$linkedFieldsCount = $this->db->num_rows($linkedModulesQuery);
		
		for($i=0; $i<$linkedFieldsCount; $i++) {
			$related_module = $this->db->query_result($linkedModulesQuery, $i, 'relmodule');
			$fieldname = $this->db->query_result($linkedModulesQuery, $i, 'fieldname');
			$columnname = $this->db->query_result($linkedModulesQuery, $i, 'columnname');
			
			$other =  CRMEntity::getInstance($related_module);
			vtlib_setup_modulevars($related_module, $other);
			
			if(!in_array($other->table_name, $joinedTables)) {
				$query .= " LEFT JOIN $other->table_name ON $other->table_name.$other->table_index = $this->table_name.$columnname";
				$joinedTables[] = $other->table_name;
			}
		}

		global $current_user;

		// Ideas WWW.
//var_dump($current_user->roleid);
//var_dump($perfiles);
		// En módulo personalizado se usa $this. En i/u/LVU se usa directo.
		//$query .= $this->getNonAdminAccessControlQuery($module,$current_user);
/**************************************
		if (in_array($current_user->roleid, $perfiles))
		{
			$query .= " ";
		}
		else
		{
			$query .= $this->getNonAdminAccessControlQuery($module,$current_user);
		}
*************************************/
//echo "<pre>";
//var_dump(getNonAdminAccessControlQuery($module, $current_user));
//echo "</pre>";
		// 20150522. Todos pueden ver.
		$query .= " ";
			// Ideas WWW.

		$query .= "	WHERE vtiger_crmentity.deleted = 0 ".$usewhere;
		return $query;
	}

	/**
	 * Apply security restriction (sharing privilege) query part for List view.
	 */
	function getListViewSecurityParameter($module) {
		global $current_user;
		require('user_privileges/user_privileges_'.$current_user->id.'.php');
		require('user_privileges/sharing_privileges_'.$current_user->id.'.php');

		$sec_query = '';
		$tabid = getTabid($module);

		if($is_admin==false && $profileGlobalPermission[1] == 1 && $profileGlobalPermission[2] == 1 
			&& $defaultOrgSharingPermission[$tabid] == 3) {

				$sec_query .= " AND (vtiger_crmentity.smownerid in($current_user->id) OR vtiger_crmentity.smownerid IN 
					(
						SELECT vtiger_user2role.userid FROM vtiger_user2role 
						INNER JOIN vtiger_users ON vtiger_users.id=vtiger_user2role.userid 
						INNER JOIN vtiger_role ON vtiger_role.roleid=vtiger_user2role.roleid 
						WHERE vtiger_role.parentrole LIKE '".$current_user_parent_role_seq."::%'
					) 
					OR vtiger_crmentity.smownerid IN 
					(
						SELECT shareduserid FROM vtiger_tmp_read_user_sharing_per 
						WHERE userid=".$current_user->id." AND tabid=".$tabid."
					) 
					OR 
						(";
		
					// Build the query based on the group association of current user.
					if(sizeof($current_user_groups) > 0) {
						$sec_query .= " vtiger_groups.groupid IN (". implode(",", $current_user_groups) .") OR ";
					}
					$sec_query .= " vtiger_groups.groupid IN 
						(
							SELECT vtiger_tmp_read_group_sharing_per.sharedgroupid 
							FROM vtiger_tmp_read_group_sharing_per
							WHERE userid=".$current_user->id." and tabid=".$tabid."
						)";
				$sec_query .= ")
				)";
		}
		return $sec_query;
	}

	/**
	 * Create query to export the records.
	 */
	function create_export_query($where)
	{
		global $current_user;
		$thismodule = $_REQUEST['module'];
		
		include("include/utils/ExportUtils.php");

		//To get the Permitted fields query and the permitted fields list
		$sql = getPermittedFieldsQuery($thismodule, "detail_view");
		
		$fields_list = getFieldsListFromQuery($sql);

		$query = "SELECT $fields_list, vtiger_users.user_name AS user_name 
					FROM vtiger_crmentity INNER JOIN $this->table_name ON vtiger_crmentity.crmid=$this->table_name.$this->table_index";

		if(!empty($this->customFieldTable)) {
			$query .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index"; 
		}

		$query .= " LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";
		$query .= " LEFT JOIN vtiger_users ON vtiger_crmentity.smownerid = vtiger_users.id and vtiger_users.status='Active'";
		
		$linkedModulesQuery = $this->db->pquery("SELECT distinct fieldname, columnname, relmodule FROM vtiger_field" .
				" INNER JOIN vtiger_fieldmodulerel ON vtiger_fieldmodulerel.fieldid = vtiger_field.fieldid" .
				" WHERE uitype='10' AND vtiger_fieldmodulerel.module=?", array($thismodule));
		$linkedFieldsCount = $this->db->num_rows($linkedModulesQuery);

		for($i=0; $i<$linkedFieldsCount; $i++) {
			$related_module = $this->db->query_result($linkedModulesQuery, $i, 'relmodule');
			$fieldname = $this->db->query_result($linkedModulesQuery, $i, 'fieldname');
			$columnname = $this->db->query_result($linkedModulesQuery, $i, 'columnname');
			
			$other = CRMEntity::getInstance($related_module);
			vtlib_setup_modulevars($related_module, $other);
			
			$query .= " LEFT JOIN $other->table_name ON $other->table_name.$other->table_index = $this->table_name.$columnname";
		}

		$query .= $this->getNonAdminAccessControlQuery($thismodule,$current_user);
		$where_auto = " vtiger_crmentity.deleted=0";

		if($where != '') $query .= " WHERE ($where) AND $where_auto";
		else $query .= " WHERE $where_auto";

		return $query;
	}

	/**
	 * Initialize this instance for importing.
	 */
	function initImport($module) {
		$this->db = PearDatabase::getInstance();
		$this->initImportableFields($module);
	}

	/**
	 * Create list query to be shown at the last step of the import.
	 * Called From: modules/Import/UserLastImport.php
	 */
	function create_import_query($module) {
		global $current_user;
		$query = "SELECT vtiger_crmentity.crmid, case when (vtiger_users.user_name not like '') then vtiger_users.user_name else vtiger_groups.groupname end as user_name, $this->table_name.* FROM $this->table_name
			INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index
			LEFT JOIN vtiger_users_last_import ON vtiger_users_last_import.bean_id=vtiger_crmentity.crmid
			LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid
			LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid
			WHERE vtiger_users_last_import.assigned_user_id='$current_user->id'
			AND vtiger_users_last_import.bean_type='$module'
			AND vtiger_users_last_import.deleted=0";
		return $query;
	}

	/**
	 * Delete the last imported records.
	 */
	function undo_import($module, $user_id) {
		global $adb;
		$count = 0;
		$query1 = "select bean_id from vtiger_users_last_import where assigned_user_id=? AND bean_type='$module' AND deleted=0";
		$result1 = $adb->pquery($query1, array($user_id)) or die("Error getting last import for undo: ".mysql_error()); 
		while ( $row1 = $adb->fetchByAssoc($result1))
		{
			$query2 = "update vtiger_crmentity set deleted=1 where crmid=?";
			$result2 = $adb->pquery($query2, array($row1['bean_id'])) or die("Error undoing last import: ".mysql_error()); 
			$count++;			
		}
		return $count;
	}
	
	/**
	 * Transform the value while exporting
	 */
	function transform_export_value($key, $value) {
		return parent::transform_export_value($key, $value);
	}

	/**
	 * Function which will set the assigned user id for import record.
	 */
	function set_import_assigned_user()
	{
		global $current_user, $adb;
		$record_user = $this->column_fields["assigned_user_id"];
		
		if($record_user != $current_user->id){
			$sqlresult = $adb->pquery("select id from vtiger_users where id = ? union select groupid as id from vtiger_groups where groupid = ?", array($record_user, $record_user));
			if($this->db->num_rows($sqlresult)!= 1) {
				$this->column_fields["assigned_user_id"] = $current_user->id;
			} else {			
				$row = $adb->fetchByAssoc($sqlresult, -1, false);
				if (isset($row['id']) && $row['id'] != -1) {
					$this->column_fields["assigned_user_id"] = $row['id'];
				} else {
					$this->column_fields["assigned_user_id"] = $current_user->id;
				}
			}
		}
	}
	
	/** 
	 * Function which will give the basic query to find duplicates
	 */
	function getDuplicatesQuery($module,$table_cols,$field_values,$ui_type_arr,$select_cols='') {
		$select_clause = "SELECT ". $this->table_name .".".$this->table_index ." AS recordid, vtiger_users_last_import.deleted,".$table_cols;

		// Select Custom Field Table Columns if present
		if(isset($this->customFieldTable)) $query .= ", " . $this->customFieldTable[0] . ".* ";

		$from_clause = " FROM $this->table_name";

		$from_clause .= "	INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index";

		// Consider custom table join as well.
		if(isset($this->customFieldTable)) {
			$from_clause .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index"; 
		}
		$from_clause .= " LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid
						LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";
		
		$where_clause = "	WHERE vtiger_crmentity.deleted = 0";
		$where_clause .= $this->getListViewSecurityParameter($module);
					
		if (isset($select_cols) && trim($select_cols) != '') {
			$sub_query = "SELECT $select_cols FROM  $this->table_name AS t " .
				" INNER JOIN vtiger_crmentity AS crm ON crm.crmid = t.".$this->table_index;
			// Consider custom table join as well.
			if(isset($this->customFieldTable)) {
				$sub_query .= " LEFT JOIN ".$this->customFieldTable[0]." tcf ON tcf.".$this->customFieldTable[1]." = t.$this->table_index";
			}
			$sub_query .= " WHERE crm.deleted=0 GROUP BY $select_cols HAVING COUNT(*)>1";	
		} else {
			$sub_query = "SELECT $table_cols $from_clause $where_clause GROUP BY $table_cols HAVING COUNT(*)>1";
		}	
		
		
		$query = $select_clause . $from_clause .
					" LEFT JOIN vtiger_users_last_import ON vtiger_users_last_import.bean_id=" . $this->table_name .".".$this->table_index .
					" INNER JOIN (" . $sub_query . ") AS temp ON ".get_on_clause($field_values,$ui_type_arr,$module) .
					$where_clause .
					" ORDER BY $table_cols,". $this->table_name .".".$this->table_index ." ASC";
					
		return $query;		
	}

	/**
	 * Invoked when special actions are performed on the module.
	 * @param String Module name
	 * @param String Event Type (module.postinstall, module.disabled, module.enabled, module.preuninstall)
	 */
	function vtlib_handler($modulename, $event_type) {
		if($event_type == 'module.postinstall') {
			// TODO Handle post installation actions
		} else if($event_type == 'module.disabled') {
			// TODO Handle actions when this module is disabled.
		} else if($event_type == 'module.enabled') {
			// TODO Handle actions when this module is enabled.
		} else if($event_type == 'module.preuninstall') {
			// TODO Handle actions when this module is about to be deleted.
		} else if($event_type == 'module.preupdate') {
			// TODO Handle actions before this module is updated.
		} else if($event_type == 'module.postupdate') {
			// TODO Handle actions after this module is updated.
		}
	}

	/** 
	 * Handle saving related module information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	// function save_related_module($module, $crmid, $with_module, $with_crmid) { }
	
	/**
	 * Handle deleting related module information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function delete_related_module($module, $crmid, $with_module, $with_crmid) { }

	/**
	 * Handle getting related list information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function get_related_list($id, $cur_tab_id, $rel_tab_id, $actions=false) { }

	/**
	 * Handle getting dependents list information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function get_dependents_list($id, $cur_tab_id, $rel_tab_id, $actions=false) { }

	// Crea una sucursal completa con sus almacenes y blocks básicos.
	function crear($letra)
	{
		global $adb;

		// Crea el cliente asignado a la sucursal.
		$cli = new Accounts;

		$cli->column_fields["assigned_user_id"] = 1;
		$cli->column_fields["accountname"] = "SUC $letra";

		$cli->save("Accounts");

		$cli_id = $cli->obtener_id();

		// Crea la obra asignada a la sucursal.
		$obr = new Obras;

		$obr->column_fields["assigned_user_id"] = 1;
		$obr->column_fields["cliente"] = $cli_id;
		$obr->column_fields["nombre"] = "SUC $letra";

		$obr->save("Obras");

		$obr_id = $obr->obtener_id();

		$suc = new Sucursales;

		$suc->column_fields["assigned_user_id"] = 1;
		$suc->column_fields["nombre"] = "SUC $letra";
		$suc->column_fields["prefijo"] = $letra;
		$suc->column_fields["cliente_mks"] = $cli_id;
		$suc->column_fields["obra_mks"] = $obr_id;

		$suc->save("Sucursales");

		$suc_id = $suc->obtener_id();

		// Crea los almacenes para la sucursal.

// Tipos: Nuevo|Flota|Código|Refacciones|Herramienta|Servicios|Previsión|Usado|Tránsito

		$plantillas_almacen["nuevo"]["nombre"] = "NUEVO SUC $letra";
		$plantillas_almacen["nuevo"]["descripcion"] = "Almacén para la recepción y venta de equipo";
		$plantillas_almacen["nuevo"]["tipo"] = "Nuevo";

		$plantillas_almacen["flota"]["nombre"] = "FLOTA RENTA SUC $letra";
		$plantillas_almacen["flota"]["descripcion"] = "Nuestra flota de equipos";
		$plantillas_almacen["flota"]["tipo"] = "Flota";

		$plantillas_almacen["codigos"]["nombre"] = "CODIGO RENTA SUC $letra";
		$plantillas_almacen["codigos"]["descripcion"] = "Codigos de Renta \"X\" y \"Y\"";
		$plantillas_almacen["codigos"]["tipo"] = "Código";

		$plantillas_almacen["refacciones"]["nombre"] = "REFACCIONES SUC $letra";
		$plantillas_almacen["refacciones"]["descripcion"] = "Control de refacciones";
		$plantillas_almacen["refacciones"]["tipo"] = "Refacciones";

		$plantillas_almacen["herramientas"]["nombre"] = "HERRAMIENTA SUC $letra";
		$plantillas_almacen["herramientas"]["descripcion"] = "Control de herramientas de uso interno";
		$plantillas_almacen["herramientas"]["tipo"] = "Herramienta";

		$plantillas_almacen["servicios"]["nombre"] = "SERVICIOS SUC $letra";
		$plantillas_almacen["servicios"]["descripcion"] = "Servicios";
		$plantillas_almacen["servicios"]["tipo"] = "Servicios";

		$plantillas_almacen["prevision"]["nombre"] = "PREVISION SUC $letra";
		$plantillas_almacen["prevision"]["descripcion"] = "Previsión";
		$plantillas_almacen["prevision"]["tipo"] = "Previsión";

		$plantillas_almacen["usado"]["nombre"] = "USADO SUC $letra";
		$plantillas_almacen["usado"]["descripcion"] = "Almacén para la baja de equipos.";
		$plantillas_almacen["usado"]["tipo"] = "Usado";

		$plantillas_almacen["transito"]["nombre"] = "TRANSITO SUC $letra";
		$plantillas_almacen["transito"]["descripcion"] = "Almacén para equipo en tránsito en traspasos.";
		$plantillas_almacen["transito"]["tipo"] = "Tránsito";

		foreach ($plantillas_almacen as $codigo => $plantilla_almacen)
		{
			$alm = new Almacenes;

			$alm->column_fields["assigned_user_id"] = 1;
			$alm->column_fields["sucursal"] = $suc_id;
			$alm->column_fields["nombre"] = $plantilla_almacen["nombre"];
			$alm->column_fields["descripcion"] = $plantilla_almacen["descripcion"];
			$alm->column_fields["sincronizar"] = true;
			if ($plantilla_almacen["tipo"] != "")
			{
				$alm->column_fields["alm_tipo"] = $plantilla_almacen["tipo"];
			}

			$alm->save("Almacenes");

			$alm_id = $alm->obtener_id();

			$suc->column_fields["almacen_$codigo"] = $alm_id;
		}

		$prefijo = "A";
		$plantillas_block["recepciones_mercancia"]["prefijo"] = $prefijo;
		$plantillas_block["recepciones_mercancia"]["nombre"] = "RECEPCION SUC $letra BLOCK $prefijo";
		$plantillas_block["recepciones_mercancia"]["tipo"] = "Recepciones de mercancía";
		$plantillas_block["recepciones_mercancia"]["subarrendado"] = false;
		$plantillas_block["recepciones_mercancia"]["blk_tipo"] = "Natural";
		$plantillas_block["recepciones_mercancia"]["blk_documento"] = "Recepciones_mercancia";

		$prefijo = "S";
		$plantillas_block["recepciones_mercancia_subarrendado"]["prefijo"] = $prefijo;
		$plantillas_block["recepciones_mercancia_subarrendado"]["nombre"] = "RECEPCION SUC $letra BLOCK $prefijo";
		$plantillas_block["recepciones_mercancia_subarrendado"]["tipo"] = "Recepciones de mercancía";
		$plantillas_block["recepciones_mercancia_subarrendado"]["subarrendado"] = true;
		$plantillas_block["recepciones_mercancia_subarrendado"]["blk_tipo"] = "Subarrendado";
		$plantillas_block["recepciones_mercancia_subarrendado"]["blk_documento"] = "Recepciones_mercancia";

		$prefijo = "W";
		$plantillas_block["recepciones_mercancia_borrador"]["prefijo"] = $prefijo;
		$plantillas_block["recepciones_mercancia_borrador"]["nombre"] = "RECEPCION SUC $letra BLOCK $prefijo";
		$plantillas_block["recepciones_mercancia_borrador"]["tipo"] = "Recepciones de mercancía";
		$plantillas_block["recepciones_mercancia_borrador"]["subarrendado"] = true;
		$plantillas_block["recepciones_mercancia_borrador"]["blk_tipo"] = "Borrador";
		$plantillas_block["recepciones_mercancia_borrador"]["blk_documento"] = "Recepciones_mercancia";

		$prefijo = "A";
		$plantillas_block["altas_flota_renta"]["prefijo"] = $prefijo;
		$plantillas_block["altas_flota_renta"]["nombre"] = "ALTA EQUIPO SUC $letra BLOCK $prefijo";
		$plantillas_block["altas_flota_renta"]["tipo"] = "Altas a flota de renta";
		$plantillas_block["altas_flota_renta"]["subarrendado"] = false;
		$plantillas_block["altas_flota_renta"]["blk_tipo"] = "Natural";
		$plantillas_block["altas_flota_renta"]["blk_documento"] = "Altas_flota_renta";

		$prefijo = "S";
		$plantillas_block["altas_flota_renta_subarrendado"]["prefijo"] = $prefijo;
		$plantillas_block["altas_flota_renta_subarrendado"]["nombre"] = "ALTA EQUIPO SUC $letra BLOCK $prefijo";
		$plantillas_block["altas_flota_renta_subarrendado"]["tipo"] = "Altas a flota de renta";
		$plantillas_block["altas_flota_renta_subarrendado"]["subarrendado"] = true;

		$prefijo = "A";
		$plantillas_block["bajas_flota_renta"]["prefijo"] = $prefijo;
		$plantillas_block["bajas_flota_renta"]["nombre"] = "BAJA EQUIPO SUC $letra BLOCK $prefijo";
		$plantillas_block["bajas_flota_renta"]["tipo"] = "Bajas de flota de renta";
		$plantillas_block["bajas_flota_renta"]["subarrendado"] = false;

		$prefijo = "S";
		$plantillas_block["bajas_flota_renta_subarrendado"]["prefijo"] = $prefijo;
		$plantillas_block["bajas_flota_renta_subarrendado"]["nombre"] = "BAJA EQUIPO SUC $letra BLOCK $prefijo";
		$plantillas_block["bajas_flota_renta_subarrendado"]["tipo"] = "Bajas de flota de renta";
		$plantillas_block["bajas_flota_renta_subarrendado"]["subarrendado"] = true;

		$prefijo = "A";
		$plantillas_block["entregas"]["prefijo"] = $prefijo;
		$plantillas_block["entregas"]["nombre"] = "ENTREGA SUC $letra BLOCK $prefijo";
		$plantillas_block["entregas"]["tipo"] = "Entregas";
		$plantillas_block["entregas"]["subarrendado"] = false;

		$prefijo = "A";
		$plantillas_block["cambios"]["prefijo"] = $prefijo;
		$plantillas_block["cambios"]["nombre"] = "CAMBIO SUC $letra BLOCK $prefijo";
		$plantillas_block["cambios"]["tipo"] = "Cambios";
		$plantillas_block["cambios"]["subarrendado"] = false;

		$prefijo = "A";
		$plantillas_block["recolecciones"]["prefijo"] = $prefijo;
		$plantillas_block["recolecciones"]["nombre"] = "RECOLECCION SUC $letra BLOCK $prefijo";
		$plantillas_block["recolecciones"]["tipo"] = "Recolecciones";
		$plantillas_block["recolecciones"]["subarrendado"] = false;

		$prefijo = "A";
		$plantillas_block["ordenes_trabajo"]["prefijo"] = $prefijo;
		$plantillas_block["ordenes_trabajo"]["nombre"] = "ORDEN TRABAJO SUC $letra BLOCK $prefijo";
		$plantillas_block["ordenes_trabajo"]["tipo"] = "Órdenes de trabajo";
		$plantillas_block["ordenes_trabajo"]["subarrendado"] = false;

		$prefijo = "A";
		$plantillas_block["facturas"]["prefijo"] = $prefijo;
		$plantillas_block["facturas"]["nombre"] = "FACTURA SUC $letra BLOCK $prefijo";
		$plantillas_block["facturas"]["tipo"] = "Facturas";
		$plantillas_block["facturas"]["subarrendado"] = false;

		$prefijo = "W";
		$plantillas_block["facturas_borrador"]["prefijo"] = $prefijo;
		$plantillas_block["facturas_borrador"]["nombre"] = "FACTURA SUC $letra BLOCK $prefijo";
		$plantillas_block["facturas_borrador"]["tipo"] = "Facturas";
		$plantillas_block["facturas_borrador"]["subarrendado"] = false;
		$plantillas_block["facturas_borrador"]["blk_tipo"] = "Borrador";
		$plantillas_block["facturas_borrador"]["blk_documento"] = "Facturas";

		$prefijo = "A";
		$plantillas_block["notas_credito"]["prefijo"] = $prefijo;
		$plantillas_block["notas_credito"]["nombre"] = "NOTA CREDITO SUC $letra BLOCK $prefijo";
		$plantillas_block["notas_credito"]["tipo"] = "Notas de crédito";
		$plantillas_block["notas_credito"]["subarrendado"] = false;

		$prefijo = "A";
		$plantillas_block["ensambles"]["prefijo"] = $prefijo;
		$plantillas_block["ensambles"]["nombre"] = "ENSAMBLE SUC $letra BLOCK $prefijo";
		$plantillas_block["ensambles"]["tipo"] = "Ensambles";
		$plantillas_block["ensambles"]["subarrendado"] = false;

		$prefijo = "A";
		$plantillas_block["traspasos"]["prefijo"] = $prefijo;
		$plantillas_block["traspasos"]["nombre"] = "TRASPASO SUC $letra BLOCK $prefijo";
		$plantillas_block["traspasos"]["tipo"] = "Traspasos";
		$plantillas_block["traspasos"]["subarrendado"] = false;

		$prefijo = "A";
		$plantillas_block["salidas_especiales"]["prefijo"] = $prefijo;
		$plantillas_block["salidas_especiales"]["nombre"] = "SALIDA ESPECIAL SUC $letra BLOCK $prefijo";
		$plantillas_block["salidas_especiales"]["tipo"] = "Salidas especiales";
		$plantillas_block["salidas_especiales"]["subarrendado"] = false;

		$prefijo = "S";
		$plantillas_block["salidas_especiales_subarrendado"]["prefijo"] = $prefijo;
		$plantillas_block["salidas_especiales_subarrendado"]["nombre"] = "SALIDA ESPECIAL SUC $letra BLOCK $prefijo";
		$plantillas_block["salidas_especiales_subarrendado"]["tipo"] = "Salidas especiales";
		$plantillas_block["salidas_especiales_subarrendado"]["subarrendado"] = true;

		$prefijo = "A";
		$plantillas_block["cotizaciones"]["prefijo"] = $prefijo;
		$plantillas_block["cotizaciones"]["nombre"] = "COTIZACION SUC $letra BLOCK $prefijo";
		$plantillas_block["cotizaciones"]["tipo"] = "Cotizaciones";
		$plantillas_block["cotizaciones"]["subarrendado"] = false;

		$prefijo = "A";
		$plantillas_block["inventario_fisico"]["prefijo"] = $prefijo;
		$plantillas_block["inventario_fisico"]["nombre"] = "INVENTARIO FISICO SUC $letra BLOCK $prefijo";
		$plantillas_block["inventario_fisico"]["tipo"] = "Inventario físico";
		$plantillas_block["inventario_fisico"]["subarrendado"] = false;

		$prefijo = "A";
		$plantillas_block["ordenes_compra"]["prefijo"] = $prefijo;
		$plantillas_block["ordenes_compra"]["nombre"] = "ORDEN COMPRA SUC $letra BLOCK $prefijo";
		$plantillas_block["ordenes_compra"]["tipo"] = "Órdenes de compra";
		$plantillas_block["ordenes_compra"]["subarrendado"] = false;

		$prefijo = "W";
		$plantillas_block["ordenes_compra"]["prefijo"] = $prefijo;
		$plantillas_block["ordenes_compra"]["nombre"] = "ORDEN COMPRA SUC $letra BLOCK $prefijo";
		$plantillas_block["ordenes_compra"]["tipo"] = "Órdenes de compra";
		$plantillas_block["ordenes_compra"]["subarrendado"] = false;
		$plantillas_block["ordenes_compra"]["blk_tipo"] = "Borrador";
		$plantillas_block["ordenes_compra"]["blk_documento"] = "Ordenes_compra";

		$prefijo = "A";
		$plantillas_block["notas_credito_proveedor"]["prefijo"] = $prefijo;
		$plantillas_block["notas_credito_proveedor"]["nombre"] = "NOTA CREDITO PROV SUC $letra BLOCK $prefijo";
		$plantillas_block["notas_credito_proveedor"]["tipo"] = "Notas crédito proveedor";
		$plantillas_block["notas_credito_proveedor"]["subarrendado"] = false;

		$prefijo = "S";

		$plantillas_block["notas_credito_proveedor_subarrendado"]["prefijo"] = $prefijo;
		$plantillas_block["notas_credito_proveedor_subarrendado"]["nombre"] = "NOTA CREDITO PROV SUC $letra BLOCK $prefijo";
		$plantillas_block["notas_credito_proveedor_subarrendado"]["tipo"] = "Notas crédito proveedor";
		$plantillas_block["notas_credito_proveedor_subarrendado"]["subarrendado"] = true;

		foreach ($plantillas_block as $codigo => $plantilla_block)
		{
			$blk = new Blocks_folios;

			$blk->column_fields["assigned_user_id"] = 1;
			$blk->column_fields["folio"] = 1;
			$blk->column_fields["nombre"] = $plantilla_block["nombre"];
			$blk->column_fields["tipo_block"] = $plantilla_block["tipo"];
			$blk->column_fields["prefijo"] = $plantilla_block["prefijo"];
			$blk->column_fields["subarrendado"] = $plantilla_block["subarrendado"];
			$blk->column_fields["blk_tipo"] = $plantilla_block["blk_tipo"];
			$blk->column_fields["blk_documento"] = $plantilla_block["blk_documento"];
			$blk->column_fields["sucursal"] = $suc_id;

			$blk->save("Blocks_folios");

			$blk_id = $blk->obtener_id();

			$suc->column_fields[$codigo] = $blk_id;
		}

		$suc->save("Sucursales", $suc_id);

		return $suc_id;
	}

	// Devuelve un almacén según su tipo.
	function almacen($tipo)
	{
		require("modules/Sucursales/fns/almacen.php");
		return $alm_id;
	}
}
?>
