<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/
require_once('data/CRMEntity.php');
require_once('data/Tracker.php');
require_once("modules/Por_facturar/Por_facturar.php");
require_once("modules/Facturas_det/Facturas_det.php");
require_once("modules/Products/Products.php");
require_once("modules/Numeros_serie/Numeros_serie.php");
require_once("modules/Flota_renta/Flota_renta.php");
require_once("modules/Sucursales/Sucursales.php");
require_once("modules/Periodos/Periodos.php");
require_once("modules/Notas_credito/Notas_credito.php");
require_once("modules/Notas_credito_det/Notas_credito_det.php");
require_once("modules/Obras/Obras.php");
require_once("modules/Parametros/Parametros.php");
require_once('modules/Oreja/Oreja.php');

class Facturas extends CRMEntity {
	var $db, $log; // Used in class functions of CRMEntity

	var $table_name = 'vtiger_facturas';
	var $table_index= 'facturasid';
	var $column_fields = Array();

	/** Indicator if this is a custom module or standard module */
	var $IsCustomModule = true;

	/**
	 * Mandatory table for supporting custom fields.
	 */
	var $customFieldTable = Array('vtiger_facturascf', 'facturasid');

	/**
	 * Mandatory for Saving, Include tables related to this module.
	 */
	var $tab_name = Array('vtiger_crmentity', 'vtiger_facturas', 'vtiger_facturascf');

	/**
	 * Mandatory for Saving, Include tablename and tablekey columnname here.
	 */
	var $tab_name_index = Array(
		'vtiger_crmentity' => 'crmid',
		'vtiger_facturas'   => 'facturasid',
	    'vtiger_facturascf' => 'facturasid');

	/**
	 * Mandatory for Listing (Related listview)
	 */
	var $list_fields = Array (
		/* Format: Field Label => Array(tablename, columnname) */
		// tablename should not have prefix 'vtiger_'
		'Facturas Name'=> Array('facturas', 'idv'),
		'Assigned To' => Array('crmentity','smownerid')
	);
	var $list_fields_name = Array(
		/* Format: Field Label => fieldname */
		'Facturas Name'=> 'idv',
		'Assigned To' => 'assigned_user_id'
	);

	// Make the field link to detail view from list view (Fieldname)
	var $list_link_field = 'idv';

	// For Popup listview and UI type support
	var $search_fields = Array(
		/* Format: Field Label => Array(tablename, columnname) */
		// tablename should not have prefix 'vtiger_'
		'Facturas Name'=> Array('facturas', 'idv')
	);
	var $search_fields_name = Array(
		/* Format: Field Label => fieldname */
		'Facturas Name'=> 'idv'
	);

	// For Popup window record selection
	var $popup_fields = Array('idv');

	// Placeholder for sort fields - All the fields will be initialized for Sorting through initSortFields
	var $sortby_fields = Array();

	// For Alphabetical search
	var $def_basicsearch_col = 'idv';

	// Column value to use on detail view record text display
	var $def_detailview_recname = 'idv';

	// Required Information for enabling Import feature
	var $required_fields = Array('idv'=>1);

	// Callback function list during Importing
	var $special_functions = Array('set_import_assigned_user');

	var $default_order_by = 'idv';
	var $default_sort_order='ASC';
	// Used when enabling/disabling the mandatory fields for the module.
	// Refers to vtiger_field.fieldname values.
	var $mandatory_fields = Array('createdtime', 'modifiedtime', 'idv');
	
	function __construct() {
		global $log, $currentModule;
		$this->column_fields = getColumnFields($currentModule);
		$this->db = PearDatabase::getInstance();
		$this->log = $log;
	}

	function getSortOrder() {
		global $currentModule;

		$sortorder = $this->default_sort_order;
		if($_REQUEST['sorder']) $sortorder = $this->db->sql_escape_string($_REQUEST['sorder']);
		else if($_SESSION[$currentModule.'_Sort_Order']) 
			$sortorder = $_SESSION[$currentModule.'_Sort_Order'];

		return $sortorder;
	}

	function getOrderBy() {
		global $currentModule;
		
		$use_default_order_by = '';		
		if(PerformancePrefs::getBoolean('LISTVIEW_DEFAULT_SORTING', true)) {
			$use_default_order_by = $this->default_order_by;
		}
		
		$orderby = $use_default_order_by;
		if($_REQUEST['order_by']) $orderby = $this->db->sql_escape_string($_REQUEST['order_by']);
		else if($_SESSION[$currentModule.'_Order_By'])
			$orderby = $_SESSION[$currentModule.'_Order_By'];
		return $orderby;
	}

	function save_module($module) {
		//$this->column_fields["fac_tipo"] = html_entity_decode($this->column_fields["fac_tipo"], ENT_QUOTES, "UTF-8");
		$this->totales();
		$this->asignar_dueno();
	}

	/**
	 * Return query to use based on given modulename, fieldname
	 * Useful to handle specific case handling for Popup
	 */
	function getQueryByModuleField($module, $fieldname, $srcrecord, $query='') {
		// $srcrecord could be empty
	}

	/**
	 * Get list view query (send more WHERE clause condition if required)
	 */
	function getListQuery($module, $usewhere='') {
		$query = "SELECT vtiger_crmentity.*, $this->table_name.*";
		
		// Keep track of tables joined to avoid duplicates
		$joinedTables = array();

		// Select Custom Field Table Columns if present
		if(!empty($this->customFieldTable)) $query .= ", " . $this->customFieldTable[0] . ".* ";

		$query .= " FROM $this->table_name";

		$query .= "	INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index";

		$joinedTables[] = $this->table_name;
		$joinedTables[] = 'vtiger_crmentity';
		
		// Consider custom table join as well.
		if(!empty($this->customFieldTable)) {
			$query .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index";
			$joinedTables[] = $this->customFieldTable[0]; 
		}
		$query .= " LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid";
		$query .= " LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";

		$joinedTables[] = 'vtiger_users';
		$joinedTables[] = 'vtiger_groups';
		
		$linkedModulesQuery = $this->db->pquery("SELECT distinct fieldname, columnname, relmodule FROM vtiger_field" .
				" INNER JOIN vtiger_fieldmodulerel ON vtiger_fieldmodulerel.fieldid = vtiger_field.fieldid" .
				" WHERE uitype='10' AND vtiger_fieldmodulerel.module=?", array($module));
		$linkedFieldsCount = $this->db->num_rows($linkedModulesQuery);
		
		for($i=0; $i<$linkedFieldsCount; $i++) {
			$related_module = $this->db->query_result($linkedModulesQuery, $i, 'relmodule');
			$fieldname = $this->db->query_result($linkedModulesQuery, $i, 'fieldname');
			$columnname = $this->db->query_result($linkedModulesQuery, $i, 'columnname');
			
			$other =  CRMEntity::getInstance($related_module);
			vtlib_setup_modulevars($related_module, $other);
			
			if(!in_array($other->table_name, $joinedTables)) {
				$query .= " LEFT JOIN $other->table_name ON $other->table_name.$other->table_index = $this->table_name.$columnname";
				$joinedTables[] = $other->table_name;
			}
		}

		global $current_user;
		$query .= $this->getNonAdminAccessControlQuery($module,$current_user);
		$query .= "	WHERE vtiger_crmentity.deleted = 0 ".$usewhere;
		return $query;
	}

	/**
	 * Apply security restriction (sharing privilege) query part for List view.
	 */
	function getListViewSecurityParameter($module) {
		global $current_user;
		require('user_privileges/user_privileges_'.$current_user->id.'.php');
		require('user_privileges/sharing_privileges_'.$current_user->id.'.php');

		$sec_query = '';
		$tabid = getTabid($module);

		if($is_admin==false && $profileGlobalPermission[1] == 1 && $profileGlobalPermission[2] == 1 
			&& $defaultOrgSharingPermission[$tabid] == 3) {

				$sec_query .= " AND (vtiger_crmentity.smownerid in($current_user->id) OR vtiger_crmentity.smownerid IN 
					(
						SELECT vtiger_user2role.userid FROM vtiger_user2role 
						INNER JOIN vtiger_users ON vtiger_users.id=vtiger_user2role.userid 
						INNER JOIN vtiger_role ON vtiger_role.roleid=vtiger_user2role.roleid 
						WHERE vtiger_role.parentrole LIKE '".$current_user_parent_role_seq."::%'
					) 
					OR vtiger_crmentity.smownerid IN 
					(
						SELECT shareduserid FROM vtiger_tmp_read_user_sharing_per 
						WHERE userid=".$current_user->id." AND tabid=".$tabid."
					) 
					OR 
						(";
		
					// Build the query based on the group association of current user.
					if(sizeof($current_user_groups) > 0) {
						$sec_query .= " vtiger_groups.groupid IN (". implode(",", $current_user_groups) .") OR ";
					}
					$sec_query .= " vtiger_groups.groupid IN 
						(
							SELECT vtiger_tmp_read_group_sharing_per.sharedgroupid 
							FROM vtiger_tmp_read_group_sharing_per
							WHERE userid=".$current_user->id." and tabid=".$tabid."
						)";
				$sec_query .= ")
				)";
		}
		return $sec_query;
	}

	/**
	 * Create query to export the records.
	 */
	function create_export_query($where)
	{
		global $current_user;
		$thismodule = $_REQUEST['module'];
		
		include("include/utils/ExportUtils.php");

		//To get the Permitted fields query and the permitted fields list
		$sql = getPermittedFieldsQuery($thismodule, "detail_view");
		
		$fields_list = getFieldsListFromQuery($sql);

		$query = "SELECT $fields_list, vtiger_users.user_name AS user_name 
					FROM vtiger_crmentity INNER JOIN $this->table_name ON vtiger_crmentity.crmid=$this->table_name.$this->table_index";

		if(!empty($this->customFieldTable)) {
			$query .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index"; 
		}

		$query .= " LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";
		$query .= " LEFT JOIN vtiger_users ON vtiger_crmentity.smownerid = vtiger_users.id and vtiger_users.status='Active'";
		
		$linkedModulesQuery = $this->db->pquery("SELECT distinct fieldname, columnname, relmodule FROM vtiger_field" .
				" INNER JOIN vtiger_fieldmodulerel ON vtiger_fieldmodulerel.fieldid = vtiger_field.fieldid" .
				" WHERE uitype='10' AND vtiger_fieldmodulerel.module=?", array($thismodule));
		$linkedFieldsCount = $this->db->num_rows($linkedModulesQuery);

		for($i=0; $i<$linkedFieldsCount; $i++) {
			$related_module = $this->db->query_result($linkedModulesQuery, $i, 'relmodule');
			$fieldname = $this->db->query_result($linkedModulesQuery, $i, 'fieldname');
			$columnname = $this->db->query_result($linkedModulesQuery, $i, 'columnname');
			
			$other = CRMEntity::getInstance($related_module);
			vtlib_setup_modulevars($related_module, $other);
			
			$query .= " LEFT JOIN $other->table_name ON $other->table_name.$other->table_index = $this->table_name.$columnname";
		}

		$query .= $this->getNonAdminAccessControlQuery($thismodule,$current_user);
		$where_auto = " vtiger_crmentity.deleted=0";

		if($where != '') $query .= " WHERE ($where) AND $where_auto";
		else $query .= " WHERE $where_auto";

		return $query;
	}

	/**
	 * Initialize this instance for importing.
	 */
	function initImport($module) {
		$this->db = PearDatabase::getInstance();
		$this->initImportableFields($module);
	}

	/**
	 * Create list query to be shown at the last step of the import.
	 * Called From: modules/Import/UserLastImport.php
	 */
	function create_import_query($module) {
		global $current_user;
		$query = "SELECT vtiger_crmentity.crmid, case when (vtiger_users.user_name not like '') then vtiger_users.user_name else vtiger_groups.groupname end as user_name, $this->table_name.* FROM $this->table_name
			INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index
			LEFT JOIN vtiger_users_last_import ON vtiger_users_last_import.bean_id=vtiger_crmentity.crmid
			LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid
			LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid
			WHERE vtiger_users_last_import.assigned_user_id='$current_user->id'
			AND vtiger_users_last_import.bean_type='$module'
			AND vtiger_users_last_import.deleted=0";
		return $query;
	}

	/**
	 * Delete the last imported records.
	 */
	function undo_import($module, $user_id) {
		global $adb;
		$count = 0;
		$query1 = "select bean_id from vtiger_users_last_import where assigned_user_id=? AND bean_type='$module' AND deleted=0";
		$result1 = $adb->pquery($query1, array($user_id)) or die("Error getting last import for undo: ".mysql_error()); 
		while ( $row1 = $adb->fetchByAssoc($result1))
		{
			$query2 = "update vtiger_crmentity set deleted=1 where crmid=?";
			$result2 = $adb->pquery($query2, array($row1['bean_id'])) or die("Error undoing last import: ".mysql_error()); 
			$count++;			
		}
		return $count;
	}
	
	/**
	 * Transform the value while exporting
	 */
	function transform_export_value($key, $value) {
		return parent::transform_export_value($key, $value);
	}

	/**
	 * Function which will set the assigned user id for import record.
	 */
	function set_import_assigned_user()
	{
		global $current_user, $adb;
		$record_user = $this->column_fields["assigned_user_id"];
		
		if($record_user != $current_user->id){
			$sqlresult = $adb->pquery("select id from vtiger_users where id = ? union select groupid as id from vtiger_groups where groupid = ?", array($record_user, $record_user));
			if($this->db->num_rows($sqlresult)!= 1) {
				$this->column_fields["assigned_user_id"] = $current_user->id;
			} else {			
				$row = $adb->fetchByAssoc($sqlresult, -1, false);
				if (isset($row['id']) && $row['id'] != -1) {
					$this->column_fields["assigned_user_id"] = $row['id'];
				} else {
					$this->column_fields["assigned_user_id"] = $current_user->id;
				}
			}
		}
	}
	
	/** 
	 * Function which will give the basic query to find duplicates
	 */
	function getDuplicatesQuery($module,$table_cols,$field_values,$ui_type_arr,$select_cols='') {
		$select_clause = "SELECT ". $this->table_name .".".$this->table_index ." AS recordid, vtiger_users_last_import.deleted,".$table_cols;

		// Select Custom Field Table Columns if present
		if(isset($this->customFieldTable)) $query .= ", " . $this->customFieldTable[0] . ".* ";

		$from_clause = " FROM $this->table_name";

		$from_clause .= "	INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index";

		// Consider custom table join as well.
		if(isset($this->customFieldTable)) {
			$from_clause .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index"; 
		}
		$from_clause .= " LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid
						LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";
		
		$where_clause = "	WHERE vtiger_crmentity.deleted = 0";
		$where_clause .= $this->getListViewSecurityParameter($module);
					
		if (isset($select_cols) && trim($select_cols) != '') {
			$sub_query = "SELECT $select_cols FROM  $this->table_name AS t " .
				" INNER JOIN vtiger_crmentity AS crm ON crm.crmid = t.".$this->table_index;
			// Consider custom table join as well.
			if(isset($this->customFieldTable)) {
				$sub_query .= " LEFT JOIN ".$this->customFieldTable[0]." tcf ON tcf.".$this->customFieldTable[1]." = t.$this->table_index";
			}
			$sub_query .= " WHERE crm.deleted=0 GROUP BY $select_cols HAVING COUNT(*)>1";	
		} else {
			$sub_query = "SELECT $table_cols $from_clause $where_clause GROUP BY $table_cols HAVING COUNT(*)>1";
		}	
		
		
		$query = $select_clause . $from_clause .
					" LEFT JOIN vtiger_users_last_import ON vtiger_users_last_import.bean_id=" . $this->table_name .".".$this->table_index .
					" INNER JOIN (" . $sub_query . ") AS temp ON ".get_on_clause($field_values,$ui_type_arr,$module) .
					$where_clause .
					" ORDER BY $table_cols,". $this->table_name .".".$this->table_index ." ASC";
					
		return $query;		
	}

	/**
	 * Invoked when special actions are performed on the module.
	 * @param String Module name
	 * @param String Event Type (module.postinstall, module.disabled, module.enabled, module.preuninstall)
	 */
	function vtlib_handler($modulename, $event_type) {
		if($event_type == 'module.postinstall') {
			// TODO Handle post installation actions
		} else if($event_type == 'module.disabled') {
			// TODO Handle actions when this module is disabled.
		} else if($event_type == 'module.enabled') {
			// TODO Handle actions when this module is enabled.
		} else if($event_type == 'module.preuninstall') {
			// TODO Handle actions when this module is about to be deleted.
		} else if($event_type == 'module.preupdate') {
			// TODO Handle actions before this module is updated.
		} else if($event_type == 'module.postupdate') {
			// TODO Handle actions after this module is updated.
		}
	}

	/** 
	 * Handle saving related module information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	// function save_related_module($module, $crmid, $with_module, $with_crmid) { }
	
	/**
	 * Handle deleting related module information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function delete_related_module($module, $crmid, $with_module, $with_crmid) { }

	/**
	 * Handle getting related list information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function get_related_list($id, $cur_tab_id, $rel_tab_id, $actions=false) { }

	/**
	 * Handle getting dependents list information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function get_dependents_list($id, $cur_tab_id, $rel_tab_id, $actions=false) { }

	function registrar_detalles($pfa_elegidos)
	{
		global $adb, $current_user;
		//var_dump($pfa_elegidos);
		//die;

		$fac_id = $this->obtener_id();

		foreach ($pfa_elegidos as $pfa_id => $valor_on)
		{
//var_dump($pfa_id, $valor_on);
//continue;
//var_dump("no mostrar");
			$pfa = new Por_facturar;
			$pfa->retrieve_entity_info($pfa_id, "Por_facturar");
//echo "<pre>";
//var_dump($pfa->column_fields);

			// Crea un registro de detalle de la factura.
			$cantidad_facturar = $pfa->cantidad_facturar();
			$facd = new Facturas_det;
			$facd->column_fields["assigned_user_id"] = $current_user->id;
			//$facd->column_fields["factura"] = $this->obtener_id();
			$facd->column_fields["factura"] = $fac_id;
			$facd->column_fields["por_facturar"] = $pfa->obtener_id();
			$facd->column_fields["descripcion_breve"] = $pfa->column_fields["concepto"];
			//$facd->column_fields["cantidad"] = $pfa->column_fields["dias"];
			$facd->column_fields["cantidad"] = $cantidad_facturar;
			$facd->column_fields["codigo"] = $pfa->codigo();
			$facd->column_fields["descripcion"] = $pfa->descripcion();
			$facd->column_fields["precio_unitario"] = $pfa->precio_unitario();
			//$facd->column_fields["importe"] = $pfa->column_fields["dias"] * $facd->column_fields["precio_unitario"];
			$facd->column_fields["importe"] = $cantidad_facturar * $facd->column_fields["precio_unitario"];
			$facd->save("Facturas_det");
//var_dump($facd->column_fields);
//echo "</pre>";

			// Actualiza el estado del por facturar para que no esté disponible.
			//$pfa->estado("Facturado");
			$parametros["estado"] = "Facturado";
			//$parametros["facturasid"] = $fac_id;
			$parametros["factura"] = $fac_id;
			$pfa->actualizar($parametros);
		}
//die;
	}

	function registrar_producto($prod_id, $cantidad, $fac_tipo, $ns_elegidos = null)
	{
		global $current_user;

		// Obtiene el producto.
		$prod = new Products;
		$prod->retrieve_entity_info($prod_id, "Products");

		// Obtiene una posible descripción adicional (número de serie más número interno en el caso de venta de productos.
		if (is_array($ns_elegidos))
		{
			//echo "<pre>";
			//var_dump($ns_elegidos);
			foreach ($ns_elegidos as $ns_id => $on)
			{
				var_dump($ns_id);
				$ns = new Numeros_serie;
				$ns->retrieve_entity_info($ns_id, "Numeros_serie");
				$descripcion_equipo = "NS: ".$ns->column_fields["numero_serie"];
				if ($ns->column_fields["numero_interno"])
				{
					$descripcion_equipo .= " NI: ".$ns->column_fields["numero_interno"];
				}
				$descripciones[] = $descripcion_equipo;
				$descripcion_adicional = " ".implode(" , ", $descripciones);
			}
			//echo "</pre>";
			//die;
		}

		// Crea un registro de detalle de la factura.
		$facd = new Facturas_det;
		$facd->column_fields["assigned_user_id"] = $current_user->id;
		$facd->column_fields["factura"] = $this->obtener_id();
		//$facd->column_fields["por_facturar"] = $pfa->obtener_id();
		$facd->column_fields["descripcion_breve"] = $fac_tipo;
		//$facd->column_fields["cantidad"] = $pfa->column_fields["dias"];
		$facd->column_fields["cantidad"] = $cantidad;
		$facd->column_fields["codigo"] = $prod->column_fields["productcode"];
		$facd->column_fields["descripcion"] = $prod->column_fields["productname"].$descripcion_adicional;
		//$facd->column_fields["precio_unitario"] = $pfa->precio_unitario();
		//$facd->column_fields["importe"] = $pfa->column_fields["dias"] * $facd->column_fields["precio_unitario"];
		$facd->column_fields["importe"] = $cantidad * $facd->column_fields["precio_unitario"];
		$facd->save("Facturas_det");

		// Actualiza totales.
		$this->totales();
		//die ("Registrando...");
	}

	function tabla_detalles()
	{
		global $adb;

        	$fac_id = $this->obtener_id();

		// Consulta para por facturar.
		//$consulta = "select facd.*, obr.nombre as obra from vtiger_facturas_det facd, vtiger_crmentity e, vtiger_por_facturar pfa, vtiger_obras obr where e.crmid = facd.facturas_detid and e.deleted = '0' and facd.facturasid = '$fac_id' and pfa.por_facturarid = facd.por_facturarid and obr.obrasid = pfa.obrasid order by facd.facturas_detid limit 0, 13";
		//$consulta = "select facd.*, obr.nombre as obra from vtiger_facturas_det facd, vtiger_crmentity e, vtiger_por_facturar pfa, vtiger_obras obr where e.crmid = facd.facturas_detid and e.deleted = '0' and facd.facturasid = '$fac_id' and pfa.por_facturarid = facd.por_facturarid and obr.obrasid = pfa.obrasid order by facd.facturas_detid limit 0, 13";
		//$consulta = "select facd.*, obr.nombre as obra, pfa.* from vtiger_facturas_det facd, vtiger_crmentity e, vtiger_por_facturar pfa, vtiger_obras obr where e.crmid = facd.facturas_detid and e.deleted = '0' and facd.facturasid = '$fac_id' and pfa.por_facturarid = facd.por_facturarid and obr.obrasid = pfa.obrasid order by facd.facturas_detid limit 0, 13";
		$consulta = "select facd.*, obr.nombre as obra, pfa.periodosid, pfa.movimiento, pfa.fecha_ini, pfa.fecha_ini_fac, pfa.fecha_fin, pfa.fecha_fin_fac, pfa.concepto, pfa.productid, pfa.flota_rentaid, pfa.numeros_serieid, pfa.cantidad as unidades from vtiger_facturas_det facd, vtiger_crmentity e, vtiger_por_facturar pfa, vtiger_obras obr where e.crmid = facd.facturas_detid and e.deleted = '0' and facd.facturasid = '$fac_id' and pfa.por_facturarid = facd.por_facturarid and obr.obrasid = pfa.obrasid order by facd.facturas_detid limit 0, 13";
//var_dump($consulta);
		$resultado = $adb->query($consulta);

		while ($renglon = $adb->fetch_array($resultado))
		{
			if (($renglon["concepto"] == "Flete") || (strpos($renglon["concepto"], "Reparaci") !== false))
			{
				$renglon["rem1"] = $renglon["movimiento"];
			}

			if ($renglon["productid"] != "")
			{
				$consulta2 = "select prod.* from vtiger_products prod, vtiger_crmentity e where e.crmid = prod.productid and e.deleted = '0' and prod.productid = '".$renglon["productid"]."'";
//var_dump($consulta2);
				$resultado2 = $adb->query($consulta2);
				$renglon2 = $adb->fetch_array($resultado2);
	//echo "<pre>";
	//var_dump($renglon2);
	//echo "</pre>";
//die;
				$prod_id = $renglon2["productid"];
				$prod_nombre = $renglon2["productname"];

				$renglon["producto"] = $prod_nombre;
			}

			if ($renglon["flota_rentaid"] != "")
			{
				$consulta2 = "select flr.* from vtiger_flota_renta flr, vtiger_crmentity e where e.crmid = flr.flota_rentaid and e.deleted = '0' and flr.flota_rentaid = '".$renglon["flota_rentaid"]."'";
//var_dump($consulta2);
				$resultado2 = $adb->query($consulta2);
				$renglon2 = $adb->fetch_array($resultado2);
	//echo "<pre>";
	//var_dump($renglon2);
	//echo "</pre>";
//die;
				$flr_id = $renglon2["flota_rentaid"];
				$renglon["numero_interno"] = $renglon2["numero_interno"];
			}

			if ($renglon["numeros_serieid"] != "")
			{
				$consulta2 = "select ns.* from vtiger_numeros_serie ns, vtiger_crmentity e where e.crmid = ns.numeros_serieid and e.deleted = '0' and ns.numeros_serieid = '".$renglon["numeros_serieid"]."'";
//var_dump($consulta2);
				$resultado2 = $adb->query($consulta2);
				$renglon2 = $adb->fetch_array($resultado2);
	//echo "<pre>";
	//var_dump($renglon2);
	//echo "</pre>";
//die;
				$ns_id = $renglon2["numeros_serieid"];
				$renglon["numero_serie"] = $renglon2["numero_serie"];
			}

			if ($renglon["periodosid"] != "")
			{
				$consulta2 = "select per.* from vtiger_periodos per, vtiger_crmentity e where e.crmid = per.periodosid and e.deleted = '0' and per.periodosid = '".$renglon["periodosid"]."'";
//var_dump($consulta2);
				$resultado2 = $adb->query($consulta2);
				$renglon2 = $adb->fetch_array($resultado2);
	//echo "<pre>";
	//var_dump($renglon2);
	//echo "</pre>";
//die;
				$per_id = $renglon2["periodosid"];
				$per_idv = $renglon2["idv"];
				$per_apertura = $renglon2["movimiento_apertura"];
				$per_cierre = $renglon2["movimiento_cierre"];

				$renglon["periodo"] = $per_idv;
				$renglon["rem1"] = $per_apertura;
				$renglon["rem2"] = $per_cierre;

				//if ($renglon["fecha_ini_fac"] != "")
				if (($renglon["fecha_ini_fac"] != "") && ($renglon["fecha_ini_fac"] != "0000-00-00"))
				{
					$renglon["ini"] = $renglon["fecha_ini_fac"];
				}
				else
				{
					$renglon["ini"] = $renglon["fecha_ini"];
				}

				//if ($renglon["fecha_fin_fac"] != "")
				if (($renglon["fecha_fin_fac"] != "") && ($renglon["fecha_fin_fac"] != "0000-00-00"))
				{
					$renglon["fin"] = $renglon["fecha_fin_fac"];
				}
				else
				{
					$renglon["fin"] = $renglon["fecha_fin"];
				}
			}

			$renglones[] = $renglon;
		}

/********************************
		// Consulta para productos.
		$consulta = "select facd.* from vtiger_facturas_det facd, vtiger_crmentity e where e.crmid = facd.facturas_detid and e.deleted = '0' and facd.facturasid = '$fac_id' and facd.descripcion_breve like 'Venta%'";
		$resultado = $adb->query($consulta);

		while ($renglon = $adb->fetch_array($resultado))
		{
			$renglones[] = $renglon;
		}
echo "<pre>";
//var_dump($renglones);
$componentes_renglon = each($renglones);
$renglon = $componentes_renglon["value"];
var_dump($renglon);
echo "</pre>";
********************************/
		$iteraciones = 13;

		$tabla_detalles = "<table style=\"width:95%\">";
		if ($this->column_fields["fac_estado"] == "Cancelada")
		{
			$tabla_detalles .= "<tr>";
			$tabla_detalles .= "<td colspan=\"15\" style=\"background:#faa;text-align:center;font-size:24px;color:red;border:1px solid red;padding:3px;\">";
			$tabla_detalles .= "CANCELADA";
			$tabla_detalles .= "</td>";
			$tabla_detalles .= "</tr>";
		}
		$tabla_detalles .= "<tr>";
		$tabla_detalles .= "<th>";
		$tabla_detalles .= "";
		$tabla_detalles .= "</th>";
		$tabla_detalles .= "<th>";
		$tabla_detalles .= "Sincr.";
		$tabla_detalles .= "</th>";
		$tabla_detalles .= "<th>";
		$tabla_detalles .= "Cant.";
		$tabla_detalles .= "</th>";
		$tabla_detalles .= "<th>";
		$tabla_detalles .= "Artículo";
		$tabla_detalles .= "</th>";
		$tabla_detalles .= "<th>";
		$tabla_detalles .= "Obra";
		$tabla_detalles .= "</th>";
		$tabla_detalles .= "<th>";
		$tabla_detalles .= "Periodo";
		$tabla_detalles .= "</th>";
		$tabla_detalles .= "<th colspan=\"2\">";
		$tabla_detalles .= "Remisiones";
		$tabla_detalles .= "</th>";
		$tabla_detalles .= "<th>";
		$tabla_detalles .= "Inicio";
		$tabla_detalles .= "</th>";
		$tabla_detalles .= "<th>";
		$tabla_detalles .= "Fin";
		$tabla_detalles .= "</th>";
		$tabla_detalles .= "<th>";
		$tabla_detalles .= "Producto";
		$tabla_detalles .= "</th>";
		$tabla_detalles .= "<th>";
		$tabla_detalles .= "Unidades";
		$tabla_detalles .= "</th>";
		$tabla_detalles .= "<th>";
		$tabla_detalles .= "NI";
		$tabla_detalles .= "</th>";
		$tabla_detalles .= "<th>";
		$tabla_detalles .= "NS";
		$tabla_detalles .= "</th>";
/***************
		$tabla_detalles .= "<th>";
		$tabla_detalles .= "Descripción";
		$tabla_detalles .= "</th>";
***************/
		$tabla_detalles .= "<th>";
		$tabla_detalles .= "Precio unitario";
		$tabla_detalles .= "</th>";
		$tabla_detalles .= "<th>";
		$tabla_detalles .= "Importe";
		$tabla_detalles .= "</th>";
		$tabla_detalles .= "</tr>";

		$subtotal = 0;
		for ($i = 1; $i <= $iteraciones; $i++)
		{
			$color = ($contador_color % 2)?"#eee":"#fed";
		
			//$renglon = $adb->fetch_array($resultado);
			if (!is_array($renglones))
			{
				continue;
			}

			$componentes_renglon = each($renglones);
			$renglon = $componentes_renglon["value"];
		
			$subtotal += $renglon["importe"];

			$tabla_detalles .= "<tr>";
			$tabla_detalles .= "<td style=\"background:$color;text-align:right;\">";
			$tabla_detalles .= "$tipo $i:";
			$tabla_detalles .= "</td>";
			$tabla_detalles .= "<td style=\"background:$color;text-align:center;\">";
			if ($renglon["sincronizar"] == "1")
			{
				$tabla_detalles .= "*";
			}
			$tabla_detalles .= "</td>";
			$tabla_detalles .= "<td style=\"background:$color;text-align:right;\">";
			$tabla_detalles .= $renglon["cantidad"];
			$tabla_detalles .= "</td>";
			$tabla_detalles .= "<td style=\"background:$color;\">";
			$tabla_detalles .= $renglon["codigo"];
			$tabla_detalles .= "</td>";
			$tabla_detalles .= "<td style=\"background:$color;\">";
			$tabla_detalles .= $renglon["obra"];
			$tabla_detalles .= "</td>";
			$tabla_detalles .= "<td style=\"background:$color;\">";
			$tabla_detalles .= $renglon["periodo"];
			$tabla_detalles .= "</td>";
			$tabla_detalles .= "<td style=\"background:$color;\">";
			$tabla_detalles .= $renglon["rem1"];
			$tabla_detalles .= "</td>";
			$tabla_detalles .= "<td style=\"background:$color;\">";
			$tabla_detalles .= $renglon["rem2"];
			$tabla_detalles .= "</td>";
			$tabla_detalles .= "<td style=\"background:$color;\">";
			$tabla_detalles .= $renglon["ini"];
			$tabla_detalles .= "</td>";
			$tabla_detalles .= "<td style=\"background:$color;\">";
			$tabla_detalles .= $renglon["fin"];
			$tabla_detalles .= "</td>";
			$tabla_detalles .= "<td style=\"background:$color;\">";
			$tabla_detalles .= $renglon["producto"];
			$tabla_detalles .= "</td>";
			$tabla_detalles .= "<td style=\"background:$color;text-align:right;\">";
			$tabla_detalles .= $renglon["unidades"];
			$tabla_detalles .= "</td>";
			$tabla_detalles .= "<td style=\"background:$color;\">";
			$tabla_detalles .= $renglon["numero_interno"];
			$tabla_detalles .= "</td>";
			$tabla_detalles .= "<td style=\"background:$color;\">";
			$tabla_detalles .= $renglon["numero_serie"];
			$tabla_detalles .= "</td>";
/**************
			$tabla_detalles .= "<td style=\"background:$color;\">";
			$tabla_detalles .= $renglon["descripcion"];
			$tabla_detalles .= "</td>";
***************/
			$tabla_detalles .= "<td style=\"background:$color;text-align:right;\">";
			//$tabla_detalles .= $renglon["precio_unitario"];
			if ($renglon["precio_unitario"] != "")
			{
				$tabla_detalles .= number_format($renglon["precio_unitario"], 2);
			}
			$tabla_detalles .= "</td>";
			$tabla_detalles .= "<td style=\"background:$color;text-align:right;\">";
			//$tabla_detalles .= $renglon["importe"];
			if ($renglon["importe"] != "")
			{
				$tabla_detalles .= number_format($renglon["importe"], 2);
			}
			$tabla_detalles .= "</td>";
			$tabla_detalles .= "</tr>";

			$contador_color++;
		}

		$iva = $subtotal * 0.16;
		$total = $subtotal + $iva;
		$colspan = 14;

		$tabla_detalles .= "<tr>";
		$tabla_detalles .= "<th colspan=\"$colspan\" style=\"text-align:right;\">";
		$tabla_detalles .= "Subtotal";
		$tabla_detalles .= "</th>";
		$tabla_detalles .= "<td style=\"text-align:right;background:#eee;\">";
		$tabla_detalles .= number_format($subtotal, 2);
		$tabla_detalles .= "</td>";
		$tabla_detalles .= "</tr>";
		$tabla_detalles .= "<tr>";
		$tabla_detalles .= "<th colspan=\"$colspan\" style=\"text-align:right;\">";
		$tabla_detalles .= "IVA ".$this->column_fields["porcentaje_iva"]."%";
		$tabla_detalles .= "</th>";
		$tabla_detalles .= "<td style=\"text-align:right;background:#eee;\">";
		$tabla_detalles .= number_format($iva, 2);
		$tabla_detalles .= "</td>";
		$tabla_detalles .= "</tr>";
		$tabla_detalles .= "<tr>";
		$tabla_detalles .= "<th colspan=\"$colspan\" style=\"text-align:right;\">";
		$tabla_detalles .= "Total";
		$tabla_detalles .= "</th>";
		$tabla_detalles .= "<td style=\"text-align:right;background:#eee;\">";
		$tabla_detalles .= "<b>";
		$tabla_detalles .= number_format($total, 2);
		$tabla_detalles .= "</b>";
		$tabla_detalles .= "</td>";
		$tabla_detalles .= "</tr>";

		$tabla_detalles .= "</table>";

		return $tabla_detalles;
	}

	// Graba totales.
	function totales()
	{
		global $adb;

		$fac_id = $this->obtener_id();

		//$consulta = "select sum(facd.importe) as subtotal from vtiger_facturas_det facd, vtiger_crmentity e where e.crmid = facd.facturas_detid and e.deleted = '0' and facd.facturasid = '$fac_id' order by facd.facturas_detid limit 0,13";
		$consulta = "select sum(facd.importe) as subtotal from vtiger_facturas_det facd, vtiger_crmentity e where e.crmid = facd.facturas_detid and e.deleted = '0' and facd.facturasid = '$fac_id' order by facd.facturas_detid limit 0,13";
//var_dump($consulta);
		$resultado = $adb->query($consulta);
		$renglon = $adb->fetch_array($resultado);

		// Calcula totales.
		$subtotal = $renglon["subtotal"];
		$porcentaje_iva = 16;
		$iva = $subtotal * 0.16;
		$total = $subtotal + $iva;

		$subtotal = number_format($subtotal, 2);
		$iva = number_format($iva, 2);
		$total = number_format($total, 2);

		$consulta = "update vtiger_facturas fac set fac.subtotal = '$subtotal', fac.porcentaje_iva = '$porcentaje_iva', fac.iva = '$iva', fac.total = '$total' where fac.facturasid = '$fac_id'";
		$adb->query($consulta);
	}

	// Emite la factura.
	function emitir()
	{
		global $adb;

		$fac_id = $this->obtener_id();

		// Obtiene la sucursal.
		$suc = new Sucursales;
		$suc->retrieve_entity_info($this->column_fields["sucursal"], "Sucursales");

		// Deja de utilizar el folio borrador y le asigna su folio oficial.
		//$folio = $this->asignar_folio("Facturas", "facturas", "F");
		$this->asignar_folio("Facturas", "facturas", "F");

		// Marca la factura como emitida y bloqueada.
		$consulta = "update vtiger_facturas set fac_estado = 'Emitida' where facturasid = '$fac_id'";
		//$consulta = "update vtiger_facturas set folio = '$folio', fac_estado = 'Emitida' where facturasid = '$fac_id'";
		$adb->query($consulta);
		$this->bloquear("facturas");

		// Actualiza totales.
		$this->totales();

		// Hace un barrido del detalle de la factura.
		//$consulta = "select facd.codigo, pfa.* from vtiger_facturas_det facd, vtiger_crmentity e, vtiger_por_facturar pfa  where e.crmid = facd.facturas_detid and e.deleted = '0' and facd.facturasid = '$fac_id' and pfa.por_facturarid = facd.por_facturarid";
		//$consulta = "select facd.codigo, facd.cantidad, pfa.productid, pfa.concepto, pfa.numeros_serieid, pfa.flota_rentaid from vtiger_facturas_det facd, vtiger_crmentity e, vtiger_por_facturar pfa  where e.crmid = facd.facturas_detid and e.deleted = '0' and facd.facturasid = '$fac_id' and pfa.por_facturarid = facd.por_facturarid";
		$consulta = "select facd.codigo, facd.cantidad, pfa.productid, pfa.concepto, pfa.numeros_serieid, pfa.flota_rentaid, pfa.periodosid from vtiger_facturas_det facd, vtiger_crmentity e, vtiger_por_facturar pfa  where e.crmid = facd.facturas_detid and e.deleted = '0' and facd.facturasid = '$fac_id' and pfa.por_facturarid = facd.por_facturarid";
		$resultado = $adb->query($consulta);
		while ($renglon = $adb->fetch_array($resultado))
		{
			// Actualiza la última factura del periodo.
			if ($renglon["periodosid"] != "")
			{
				$per = new Periodos;
				$per->retrieve_entity_info($renglon["periodosid"], "Periodos");
				$per->column_fields["ultima_factura"] = $this->column_fields["folio"];
				$per->save("Periodos", $renglon["periodosid"]);
			}

			// Determina el almacén a afectar.
			switch ($renglon["concepto"])
			{
				case "Venta usado":
					$almacen = $suc->column_fields["almacen_usado"];
				break;
				case "Venta nuevo":
					$almacen = $suc->column_fields["almacen_nuevo"];
				break;
				case "Venta refacciones":
					$almacen = $suc->column_fields["almacen_refacciones"];
				break;
				case "Renta de equipo":
					$almacen = $suc->column_fields["almacen_codigos"];
				break;
				default:
					$almacen = $suc->column_fields["almacen_servicios"];
				break;
			}


			// Acumula cantidades considerando el caso de facturar varios renglones de un mismo producto.
			$cantidad[$renglon["codigo"]] += $renglon["cantidad"];

			// Registra en kardex y existencias.

			unset($parametros);
			$parametros["sucursal"] = $this->column_fields["sucursal"];
			$parametros["almacen"] = $almacen;
			$parametros["tipo_documento"] = "Factura";
			$parametros["folio"] = $this->column_fields["folio"];
			$parametros["fecha"] = $this->column_fields["fecha_facturacion"];
			$parametros["producto"] = $renglon["productid"];
			$parametros["codigo_articulo"] = $renglon["codigo"];
			$parametros["entradas"] = 0;
			//$parametros["salidas"] = $renglon["cantidad"];
			$parametros["salidas"] = $cantidad[$renglon["codigo"]];
//echo "<pre>";
//var_dump($parametros);
//var_dump($renglon);
//echo "</pre>";
			$this->kardex($parametros);

			// Afecta número de serie y flota de renta.
			if (($renglon["numeros_serieid"] != "") && (strpos($this->column_fields["fac_tipo"], "Venta") !== false))
			{
				$ns = new Numeros_serie;
				$ns->retrieve_entity_info($renglon["numeros_serieid"], "Numeros_serie");
				$ns->estado("Vendido");
			}
			if (($renglon["flota_rentaid"] != "") && (strpos($this->column_fields["fac_tipo"], "Venta") !== false))
			{
				$flr = new Flota_renta;
				$flr->retrieve_entity_info($renglon["flota_rentaid"], "Flota_renta");
				//$flr->estado("Vendido");
				$flr->transferir($this->column_fields["sucursal"], "Usado", "Vendido", "", $renglon["cantidad"], $this->column_fields["folio"]);
			}
		}
	}

	// Crea una nota de crédito en borrador a partir de esta factura si aún no existe.
	// Devuelve el id de la nota de crédito.
	function nota_credito()
	{
		global $adb;

		$fac_id = $this->obtener_id();

		if ($this->column_fields["fac_estado"] != "Emitida")
		{
			die ("<h1>ERROR</h1>La factura debe estar emitida para poder generar una nota de crédito.");
		}

		// Busca una posible nota existente.
		$consulta = "select nc.* from vtiger_notas_credito nc, vtiger_crmentity e where e.crmid = nc.notas_creditoid and e.deleted = '0' and nc.facturasid = '$fac_id' and nc.nc_estado = 'Borrador'";
//var_dump($consulta);
		$resultado = $adb->query($consulta);
		$renglon = $adb->fetch_array($resultado);
	//echo "<pre>";
	//var_dump($renglon);
	//echo "</pre>";
//die;
		$nc_id = $renglon["notas_creditoid"];

		if ($nc_id == "")
		{
			$nc = new Notas_credito;

			//$nc->column_fields["folio"] = $nc_folio;
			$nc->column_fields["assigned_user_id"] = $this->column_fields["assigned_user_id"];
			$nc->column_fields["sucursal"] = $this->column_fields["sucursal"];
			$nc->column_fields["cliente"] = $this->column_fields["cliente"];
			$nc->column_fields["obra"] = $this->column_fields["obra"];
			$nc->column_fields["nc_tipo"] = $this->column_fields["fac_tipo"];
			$nc->column_fields["fecha_facturacion"] = date("Y-m-d");;
			$nc->column_fields["fecha_vencimiento"] = date("Y-m-d");
			$nc->column_fields["moneda"] = $this->column_fields["moneda"];
			$nc->column_fields["subtotal"] = $this->column_fields["subtotal"];
			$nc->column_fields["porcentaje_iva"] = $this->column_fields["porcentaje_iva"];
			$nc->column_fields["iva"] = $this->column_fields["iva"];
			$nc->column_fields["total"] = $this->column_fields["total"];
			$nc->column_fields["mlan"] = "";
			$nc->column_fields["nc_estado"] = "Borrador";
			$nc->column_fields["observaciones"] = "";
			$nc->column_fields["bloqueado"] = 0;
			$nc->column_fields["factura"] = $fac_id;
			$nc->save("Notas_credito");

			$nc_id = $nc->obtener_id();
			$nc->asignar_folio("Notas_credito", "notas_credito", "N");

			$consulta = "select facd.* from vtiger_facturas_det facd, vtiger_crmentity e where e.crmid = facd.facturas_detid and e.deleted = '0' and facd.facturasid = '$fac_id'";
//var_dump($consulta);
			$resultado = $adb->query($consulta);
			//$renglon = $adb->fetch_array($resultado);
			while ($renglon = $adb->fetch_array($resultado))
			{
	//echo "<pre>";
	//var_dump($renglon);
	//echo "</pre>";
//die;
				$facd_id = $renglon["facturas_detid"];
	$facd_codigo = $renglon["codigo"];
/************************
	$facd_folio = $renglon["folio"];
	$facd_factura = $renglon["factura"];
	$facd_descripcion_breve = $renglon["descripcion_breve"];
	$facd_codigo = $renglon["codigo"];
	$facd_cantidad = $renglon["cantidad"];
	$facd_descripcion = $renglon["descripcion"];
	$facd_precio_unitario = $renglon["precio_unitario"];
	$facd_importe = $renglon["importe"];
	$facd_por_facturar = $renglon["por_facturar"];
	$facd_equipo_venta = $renglon["equipo_venta"];
	$facd_equipo_venta_cantidad = $renglon["equipo_venta_cantidad"];
	$facd_producto_venta = $renglon["producto_venta"];
	$facd_producto_venta_cantidad = $renglon["producto_venta_cantidad"];
************************/
//var_dump($facd_id);
//var_dump($facd_codigo);
				$ncd = new Notas_credito_det;

				$ncd->column_fields["assigned_user_id"] = $this->column_fields["assigned_user_id"];
				$ncd->column_fields["descripcion_breve"] = $renglon["descripcion_breve"];
				//$ncd->column_fields["folio"] = $ncd_folio;
				$ncd->column_fields["nota_credito"] = $nc_id;
				$ncd->column_fields["ncd_efecto"] = "Reabrir";
				$ncd->column_fields["codigo"] = $renglon["codigo"];
				$ncd->column_fields["cantidad"] = $renglon["cantidad"];
				$ncd->column_fields["descripcion"] = $renglon["descripcion"];
				$ncd->column_fields["precio_unitario"] = $renglon["precio_unitario"];
				$ncd->column_fields["importe"] = $renglon["importe"];
				$pfa_id = $renglon["por_facturarid"];
				$ncd->column_fields["por_facturar"] = $pfa_id;

				if ($pfa_id != "")
				{
					$pfa = new Por_facturar;
					$pfa->retrieve_entity_info($pfa_id, "Por_facturar");
					$ncd->column_fields["fecha_ini"] = ($pfa->column_fields["fecha_ini_fac"] != "" && $pfa->column_fields["fecha_ini_fac"] != "0000-00-00")?$pfa->column_fields["fecha_ini_fac"]:$pfa->column_fields["fecha_ini"];
					$ncd->column_fields["fecha_fin"] = ($pfa->column_fields["fecha_fin_fac"] != "" && $pfa->column_fields["fecha_fin_fac"] != "0000-00-00")?$pfa->column_fields["fecha_fin_fac"]:$pfa->column_fields["fecha_fin"];
					$ncd->column_fields["unidades"] = $pfa->column_fields["cantidad"];
				}

				$ncd->column_fields["equipo_venta"] = $renglon["flota_rentaid"];
				$ncd->column_fields["equipo_venta_cantidad"] = $renglon["equipo_venta_cantidad"];
				$ncd->column_fields["producto_venta"] = $renglon["productid"];
				$ncd->column_fields["producto_venta_cantidad"] = $renglon["producto_venta_cantidad"];
				$ncd->column_fields["facd"] = $facd_id;
				$ncd->save("Notas_credito_det");
			}



		}
/************************
	$nc_folio = $renglon["folio"];
	$nc_sucursal = $renglon["sucursal"];
	$nc_cliente = $renglon["cliente"];
	$nc_obra = $renglon["obra"];
	$nc_nc_tipo = $renglon["nc_tipo"];
	$nc_fecha_facturacion = $renglon["fecha_facturacion"];
	$nc_fecha_vencimiento = $renglon["fecha_vencimiento"];
	$nc_moneda = $renglon["moneda"];
	$nc_subtotal = $renglon["subtotal"];
	$nc_porcentaje_iva = $renglon["porcentaje_iva"];
	$nc_iva = $renglon["iva"];
	$nc_total = $renglon["total"];
	$nc_mlan = $renglon["mlan"];
	$nc_nc_estado = $renglon["nc_estado"];
	$nc_observaciones = $renglon["observaciones"];
	$nc_bloqueado = $renglon["bloqueado"];
	$nc_factura = $renglon["factura"];
************************/
//die;

		return $nc_id;
	}

	// Cancela la factura.
	function cancelar()
	{
		// Algoritmo:
		// Ajusta el encabezado, marcando la factura como cancelada, agregando fecha de cancelación y quién la canceló.
		// Hace un barrido de los por facturar relacionados y los clona ajustando los campos necesarios.

		global $adb, $current_user;
//var_dump($current_user);
//die;
//$current_user->retrieveCurrentUserInfoFromFile($_SESSION["authenticated_user_id"]);

		$fac_id = $this->obtener_id();

		if ($this->column_fields["fac_estado"] != "Emitida")
		{
			die ("<h1>ERROR</h1>La factura debe estar emitida para poder ser cancelada.");
		}

		// Ajusta el encabezado.
/********************
Usando this y save da problemas de access restricted file.
		$this->column_fields["fac_estado"] = "Cancelada";
		$this->column_fields["fecha_cancelacion"] = date("Y-m-d");
		//$this->column_fields["cancelado_por"] = $current_user->id;
		$this->column_fields["cancelado_por"] = $_SESSION["authenticated_user_id"];
		$this->save($fac_id, "Facturas");
*******************/
		$consulta = "update vtiger_facturas set fac_estado = 'Cancelada', fecha_cancelacion = '".date("Y-m-d")."', cancelado_por = '".$current_user->user_name."' where facturasid = '$fac_id'";
		$adb->query($consulta);

		// Genera una copia no facturada de los por facturar.
		$consulta = "select pfa.* from vtiger_por_facturar pfa, vtiger_crmentity e where e.crmid = pfa.por_facturarid and e.deleted = '0' and pfa.facturasid = '$fac_id'";
//var_dump($consulta);
		$resultado = $adb->query($consulta);
		//$renglon = $adb->fetch_array($resultado);
		while ($renglon = $adb->fetch_array($resultado))
		{
	//echo "<pre>";
	//var_dump($renglon);
	//echo "</pre>";
//die;
			$pfa_id = $renglon["por_facturarid"];
			$pfa_folio = $renglon["idv"];
//var_dump($pfa_folio);
			$pfa = new Por_facturar;
			$pfa->retrieve_entity_info($pfa_id, "Por_facturar");
			$pfa->column_fields["estado"] = "Pendiente";
			$pfa->column_fields["factura"] = "";
			$pfa->column_fields["fecha_ini_fac"] = "";
			$pfa->column_fields["fecha_fin_fac"] = "";
			$pfa->column_fields["dias_fac"] = "";
			$pfa->column_fields["cantidad_fac"] = "";
			$pfa->column_fields["precio_unitario_fac"] = "";
			$pfa->save("Por_facturar");
//die;
		}

//var_dump("hola");
	}


	// Crea o actualiza los registros necesarios de este documento en la oreja.
	function sincronizar()
	{
		require("oreja_config.php");
		$suc_numero = $oreja_config["sucursal"][$this->column_fields["sucursal"]];

		global $adb;

		$ore = new Oreja;

		$par = new Parametros;
		$config_oreja = json_decode(html_entity_decode($par->valor("config_oreja"), ENT_QUOTES, "UTF-8"), true);

		$fac_id = $this->obtener_id();
		$fac_moneda = ($this->column_fields["moneda"] != "")?$this->column_fields["moneda"]:"MXN";
		$fac_tipo = $this->column_fields["fac_tipo"];
		$oreja = $this->oreja_conectar();

		$cli_id = $this->column_fields["cliente"];

		// Ajuste para segundo cliente y obra.
		if ($this->column_fields["cliente_facturar"] != "")
		{
			$cli_id = $this->column_fields["cliente_facturar"];
		}

		if ($cli_id != "")
		{
			$cli = new Accounts;
			$cli->retrieve_entity_info($cli_id, "Accounts");
			$campo_codigo_cliente = $cli->personalizado("mlan", true);
			//$campo_dias_credito = $cli->personalizado("dias_credito", true);
			$nal_ext = $cli->personalizado("nal_ext");
			$metodo_pago_33 = $cli->personalizado("metodo_pago_33");
//var_dump($metodo_pago_33);

			$obr_id = $this->column_fields["obra"];

// IW3:20160906-1412
			// Ajuste para segundo cliente y obra.
			if ($this->column_fields["obra_facturar"] != "")
			{
				$obr_id = $this->column_fields["obra_facturar"];
			}
// IW3:20160906-1412

			if ($obr_id == "")
			{
				die ("<h1>ERROR</h1>No se pudo leer la obra al sincronizar.");
			}
			$obr = new Obras;
			$obr->retrieve_entity_info($obr_id, "Obras");
			$obr_nombre = $obr->column_fields["nombre"];
			$obr_mlan = $obr->column_fields["codigo_mlan"];

/**************************
echo "<pre>";
var_dump($cli->column_fields);
var_dump($obr->column_fields);
echo "</pre>";
die;
**************************/

			// Sincroniza el cliente.
			//$cli->sincronizar();
			$cli->sincronizar($this->column_fields["folio"], $obr_nombre, $obr_mlan);
		}

		if ($nal_ext == "Extranjero")
		{
		//$oreja_facturas_codigo_concepto_mxn = "4";
		//$oreja_facturas_codigo_concepto_usd = "5";
			$oreja_facturas_codigo_concepto_mxn = $oreja_config["concepto"]["FEMN"][$this->column_fields["sucursal"]];
			$oreja_facturas_codigo_concepto_usd = $oreja_config["concepto"]["FEME"][$this->column_fields["sucursal"]];
		}
		else
		{
			$oreja_facturas_codigo_concepto_mxn = $oreja_config["concepto"]["FNMN"][$this->column_fields["sucursal"]];
			$oreja_facturas_codigo_concepto_usd = $oreja_config["concepto"]["FNME"][$this->column_fields["sucursal"]];
		}

		// LIMPIA DATOS ---------------
		unset($datos);

		// Valida tipo de cambio.
		//$fac_tipo_cambio = ($this->column_fields["tipo_cambio"] != "")?$this->column_fields["tipo_cambio"]:1;
		//$datos["cTipoCambio"] = $fac_tipo_cambio;
		$datos["cTipoCambio"] = $this->column_fields["tipo_cambio"];

		// Valida tipo de cambio.
		if ($datos["cTipoCambio"] == "")
		{
			//$datos["cTipoCambio"] = 1;
			$datos["cTipoCambio"] = $this->tipo_cambio($this->column_fields["fecha_facturacion"], "USD");
		}

		if ($datos["cTipoCambio"] == "")
		{
			die ("<h1>ERROR</h1>Este documento no puede sincronizarse porque no tiene tipo de cambio o porque no se ha registrado el tipo de cambio general para la fecha de facturación.");
		}

/**********************
		$datos["cIdDocumento"] = "ER5";
		$datos["cFecha"] = "2015-09-03";
		$datos["cCodigoConcepto"] = "340";
		$datos["cCodigoCteProv"] = "";
**********************/
		//$datos["cIdDocumento"] = $this->column_fields["folio"];
		//$datos["cFecha"] = $this->column_fields["fecha_facturacion"];
		// ETL2 maneja otro formato de fecha.
		$datos["cFecha"] = date("m/d/Y", strtotime($this->column_fields["fecha_facturacion"]));
		if ($fac_moneda == "MXN")
		{
			$datos["cCodigoConcepto"] = $oreja_facturas_codigo_concepto_mxn;
			$datos["cIdMoneda"] = 1;
		}
		if ($fac_moneda == "USD")
		{
			$datos["cCodigoConcepto"] = $oreja_facturas_codigo_concepto_usd;
			$datos["cIdMoneda"] = 2;
		}
		$datos["cCodigoCteProv"] = $cli->column_fields[$campo_codigo_cliente];
		$datos["cImporte"] = 0;
		$datos["CSERIEDOCUMENTO"] = substr($this->column_fields["folio"], 0, 3);
		$folio = substr($this->column_fields["folio"], 3);
		$datos["CFOLIO"] = (int)$folio;
		$cIdDocumento = $datos["CSERIEDOCUMENTO"].$folio;
		$datos["cIdDocumento"] = $cIdDocumento;
		$datos["CREFERENCIA"] = $this->column_fields["orden_compra"];
		$datos["CMETODOPAG"] = $cli->column_fields[$config_oreja["clientes"]["CMETODOPAG"]];
		$datos["CNUMCTAPAG"] = $cli->column_fields[$config_oreja["clientes"]["CNumCtaPag"]];
/***********************
echo "<pre>";
var_dump($datos);
var_dump($cli->column_fields[$config_oreja["clientes"]["cNumCtaPag"]]);
var_dump($cli->column_fields);
var_dump($config_oreja["clientes"]);
echo "</pre>";
die;
***********************/

		// Agente.
		$usr_id = $this->column_fields["assigned_user_id"];
		$consulta = "select id, user_name from vtiger_users where id = '$usr_id'";
		$resultado = $adb->query($consulta);
		$renglon = $adb->fetch_array($resultado);

		$datos["cCodigoAgente"] = $renglon["id"];

		// Limpia posibles registros previos.
		//$this->oreja_limpiar($oreja, "Documentos", "cIdDocumento", "ER5");
		//$this->oreja_limpiar($oreja, "Movimientos", "cIdDocumento", "ER5");
		$this->oreja_limpiar($oreja, "Documentos", "cIdDocumento", $this->column_fields["folio"]);
		$this->oreja_limpiar($oreja, "Movimientos", "cIdDocumento", $this->column_fields["folio"]);
		$this->oreja_limpiar($oreja, "CapasProducto", "cIdDocumento", $this->column_fields["folio"]);
		$this->oreja_limpiar($oreja, "Agentes", "cCodigoAgente", $usr_id);
//var_dump($datos["cTipoCambio"]);
//die;

		// Transmite el encabezado.
// IW3 201711
// IW3 201712
$datos["cCantParci"] = 2;
//var_dump($metodo_pago_33);
//die;
if (substr($metodo_pago_33, 0, 3) == "PUE")
{
	$datos["cCantParci"] = 1;
}
		//$this->oreja_transmitir($oreja, "Documentos", $datos);
		unset ($parametros);
		$parametros["crmid"] = $fac_id;
		$parametros["tipo_documento"] = "Facturas";
		$parametros["tabla_destino"] = "Documentos";
		$parametros["fecha"] = date("Y-m-d", strtotime($datos["cFecha"]));
		$parametros["datos"] = $datos;
		$this->oreja_transmitir($oreja, "Documentos", $ore->transformar($parametros));
		unset ($parametros);
//die;
// IW3 201712
// IW3 201711

		// Transmite el agente.
		unset($datos);
		$datos["cCodigoAgente"] = $renglon["id"];
		$datos["cNombreAgente"] = $renglon["user_name"];
		$datos["cTipoAgente"] = 2;
		$this->oreja_transmitir($oreja, "Agentes", $datos);

		// Transmite los detalles.
		//$consulta = "select facd.*, obr.nombre as obra, pfa.periodosid, pfa.movimiento, pfa.fecha_ini, pfa.fecha_ini_fac, pfa.fecha_fin, pfa.fecha_fin_fac, pfa.concepto, pfa.productid, pfa.flota_rentaid, pfa.numeros_serieid, pfa.cantidad as unidades from vtiger_facturas_det facd, vtiger_crmentity e, vtiger_por_facturar pfa, vtiger_obras obr where e.crmid = facd.facturas_detid and e.deleted = '0' and facd.facturasid = '$fac_id' and pfa.por_facturarid = facd.por_facturarid and obr.obrasid = pfa.obrasid order by facd.facturas_detid limit 0, 13";
		$consulta = "select facd.*, obr.nombre as obra, pfa.periodosid, pfa.movimiento, pfa.fecha_ini, pfa.fecha_ini_fac, pfa.fecha_fin, pfa.fecha_fin_fac, pfa.concepto, pfa.productid, pfa.flota_rentaid, pfa.numeros_serieid, pfa.cantidad as unidades from vtiger_facturas_det facd, vtiger_crmentity e, vtiger_por_facturar pfa, vtiger_obras obr where e.crmid = facd.facturas_detid and e.deleted = '0' and facd.facturasid = '$fac_id' and pfa.por_facturarid = facd.por_facturarid and obr.obrasid = pfa.obrasid and facd.sincronizar = '1' order by facd.facturas_detid limit 0, 13";
//var_dump($consulta);
		$resultado = $adb->query($consulta);

		$i = 1;
		while ($renglon = $adb->fetch_array($resultado))
		{
			unset($datos);
/**************************
			$datos["cIdDocumento"] = "ER5";
			$datos["cIdMovimiento"] = $datos["cIdDocumento"]."-".str_pad($i, 2, "0", STR_PAD_LEFT);
			$datos["cCodigoProducto"] = "9REP";
			$datos["cCodigoAlmacen"] = "01REP";
			$datos["cUnidades"] = 1;
			$datos["cPrecio"] = 1900.50;
**************************/
			$datos["cIdDocumento"] = $this->column_fields["folio"];
			$datos["cIdMovimiento"] = $datos["cIdDocumento"]."-".str_pad($i, 2, "0", STR_PAD_LEFT);



			if ($renglon["periodosid"] != "")
			{
				$consulta2 = "select per.movimiento_apertura, per.movimiento_cierre from vtiger_periodos per, vtiger_crmentity e where e.crmid = per.periodosid and e.deleted = '0' and per.periodosid = '".$renglon["periodosid"]."'";
//var_dump($consulta2);
				$resultado2 = $adb->query($consulta2);
				$renglon2 = $adb->fetch_array($resultado2);
	//echo "<pre>";
	//var_dump($renglon2);
	//echo "</pre>";
//die;
				$per_id = $renglon2["periodosid"];
				$per_idv = $renglon2["idv"];
				$per_apertura = $renglon2["movimiento_apertura"];
				$per_cierre = $renglon2["movimiento_cierre"];

				$rem1 = substr($per_apertura, 1, 1).(int)substr($per_apertura, 3);
				$rem2 = substr($per_cierre, 1, 1).(int)substr($per_cierre, 3);

				if (($renglon["fecha_ini_fac"] != "") && ($renglon["fecha_ini_fac"] != "0000-00-00"))
				{
					$fecha_ini = $renglon["fecha_ini_fac"];
				}
				else
				{
					$fecha_ini = $renglon["fecha_ini"];
				}

				if (($renglon["fecha_fin_fac"] != "") && ($renglon["fecha_fin_fac"] != "0000-00-00"))
				{
					$fecha_fin = $renglon["fecha_fin_fac"];
				}
				else
				{
					$fecha_fin = $renglon["fecha_fin"];
				}

// IW3 201712
				//$datos["CTEXTOEXTRA1"] = "$fecha_ini,$fecha_fin";
				$datos["CTEXTOEXTRA1"] = "$fecha_ini $fecha_fin";
// IW3 201712
				$datos["CTEXTOEXTRA2"] = "$rem1,$rem2";
			}
// IW3 201712
			//$datos["CTEXTOEXTRA3"] = $renglon["cantidad"];
			$datos["CTEXTOEXTRA3"] = $renglon["unidades"];
// IW3 201712

			$datos["cUnidades"] = $renglon["cantidad"];

			$prod_id = $renglon["productid"];
			if ($prod_id != "")
			{
				$prod = new Products;
				$prod->retrieve_entity_info($prod_id, "Products");
				//$datos["cCodigoProducto"] = $prod->column_fields["productcode"];
				//if ($prod->individual())
				if ((strpos($fac_tipo, "Venta") !== false) && ($prod->individual()))
				{
					$datos["cUnidades"] = 0;
				}
				$prod->sincronizar();

				if ($prod->individual())
				{
					$datos["CIDUNIDAD"] = 0;
				}
				else
				{
					$datos["CIDUNIDAD"] = $oreja_config["medida"]["PZA"];
				}
			}
			$flr_id = $renglon["flota_rentaid"];
			if ($flr_id != "")
			{
				$flr = new Flota_renta;
				$flr->retrieve_entity_info($flr_id, "Flota_renta");
				$flr->sincronizar();
			}
			$datos["cCodigoProducto"] = $renglon["codigo"];
			//$datos["CIDUNIDAD"] = $oreja_config["medida"]["PZA"];

			if ((substr($renglon["codigo"], 0, 1) == "X") || (substr($renglon["codigo"], 0, 2) == "6X"))
			{
				$datos["CIDUNIDAD"] = $oreja_config["medida"]["DIA"];
			}

			if ((substr($renglon["codigo"], 0, 1) == "Y") || (substr($renglon["codigo"], 0, 2) == "6Y"))
			{
				$datos["CIDUNIDAD"] = $oreja_config["medida"]["HORA"];
			}

			if ($oreja_config["medida"][$renglon["codigo"]] != "")
			{
				$datos["CIDUNIDAD"] = $oreja_config["medida"][$oreja_config["medida"][$renglon["codigo"]]]; 
			}
/************************
Renta propio|Renta subarrendado|Servicio maniobra|Servicio reparación|Venta activo fijo|Venta nuevo|Venta refacciones|Venta usado|Varios
************************/

			if ($oreja_config["almacen_especifico"][$renglon["codigo"]] == "")
			{
				if ($fac_tipo == "Renta propio")
				{
					//$datos["cCodigoAlmacen"] = $this->oreja_almacen("FRP", $prod_id);
					$datos["cCodigoAlmacen"] = $this->oreja_almacen("FRP", $prod_id, $suc_numero);
				}
				if ($fac_tipo == "Renta subarrendado")
				{
					$datos["cCodigoAlmacen"] = $this->oreja_almacen("FRS", $prod_id, $suc_numero);
				}
				if ($fac_tipo == "Servicio maniobra")
				{
					$datos["cCodigoAlmacen"] = $this->oreja_almacen("FSM", $prod_id, $suc_numero);
				}
				if (strpos($fac_tipo, "Servicio reparaci") !== false)
				{
					$datos["cCodigoAlmacen"] = $this->oreja_almacen("FSR", $prod_id, $suc_numero);
				}
				if ($fac_tipo == "Venta activo fijo")
				{
					$datos["cCodigoAlmacen"] = $this->oreja_almacen("FVAF", $prod_id, $suc_numero);
				}
				if ($fac_tipo == "Venta nuevo")
				{
					$datos["cCodigoAlmacen"] = $this->oreja_almacen("FVN", $prod_id, $suc_numero);
				}
				if ($fac_tipo == "Venta refacciones")
				{
					$datos["cCodigoAlmacen"] = $this->oreja_almacen("FVR", $prod_id, $suc_numero);
				}
				if ($fac_tipo == "Venta usado")
				{
					$datos["cCodigoAlmacen"] = $this->oreja_almacen("FVU", $prod_id, $suc_numero);
				}
				if ($fac_tipo == "Varios")
				{
					$datos["cCodigoAlmacen"] = $this->oreja_almacen("FVAR", $prod_id, $suc_numero, $renglon["descripcion_breve"], $renglon["codigo"]);
				}
			}
			else
			{
				$datos["cCodigoAlmacen"] = $suc_numero.$oreja_config["almacen_especifico"][$renglon["codigo"]];
			}

// 201810
// Validación para sincronizar 01CRS en almacén cuando es subarrendado.
if (substr($renglon["codigo"], 0, 1) == "6")
{
	$datos["cCodigoAlmacen"] = "{$suc_numero}CRS";
}

// Validación de almacén específico en producto.
//var_dump($prod->personalizado("prod_almacen_oreja"));
//die;
if ($prod->personalizado("prod_almacen_oreja") != "-" && $prod->personalizado("prod_almacen_oreja") != "")
{
	$datos["cCodigoAlmacen"] = $suc_numero.$prod->personalizado("prod_almacen_oreja");
}
// 201810

			$datos["cPrecio"] = $renglon["precio_unitario"];

			// Almacena información que puede servir para capas.
			$movimientos_capas[$datos["cCodigoProducto"]] = $datos["cIdMovimiento"];

// IW3 201711
			//$this->oreja_transmitir($oreja, "Movimientos", $datos);
// IW3 21A
$datos["cUnidadesCapturadas"] = $datos["cUnidades"];
$datos["cPrecioCapturado"] = $datos["cPrecio"];
unset($datos["cUnidades"]);
unset($datos["cPrecio"]);
// IW3 21A
			unset ($parametros);
			$parametros["crmid"] = $fac_id;
			$parametros["tipo_documento"] = "Facturas";
			$parametros["tabla_destino"] = "Movimientos";
			$parametros["fecha"] = date("Y-m-d", strtotime($datos["cFecha"]));
			$parametros["datos"] = $datos;
			$this->oreja_transmitir($oreja, "Movimientos", $ore->transformar($parametros));
			unset ($parametros);
// IW3 201711
//echo "<pre>";
//var_dump($datos);
//echo "</pre>";

			$i++;
		}
//die;

		// Transmite las capas de producto (números de serie).
		$consulta = "select ns.numero_serie, ns.motor, ns.costo, prod.productcode from vtiger_numeros_serie ns, vtiger_crmentity e, vtiger_products prod, vtiger_por_facturar pfa, vtiger_facturas fac where e.crmid = ns.numeros_serieid and e.deleted = '0' and prod.productid = ns.productid and pfa.numeros_serieid = ns.numeros_serieid and pfa.facturasid = fac.facturasid and fac.facturasid = '$fac_id'";

//var_dump($consulta);
//die;
		$resultado = $adb->query($consulta);

		$i = 1;
		while ($renglon = $adb->fetch_array($resultado))
		{
			unset($datos);
			$datos["cIdDocumento"] = $this->column_fields["folio"];
			$datos["cIdMovimiento"] = $movimientos_capas[$renglon["productcode"]];
			$datos["CUNIDADES"] = 1;
			$datos["CPEDIMENTO"] = "";
			$datos["CADUANA"] = "";
			//$datos["CFECHAPEDIMENTO"] = $this->column_fields["fecha_pedimento"];
			$datos["CFECHAPEDIMENTO"] = "";
			$datos["CTIPOCAMBIO"] = 1;
			$datos["CSERIE"] = $renglon["numero_serie"];
			$datos["CNUMEROLOTE"] = "";
			$datos["CFECHACADUCIDAD"] = "";
			$datos["CFECHAFABRICACION"] = "";
			//$datos["CCOSTO"] = $renglon["costo"];
			$datos["cCodigoProducto"] = $renglon["productcode"];

			$this->oreja_transmitir($oreja, "CapasProducto", $datos);

			$i++;
		}

		$this->oreja_desconectar($oreja);
//die;
	}
}
?>
