<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/
require_once('data/CRMEntity.php');
require_once('data/Tracker.php');
require_once('modules/Flota_renta/Flota_renta.php');
require_once('modules/Numeros_serie/Numeros_serie.php');
require_once('modules/Sucursales/Sucursales.php');
require_once('modules/Products/Products.php');
require_once('modules/Salidas/Salidas.php');

class Bajas_flota_renta extends CRMEntity {
	var $db, $log; // Used in class functions of CRMEntity

	var $table_name = 'vtiger_bajas_flota_renta';
	var $table_index= 'bajas_flota_rentaid';
	var $column_fields = Array();

	/** Indicator if this is a custom module or standard module */
	var $IsCustomModule = true;

	/**
	 * Mandatory table for supporting custom fields.
	 */
	var $customFieldTable = Array('vtiger_bajas_flota_rentacf', 'bajas_flota_rentaid');

	/**
	 * Mandatory for Saving, Include tables related to this module.
	 */
	var $tab_name = Array('vtiger_crmentity', 'vtiger_bajas_flota_renta', 'vtiger_bajas_flota_rentacf');

	/**
	 * Mandatory for Saving, Include tablename and tablekey columnname here.
	 */
	var $tab_name_index = Array(
		'vtiger_crmentity' => 'crmid',
		'vtiger_bajas_flota_renta'   => 'bajas_flota_rentaid',
	    'vtiger_bajas_flota_rentacf' => 'bajas_flota_rentaid');

	/**
	 * Mandatory for Listing (Related listview)
	 */
	var $list_fields = Array (
		/* Format: Field Label => Array(tablename, columnname) */
		// tablename should not have prefix 'vtiger_'
		'Bajas_flota_renta Name'=> Array('bajas_flota_renta', 'idv'),
		'Assigned To' => Array('crmentity','smownerid')
	);
	var $list_fields_name = Array(
		/* Format: Field Label => fieldname */
		'Bajas_flota_renta Name'=> 'idv',
		'Assigned To' => 'assigned_user_id'
	);

	// Make the field link to detail view from list view (Fieldname)
	var $list_link_field = 'idv';

	// For Popup listview and UI type support
	var $search_fields = Array(
		/* Format: Field Label => Array(tablename, columnname) */
		// tablename should not have prefix 'vtiger_'
		'Bajas_flota_renta Name'=> Array('bajas_flota_renta', 'idv')
	);
	var $search_fields_name = Array(
		/* Format: Field Label => fieldname */
		'Bajas_flota_renta Name'=> 'idv'
	);

	// For Popup window record selection
	var $popup_fields = Array('idv');

	// Placeholder for sort fields - All the fields will be initialized for Sorting through initSortFields
	var $sortby_fields = Array();

	// For Alphabetical search
	var $def_basicsearch_col = 'idv';

	// Column value to use on detail view record text display
	var $def_detailview_recname = 'idv';

	// Required Information for enabling Import feature
	var $required_fields = Array('idv'=>1);

	// Callback function list during Importing
	var $special_functions = Array('set_import_assigned_user');

	var $default_order_by = 'idv';
	var $default_sort_order='ASC';
	// Used when enabling/disabling the mandatory fields for the module.
	// Refers to vtiger_field.fieldname values.
	var $mandatory_fields = Array('createdtime', 'modifiedtime', 'idv');
	
	function __construct() {
		global $log, $currentModule;
		$this->column_fields = getColumnFields($currentModule);
		$this->db = PearDatabase::getInstance();
		$this->log = $log;
	}

	function getSortOrder() {
		global $currentModule;

		$sortorder = $this->default_sort_order;
		if($_REQUEST['sorder']) $sortorder = $this->db->sql_escape_string($_REQUEST['sorder']);
		else if($_SESSION[$currentModule.'_Sort_Order']) 
			$sortorder = $_SESSION[$currentModule.'_Sort_Order'];

		return $sortorder;
	}

	function getOrderBy() {
		global $currentModule;
		
		$use_default_order_by = '';		
		if(PerformancePrefs::getBoolean('LISTVIEW_DEFAULT_SORTING', true)) {
			$use_default_order_by = $this->default_order_by;
		}
		
		$orderby = $use_default_order_by;
		if($_REQUEST['order_by']) $orderby = $this->db->sql_escape_string($_REQUEST['order_by']);
		else if($_SESSION[$currentModule.'_Order_By'])
			$orderby = $_SESSION[$currentModule.'_Order_By'];
		return $orderby;
	}

	function save_module($module) {
// Prender esta variable para apartado de folios.
//$apartar_folios = true;
$apartar_folios = false;

		// Validaciones.
		if ($this->column_fields["sucursal"] == "")
		{
			die ("<h1>ERROR</h1>No se capturó la sucursal.");
		}

		if ((int)$this->column_fields["cantidad"] < 1 && !$apartar_folios)
		{
			die ("<h1>ERROR</h1>La cantidad debe ser mayor o igual a 1.");
		}

		// Obtiene la sucursal.
		$suc = new Sucursales;
		$suc->retrieve_entity_info($this->column_fields["sucursal"], "Sucursales");

		if ($suc->column_fields["almacen_usado"] == "")
		{
			die ("<h1>ERROR</h1>La sucursal elegida no tiene configurado el almacén de equipo usado.");
		}

		if ($suc->column_fields["almacen_flota"] == "")
		{
			die ("<h1>ERROR</h1>La sucursal elegida no tiene configurado el almacén de flota de renta.");
		}

		// Asigna dueño.
		$this->asignar_dueno("bfr");

		// Procesa la baja.
		if (!$apartar_folios)
		{
			$this->procesar();
		}
	}

	/**
	 * Return query to use based on given modulename, fieldname
	 * Useful to handle specific case handling for Popup
	 */
	function getQueryByModuleField($module, $fieldname, $srcrecord, $query='') {
		// $srcrecord could be empty
	}

	/**
	 * Get list view query (send more WHERE clause condition if required)
	 */
	function getListQuery($module, $usewhere='') {
		$query = "SELECT vtiger_crmentity.*, $this->table_name.*";
		
		// Keep track of tables joined to avoid duplicates
		$joinedTables = array();

		// Select Custom Field Table Columns if present
		if(!empty($this->customFieldTable)) $query .= ", " . $this->customFieldTable[0] . ".* ";

		$query .= " FROM $this->table_name";

		$query .= "	INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index";

		$joinedTables[] = $this->table_name;
		$joinedTables[] = 'vtiger_crmentity';
		
		// Consider custom table join as well.
		if(!empty($this->customFieldTable)) {
			$query .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index";
			$joinedTables[] = $this->customFieldTable[0]; 
		}
		$query .= " LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid";
		$query .= " LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";

		$joinedTables[] = 'vtiger_users';
		$joinedTables[] = 'vtiger_groups';
		
		$linkedModulesQuery = $this->db->pquery("SELECT distinct fieldname, columnname, relmodule FROM vtiger_field" .
				" INNER JOIN vtiger_fieldmodulerel ON vtiger_fieldmodulerel.fieldid = vtiger_field.fieldid" .
				" WHERE uitype='10' AND vtiger_fieldmodulerel.module=?", array($module));
		$linkedFieldsCount = $this->db->num_rows($linkedModulesQuery);
		
		for($i=0; $i<$linkedFieldsCount; $i++) {
			$related_module = $this->db->query_result($linkedModulesQuery, $i, 'relmodule');
			$fieldname = $this->db->query_result($linkedModulesQuery, $i, 'fieldname');
			$columnname = $this->db->query_result($linkedModulesQuery, $i, 'columnname');
			
			$other =  CRMEntity::getInstance($related_module);
			vtlib_setup_modulevars($related_module, $other);
			
			if(!in_array($other->table_name, $joinedTables)) {
				$query .= " LEFT JOIN $other->table_name ON $other->table_name.$other->table_index = $this->table_name.$columnname";
				$joinedTables[] = $other->table_name;
			}
		}

		global $current_user;
		$query .= $this->getNonAdminAccessControlQuery($module,$current_user);
		$query .= "	WHERE vtiger_crmentity.deleted = 0 ".$usewhere;
		return $query;
	}

	/**
	 * Apply security restriction (sharing privilege) query part for List view.
	 */
	function getListViewSecurityParameter($module) {
		global $current_user;
		require('user_privileges/user_privileges_'.$current_user->id.'.php');
		require('user_privileges/sharing_privileges_'.$current_user->id.'.php');

		$sec_query = '';
		$tabid = getTabid($module);

		if($is_admin==false && $profileGlobalPermission[1] == 1 && $profileGlobalPermission[2] == 1 
			&& $defaultOrgSharingPermission[$tabid] == 3) {

				$sec_query .= " AND (vtiger_crmentity.smownerid in($current_user->id) OR vtiger_crmentity.smownerid IN 
					(
						SELECT vtiger_user2role.userid FROM vtiger_user2role 
						INNER JOIN vtiger_users ON vtiger_users.id=vtiger_user2role.userid 
						INNER JOIN vtiger_role ON vtiger_role.roleid=vtiger_user2role.roleid 
						WHERE vtiger_role.parentrole LIKE '".$current_user_parent_role_seq."::%'
					) 
					OR vtiger_crmentity.smownerid IN 
					(
						SELECT shareduserid FROM vtiger_tmp_read_user_sharing_per 
						WHERE userid=".$current_user->id." AND tabid=".$tabid."
					) 
					OR 
						(";
		
					// Build the query based on the group association of current user.
					if(sizeof($current_user_groups) > 0) {
						$sec_query .= " vtiger_groups.groupid IN (". implode(",", $current_user_groups) .") OR ";
					}
					$sec_query .= " vtiger_groups.groupid IN 
						(
							SELECT vtiger_tmp_read_group_sharing_per.sharedgroupid 
							FROM vtiger_tmp_read_group_sharing_per
							WHERE userid=".$current_user->id." and tabid=".$tabid."
						)";
				$sec_query .= ")
				)";
		}
		return $sec_query;
	}

	/**
	 * Create query to export the records.
	 */
	function create_export_query($where)
	{
		global $current_user;
		$thismodule = $_REQUEST['module'];
		
		include("include/utils/ExportUtils.php");

		//To get the Permitted fields query and the permitted fields list
		$sql = getPermittedFieldsQuery($thismodule, "detail_view");
		
		$fields_list = getFieldsListFromQuery($sql);

		$query = "SELECT $fields_list, vtiger_users.user_name AS user_name 
					FROM vtiger_crmentity INNER JOIN $this->table_name ON vtiger_crmentity.crmid=$this->table_name.$this->table_index";

		if(!empty($this->customFieldTable)) {
			$query .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index"; 
		}

		$query .= " LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";
		$query .= " LEFT JOIN vtiger_users ON vtiger_crmentity.smownerid = vtiger_users.id and vtiger_users.status='Active'";
		
		$linkedModulesQuery = $this->db->pquery("SELECT distinct fieldname, columnname, relmodule FROM vtiger_field" .
				" INNER JOIN vtiger_fieldmodulerel ON vtiger_fieldmodulerel.fieldid = vtiger_field.fieldid" .
				" WHERE uitype='10' AND vtiger_fieldmodulerel.module=?", array($thismodule));
		$linkedFieldsCount = $this->db->num_rows($linkedModulesQuery);

		for($i=0; $i<$linkedFieldsCount; $i++) {
			$related_module = $this->db->query_result($linkedModulesQuery, $i, 'relmodule');
			$fieldname = $this->db->query_result($linkedModulesQuery, $i, 'fieldname');
			$columnname = $this->db->query_result($linkedModulesQuery, $i, 'columnname');
			
			$other = CRMEntity::getInstance($related_module);
			vtlib_setup_modulevars($related_module, $other);
			
			$query .= " LEFT JOIN $other->table_name ON $other->table_name.$other->table_index = $this->table_name.$columnname";
		}

		$query .= $this->getNonAdminAccessControlQuery($thismodule,$current_user);
		$where_auto = " vtiger_crmentity.deleted=0";

		if($where != '') $query .= " WHERE ($where) AND $where_auto";
		else $query .= " WHERE $where_auto";

		return $query;
	}

	/**
	 * Initialize this instance for importing.
	 */
	function initImport($module) {
		$this->db = PearDatabase::getInstance();
		$this->initImportableFields($module);
	}

	/**
	 * Create list query to be shown at the last step of the import.
	 * Called From: modules/Import/UserLastImport.php
	 */
	function create_import_query($module) {
		global $current_user;
		$query = "SELECT vtiger_crmentity.crmid, case when (vtiger_users.user_name not like '') then vtiger_users.user_name else vtiger_groups.groupname end as user_name, $this->table_name.* FROM $this->table_name
			INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index
			LEFT JOIN vtiger_users_last_import ON vtiger_users_last_import.bean_id=vtiger_crmentity.crmid
			LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid
			LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid
			WHERE vtiger_users_last_import.assigned_user_id='$current_user->id'
			AND vtiger_users_last_import.bean_type='$module'
			AND vtiger_users_last_import.deleted=0";
		return $query;
	}

	/**
	 * Delete the last imported records.
	 */
	function undo_import($module, $user_id) {
		global $adb;
		$count = 0;
		$query1 = "select bean_id from vtiger_users_last_import where assigned_user_id=? AND bean_type='$module' AND deleted=0";
		$result1 = $adb->pquery($query1, array($user_id)) or die("Error getting last import for undo: ".mysql_error()); 
		while ( $row1 = $adb->fetchByAssoc($result1))
		{
			$query2 = "update vtiger_crmentity set deleted=1 where crmid=?";
			$result2 = $adb->pquery($query2, array($row1['bean_id'])) or die("Error undoing last import: ".mysql_error()); 
			$count++;			
		}
		return $count;
	}
	
	/**
	 * Transform the value while exporting
	 */
	function transform_export_value($key, $value) {
		return parent::transform_export_value($key, $value);
	}

	/**
	 * Function which will set the assigned user id for import record.
	 */
	function set_import_assigned_user()
	{
		global $current_user, $adb;
		$record_user = $this->column_fields["assigned_user_id"];
		
		if($record_user != $current_user->id){
			$sqlresult = $adb->pquery("select id from vtiger_users where id = ? union select groupid as id from vtiger_groups where groupid = ?", array($record_user, $record_user));
			if($this->db->num_rows($sqlresult)!= 1) {
				$this->column_fields["assigned_user_id"] = $current_user->id;
			} else {			
				$row = $adb->fetchByAssoc($sqlresult, -1, false);
				if (isset($row['id']) && $row['id'] != -1) {
					$this->column_fields["assigned_user_id"] = $row['id'];
				} else {
					$this->column_fields["assigned_user_id"] = $current_user->id;
				}
			}
		}
	}
	
	/** 
	 * Function which will give the basic query to find duplicates
	 */
	function getDuplicatesQuery($module,$table_cols,$field_values,$ui_type_arr,$select_cols='') {
		$select_clause = "SELECT ". $this->table_name .".".$this->table_index ." AS recordid, vtiger_users_last_import.deleted,".$table_cols;

		// Select Custom Field Table Columns if present
		if(isset($this->customFieldTable)) $query .= ", " . $this->customFieldTable[0] . ".* ";

		$from_clause = " FROM $this->table_name";

		$from_clause .= "	INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index";

		// Consider custom table join as well.
		if(isset($this->customFieldTable)) {
			$from_clause .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index"; 
		}
		$from_clause .= " LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid
						LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";
		
		$where_clause = "	WHERE vtiger_crmentity.deleted = 0";
		$where_clause .= $this->getListViewSecurityParameter($module);
					
		if (isset($select_cols) && trim($select_cols) != '') {
			$sub_query = "SELECT $select_cols FROM  $this->table_name AS t " .
				" INNER JOIN vtiger_crmentity AS crm ON crm.crmid = t.".$this->table_index;
			// Consider custom table join as well.
			if(isset($this->customFieldTable)) {
				$sub_query .= " LEFT JOIN ".$this->customFieldTable[0]." tcf ON tcf.".$this->customFieldTable[1]." = t.$this->table_index";
			}
			$sub_query .= " WHERE crm.deleted=0 GROUP BY $select_cols HAVING COUNT(*)>1";	
		} else {
			$sub_query = "SELECT $table_cols $from_clause $where_clause GROUP BY $table_cols HAVING COUNT(*)>1";
		}	
		
		
		$query = $select_clause . $from_clause .
					" LEFT JOIN vtiger_users_last_import ON vtiger_users_last_import.bean_id=" . $this->table_name .".".$this->table_index .
					" INNER JOIN (" . $sub_query . ") AS temp ON ".get_on_clause($field_values,$ui_type_arr,$module) .
					$where_clause .
					" ORDER BY $table_cols,". $this->table_name .".".$this->table_index ." ASC";
					
		return $query;		
	}

	/**
	 * Invoked when special actions are performed on the module.
	 * @param String Module name
	 * @param String Event Type (module.postinstall, module.disabled, module.enabled, module.preuninstall)
	 */
	function vtlib_handler($modulename, $event_type) {
		if($event_type == 'module.postinstall') {
			// TODO Handle post installation actions
		} else if($event_type == 'module.disabled') {
			// TODO Handle actions when this module is disabled.
		} else if($event_type == 'module.enabled') {
			// TODO Handle actions when this module is enabled.
		} else if($event_type == 'module.preuninstall') {
			// TODO Handle actions when this module is about to be deleted.
		} else if($event_type == 'module.preupdate') {
			// TODO Handle actions before this module is updated.
		} else if($event_type == 'module.postupdate') {
			// TODO Handle actions after this module is updated.
		}
	}

	/** 
	 * Handle saving related module information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	// function save_related_module($module, $crmid, $with_module, $with_crmid) { }
	
	/**
	 * Handle deleting related module information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function delete_related_module($module, $crmid, $with_module, $with_crmid) { }

	/**
	 * Handle getting related list information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function get_related_list($id, $cur_tab_id, $rel_tab_id, $actions=false) { }

	/**
	 * Handle getting dependents list information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function get_dependents_list($id, $cur_tab_id, $rel_tab_id, $actions=false) { }

	// Procesa la baja.
	function procesar()
	{
		// Bloquea automáticamente el documento.
		$this->bloquear("bajas_flota_renta");

//var_dump($this->column_fields["cantidad"]);
//die;
		// Carga configuración de dueños predeterminados.
		require("duenos.php");

		global $adb;

		// Obtiene la sucursal.
		$suc = new Sucursales;
		$suc->retrieve_entity_info($this->column_fields["sucursal"], "Sucursales");

		// Marca el equipo de la flota como usado.
		$flr = new Flota_renta;
		$flr->retrieve_entity_info($this->column_fields["numero_interno"], "Flota_renta");

		if ($flr->column_fields["producto"] == "")
		{
			die ("<h1>ERROR</h1>El elemento de la flota no tiene registrado su producto.");
		}

		/***************************
		$flr->column_fields["estado"] = "Usado";
		$flr->save("Flota_renta", $this->column_fields["numero_interno"]);

		echo "<pre>";
		var_dump($flr->column_fields);
		echo "</pre>";
		die;
		// Marca el número de serie como usado si existe.
		if ($flr->column_fields["numero_serie"] != "")
		{
			$ns = new Numeros_serie;
			$ns->retrieve_entity_info($flr->column_fields["numero_serie"], "Numeros_serie");
			$ns->column_fields["estado"] = "Usado";
			$ns->save("Numeros_serie", $flr->column_fields["numero_serie"]);
		}
		***************************/
		//$flr->baja($this->column_fields["sucursal"], $this->column_fields["cantidad"]);
		$flr->transferir($this->column_fields["sucursal"], "Disponible", "Usado", "", $this->column_fields["cantidad"], $this->column_fields["folio"]);

		// Obtiene el producto.
		$prod = new Products;
		$prod->retrieve_entity_info($flr->column_fields["producto"], "Products");

		// Registra en kardex y existencias.

		// Flota de renta.
		unset($parametros);
		$parametros["sucursal"] = $this->column_fields["sucursal"];
		$parametros["almacen"] = $suc->column_fields["almacen_flota"];
		$parametros["tipo_documento"] = "Baja de flota de renta";
		$parametros["folio"] = $this->column_fields["folio"];
		$parametros["fecha"] = $this->column_fields["fecha_efectiva"];
		$parametros["producto"] = $flr->column_fields["producto"];
		$parametros["codigo_articulo"] = $flr->column_fields["numero_interno"];
		$parametros["entradas"] = 0;
		$parametros["salidas"] = $this->column_fields["cantidad"];

		$this->kardex($parametros);

		// Usado.
		unset($parametros);
		$parametros["sucursal"] = $this->column_fields["sucursal"];
		$parametros["almacen"] = $suc->column_fields["almacen_usado"];
		$parametros["tipo_documento"] = "Baja de flota de renta";
		$parametros["folio"] = $this->column_fields["folio"];
		$parametros["fecha"] = $this->column_fields["fecha_efectiva"];
		$parametros["producto"] = $flr->column_fields["producto"];
		if ($this->column_fields["subarrendado"])
		{
			$parametros["codigo_articulo"] = "6".$prod->column_fields["productcode"];
		}
		else
		{
			$parametros["codigo_articulo"] = $prod->column_fields["productcode"];
		}
		$parametros["entradas"] = $this->column_fields["cantidad"];
		$parametros["salidas"] = 0;

		$this->kardex($parametros);
//die;
		// Si es subarrendado genera su salida automáticamente.
		if ($this->column_fields["subarrendado"])
		{
			$dueno = $duenos["sal"];

			$sal = new Salidas;
			$sal->column_fields["assigned_user_id"] = $dueno;
			$sal->column_fields["sucursal"] = $this->column_fields["sucursal"];
			$sal->column_fields["sal_tipo"] = "Devolución subarrendamiento";
			$sal->column_fields["fecha_efectiva"] = $this->column_fields["fecha_efectiva"];
			$sal->column_fields["hora_efectiva"] = $this->column_fields["hora_efectiva"];
			$sal->column_fields["subarrendado"] = "1";
			$sal->column_fields["bfr"] = $this->obtener_id();
			$sal->save("Salidas");

			if ($sal->column_fields["folio"] == "")
			{
				$sal->asignar_folio("Salidas", "salidas_especiales", "S");
			}

			// Genera arreglo de captura con la información de detalle de la salida.
			$consulta = "select exi.existenciasid from vtiger_existencias exi, vtiger_crmentity e where e.crmid = exi.existenciasid and e.deleted = '0' and exi.almacenesid = '65422' and exi.codigo_producto = '6".$prod->column_fields["productcode"]."'";
//var_dump($consulta);
			$resultado = $adb->query($consulta);
			$renglon = $adb->fetch_array($resultado);

			$captura[1]["existencia"] = $renglon["existenciasid"];
			$captura[1]["producto"] = $flr->column_fields["producto"];
			$captura[1]["cantidad"] = $this->column_fields["cantidad"];
			$captura[1]["ns"][] = $flr->column_fields["numero_serie"];

/***************
echo "<pre>";
var_dump($captura);
echo "</pre>";
***************/
			$sal->registrar_detalles($captura);
		}
	}

	// Crea o actualiza los registros necesarios de este documento en la oreja.
	function sincronizar()
	{
		require("oreja_config.php");
		$suc_numero = $oreja_config["sucursal"][$this->column_fields["sucursal"]];

		global $adb;

		$bfr_id = $this->obtener_id();
		$flr_id = $this->column_fields["numero_interno"];

		$consulta = "select flr.numero_interno, ns.numero_serie, ns.costo from vtiger_flota_renta flr, vtiger_crmentity e, vtiger_numeros_serie ns where e.crmid = flr.flota_rentaid and e.deleted = '0' and ns.numeros_serieid = flr.numeros_serieid and flr.flota_rentaid = '$flr_id';";
//var_dump($consulta);
//die;
		$resultado = $adb->query($consulta);
		$renglon = $adb->fetch_array($resultado);

		$textoextra1 = $renglon["numero_interno"];
		$sum_costo = $renglon["costo"];
		$acum_cantidad = $this->column_fields["cantidad"];

		$oreja = $this->oreja_conectar();

		//$oreja_bfr_codigo_concepto_salida = "35012";
		//$oreja_bfr_codigo_concepto_entrada = "34012";
		$oreja_bfr_codigo_concepto_salida = $oreja_config["concepto"]["BFRS"][$this->column_fields["sucursal"]];
		$oreja_bfr_codigo_concepto_entrada = $oreja_config["concepto"]["BFRE"][$this->column_fields["sucursal"]];
		//$oreja_bfr_almacen = "01REP";


		// La BFR se traduce en una salida y una entrada.

		// Salida.
		unset($datos);
/**********************
		$datos["cIdDocumento"] = "ER5";
		$datos["cFecha"] = "2015-09-03";
		$datos["cCodigoConcepto"] = "340";
		$datos["cCodigoCteProv"] = "";
**********************/
		$datos["cCodigoCteProv"] = "";

		// ETL2 maneja otro formato de fecha.
		//$datos["cFecha"] = $this->column_fields["fecha_efectiva"];
		if (substr($this->column_fields["fecha_efectiva"], 0, 4) < $oreja_config["ano_inicial"])
		{
			$datos["cFecha"] = "01/01/".$oreja_config["ano_inicial"];
		}
		else
		{
			$datos["cFecha"] = date("m/d/Y", strtotime($this->column_fields["fecha_efectiva"]));
		}

		$datos["cCodigoConcepto"] = $oreja_bfr_codigo_concepto_salida;
		$datos["cCodigoCteProv"] = "";
		$datos["cImporte"] = 0;
		$datos["CSERIEDOCUMENTO"] = substr($this->column_fields["folio"], 0, 3)."S";
		$folio = substr($this->column_fields["folio"], 3);
		$datos["CFOLIO"] = (int)$folio;
		$cIdDocumento = $datos["CSERIEDOCUMENTO"].$folio;
		$datos["cIdDocumento"] = $cIdDocumento;
		$datos["cIdMoneda"] = 1;
		$datos["cTipoCambio"] = 1;
		$folio_salida = $cIdDocumento;

		// Obtiene los datos de la flota de esta baja.
		$flr_id = $this->column_fields["numero_interno"];
		if ($flr_id != "")
		{
			$flr = new Flota_renta;
			$flr->retrieve_entity_info($flr_id, "Flota_renta");
		}
		$flr_codigo_flota = $flr->column_fields["codigo_flota"];
		$flr_producto = $flr->column_fields["producto"];

		// Limpia posibles registros previos.
		//$this->oreja_limpiar($oreja, "Documentos", "cIdDocumento", "ER5");
		//$this->oreja_limpiar($oreja, "Movimientos", "cIdDocumento", "ER5");
		$this->oreja_limpiar($oreja, "Documentos", "cIdDocumento", $cIdDocumento);
		$this->oreja_limpiar($oreja, "Movimientos", "cIdDocumento", $cIdDocumento);
		$this->oreja_limpiar($oreja, "CapasProducto", "cIdDocumento", $cIdDocumento);
//die;

		// Transmite el encabezado.
// 201712
$datos["cCantParci"] = 2;
// 201712
		$this->oreja_transmitir($oreja, "Documentos", $datos);

		// Transmite los detalles.
		// En la BFR todo viene en el encabezado, todo es tabla 1.

		$i = 1;
		unset($datos);
/**************************
			$datos["cIdDocumento"] = "ER5";
			$datos["cIdMovimiento"] = $datos["cIdDocumento"]."-".str_pad($i, 2, "0", STR_PAD_LEFT);
			$datos["cCodigoProducto"] = "9REP";
			$datos["cCodigoAlmacen"] = "01REP";
			$datos["cUnidades"] = 1;
			$datos["cPrecio"] = 1900.50;
**************************/
		$datos["cIdDocumento"] = $cIdDocumento;
		$datos["cIdMovimiento"] = $cIdDocumento."-".str_pad($i, 2, "0", STR_PAD_LEFT);
		$datos["cCodigoProducto"] = $flr_codigo_flota;
		//$datos["cCodigoAlmacen"] = $oreja_bfr_almacen;
		$datos["cUnidades"] = $this->column_fields["cantidad"];
		$datos["cPrecio"] = "";
		$prod_id = $flr_producto;
		if ($prod_id != "")
		{
			$prod = new Products;
			$prod->retrieve_entity_info($prod_id, "Products");
			$datos["cCodigoProducto"] = $prod->column_fields["productcode"];
			$tipo_contable = $prod->tipo_contable();

			if ($tipo_contable == "Activo fijo")
			{
				$datos["CSCMOVTO"] = "0003";
			}

			if ($tipo_contable == "Gasto")
			{
				$datos["CSCMOVTO"] = "0005";
			}

			if ($tipo_contable == "Equipo ligero")
			{
				$datos["CSCMOVTO"] = "0005";
			}

			// Sincroniza el producto.
			$prod->sincronizar();

			if ($prod->individual())
			{
				$datos["CIDUNIDAD"] = 0;
			}
			else
			{
				$datos["CIDUNIDAD"] = $oreja_config["medida"]["PZA"];
			}
		}
		//$datos["cCodigoAlmacen"] = $this->oreja_almacen("BFRS", $prod_id);
		$datos["cCodigoAlmacen"] = $this->oreja_almacen("BFRS", $prod_id, $suc_numero);
		//$datos["cUnidades"] = $this->column_fields["cantidad"];
		$datos["cUnidades"] = 0;
		$datos["cPrecio"] = "";
		$datos["CCOSTOCAPTURADO"] = (float)number_format(($sum_costo / $acum_cantidad), 2, '.', '');


// IW3:20160831-1352
		//$datos["CIDUNIDAD"] = 1;
		//$datos["CIDUNIDAD"] = $oreja_config["medida"]["PZA"];

		if (substr($renglon["productcode"], 0, 1) == "X")
		{
			$datos["CIDUNIDAD"] = $oreja_config["medida"]["DIA"];
		}

		if (substr($renglon["productcode"], 0, 1) == "Y")
		{
			$datos["CIDUNIDAD"] = $oreja_config["medida"]["HORA"];
		}

		if ($oreja_config["medida"][$renglon["productcode"]] != "")
		{
			$datos["CIDUNIDAD"] = $oreja_config["medida"][$oreja_config["medida"][$renglon["productcode"]]]; 
		}
// IW3:20160831-1352

		$datos["CTEXTOEXTRA1"] = $textoextra1;



// IW3:20160907-1247
//unset($datos["CIDUNIDAD"]);
// IW3:20160907-1247

// IW3 21A
$datos["cUnidadesCapturadas"] = $datos["cUnidades"];
$datos["cPrecioCapturado"] = $datos["cPrecio"];
unset($datos["cUnidades"]);
unset($datos["cPrecio"]);
// IW3 21A
		$this->oreja_transmitir($oreja, "Movimientos", $datos);


		// Entrada.
		unset($datos);
/**********************
		$datos["cIdDocumento"] = "ER5";
		$datos["cFecha"] = "2015-09-03";
		$datos["cCodigoConcepto"] = "340";
		$datos["cCodigoCteProv"] = "";
**********************/

		// ETL2 maneja otro formato de fecha.
		//$datos["cFecha"] = $this->column_fields["fecha_efectiva"];
		if (substr($this->column_fields["fecha_efectiva"], 0, 4) < $oreja_config["ano_inicial"])
		{
			$datos["cFecha"] = "01/01/".$oreja_config["ano_inicial"];
		}
		else
		{
			$datos["cFecha"] = date("m/d/Y", strtotime($this->column_fields["fecha_efectiva"]));
		}

		$datos["cCodigoConcepto"] = $oreja_bfr_codigo_concepto_entrada;
		$datos["cCodigoCteProv"] = "";
		$datos["cImporte"] = 0;
		$datos["CSERIEDOCUMENTO"] = substr($this->column_fields["folio"], 0, 3)."E";
		$folio = substr($this->column_fields["folio"], 3);
		$datos["CFOLIO"] = (int)$folio;
		$cIdDocumento = $datos["CSERIEDOCUMENTO"].$folio;
		$datos["cIdDocumento"] = $cIdDocumento;
		$datos["cIdMoneda"] = 1;
		$datos["cTipoCambio"] = 1;
		$folio_entrada = $cIdDocumento;

		// Limpia posibles registros previos.
		//$this->oreja_limpiar($oreja, "Documentos", "cIdDocumento", "ER5");
		//$this->oreja_limpiar($oreja, "Movimientos", "cIdDocumento", "ER5");
		$this->oreja_limpiar($oreja, "Documentos", "cIdDocumento", $cIdDocumento);
		$this->oreja_limpiar($oreja, "Movimientos", "cIdDocumento", $cIdDocumento);
		$this->oreja_limpiar($oreja, "CapasProducto", "cIdDocumento", $cIdDocumento);
//die;

		// Transmite el encabezado.
		$this->oreja_transmitir($oreja, "Documentos", $datos);

		// Transmite los detalles.
		// En la BFR todo viene en el encabezado, todo es tabla 1.

		$i = 1;
		unset($datos);
/**************************
			$datos["cIdDocumento"] = "ER5";
			$datos["cIdMovimiento"] = $datos["cIdDocumento"]."-".str_pad($i, 2, "0", STR_PAD_LEFT);
			$datos["cCodigoProducto"] = "9REP";
			$datos["cCodigoAlmacen"] = "01REP";
			$datos["cUnidades"] = 1;
			$datos["cPrecio"] = 1900.50;
**************************/
		$datos["cIdDocumento"] = $cIdDocumento;
		$datos["cIdMovimiento"] = $cIdDocumento."-".str_pad($i, 2, "0", STR_PAD_LEFT);
// La flota no se registra en adminpaq, sólo el producto!!!
		//$datos["cCodigoProducto"] = $flr_codigo_flota;
		$datos["cCodigoProducto"] = $prod->column_fields["productcode"];
		//$datos["cCodigoAlmacen"] = $oreja_afr_almacen_entrada;
		//$datos["cCodigoAlmacen"] = $this->oreja_almacen("BFRE", $prod_id);
		$datos["cCodigoAlmacen"] = $this->oreja_almacen("BFRE", $prod_id, $suc_numero);
		//$datos["cUnidades"] = $this->column_fields["cantidad"];
		$datos["cUnidades"] = 0;
		$datos["cPrecio"] = "";
		$datos["CCOSTOCAPTURADO"] = (float)number_format(($sum_costo / $acum_cantidad), 2, '.', '');

		$tipo_contable = $prod->tipo_contable();

		if ($tipo_contable == "Activo fijo")
		{
			$datos["CSCMOVTO"] = "0003";
		}

		if ($tipo_contable == "Gasto")
		{
			$datos["CSCMOVTO"] = "0005";
		}

		if ($tipo_contable == "Equipo ligero")
		{
			$datos["CSCMOVTO"] = "0005";
		}

// IW3:20160831-1354
		//$datos["CIDUNIDAD"] = 1;
		//$datos["CIDUNIDAD"] = $oreja_config["medida"]["PZA"];
		if ($prod->individual())
		{
			$datos["CIDUNIDAD"] = 0;
		}
		else
		{
			$datos["CIDUNIDAD"] = $oreja_config["medida"]["PZA"];
		}

		if (substr($renglon["productcode"], 0, 1) == "X")
		{
			$datos["CIDUNIDAD"] = $oreja_config["medida"]["DIA"];
		}

		if (substr($renglon["productcode"], 0, 1) == "Y")
		{
			$datos["CIDUNIDAD"] = $oreja_config["medida"]["HORA"];
		}

		if ($oreja_config["medida"][$renglon["productcode"]] != "")
		{
			$datos["CIDUNIDAD"] = $oreja_config["medida"][$oreja_config["medida"][$renglon["productcode"]]]; 
		}
// IW3:20160831-1354

		$datos["CTEXTOEXTRA1"] = $textoextra1;


// IW3:20160907-1243
//unset($datos["CIDUNIDAD"]);
// IW3:20160907-1243
// IW3 21A
$datos["cUnidadesCapturadas"] = $datos["cUnidades"];
$datos["cPrecioCapturado"] = $datos["cPrecio"];
unset($datos["cUnidades"]);
unset($datos["cPrecio"]);
// IW3 21A

		$this->oreja_transmitir($oreja, "Movimientos", $datos);

		$ns_id = $flr->column_fields["numero_serie"];
/***************************
echo "<pre>";
var_dump($ns_id);
die;
echo "</pre>";
***************************/
		// Capas de producto.
		if ($ns_id != "")
		{
			$ns = new Numeros_serie;
			$ns->retrieve_entity_info($ns_id, "Numeros_serie");

			//Salida.
			unset($datos);
			$datos["cIdDocumento"] = $folio_salida;
			$datos["cIdMovimiento"] = $folio_salida."-01";
			$datos["CUNIDADES"] = 1;
			$datos["CPEDIMENTO"] = "";
			$datos["CADUANA"] = "";
			$datos["CFECHAPEDIMENTO"] = "";
			$datos["CTIPOCAMBIO"] = 1;
			//$datos["CSERIE"] = $ns->column_fields["numero_serie"];
			$datos["CSERIE"] = "NS.".$ns->column_fields["numero_serie"];
			$datos["CNUMEROLOTE"] = "";
			$datos["CFECHACADUCIDAD"] = "";
			$datos["CFECHAFABRICACION"] = "";
			$datos["CCOSTO"] = $sum_costo;
			//$datos["cCodigoProducto"] = $renglon["productcode"];
			$datos["cCodigoProducto"] = $prod->column_fields["productcode"];

/************************
echo "<pre>";
var_dump($datos);
die;
echo "</pre>";
************************/


			$this->oreja_transmitir($oreja, "CapasProducto", $datos);

			// Entrada.
			$datos["cIdDocumento"] = $folio_entrada;
			$datos["cIdMovimiento"] = $folio_entrada."-01";
			$datos["CSERIE"] = $ns->column_fields["numero_serie"];

			$this->oreja_transmitir($oreja, "CapasProducto", $datos);
		}

		$this->oreja_desconectar($oreja);
	}
}
?>
