<?php
// Algunas variables ya deben venir con valor: folio, obr_id.
vd("fact");
vd($folio);
vd($obr_id);

// Obtiene los números internos del documento. Importante: usar número interno y no flr_id, pues se alterna entre flr_disp y flr_obr.
$c =
"
select
flr.flota_rentaid,
flr.numero_interno,
flr.estado
from
vtiger_remisiones_det remd
inner join vtiger_crmentity e on e.crmid = remd.remisiones_detid
inner join vtiger_flota_renta flr on flr.flota_rentaid = remd.flota_rentaid
left join vtiger_entregas ent on ent.entregasid = remd.entregasid
left join vtiger_recolecciones rco on rco.recoleccionesid = remd.recoleccionesid
left join vtiger_cambios cmb on cmb.cambiosid = remd.cambiosid
where
e.deleted = '0'
and (ent.folio = '$folio' or rco.folio = '$folio' or cmb.folio = '$folio')
";
qd($c);

$nints = qrows($c, "numero_interno");
vd($nints);

// Procesamiento de periodos para cada número interno.
foreach ($nints as $nint)
{
vdc("Procesando periodos $nint...");
	q("select @calc_cantidad := 0, @calc_per_ant_id := '', @calc_turno := ''");

	$c =
"
select
flr.flota_rentaid as flr_id,
flr.estado as flr_estado,
flr.numero_interno as flr_numero_interno,
fam.cantidad_alta_flota,
flro.flota_rentaid as flro_id,
flro.estado as flro_estado,
if (fam.cantidad_alta_flota = 'Individual', flr.flota_rentaid, flro.flota_rentaid) as calc_flr_id,
if(ent.entregasid is not null, ent.sucursalesid, if(rco.recoleccionesid is not null, rco.sucursalesid, if(cmb.cambiosid is not null, cmb.sucursalesid, null))) as suc_id,
if(ent.entregasid is not null, ent.accountid, if(rco.recoleccionesid is not null, rco.accountid, if(cmb.cambiosid is not null, cmb.accountid, null))) as cli_id,
obr.obrasid as obr_id,
obr.nombre as obr_nombre,
if(ent.entregasid is not null, 'E', if(rco.recoleccionesid is not null, 'R', if(cmb.cambiosid is not null, 'C', 'ERROR'))) as rem_tipo,
if(ent.entregasid is not null, ent.folio, if(rco.recoleccionesid is not null, rco.folio, if(cmb.cambiosid is not null, cmb.folio, 'ERROR'))) as rem_folio,
if(ent.entregasid is not null, ent.fecha_efectiva, if(rco.recoleccionesid is not null, rco.fecha_efectiva, if(cmb.cambiosid is not null, cmb.fecha_efectiva, 'ERROR'))) as rem_fecha_efectiva,
if(ent.entregasid is not null, ent.hora_efectiva, if(rco.recoleccionesid is not null, rco.hora_efectiva, if(cmb.cambiosid is not null, cmb.hora_efectiva, 'ERROR'))) as rem_hora_efectiva,
if(ent.entregasid is not null, remd.cantidad, if(rco.recoleccionesid is not null, remd.cantidad * -1, if(cmb.cambiosid is not null, remd.cantidad * (if(remd_sentido = 'E', 1, -1)), 'ERROR'))) as rem_cantidad,
@calc_turno := if(ifnull(@calc_turno, '') = '', ent.ent_turno, @calc_turno) as calc_turno,
if (fam.cantidad_alta_flota = 'Individual', if(remd.remd_sentido = 'R', -1, 1), @calc_cantidad := @calc_cantidad + if(ent.entregasid is not null, remd.cantidad, if(rco.recoleccionesid is not null, remd.cantidad * -1, if(cmb.cambiosid is not null, remd.cantidad * (if(remd_sentido = 'E', 1, -1)), 0)))) as calc_cantidad,
@calc_per_ant_id as calc_per_ant_id,
@calc_per_ant_id := per.periodosid as calc_per_id,
per.*
from
vtiger_remisiones_det remd
inner join vtiger_crmentity e on e.crmid = remd.remisiones_detid
inner join vtiger_flota_renta flr on flr.flota_rentaid = remd.flota_rentaid
inner join vtiger_productcf prod2 on prod2.productid = flr.productid
inner join vtiger_lineas lin on lin.lineasid = prod2.$campo_prod_linea
inner join vtiger_familias fam on fam.familiasid = lin.familiasid
left join vtiger_entregas ent on ent.entregasid = remd.entregasid
left join vtiger_recolecciones rco on rco.recoleccionesid = remd.recoleccionesid
left join vtiger_cambios cmb on cmb.cambiosid = remd.cambiosid
left join vtiger_obras obr on obr.obrasid = if(ent.entregasid is not null, ent.obrasid, if(rco.recoleccionesid is not null, rco.obrasid, if(cmb.cambiosid is not null, cmb.obrasid, null)))
left join vtiger_flota_renta flro on flro.numero_interno = flr.numero_interno and flro.obrasid = obr.obrasid
left join
(
select
flr.numero_interno,
per.*
from
vtiger_periodos per
inner join vtiger_crmentity e on e.crmid = per.periodosid
inner join vtiger_flota_renta flr on flr.flota_rentaid = per.flota_rentaid
where
e.deleted = '0'
) as per on per.movimiento_apertura = if(ent.entregasid is not null, ent.folio, if(rco.recoleccionesid is not null, rco.folio, if(cmb.cambiosid is not null, cmb.folio, 'ERROR'))) and per.numero_interno = flr.numero_interno
where
e.deleted = '0'
and obr.obrasid = '$obr_id'
and if(fam.cantidad_alta_flota = 'Individual', 1, flro.estado = 'En obra')
and flr.numero_interno = '$nint'
order by rem_fecha_efectiva, rem_hora_efectiva
";
qd($c);
q("select @calc_cantidad := 0, @calc_per_ant_id := '', @calc_turno := ''");
/************
and flro.estado = 'En obra'
************/
	$datos = qrows($c);
//vd($datos);
	foreach ($datos as $dato)
	{
		if ($dato["rem_folio"] != $folio) continue;
vd($dato["rem_folio"]);
vd($dato["flr_numero_interno"]);

		// Hay 2 casos. Periodo que se abre y periodo que se cierra.

		// Abrir.
		// Si no existe periodo lo crea, excepto cuando cantidad es 0.
vd($dato["calc_per_id"]);
		if ($dato["calc_per_id"] == "")
		{
vd($dato["calc_cantidad"]);
			//if ($dato["calc_cantidad"] < 1) continue;
			if ($dato["calc_cantidad"] > 0)
			{
vd("crear");
				$per = new Periodos;
				$per->column_fields["estado"] = "Abierto";
				$per->column_fields["assigned_user_id"] = $current_user->id;
				$per->column_fields["sucursal"] = $dato["suc_id"];
				$per->column_fields["cliente"] = $dato["cli_id"];
				$per->column_fields["obra"] = $dato["obr_id"];
				$per->column_fields["equipo"] = $dato["calc_flr_id"];
				$per->column_fields["cantidad"] = $dato["calc_cantidad"];
				$per->column_fields["fecha_ini"] = $dato["rem_fecha_efectiva"];
				$per->column_fields["per_turno"] = $dato["calc_turno"];
				$per->column_fields["movimiento_apertura"] = $dato["rem_folio"];
				$per->save("Periodos");
				$per_id = $per->obtener_id();
			}
		}
		else
		{
vd("actualizar");
			$per_id = $dato["calc_per_id"];
			$c =
"
update
vtiger_periodos per
set
sucursalesid = ".$dato["suc_id"].",
accountid = ".$dato["cli_id"].",
obrasid = ".$dato["obr_id"].",
flota_rentaid = ".$dato["calc_flr_id"].",
cantidad = ".$dato["calc_cantidad"].",
fecha_ini = '".$dato["rem_fecha_efectiva"]."',
estado = if(ifnull(estado, '') = '', 'Abierto', estado),
per_turno = '".$dato["calc_turno"]."',
movimiento_apertura = '".$dato["rem_folio"]."'
where
per.periodosid = '$per_id'
";
vd($c);
q($c);
		}

		// Cerrar.
		$c =
"
update
vtiger_periodos per
set
sucursalesid = ".$dato["suc_id"].",
accountid = ".$dato["cli_id"].",
obrasid = ".$dato["obr_id"].",
flota_rentaid = ".$dato["calc_flr_id"].",
fecha_fin = '".$dato["rem_fecha_efectiva"]."',
estado = 'Cerrado',
per_turno = '".$dato["calc_turno"]."',
movimiento_cierre = '".$dato["rem_folio"]."'
where
per.periodosid = '".$dato["calc_per_ant_id"]."'
";
vd($c);
q($c);
		// Calcula pfa usando código existente.
		if ($dato["calc_per_ant_id"] != "")
		{
			$per = new Periodos;
			$per->retrieve_entity_info($dato["calc_per_ant_id"], "Periodos");
			$per->facturar($dato["rem_fecha_efectiva"], true);
		}
	}
}
//vdd("pausa");
?>
