<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/
require_once('data/CRMEntity.php');
require_once('data/Tracker.php');
require_once('modules/Flota_renta_det/Flota_renta_det.php');
require_once('modules/Sucursales/Sucursales.php');
require_once('modules/Obras/Obras.php');
require_once('modules/Products/Products.php');
require_once('modules/Periodos/Periodos.php');
require_once('modules/Numeros_serie/Numeros_serie.php');
require_once("modules/Parametros/Parametros.php");
require_once("modules/Ordenes_trabajo/Ordenes_trabajo.php");
require_once("modules/Altas_flota_renta/Altas_flota_renta.php");
require_once("modules/Bajas_flota_renta/Bajas_flota_renta.php");
require_once("modules/Oreja/Oreja.php");

class Flota_renta extends CRMEntity {
	var $db, $log; // Used in class functions of CRMEntity

	var $table_name = 'vtiger_flota_renta';
	var $table_index= 'flota_rentaid';
	var $column_fields = Array();

	/** Indicator if this is a custom module or standard module */
	var $IsCustomModule = true;

	/**
	 * Mandatory table for supporting custom fields.
	 */
	var $customFieldTable = Array('vtiger_flota_rentacf', 'flota_rentaid');

	/**
	 * Mandatory for Saving, Include tables related to this module.
	 */
	var $tab_name = Array('vtiger_crmentity', 'vtiger_flota_renta', 'vtiger_flota_rentacf');

	/**
	 * Mandatory for Saving, Include tablename and tablekey columnname here.
	 */
	var $tab_name_index = Array(
		'vtiger_crmentity' => 'crmid',
		'vtiger_flota_renta'   => 'flota_rentaid',
	    'vtiger_flota_rentacf' => 'flota_rentaid');

	/**
	 * Mandatory for Listing (Related listview)
	 */
	var $list_fields = Array (
		/* Format: Field Label => Array(tablename, columnname) */
		// tablename should not have prefix 'vtiger_'
		//'Flota_renta Name'=> Array('flota_renta', 'idv'),
		//'Assigned To' => Array('crmentity','smownerid')
		'Número interno'=> Array('flota_renta', 'numero_interno'),
		'Producto'=> Array('flota_renta', 'productid'),
		'Número de serie'=> Array('flota_renta', 'numero_serie'),
		'Estado'=> Array('flota_renta', 'estado'),
		'Obra'=> Array('flota_renta', 'obrasid'),
		'Existencia'=> Array('flota_renta', 'existencia'),
		'Folio'=> Array('flota_renta', 'idv'),
		'Número interno anterior'=> Array('flota_renta', 'numero_interno_anterior'),
	);
	var $list_fields_name = Array(
		/* Format: Field Label => fieldname */
		//'Flota_renta Name'=> 'idv',
		//'Assigned To' => 'assigned_user_id'
		'Número interno'=> 'numero_interno',
		'Producto'=> 'producto',
		'Número de serie'=> 'numero_serie',
		'Estado'=> 'estado',
		'Obra'=> 'obra',
		'Existencia'=> 'existencia',
		'Folio'=> 'idv',
		'Número interno anterior'=> 'numero_interno anterior',
	);

	// Make the field link to detail view from list view (Fieldname)
	//var $list_link_field = 'idv';
	var $list_link_field = 'numero_interno';

	// For Popup listview and UI type support
	var $search_fields = Array(
		/* Format: Field Label => Array(tablename, columnname) */
		// tablename should not have prefix 'vtiger_'
		//'Flota_renta Name'=> Array('flota_renta', 'idv')
		'Número interno'=> Array('flota_renta', 'numero_interno'),
		'Producto'=> Array('flota_renta', 'productid'),
		'Número de serie'=> Array('flota_renta', 'numero_serie'),
		'Estado'=> Array('flota_renta', 'estado'),
		'Obra'=> Array('flota_renta', 'obrasid'),
		'Existencia'=> Array('flota_renta', 'existencia'),
		'Folio'=> Array('flota_renta', 'idv'),
		'Número interno anterior'=> Array('flota_renta', 'numero_interno_anterior'),
	);
	var $search_fields_name = Array(
		/* Format: Field Label => fieldname */
		//'Flota_renta Name'=> 'idv'
		'Número interno'=> 'numero_interno',
		'Producto'=> 'producto',
		'Número de serie'=> 'numero_serie',
		'Estado'=> 'estado',
		'Obra'=> 'obra',
		'Existencia'=> 'existencia',
		'Folio'=> 'idv',
		'Número interno anterior'=> 'numero_interno anterior',
	);

	// For Popup window record selection
	//var $popup_fields = Array('idv');
	var $popup_fields = Array('numero_interno');

	// Placeholder for sort fields - All the fields will be initialized for Sorting through initSortFields
	var $sortby_fields = Array();

	// For Alphabetical search
	var $def_basicsearch_col = 'idv';

	// Column value to use on detail view record text display
	var $def_detailview_recname = 'idv';

	// Required Information for enabling Import feature
	var $required_fields = Array('idv'=>1);

	// Callback function list during Importing
	var $special_functions = Array('set_import_assigned_user');

	var $default_order_by = 'idv';
	var $default_sort_order='ASC';
	// Used when enabling/disabling the mandatory fields for the module.
	// Refers to vtiger_field.fieldname values.
	var $mandatory_fields = Array('createdtime', 'modifiedtime', 'idv');
	
	function __construct() {
		global $log, $currentModule;
		$this->column_fields = getColumnFields($currentModule);
		$this->db = PearDatabase::getInstance();
		$this->log = $log;
	}

	function getSortOrder() {
		global $currentModule;

		$sortorder = $this->default_sort_order;
		if($_REQUEST['sorder']) $sortorder = $this->db->sql_escape_string($_REQUEST['sorder']);
		else if($_SESSION[$currentModule.'_Sort_Order']) 
			$sortorder = $_SESSION[$currentModule.'_Sort_Order'];

		return $sortorder;
	}

	function getOrderBy() {
		global $currentModule;
		
		$use_default_order_by = '';		
		if(PerformancePrefs::getBoolean('LISTVIEW_DEFAULT_SORTING', true)) {
			$use_default_order_by = $this->default_order_by;
		}
		
		$orderby = $use_default_order_by;
		if($_REQUEST['order_by']) $orderby = $this->db->sql_escape_string($_REQUEST['order_by']);
		else if($_SESSION[$currentModule.'_Order_By'])
			$orderby = $_SESSION[$currentModule.'_Order_By'];
		return $orderby;
	}

	function save_module($module) {
		if ($this->column_fields["estado"] == "En obra")
		{
			$this->asignar_dueno();
		}
		else
		{
			$this->asignar_dueno("flota");
		}
	}

	/**
	 * Return query to use based on given modulename, fieldname
	 * Useful to handle specific case handling for Popup
	 */
	function getQueryByModuleField($module, $fieldname, $srcrecord, $query='') {
		// $srcrecord could be empty
	}

	/**
	 * Get list view query (send more WHERE clause condition if required)
	 */
	function getListQuery($module, $usewhere='') {
		// Ideas WWW.
		$codigo_programa = "m/Obr/Obr";
	
		$par = new Parametros;
		$perfil_mecanico = $par->valor("perfil_mecanico");
		$perfiles = explode("|", $perfil_mecanico);
//var_dump($perfil_mecanico);
		// Ideas WWW.

		$query = "SELECT vtiger_crmentity.*, $this->table_name.*";
		
		// Keep track of tables joined to avoid duplicates
		$joinedTables = array();

		// Select Custom Field Table Columns if present
		if(!empty($this->customFieldTable)) $query .= ", " . $this->customFieldTable[0] . ".* ";

		$query .= " FROM $this->table_name";

		$query .= "	INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index";

		$joinedTables[] = $this->table_name;
		$joinedTables[] = 'vtiger_crmentity';
		
		// Consider custom table join as well.
		if(!empty($this->customFieldTable)) {
			$query .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index";
			$joinedTables[] = $this->customFieldTable[0]; 
		}
		$query .= " LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid";
		$query .= " LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";

		$joinedTables[] = 'vtiger_users';
		$joinedTables[] = 'vtiger_groups';
		
		$linkedModulesQuery = $this->db->pquery("SELECT distinct fieldname, columnname, relmodule FROM vtiger_field" .
				" INNER JOIN vtiger_fieldmodulerel ON vtiger_fieldmodulerel.fieldid = vtiger_field.fieldid" .
				" WHERE uitype='10' AND vtiger_fieldmodulerel.module=?", array($module));
		$linkedFieldsCount = $this->db->num_rows($linkedModulesQuery);
		
		for($i=0; $i<$linkedFieldsCount; $i++) {
			$related_module = $this->db->query_result($linkedModulesQuery, $i, 'relmodule');
			$fieldname = $this->db->query_result($linkedModulesQuery, $i, 'fieldname');
			$columnname = $this->db->query_result($linkedModulesQuery, $i, 'columnname');
			
			$other =  CRMEntity::getInstance($related_module);
			vtlib_setup_modulevars($related_module, $other);
			
			if(!in_array($other->table_name, $joinedTables)) {
				$query .= " LEFT JOIN $other->table_name ON $other->table_name.$other->table_index = $this->table_name.$columnname";
				$joinedTables[] = $other->table_name;
			}
		}

		global $current_user;

		// Ideas WWW.
//var_dump($current_user->roleid);
//var_dump($perfiles);
		// En módulo personalizado se usa $this. En i/u/LVU se usa directo.
		//$query .= $this->getNonAdminAccessControlQuery($module,$current_user);
		if (in_array($current_user->roleid, $perfiles))
		{
			$query .= " ";
		}
		else
		{
			$query .= $this->getNonAdminAccessControlQuery($module,$current_user);
		}
//echo "<pre>";
//var_dump(getNonAdminAccessControlQuery($module, $current_user));
//echo "</pre>";
			// Ideas WWW.

		$query .= "	WHERE vtiger_crmentity.deleted = 0 ".$usewhere;
		return $query;
	}

	/**
	 * Apply security restriction (sharing privilege) query part for List view.
	 */
	function getListViewSecurityParameter($module) {
		global $current_user;
		require('user_privileges/user_privileges_'.$current_user->id.'.php');
		require('user_privileges/sharing_privileges_'.$current_user->id.'.php');

		$sec_query = '';
		$tabid = getTabid($module);

		if($is_admin==false && $profileGlobalPermission[1] == 1 && $profileGlobalPermission[2] == 1 
			&& $defaultOrgSharingPermission[$tabid] == 3) {

				$sec_query .= " AND (vtiger_crmentity.smownerid in($current_user->id) OR vtiger_crmentity.smownerid IN 
					(
						SELECT vtiger_user2role.userid FROM vtiger_user2role 
						INNER JOIN vtiger_users ON vtiger_users.id=vtiger_user2role.userid 
						INNER JOIN vtiger_role ON vtiger_role.roleid=vtiger_user2role.roleid 
						WHERE vtiger_role.parentrole LIKE '".$current_user_parent_role_seq."::%'
					) 
					OR vtiger_crmentity.smownerid IN 
					(
						SELECT shareduserid FROM vtiger_tmp_read_user_sharing_per 
						WHERE userid=".$current_user->id." AND tabid=".$tabid."
					) 
					OR 
						(";
		
					// Build the query based on the group association of current user.
					if(sizeof($current_user_groups) > 0) {
						$sec_query .= " vtiger_groups.groupid IN (". implode(",", $current_user_groups) .") OR ";
					}
					$sec_query .= " vtiger_groups.groupid IN 
						(
							SELECT vtiger_tmp_read_group_sharing_per.sharedgroupid 
							FROM vtiger_tmp_read_group_sharing_per
							WHERE userid=".$current_user->id." and tabid=".$tabid."
						)";
				$sec_query .= ")
				)";
		}
		return $sec_query;
	}

	/**
	 * Create query to export the records.
	 */
	function create_export_query($where)
	{
		global $current_user;
		$thismodule = $_REQUEST['module'];
		
		include("include/utils/ExportUtils.php");

		//To get the Permitted fields query and the permitted fields list
		$sql = getPermittedFieldsQuery($thismodule, "detail_view");
		
		$fields_list = getFieldsListFromQuery($sql);

		$query = "SELECT $fields_list, vtiger_users.user_name AS user_name 
					FROM vtiger_crmentity INNER JOIN $this->table_name ON vtiger_crmentity.crmid=$this->table_name.$this->table_index";

		if(!empty($this->customFieldTable)) {
			$query .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index"; 
		}

		$query .= " LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";
		$query .= " LEFT JOIN vtiger_users ON vtiger_crmentity.smownerid = vtiger_users.id and vtiger_users.status='Active'";
		
		$linkedModulesQuery = $this->db->pquery("SELECT distinct fieldname, columnname, relmodule FROM vtiger_field" .
				" INNER JOIN vtiger_fieldmodulerel ON vtiger_fieldmodulerel.fieldid = vtiger_field.fieldid" .
				" WHERE uitype='10' AND vtiger_fieldmodulerel.module=?", array($thismodule));
		$linkedFieldsCount = $this->db->num_rows($linkedModulesQuery);

		for($i=0; $i<$linkedFieldsCount; $i++) {
			$related_module = $this->db->query_result($linkedModulesQuery, $i, 'relmodule');
			$fieldname = $this->db->query_result($linkedModulesQuery, $i, 'fieldname');
			$columnname = $this->db->query_result($linkedModulesQuery, $i, 'columnname');
			
			$other = CRMEntity::getInstance($related_module);
			vtlib_setup_modulevars($related_module, $other);
			
			$query .= " LEFT JOIN $other->table_name ON $other->table_name.$other->table_index = $this->table_name.$columnname";
		}

		$query .= $this->getNonAdminAccessControlQuery($thismodule,$current_user);
		$where_auto = " vtiger_crmentity.deleted=0";

		if($where != '') $query .= " WHERE ($where) AND $where_auto";
		else $query .= " WHERE $where_auto";

		return $query;
	}

	/**
	 * Initialize this instance for importing.
	 */
	function initImport($module) {
		$this->db = PearDatabase::getInstance();
		$this->initImportableFields($module);
	}

	/**
	 * Create list query to be shown at the last step of the import.
	 * Called From: modules/Import/UserLastImport.php
	 */
	function create_import_query($module) {
		global $current_user;
		$query = "SELECT vtiger_crmentity.crmid, case when (vtiger_users.user_name not like '') then vtiger_users.user_name else vtiger_groups.groupname end as user_name, $this->table_name.* FROM $this->table_name
			INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index
			LEFT JOIN vtiger_users_last_import ON vtiger_users_last_import.bean_id=vtiger_crmentity.crmid
			LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid
			LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid
			WHERE vtiger_users_last_import.assigned_user_id='$current_user->id'
			AND vtiger_users_last_import.bean_type='$module'
			AND vtiger_users_last_import.deleted=0";
		return $query;
	}

	/**
	 * Delete the last imported records.
	 */
	function undo_import($module, $user_id) {
		global $adb;
		$count = 0;
		$query1 = "select bean_id from vtiger_users_last_import where assigned_user_id=? AND bean_type='$module' AND deleted=0";
		$result1 = $adb->pquery($query1, array($user_id)) or die("Error getting last import for undo: ".mysql_error()); 
		while ( $row1 = $adb->fetchByAssoc($result1))
		{
			$query2 = "update vtiger_crmentity set deleted=1 where crmid=?";
			$result2 = $adb->pquery($query2, array($row1['bean_id'])) or die("Error undoing last import: ".mysql_error()); 
			$count++;			
		}
		return $count;
	}
	
	/**
	 * Transform the value while exporting
	 */
	function transform_export_value($key, $value) {
		return parent::transform_export_value($key, $value);
	}

	/**
	 * Function which will set the assigned user id for import record.
	 */
	function set_import_assigned_user()
	{
		global $current_user, $adb;
		$record_user = $this->column_fields["assigned_user_id"];
		
		if($record_user != $current_user->id){
			$sqlresult = $adb->pquery("select id from vtiger_users where id = ? union select groupid as id from vtiger_groups where groupid = ?", array($record_user, $record_user));
			if($this->db->num_rows($sqlresult)!= 1) {
				$this->column_fields["assigned_user_id"] = $current_user->id;
			} else {			
				$row = $adb->fetchByAssoc($sqlresult, -1, false);
				if (isset($row['id']) && $row['id'] != -1) {
					$this->column_fields["assigned_user_id"] = $row['id'];
				} else {
					$this->column_fields["assigned_user_id"] = $current_user->id;
				}
			}
		}
	}
	
	/** 
	 * Function which will give the basic query to find duplicates
	 */
	function getDuplicatesQuery($module,$table_cols,$field_values,$ui_type_arr,$select_cols='') {
		$select_clause = "SELECT ". $this->table_name .".".$this->table_index ." AS recordid, vtiger_users_last_import.deleted,".$table_cols;

		// Select Custom Field Table Columns if present
		if(isset($this->customFieldTable)) $query .= ", " . $this->customFieldTable[0] . ".* ";

		$from_clause = " FROM $this->table_name";

		$from_clause .= "	INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index";

		// Consider custom table join as well.
		if(isset($this->customFieldTable)) {
			$from_clause .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index"; 
		}
		$from_clause .= " LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid
						LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";
		
		$where_clause = "	WHERE vtiger_crmentity.deleted = 0";
		$where_clause .= $this->getListViewSecurityParameter($module);
					
		if (isset($select_cols) && trim($select_cols) != '') {
			$sub_query = "SELECT $select_cols FROM  $this->table_name AS t " .
				" INNER JOIN vtiger_crmentity AS crm ON crm.crmid = t.".$this->table_index;
			// Consider custom table join as well.
			if(isset($this->customFieldTable)) {
				$sub_query .= " LEFT JOIN ".$this->customFieldTable[0]." tcf ON tcf.".$this->customFieldTable[1]." = t.$this->table_index";
			}
			$sub_query .= " WHERE crm.deleted=0 GROUP BY $select_cols HAVING COUNT(*)>1";	
		} else {
			$sub_query = "SELECT $table_cols $from_clause $where_clause GROUP BY $table_cols HAVING COUNT(*)>1";
		}	
		
		
		$query = $select_clause . $from_clause .
					" LEFT JOIN vtiger_users_last_import ON vtiger_users_last_import.bean_id=" . $this->table_name .".".$this->table_index .
					" INNER JOIN (" . $sub_query . ") AS temp ON ".get_on_clause($field_values,$ui_type_arr,$module) .
					$where_clause .
					" ORDER BY $table_cols,". $this->table_name .".".$this->table_index ." ASC";
					
		return $query;		
	}

	/**
	 * Invoked when special actions are performed on the module.
	 * @param String Module name
	 * @param String Event Type (module.postinstall, module.disabled, module.enabled, module.preuninstall)
	 */
	function vtlib_handler($modulename, $event_type) {
		if($event_type == 'module.postinstall') {
			// TODO Handle post installation actions
		} else if($event_type == 'module.disabled') {
			// TODO Handle actions when this module is disabled.
		} else if($event_type == 'module.enabled') {
			// TODO Handle actions when this module is enabled.
		} else if($event_type == 'module.preuninstall') {
			// TODO Handle actions when this module is about to be deleted.
		} else if($event_type == 'module.preupdate') {
			// TODO Handle actions before this module is updated.
		} else if($event_type == 'module.postupdate') {
			// TODO Handle actions after this module is updated.
		}
	}

	/** 
	 * Handle saving related module information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	// function save_related_module($module, $crmid, $with_module, $with_crmid) { }
	
	/**
	 * Handle deleting related module information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function delete_related_module($module, $crmid, $with_module, $with_crmid) { }

	/**
	 * Handle getting related list information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function get_related_list($id, $cur_tab_id, $rel_tab_id, $actions=false) { }

	/**
	 * Handle getting dependents list information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function get_dependents_list($id, $cur_tab_id, $rel_tab_id, $actions=false) { }
	function estado($estado)
	{
		$this->column_fields["estado"] = $estado;
		$this->save("Flota_renta", $this->obtener_id());
	}

	function detalle($folio, $cantidad)
	{
		global $adb, $current_user;

		$id_flota = $this->obtener_id();

		// Busca si ya existe un registro de detalle para este folio.
		$consulta = "select flrd.flota_renta_detid from vtiger_flota_renta_det flrd, vtiger_crmentity e where e.crmid = flrd.flota_renta_detid and e.deleted = '0' and flrd.flota_rentaid = '$id_flota' and flrd.documento = '$folio'";
		//var_dump($folio);
		//var_dump($cantidad);
		//var_dump($consulta);

		$resultado = $adb->query($consulta);
		$renglon = $adb->fetch_array($resultado);

		$flrd = new Flota_renta_det;
		/******************************
		// No es necesario.
		if ($renglon["flota_renta_detid"] != "")
		{
			$flrd->retrieve_entity_info($renglon["flota_renta_detid"], "Flota_renta_det");
		}
		*******************************/
		$flrd->column_fields["assigned_user_id"] = $current_user->id;
		$flrd->column_fields["flota_renta"] = $id_flota;
		$flrd->column_fields["documento"] = $folio;
		$flrd->column_fields["cantidad"] = $cantidad;
		$flrd->column_fields["cliente"] = $this->column_fields["cliente"];
		$flrd->column_fields["obra"] = $this->column_fields["obra"];
		$fecha_efectiva = $this->fecha_efectiva($folio);
		$flrd->column_fields["fecha_efectiva"] = $fecha_efectiva["fecha"];
		$flrd->column_fields["hora_efectiva"] = $fecha_efectiva["hora"];
		$flrd->save("Flota_renta_det", $renglon["flota_renta_detid"]);

		$id_flrd = $flrd->obtener_id();
		$flrd->column_fields["acumulado"] = $this->acumulado($folio);
		$flrd->save("Flota_renta_det", $id_flrd);
	}

	function actualizar_cantidad()
	{
		global $adb, $current_user;

		$id_flota = $this->obtener_id();

		// Obtiene el acumulado proveniente de los documentos relacionados con este registro de flota de renta y lo actualiza. Esto facilita la reconstrucción.
		$consulta = "select sum(cantidad) as acumulado from vtiger_flota_renta_det flrd, vtiger_crmentity e where e.crmid = flrd.flota_renta_detid and e.deleted = '0' and flrd.flota_rentaid = '$id_flota'";
		$resultado = $adb->query($consulta);
		$renglon = $adb->fetch_array($resultado);
//var_dump($renglon["acumulado"]);
//die;

		$this->column_fields["existencia"] = $renglon["acumulado"];
		$this->save("Flota_renta", $id_flota);
	}

function acumulado2($folio, $anterior = false)
{
require("modules/Flota_renta/fns/acumulado.php");
return $acumulado;
}
	function acumulado($folio, $anterior = false)
	{
		global $adb, $current_user;

		$id_flota = $this->obtener_id();

		// Revisa si este artículo se maneja individual o agrupado. Si es individual se maneja un solo registro de flota y si es agrupado se maneja un registro por cada estado y obra.
		$producto = new Products;
		$producto->retrieve_entity_info($this->column_fields["producto"], "Products");
		$individual = $producto->individual();

		if ($individual)
		{
			return 1;
		}

		// Obtiene el acumulado proveniente de los documentos relacionados con este registro de flota de renta.
		$consulta = "select flrd.* from vtiger_flota_renta_det flrd, vtiger_crmentity e where e.crmid = flrd.flota_renta_detid and e.deleted = '0' and flrd.flota_rentaid = '$id_flota' and flrd.fecha_efectiva != '' order by flrd.fecha_efectiva, flrd.hora_efectiva";
//echo "<pre>";
//var_dump("acum", $consulta);
//echo "</pre>";
		$resultado = $adb->query($consulta);

		while ($renglon = $adb->fetch_array($resultado))
		{
//var_dump("acum", $acumulado);
			//$acumulado += $renglon["cantidad"];
			if (!$anterior)
			{
				$acumulado += $renglon["cantidad"];
			}
			if ($renglon["documento"] == $folio)
			{
				break;
			}
			if ($anterior)
			{
				$acumulado += $renglon["cantidad"];
			}
		}
//var_dump("acum", $acumulado);
//var_dump($renglon["acumulado"]);

		return $acumulado;
	}

	function transferir($sucursal, $origen, $destino, $obra, $cantidad, $documento)
	{
//var_dump($sucursal, $origen, $destino, $obra, $cantidad, $documento);
		global $adb, $current_user;

		$id_flota = $this->obtener_id();

		// Revisa si este artículo se maneja individual o agrupado. Si es individual se maneja un solo registro de flota y si es agrupado se maneja un registro por cada estado y obra.
		$producto = new Products;
		$producto->retrieve_entity_info($this->column_fields["producto"], "Products");
		$individual = $producto->individual();

		if ($individual)
		{
			$this->column_fields["estado"] = $destino;

			// Ajusta cliente y obra según corresponda.
			if ($destino == "En obra")
			{
				$obr = new Obras;
				$obr->retrieve_entity_info($obra, "Obras");

        			$this->column_fields["cliente"] = $obr->column_fields["cliente"];
        			$this->column_fields["obra"] = $obra;
			}
			else
			{
				// Obtiene la sucursal.
				$suc = new Sucursales;
				$suc->retrieve_entity_info($sucursal, "Sucursales");

        			$this->column_fields["cliente"] = $suc->column_fields["cliente_mks"];
        			$this->column_fields["obra"] = $suc->column_fields["obra_mks"];
			}
			$this->save("Flota_renta", $id_flota);

			// Ajusta estado del número de serie si corresponde hacerlo.
			if(($this->column_fields["numero_serie"] != "") && (($destino == "Usado") || ($destino == "Vendido")))
			{
				$ns = new Numeros_serie;
				$ns->retrieve_entity_info($this->column_fields["numero_serie"], "Numeros_serie");
				$ns->estado($destino);
			}
		}
		else
		{
			// Transfiere cierta cantidad de un artículo de la flota de un estado a otro y equilibra los diferentes registros (disponible, obra o servicio) para que sean congruentes con la existencia de ese código.
$incluir = "modules/Flota_renta/fns/transferir_acumulado.php";
require("clyfn/inc/inc.php");
vdd("flr.transf.agrupado");
/******************************
echo("<h3>Completando detalle...</h3>");
$incluir = "modules/Traspasos/bd/completar_detalle.php";
require("clyfn/inc/inc.php");
q($consulta);
echo("<b>Listo.</b>");
	
			// Obtiene los registros de flota involucrados (disponible, obra y servicio).
			$registros_flr = $this->registros_flota($obra);
//var_dump($registros_flr);

			// Obtiene las instancias de flota correspondientes. Las crea si no existen.
			$flr_origen = new Flota_renta;
			if ($registros_flr[$origen] == "")
			{
				$this->inicializar($sucursal, $origen, $obra);
				$registros_flr = $this->registros_flota($obra);
			}
			$flr_origen->retrieve_entity_info($registros_flr[$origen], "Flota_renta");

			$flr_destino = new Flota_renta;
			if ($registros_flr[$destino] == "")
			{
				$this->inicializar($sucursal, $destino, $obra);
				$registros_flr = $this->registros_flota($obra);
			}
			$flr_destino->retrieve_entity_info($registros_flr[$destino], "Flota_renta");

			// Transfiere la cantidad.
			$flr_origen->detalle($documento, $cantidad * -1);
			$flr_origen->actualizar_cantidad();
			$flr_destino->detalle($documento, $cantidad);
			$flr_destino->actualizar_cantidad();
******************************/
		}
	}

	function inicializar($id_sucursal, $estado, $id_obra = "")
	{
		global $adb, $current_user;

		$id_flota = $this->obtener_id();

		// Obtiene la sucursal.
		$sucursal = new Sucursales;
		$sucursal->retrieve_entity_info($id_sucursal, "Sucursales");

		// Clona la instancia actual.
		$flr = new Flota_renta;
		$flr->retrieve_entity_info($id_flota, "Flota_renta");

		if ($estado == "En obra")
		{
			$obra = new Obras;
			$obra->retrieve_entity_info($id_obra, "Obras");

        		$flr->column_fields["cliente"] = $obra->column_fields["cliente"];
        		$flr->column_fields["obra"] = $id_obra;
		}
		else
		{
        		$flr->column_fields["cliente"] = $sucursal->column_fields["cliente_mks"];
        		$flr->column_fields["obra"] = $sucursal->column_fields["obra_mks"];
		}
     		$flr->column_fields["existencia"] = 0;
		$flr->column_fields["estado"] = $estado;
		$flr->save("Flota_renta");
	}

	function registros_flota($obra = "")
	{
		global $adb, $current_user;

//20F
		$flr_id = $this->obtener_id();

		// Actualiza campo sucursal para este número interno.
		$consulta =
"
update
vtiger_flota_renta flr
inner join vtiger_crmentity e on e.crmid = flr.flota_rentaid
left join vtiger_obras obr on obr.obrasid = flr.obrasid
set
flr.sucursalesid = obr.sucursalesid
where
e.deleted = '0'
and flr.numero_interno = '".$this->column_fields["numero_interno"]."'
";
q($consulta);

		// Obtiene los registros de flota involucrados (disponible, obra y servicio).
/*****************
		$consulta = "select flr.* from vtiger_flota_renta flr, vtiger_crmentity e where e.crmid = flr.flota_rentaid and e.deleted = '0' and flr.numero_interno = '".$this->column_fields["numero_interno"]."' and ((flr.estado = 'En obra' and flr.obrasid = '$obra') or flr.estado != 'En obra')";
		$consulta =
"
select
flr.*
from
vtiger_flota_renta flr,
vtiger_crmentity e
where
e.crmid = flr.flota_rentaid
and e.deleted = '0'
and flr.numero_interno = '".$this->column_fields["numero_interno"]."'
and ((flr.estado = 'En obra' and flr.obrasid = '$obra') or flr.estado != 'En obra')
";
		//var_dump($consulta);
*****************/
		$consulta =
"
select
obr.obrasid as obr_id,
obr.sucursalesid as obr_suc_id,
obr.nombre as obr_nombre,
flr.*
from
vtiger_flota_renta flr
inner join vtiger_crmentity e on e.crmid = flr.flota_rentaid
left join vtiger_obras obr on obr.obrasid = flr.obrasid
where
e.deleted = '0'
and flr.numero_interno = '".$this->column_fields["numero_interno"]."'
and if(flr.estado = 'En obra', flr.obrasid = '$obra', flr.sucursalesid =
(
select
flr.sucursalesid
from
vtiger_flota_renta flr
inner join vtiger_crmentity e on e.crmid = flr.flota_rentaid
where
e.deleted = '0'
and flr.flota_rentaid = '$flr_id'
))
";
/**************
and ((flr.estado = 'En obra' and flr.obrasid = '$obra') or flr.estado != 'En obra')
**************/
//qd($consulta);

		$resultado = $adb->query($consulta);
		while ($renglon = $adb->fetch_array($resultado))
		{
			$registros_flr[$renglon["estado"]] = $renglon["flota_rentaid"];
			$suc_id = $renglon["sucursalesid"];
		}
		//var_dump($registros_flr);

		// Verifica si existe registro para obra. Si no hay crea uno.
		if ($registros_flr["En obra"] == "")
		{
//vd("obra");
			$this->inicializar($suc_id, "En obra", $obra);
			$registros_flr = $this->registros_flota($obra);
		}

		// Verifica si existe registro para servicio. Si no hay crea uno.
		if ($registros_flr["En servicio"] == "")
		{
//vd("servicio");
			$this->inicializar($suc_id, "En servicio");
			$registros_flr = $this->registros_flota($obra);
		}


/***********
		$consulta =
"
select
*
from
(
select
'Disponible' as calc_estado
union
select
'En obra' as calc_estado
union
select
'En servicio' as calc_estado
) as c1
left join ($consulta) as c2 on c2.estado = c1.calc_estado
";
***********/
//qd($consulta);

//vdd($registros_flr);
//20F

		return $registros_flr;
	}

	//function transferir($sucursal, $origen, $destino, $obra, $cantidad, $documento)
	function cerrar_periodos($obra, $cantidad, $documento, $fecha_fin)
	{
//vd($obra);
//var_dump("fin", $fecha_fin);
		global $adb, $current_user;

		// Revisa y corrige, de ser necesario, los periodos existentes para esta obra y número interno.
		$this->corregir_periodos($obra);

		// Vuelve a abrir los periodos que ya hubiera cerrado este documento (pensando en una reconstrucción).
		$this->reabrir_periodos($obra, $documento);

		$id_flota = $this->obtener_id();

		// Revisa si este artículo se maneja individual o agrupado. Si es individual se maneja un solo registro de flota y si es agrupado se maneja un registro por cada estado y obra.
		$producto = new Products;
		$producto->retrieve_entity_info($this->column_fields["producto"], "Products");
		$individual = $producto->individual();

		if ($individual)
		{
			$id_flr = $id_flota;
		}
		else
		{
			$registros_flr = $this->registros_flota($obra);
			$id_flr = $registros_flr["En obra"];
		}

//vd($id_flr);
//vd("flr.cerr");
		if ($cantidad == "acumulado")
		{
			$flr = new Flota_renta;
			$flr->retrieve_entity_info($id_flr, "Flota_renta");
			//$cantidad = $flr->acumulado($documento);
			$cantidad = $flr->acumulado($documento, true);
		}

		// Detecta los periodos que requieren cerrarse para poder recoger la cantidad de flota de la obra según se especifica en la remisión.
		//$consulta = "select per.* from vtiger_periodos per, vtiger_crmentity e where e.crmid = per.periodosid and e.deleted = '0' and per.flota_rentaid = '$id_flr' and per.estado like 'Abiert%' order by per.fecha_ini";
		$consulta = "select per.* from vtiger_periodos per, vtiger_crmentity e where e.crmid = per.periodosid and e.deleted = '0' and per.flota_rentaid = '$id_flr' and per.estado like 'Abiert%' and per.movimiento_apertura != '$documento' order by per.fecha_ini";
		//var_dump($consulta);
		$resultado = $adb->query($consulta);

		$restante = $cantidad;
		$acumulado = 0;

		while ($renglon = $adb->fetch_array($resultado))
		{
			//echo "<br>".$renglon["idv"];
			$per = new Periodos;
			$per->retrieve_entity_info($renglon["periodosid"], "Periodos");
			$per->cerrar($restante, $documento, $fecha_fin);

			if ($renglon["cantidad"] >= $restante)
			{
				break;
			}
			$restante -= $renglon["cantidad"];
			$acumulado += $renglon["cantidad"];
		}

		return $acumulado;
	}

	function reabrir_periodos($obra, $documento)
	{
		global $adb, $current_user;

		$id_flota = $this->obtener_id();

		// Revisa si este artículo se maneja individual o agrupado. Si es individual se maneja un solo registro de flota y si es agrupado se maneja un registro por cada estado y obra.
		$producto = new Products;
		$producto->retrieve_entity_info($this->column_fields["producto"], "Products");
		$individual = $producto->individual();

		if ($individual)
		{
			$id_flr = $id_flota;
		}
		else
		{
			$registros_flr = $this->registros_flota($obra);
			$id_flr = $registros_flr["En obra"];
		}

		// Detecta los periodos que requieren volver a abrirse para poder aplicar nuevamente una recolección o cambio.
		$consulta = "select per.* from vtiger_periodos per, vtiger_crmentity e where e.crmid = per.periodosid and e.deleted = '0' and per.flota_rentaid = '$id_flr' and per.movimiento_cierre = '$documento'";
		//var_dump($consulta);
		$resultado = $adb->query($consulta);

		unset($reabrir);
		while ($renglon = $adb->fetch_array($resultado))
		{
			//echo "<br>".$renglon["idv"];
			$reabrir[] = "'".$renglon["movimiento_apertura"]."'";

			$per = new Periodos;
			$per->retrieve_entity_info($renglon["periodosid"], "Periodos");
			$per->column_fields["estado"] = "Abierto";
			$per->column_fields["movimiento_cierre"] = "";
			$per->column_fields["fecha_fin"] = "";
			$per->save("Periodos", $renglon["periodosid"]);
		}

		// Si no hay nada que abrir se termina el procesamiento.
		if (is_null($reabrir))		
		{
			return;
		}

		$lista_reabrir = implode(",", $reabrir);

		// Agrupa posibles periodos partidos por una recolección o cambio previos.
		// IMPORTANTE: Sólo se pueden agrupar periodos del movimiento de cierre en cuestión o que estén todavía abiertos.
		//$consulta = "select count(per.movimiento_apertura) as periodos, per.movimiento_apertura, sum(per.cantidad) as cantidad, per.periodosid, per.idv  from vtiger_periodos per, vtiger_crmentity e where e.crmid = per.periodosid and e.deleted = '0' and per.flota_rentaid = '$id_flr' group by per.movimiento_apertura";
		$consulta = "select count(per.movimiento_apertura) as periodos, per.movimiento_apertura, sum(per.cantidad) as cantidad, per.periodosid, per.idv  from vtiger_periodos per, vtiger_crmentity e where e.crmid = per.periodosid and e.deleted = '0' and per.flota_rentaid = '$id_flr' and per.movimiento_apertura in ($lista_reabrir) and (per.movimiento_cierre = '$documento' or per.movimiento_cierre = '') group by per.movimiento_apertura";
		//var_dump($consulta);
		$resultado = $adb->query($consulta);

		// Busca el movimiento de apertura con 2 periodos.
		while ($renglon = $adb->fetch_array($resultado))
		{
			if ($renglon["periodos"] > 1)
			{
				$id_periodo = $renglon["periodosid"];
				$movimiento_apertura = $renglon["movimiento_apertura"];
				$cantidad = $renglon["cantidad"];

				// Actualiza la cantidad del periodo y borra los restantes.
				$consulta = "update vtiger_periodos set cantidad = '$cantidad' where periodosid = '$id_periodo'";
				//var_dump($consulta);
				$adb->query($consulta);

				$consulta = "update vtiger_periodos per, vtiger_crmentity e set e.deleted = '1' where e.crmid = per.periodosid and per.movimiento_apertura = '$movimiento_apertura' and per.flota_rentaid = '$id_flr' and per.periodosid != '$id_periodo'";
				//var_dump($consulta);
				$adb->query($consulta);
			}
		}
	}

	function abrir_periodos($sucursal, $cliente, $obra, $documento, $fecha_ini)
	{
		global $adb, $current_user;

		$id_flota = $this->obtener_id();
//echo "<pre>";
//var_dump("abrir_per", $id_flota);

		// Revisa si este artículo se maneja individual o agrupado. Si es individual se maneja un solo registro de flota y si es agrupado se maneja un registro por cada estado y obra.
		$producto = new Products;
		$producto->retrieve_entity_info($this->column_fields["producto"], "Products");
		$individual = $producto->individual();

		if ($individual)
		{
			$id_flr = $id_flota;
		}
		else
		{
			$registros_flr = $this->registros_flota($obra);
			$id_flr = $registros_flr["En obra"];
		}

		$flr = new Flota_renta;
		$flr->retrieve_entity_info($id_flr, "Flota_renta");

		// Crea o actualiza, según sea el caso, el periodo de renta correspondiente.
		$consulta = "select per.* from vtiger_periodos per, vtiger_crmentity e where e.crmid = per.periodosid and e.deleted = '0' and per.flota_rentaid = '$id_flr' and per.movimiento_apertura = '$documento'";
//var_dump($consulta);
		//die ($consulta);
		$resultado = $adb->query($consulta);
		$renglon = $adb->fetch_array($resultado);
		$id_periodo = $renglon["periodosid"];

		$periodo = new Periodos;
		if ($id_periodo != "")
		{
			$periodo->retrieve_entity_info($id_periodo, "Periodos");
		}
//var_dump($periodo);
		$periodo->column_fields["estado"] = "Abierto";
		$periodo->column_fields["assigned_user_id"] = $current_user->id;
		$periodo->column_fields["sucursal"] = $sucursal;
		$periodo->column_fields["cliente"] = $cliente;
		$periodo->column_fields["obra"] = $obra;
		$periodo->column_fields["equipo"] = $id_flr;
		$periodo->column_fields["cantidad"] = ($individual)?1:$flr->acumulado($documento);
		$periodo->column_fields["fecha_ini"] = $fecha_ini;
		$periodo->column_fields["movimiento_apertura"] = $documento;
//var_dump("indiv", $individual);
//var_dump($flr->acumulado($documento));
//var_dump($periodo->column_fields);
		if ($periodo->column_fields["cantidad"] >= 1)
		{
			$periodo->save("Periodos", $id_periodo);
		}
//echo "</pre>";
	}

	// Corrige periodos. Se detectó que los periodos que hayan sido importados manualmente pueden presentar errores en los ids de obra y flota por una deficiencia en el programa de importación del vtiger.
	function corregir_periodos($obra)
	{
		global $adb, $current_user;

		$id_flota = $this->obtener_id();
		$num_int = $this->column_fields["numero_interno"];

		// Revisa si este artículo se maneja individual o agrupado. Si es individual se maneja un solo registro de flota y si es agrupado se maneja un registro por cada estado y obra.
		$producto = new Products;
		$producto->retrieve_entity_info($this->column_fields["producto"], "Products");
		$individual = $producto->individual();

		if ($individual)
		{
			$id_flr = $id_flota;
		}
		else
		{
			$registros_flr = $this->registros_flota($obra);
			$id_flr = $registros_flr["En obra"];
		}

		// Obtiene el id del cliente a partir de la obra.
		$obr = new Obras;
		$obr->retrieve_entity_info($obra, "Obras");
		$id_cliente = $obr->column_fields["cliente"];
		$nombre_obra = $obr->column_fields["nombre"];

		// Detecta los periodos que requieren volver a abrirse para poder aplicar nuevamente una recolección o cambio.
/*********************
		var_dump("cli:", $id_cliente);
		var_dump("obr:", $obra);
		var_dump("num_int:", $num_int);
		var_dump("flr:", $id_flr);
*********************/

		$consulta = "update vtiger_periodos per, vtiger_crmentity e, vtiger_flota_renta flr, vtiger_obras obr set per.flota_rentaid = '$id_flr', per.obrasid = '$obra' where e.crmid = per.periodosid and e.deleted = '0' and per.accountid = '$id_cliente' and flr.flota_rentaid = per.flota_rentaid and obr.obrasid = per.obrasid and flr.numero_interno = '$num_int' and obr.nombre = '$nombre_obra'";
		//var_dump($consulta);
		$adb->query($consulta);
//die;
	}

	// Devuelve el código correspondiente al tipo solicitado a partir del número interno.
	function codigo($tipo = "renta")
	{
		switch ($tipo)
		{
			case "renta":
				$letra = "X";
			break;
			case "hextra":
				$letra = "Y";
			break;
		}

		// Hay 4 casos, producto de las combinaciones de valores de las variables equipo y subarrendado.
		if (substr($this->column_fields["numero_interno"], 0, 1) == "6")
		{
			// Subarrendado.
			if (substr($this->column_fields["numero_interno"], 1, 1) == "E")
			{
				// Equipo.
				//$codigo = preg_replace("/6E/", "6X", $this->column_fields["numero_interno"], 1);
				$codigo = preg_replace("/6E/", "6$letra", $this->column_fields["numero_interno"], 1);
			}
			else
			{
				// No equipo.
				//$codigo = preg_replace("/6/", "6X", $this->column_fields["numero_interno"], 1);
				$codigo = preg_replace("/6/", "6$letra", $this->column_fields["numero_interno"], 1);
			}
		}
		else
		{
			// No subarrendado.
			if (substr($this->column_fields["numero_interno"], 0, 1) == "E")
			{
				// Equipo.
				//$codigo = preg_replace("/E/", "X", $this->column_fields["numero_interno"], 1);
				$codigo = preg_replace("/E/", "$letra", $this->column_fields["numero_interno"], 1);
			}
			else
			{
				// No equipo.
				//$codigo = "X".$this->column_fields["numero_interno"];
				$codigo = "$letra".$this->column_fields["numero_interno"];
			}
		}

		return $codigo;
	}

	// Da de baja una cantidad del número interno solicitado.
	function baja($sucursal, $cantidad = 1)
	{
		// La flota se maneja diferente según si es individual o agrupado.
		if ($this->individual())
		{
			$flr->column_fields["estado"] = "Usado";
			$flr->save("Flota_renta", $this->column_fields["numero_interno"]);
	
			// Marca el número de serie como usado si existe.
			if ($flr->column_fields["numero_serie"] != "")
			{
				$ns = new Numeros_serie;
				$ns->retrieve_entity_info($flr->column_fields["numero_serie"], "Numeros_serie");
				$ns->column_fields["estado"] = "Usado";
				$ns->save("Numeros_serie", $flr->column_fields["numero_serie"]);
			}
		}
		else
		{
			$registros_flr = $this->registros_flota();
//echo "<pre>";
//var_dump($registros_flr);
//echo "</pre>";
			// Valida registro de disponible. Debe existir.
			if ($registros_flr["Disponible"] == "")
			{
				die ("<h1>ERROR</h1>No se encontró el registro de flota de renta con estado \"Disponible\" correspondiente.<br>(m/FLR/FLR)");
			}

			// Verifica si existe registro de usado. Si no hay crea uno.
			if ($registros_flr["Usado"] == "")
			{
				$this->inicializar($sucursal, "Usado");
				$registros_flr = $this->registros_flota();
			}
//echo "<pre>";
//var_dump($registros_flr);
//echo "</pre>";

			// Actualiza cantidades en disponible y en usado.
			$flr_disponible = new Flota_renta;
			$flr_disponible->retrieve_entity_info($registros_flr["Disponible"], "Flota_renta");
			$flr_disponible->column_fields["existencia"] -= $cantidad;
			$flr_disponible->save("Flota_renta", $registros_flr["Disponible"]);

			$flr_usado = new Flota_renta;
			$flr_usado->retrieve_entity_info($registros_flr["Usado"], "Flota_renta");
			$flr_usado->column_fields["existencia"] += $cantidad;
			$flr_usado->save("Flota_renta", $registros_flr["Usado"]);
//die;
		}
	}

	// Revisa si este registro de flota se maneja individual o agrupado a través de su producto asociado.
	function individual()
	{
		$producto = new Products;
		$producto->retrieve_entity_info($this->column_fields["producto"], "Products");
		$individual = $producto->individual();

		return $individual;
	}

	// Obtiene el número interno a partir de un código de renta.
	function codigo_renta_a_numero_interno($codigo)
	{
		// Hay 4 casos, producto de las combinaciones de valores de las variables equipo y subarrendado.
		// Si es subarrendado es la misma lógica pero desplazada una posición a la derecha.
		$desplazamiento = (substr($codigo, 0, 1) == "6")?1:0;
		$letra = substr($codigo, 0 + $desplazamiento, 1);
		$prefijo = substr($codigo, 1 + $desplazamiento, 1);

		if (!is_numeric($prefijo))
		{
			// Equipo.
			$reemplazo = "E";
		}
		else
		{
			// No equipo.
			$reemplazo = "";
		}

		$codigo = preg_replace("/$letra/", $reemplazo, $codigo, 1);

		return $codigo;
	}

	// Genera la tabla con el historial del equipo.
	function historial()
	{
		global $adb;

		$flr_id = $this->obtener_id();

		$tabla = "<table>";
		$tabla .= "<tr>";
		$tabla .= "<th>";
		$tabla .= "Número interno";
		$tabla .= "</th>";
		$tabla .= "<th>";
		$tabla .= "Documento";
		$tabla .= "</th>";
		$tabla .= "<th>";
		$tabla .= "Fecha efectiva";
		$tabla .= "</th>";
		$tabla .= "<th>";
		$tabla .= "Hora efectiva";
		$tabla .= "</th>";
		$tabla .= "<th>";
		$tabla .= "Horómetro";
		$tabla .= "</th>";
		$tabla .= "<th>";
		$tabla .= "Combustible";
		$tabla .= "</th>";
		$tabla .= "</tr>";

		$consulta = "select afe.* from vtiger_afectacion afe, vtiger_crmentity e where e.crmid = afe.afectacionid and e.deleted = '0' and afe.flota_rentaid = '$flr_id' order by fecha_efectiva, hora_efectiva";
//var_dump($consulta);
		$resultado = $adb->query($consulta);
//$renglon = $adb->fetch_array($resultado);
		while ($renglon = $adb->fetch_array($resultado))
		{
	//echo "<pre>";
	//var_dump($renglon);
	//echo "</pre>";
//die;
		$afe_id = $renglon["afectacionid"];
		$afe_documento = $renglon["documento"];
		$afe_fecha_efectiva = $renglon["fecha_efectiva"];
		$afe_hora_efectiva = $renglon["hora_efectiva"];
		$afe_horometro = $renglon["horometro"];
		$afe_combustible = $renglon["combustible"];
/************************
	$afe_folio = $renglon["folio"];
	$afe_afe_tipo_documento = $renglon["afe_tipo_documento"];
	$afe_sucursal = $renglon["sucursal"];
	$afe_cliente = $renglon["cliente"];
	$afe_obra = $renglon["obra"];
	$afe_proveedor = $renglon["proveedor"];
	$afe_subarrendado = $renglon["subarrendado"];
	$afe_afe_tipo_interno = $renglon["afe_tipo_interno"];
	$afe_codigo = $renglon["codigo"];
	$afe_producto = $renglon["producto"];
	$afe_cantidad = $renglon["cantidad"];
	$afe_almacen = $renglon["almacen"];
	$afe_numero_interno = $renglon["numero_interno"];
	$afe_numero_serie = $renglon["numero_serie"];
	$afe_costo = $renglon["costo"];
	$afe_modulo = $renglon["modulo"];
	$afe_crmid = $renglon["crmid"];
************************/
			$tabla .= "<tr>";
			$tabla .= "<td>";
			$tabla .= $flr_numero_interno;
			$tabla .= "</td>";
			$tabla .= "<td>";
			$tabla .= $afe_documento;
			$tabla .= "</td>";
			$tabla .= "<td>";
			$tabla .= $afe_fecha_efectiva;
			$tabla .= "</td>";
			$tabla .= "<td>";
			$tabla .= $afe_hora_efectiva;
			$tabla .= "</td>";
			$tabla .= "<td>";
			$tabla .= $afe_horometro;
			$tabla .= "</td>";
			$tabla .= "<td>";
			$tabla .= $afe_combustible;
			$tabla .= "</td>";
			$tabla .= "</tr>";
		}
		$tabla .= "</table>";

		$historial = $tabla;

		return $historial;
	}

	// Recalcula alguna información del equipo, como horómetro, próximo mantenimiento, etc.
	function recalcular($fecha_calculo = "")
	{
		global $adb;

		$flr_id = $this->obtener_id();

		if ($fecha_calculo == "")
		{
			$fecha_calculo = date("Y-m-d");
		}

		// Horómetro teórico.
		$horometro_teorico = $this->horometro_teorico($fecha_calculo);
//var_dump($horometro_teorico);
//die;

		// Horómetro.
		//$consulta = "select afe.horometro from vtiger_afectacion afe, vtiger_crmentity e where e.crmid = afe.afectacionid and e.deleted = '0' order by fecha_efectiva desc, hora_efectiva desc limit 0,1";
		$consulta = "select afe.horometro from vtiger_afectacion afe, vtiger_crmentity e where e.crmid = afe.afectacionid and e.deleted = '0' and afe.horometro != '' and afe.flota_rentaid = '$flr_id' order by fecha_efectiva desc, hora_efectiva desc limit 0,1";
//var_dump($consulta);
		$resultado = $adb->query($consulta);
		$renglon = $adb->fetch_array($resultado);
		$flr_horometro = $renglon["horometro"];

		// Último servicio.
		$consulta = "select afe.fecha_efectiva from vtiger_afectacion afe, vtiger_crmentity e where e.crmid = afe.afectacionid and e.deleted = '0' and afe.modulo = 'Ordenes_trabajo' and afe.flota_rentaid = '$flr_id' order by fecha_efectiva desc, hora_efectiva desc limit 0,1";
//var_dump($consulta);
		$resultado = $adb->query($consulta);
		$renglon = $adb->fetch_array($resultado);
		$flr_ultimo_servicio = $renglon["fecha_efectiva"];

		// Actualiza el equipo.
		//$consulta = "update vtiger_flota_renta flr set flr.horometro = '$flr_horometro', flr.ultimo_servicio = '$flr_ultimo_servicio' where flr.flota_rentaid = '$flr_id'";
		$consulta = "update vtiger_flota_renta flr set flr.horometro = '$flr_horometro', flr.horometro_teorico = '$horometro_teorico', flr.ultimo_servicio = '$flr_ultimo_servicio' where flr.flota_rentaid = '$flr_id'";
		$adb->query($consulta);
	}

	// Calcula el horómetro teórico.
	// Se buscan los periodos que cumplan las siguientes condiciones:
	// - Fecha inicial mayor o igual que la fecha de último servicio (anterior a la fecha de cálculo)
	// - Fecha final menor o igual a la fecha de cálculo.
	function horometro_teorico($fecha_calculo)
	{
		global $adb;

		$flr_id = $this->obtener_id();

		if ($fecha_calculo == "")
		{
			$fecha_calculo = date("Y-m-d");
		}
//$fecha_calculo = "2014-04-30";
//$fecha_calculo = "2014-05-09";
//$fecha_calculo = "2014-05-12";

		$horometro_teorico = 0;

		// Último servicio menor o igual a la fecha de cálculo.
		$consulta = "select afe.fecha_efectiva from vtiger_afectacion afe, vtiger_crmentity e where e.crmid = afe.afectacionid and e.deleted = '0' and afe.modulo = 'Ordenes_trabajo' and afe.fecha_efectiva <= '$fecha_calculo' and afe.flota_rentaid = '$flr_id' order by fecha_efectiva desc, hora_efectiva desc limit 0,1";
//var_dump($consulta);
		$resultado = $adb->query($consulta);
		$renglon = $adb->fetch_array($resultado);
		$flr_ultimo_servicio = $renglon["fecha_efectiva"];
//var_dump($flr_ultimo_servicio);
//die;

		//$consulta = "select per.* from vtiger_periodos per, vtiger_crmentity e where e.crmid = per.periodosid and e.deleted = '0' and per.flota_rentaid = '$flr_id' and per.fecha_ini >= '$flr_ultimo_servicio' and per.fecha_fin <= '$fecha_calculo'";
		$consulta = "select per.* from vtiger_periodos per, vtiger_crmentity e where e.crmid = per.periodosid and e.deleted = '0' and per.flota_rentaid = '$flr_id' and per.fecha_ini <= '$fecha_calculo'";
/******************
		if ($flr_ultimo_servicio != "")
		{
			$consulta .= " and per.fecha_ini >= '$flr_ultimo_servicio'";
		}
******************/
//var_dump($consulta);
		$resultado = $adb->query($consulta);
		//$renglon = $adb->fetch_array($resultado);
		while ($renglon = $adb->fetch_array($resultado))
		{
//var_dump($renglon["idv"]);
	//echo "<pre>";
	//var_dump($renglon);
	//echo "</pre>";
//die;
			$per_id = $renglon["periodosid"];
			$per_folio = $renglon["idv"];
			$per_fecha_ini = $renglon["fecha_ini"];
			$per_fecha_fin = $renglon["fecha_fin"];
			$per_turno = $renglon["per_turno"];
			$per_estado = $renglon["estado"];

			$fecha_ini = new DateTime($per_fecha_ini);

			if ($flr_ultimo_servicio != "")
			{
//var_dump("hola");
//var_dump($per_fecha_ini);
//var_dump($per_fecha_fin);
				$ultimo_servicio = new DateTime($flr_ultimo_servicio);
				$fecha_fin = new DateTime($per_fecha_fin);

				//if ($ultimo_servicio > $fecha_fin)
				if ($per_fecha_fin != "" && $per_fecha_fin != "0000-00-00" && $ultimo_servicio > $fecha_fin)
				{
//var_dump("hola");
					continue;
				}
				$fecha_ini = new DateTime($flr_ultimo_servicio);
			}

//var_dump("hola");
			switch ($per_turno)
			{
				case "Doble":
					$horas_dia = 16;
				break;
				case "Triple":
					$horas_dia = 24;
				break;
				default:
					$horas_dia = 8;
				break;
			}

			//$fecha_ini = new DateTime($per_fecha_ini);
			//if ($per_fecha_fin <= $fecha_calculo)
			if ($per_fecha_fin <= $fecha_calculo && $per_fecha_fin != "" && $per_fecha_fin != "0000-00-00")
			{
//var_dump("leído");
				$fecha_fin = new DateTime($per_fecha_fin);
			}
			else
			{
				$fecha_fin = new DateTime($fecha_calculo);
			}
			$diferencia = $fecha_fin->diff($fecha_ini);
//var_dump($fecha_ini);
//var_dump($fecha_fin);
//var_dump("calculado");
//var_dump($diferencia->days + 1);
			$horometro_teorico = ($diferencia->days + 1) * $horas_dia;
/************************
	$per_sucursal = $renglon["sucursal"];
	$per_cliente = $renglon["cliente"];
	$per_obra = $renglon["obra"];
	$per_equipo = $renglon["equipo"];
	$per_cantidad = $renglon["cantidad"];
	$per_facturado_hasta = $renglon["facturado_hasta"];
	$per_estado = $renglon["estado"];
	$per_movimiento_apertura = $renglon["movimiento_apertura"];
	$per_movimiento_cierre = $renglon["movimiento_cierre"];
	$per_ultima_factura = $renglon["ultima_factura"];
************************/
		}

//var_dump($horometro_teorico);
//die;
		return $horometro_teorico;
	}

	// Genera la tabla con los equipos que requieren mantenimiento, ya sea por fecha o por horómetro.
	function tabla_mantenimiento($suc_id)
	{
		global $adb;

		//$flr_id = $this->obtener_id();
		$prod = new Products;
		$campo_linea = $prod->personalizado("linea", true);

		$tabla .= "<table style=\"padding-bottom:20px;border-collapse:collapse;border:1px solid #ddd;width:90%\">";
		$tabla .= "<tr>";
//$tabla .= "<th class=\"dvtCellLabel\" style=\"width:10px;text-align:center;\">";
		$tabla .= "<th class=\"dvtCellLabel\">";
		$tabla .= "N&uacute;mero interno";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvtCellLabel\">";
		$tabla .= "Cliente";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvtCellLabel\">";
		$tabla .= "Obra";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvtCellLabel\" style=\"width:250px;\">";
		$tabla .= "Producto";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvtCellLabel\">";
		$tabla .= "Estatus";
		$tabla .= "</th>";
/***************************
		$tabla .= "<th class=\"dvtCellLabel\">";
		$tabla .= "N&uacute;mero de serie";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvtCellLabel\">";
		$tabla .= "Observaciones";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvtCellLabel\">";
		$tabla .= "Tipo";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvtCellLabel\">";
		$tabla .= "N&uacute;mero interno cliente";
		$tabla .= "</th>";
**************************/
		$tabla .= "<th class=\"dvtCellLabel\">";
		$tabla .= "Hor&oacute;metro";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvtCellLabel\">";
		$tabla .= "&Uacute;ltimo servicio";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvtCellLabel\">";
		$tabla .= "Hor&oacute;metro te&oacute;rico";
		$tabla .= "</th>";
		//$tabla .= "<th class=\"dvtCellLabel\" colspan=\"2\">";
		$tabla .= "<th class=\"dvtCellLabel\">";
		$tabla .= "Acciones";
		$tabla .= "</th>";
		$tabla .= "</tr>";

		//$consulta = "select flr.* from vtiger_flota_renta flr, vtiger_crmentity e where e.crmid = flr.flota_rentaid and e.deleted = '0' and cast(flr.horometro_teorico as signed) > 80";
		//$consulta = "select flr.* from vtiger_flota_renta flr inner join vtiger_crmentity e on e.crmid = flr.flota_rentaid left join vtiger_productcf prod2 on prod2.productid = flr.productid left join vtiger_lineas lin on lin.lineasid = prod2.$campo_linea where e.deleted = '0' and cast(flr.horometro_teorico as signed) > lin.mantenimiento_horometro";
		//$consulta = "select flr.* from vtiger_flota_renta flr inner join vtiger_crmentity e on e.crmid = flr.flota_rentaid left join vtiger_productcf prod2 on prod2.productid = flr.productid left join vtiger_lineas lin on lin.lineasid = prod2.$campo_linea where e.deleted = '0' and cast(flr.horometro_teorico as signed) > (lin.mantenimiento_horometro * 0.8)";
		//$consulta = "select flr.*, cli.accountname as cliente, obr.nombre as obra, prod.productname as producto, lin.mantenimiento_horometro from vtiger_flota_renta flr inner join vtiger_crmentity e on e.crmid = flr.flota_rentaid left join vtiger_account cli on cli.accountid = flr.accountid left join vtiger_obras obr on obr.obrasid = flr.obrasid left join vtiger_products prod on prod.productid = flr.productid left join vtiger_productcf prod2 on prod2.productid = flr.productid left join vtiger_lineas lin on lin.lineasid = prod2.$campo_linea where e.deleted = '0' and cast(flr.horometro_teorico as signed) > (lin.mantenimiento_horometro * 0.8)";
		$consulta = "select flr.*, cli.accountname as cliente, obr.nombre as obra, prod.productname as producto, lin.mantenimiento_horometro from vtiger_flota_renta flr inner join vtiger_crmentity e on e.crmid = flr.flota_rentaid left join vtiger_account cli on cli.accountid = flr.accountid left join vtiger_obras obr on obr.obrasid = flr.obrasid left join vtiger_products prod on prod.productid = flr.productid left join vtiger_productcf prod2 on prod2.productid = flr.productid left join vtiger_lineas lin on lin.lineasid = prod2.$campo_linea where e.deleted = '0' and cast(flr.horometro_teorico as signed) > (lin.mantenimiento_horometro * 0.8) order by cli.accountname, obr.nombre, flr.numero_interno";
//var_dump($consulta);
		$resultado = $adb->query($consulta);
		$contador_color = 0;
		while ($renglon = $adb->fetch_array($resultado))
		{
			$color = ($contador_color % 2)?"#fcfcfc":"#fff0dd";
			$flr_id = $renglon["flota_rentaid"];
			$numero_interno = $renglon["numero_interno"];
			$mantenimiento_horometro = $renglon["mantenimiento_horometro"];

			$tabla .= "<tr style=\"background:$color;\">";
			$tabla .= "<td class=\"dvtCellInfo\">";
			$tabla .= "<a href=\"index.php?module=Flota_renta&action=DetailView&record=$flr_id\">";
			$tabla .= $renglon["numero_interno"];
			$tabla .= "</a>";
			$tabla .= "</td>";
			$tabla .= "<td class=\"dvtCellInfo\">";
			$tabla .= $renglon["cliente"];
			$tabla .= "</td>";
			$tabla .= "<td class=\"dvtCellInfo\">";
			$tabla .= $renglon["obra"];
			$tabla .= "</td>";
			$tabla .= "<td class=\"dvtCellInfo\" style=\"width:250px;\">";
			$tabla .= $renglon["producto"];
			$tabla .= "</td>";
			$tabla .= "<td class=\"dvtCellInfo\">";
			$tabla .= $renglon["estado"];
			$tabla .= "</td>";
/*****************************
			$tabla .= "<td class=\"dvtCellInfo\">";
			$tabla .= $renglon["numero_serie"];
			$tabla .= "</td>";
			$tabla .= "<td class=\"dvtCellInfo\">";
			$tabla .= $renglon["observaciones"];
			$tabla .= "</td>";
			$tabla .= "<td class=\"dvtCellInfo\">";
			$tabla .= $renglon["flr_tipo"];
			$tabla .= "</td>";
			$tabla .= "<td class=\"dvtCellInfo\">";
			$tabla .= $renglon["numero_interno_cliente"];
			$tabla .= "</td>";
******************************/
			$tabla .= "<td class=\"dvtCellInfo\" style=\"text-align:right;\">";
			$tabla .= $renglon["horometro"];
			$tabla .= "</td>";
			$tabla .= "<td class=\"dvtCellInfo\" style=\"text-align:right;\">";
			$tabla .= $renglon["ultimo_servicio"];
			$tabla .= "</td>";
			$semaforo = "";
			if ($renglon["horometro_teorico"] > ($mantenimiento_horometro * 0.8))
			{
				$semaforo = "#ffa";
			}
			if ($renglon["horometro_teorico"] > $mantenimiento_horometro)
			{
				$semaforo = "#faa";
			}
			$tabla .= "<td class=\"dvtCellInfo\" style=\"background:$semaforo;text-align:right;\">";
			$tabla .= $renglon["horometro_teorico"];
			$tabla .= "</td>";
			$consulta2 = "select ot.ordenes_trabajoid, ot.folio from vtiger_ordenes_trabajo ot, vtiger_crmentity e where e.crmid = ot.ordenes_trabajoid and e.deleted = '0' and ot.flota_rentaid = '$flr_id' and ot.estado = 'Abierto'";
//var_dump($consulta2);
			$resultado2 = $adb->query($consulta2);
			$renglon2 = $adb->fetch_array($resultado2);
			$tabla .= "<td class=\"dvtCellInfo\" style=\"text-align:center;\">";
			if ($renglon2["folio"] != "")
			{
				$ot_id = $renglon2["ordenes_trabajoid"];
				$tabla .= "<a href=\"index.php?module=Ordenes_trabajo&action=DetailView&record=$ot_id\">";
				$tabla .= $renglon2["folio"];
				$tabla .= "</a>";
			}
			else
			{
				$tabla .= "<a href=\"index.php?module=Flota_renta&action=generar_ot&record=$flr_id&suc_id=$suc_id&return_module=Flota_renta&return_action=reporte_mantenimiento\" onclick=\"return confirm('¿Desea generar una orden de trabajo para el equipo $numero_interno?');\">";
				$tabla .= "Generar OT";
				$tabla .= "</a>";
			}
			$tabla .= "</td>";
			$tabla .= "</tr>";
			$contador_color++;
		}
		$tabla .= "</table>";
		$tabla .= "<div style=\"height:20px;\">";
		$tabla .= "</div>";

		return $tabla;
	}

	// Genera una OT para este equipo en este momento.
	function generar_ot($suc_id)
	{
		global $adb;

		$flr_id = $this->obtener_id();
		$en_obra = ($this->column_fields["estado"] == "En obra")?1:0;
		$horometro_teorico = $this->column_fields["horometro_teorico"];

		$ot = new Ordenes_trabajo;
		$ot->column_fields["assigned_user_id"] = $current_user->id;
		$ot->column_fields["sucursal"] = $suc_id;
		$ot->column_fields["cliente"] = $this->column_fields["cliente"];
		$ot->column_fields["obra"] = $this->column_fields["obra"];
               	$ot->column_fields["equipo"] = $flr_id;
		$ot->column_fields["cantidad"] = $this->column_fields["existencia"];
		$ot->column_fields["estado"] = "Abierto";
		$ot->column_fields["fecha_ini"] = date("Y-m-d");
		$ot->column_fields["ot_tipo"] = $this->column_fields["flr_tipo"];
               	$ot->column_fields["en_obra"] = $en_obra;
               	$ot->column_fields["movimiento"] = "MTTO";
               	$ot->column_fields["horometro"] = $this->column_fields["horometro"];
		//$ot->column_fields["observaciones"] = $observaciones;
		//$ot->column_fields["cargo"] = $cargo;
//var_dump($ot->column_fields);
		$ot->save("Ordenes_trabajo", $id_ot);
		if ($ot->column_fields["folio"] == "")
		{
			$ot->asignar_folio();
		}

		// Actualiza este registro.
		if ($en_obra)
		{
			$consulta = "update vtiger_flota_renta flr set flr.horometro_teorico = '$horometro_teorico' where flr.flota_rentaid = '$flr_id'";
		}
		else
		{
			$consulta = "update vtiger_flota_renta flr set flr.estado = 'En servicio', flr.horometro_teorico = '$horometro_teorico' where flr.flota_rentaid = '$flr_id'";
		}
		$adb->query($consulta);
	}

	function tabla_remisiones()
	{
		global $adb;

		$flr_id = $this->obtener_id();

		$consulta = "select afe.* from vtiger_afectacion afe, vtiger_crmentity e where e.crmid = afe.afectacionid and e.deleted = '0' and afe.flota_rentaid = '$flr_id' order by afe.codigo, afe.fecha_efectiva, afe.hora_efectiva, afe.documento";
//var_dump($consulta);
		$resultado = $adb->query($consulta);
//$renglon = $adb->fetch_array($resultado);

		$tabla = "<table>";
		$tabla .= "<tr>";
		$tabla .= "<th>";
		$tabla .= "Número interno";
		$tabla .= "</th>";
		$tabla .= "<th>";
		$tabla .= "Documento";
		$tabla .= "</th>";
		$tabla .= "<th>";
		$tabla .= "Fecha";
		$tabla .= "</th>";
		$tabla .= "<th>";
		$tabla .= "Hora";
		$tabla .= "</th>";
		$tabla .= "<th>";
		$tabla .= "Horómetro";
		$tabla .= "</th>";
		$tabla .= "<th>";
		$tabla .= "Cantidad";
		$tabla .= "</th>";
		$tabla .= "<th>";
		$tabla .= "Acumulado";
		$tabla .= "</th>";
		$tabla .= "</tr>";
		while ($renglon = $adb->fetch_array($resultado))
		{
	//echo "<pre>";
	//var_dump($renglon);
	//echo "</pre>";
//die;
			$afe_id = $renglon["afectacionid"];
			if ($renglon["codigo"] != $afe_codigo && $afe_codigo != "")
			{
				$separador = true;
			}
			else
			{
				$separador = false;
			}
			$afe_codigo = $renglon["codigo"];
			$afe_documento = $renglon["documento"];
			$afe_fecha_efectiva = $renglon["fecha_efectiva"];
			$afe_hora_efectiva = $renglon["hora_efectiva"];
			$afe_cantidad = $renglon["cantidad"];
			$afe_modulo = $renglon["modulo"];
			$afe_crmid = $renglon["crmid"];
			$afe_horometro = $renglon["horometro"];
			if ($afe_modulo == "Entregas" || $afe_modulo == "Cambios" || $afe_modulo == "Recolecciones")
			{
				$acumulado[$afe_codigo] += $afe_cantidad;
			}
/************************
	$afe_folio = $renglon["folio"];
	$afe_afe_tipo_documento = $renglon["afe_tipo_documento"];
	$afe_sucursal = $renglon["sucursal"];
	$afe_cliente = $renglon["cliente"];
	$afe_obra = $renglon["obra"];
	$afe_proveedor = $renglon["proveedor"];
	$afe_subarrendado = $renglon["subarrendado"];
	$afe_afe_tipo_interno = $renglon["afe_tipo_interno"];
	$afe_producto = $renglon["producto"];
	$afe_almacen = $renglon["almacen"];
	$afe_numero_interno = $renglon["numero_interno"];
	$afe_numero_serie = $renglon["numero_serie"];
	$afe_costo = $renglon["costo"];
	$afe_combustible = $renglon["combustible"];
	$afe_horas_uso = $renglon["horas_uso"];
************************/
			if ($separador)
			{
				$tabla .= "<tr>";
				$tabla .= "<td>";
				$tabla .= "<br>";
				$tabla .= "</td>";
				$tabla .= "</tr>";
				$tabla .= "<tr>";
			}
			else
			{
				$tabla .= "<tr>";
			}
			$tabla .= "<td>";
			$tabla .= $afe_codigo;
			$tabla .= "</td>";
			$tabla .= "<td>";
			$tabla .= "<a href=\"index.php?module=$afe_modulo&action=DetailView&record=$afe_crmid\">";
			$tabla .= $afe_documento;
			$tabla .= "</a>";
			$tabla .= "</td>";
			$tabla .= "<td>";
			$tabla .= $afe_fecha_efectiva;
			$tabla .= "</td>";
			$tabla .= "<td>";
			$tabla .= $afe_hora_efectiva;
			$tabla .= "</td>";
			$tabla .= "<td style=\"text-align:right;\">";
			$tabla .= $afe_horometro;
			$tabla .= "</td>";
			$tabla .= "<td style=\"text-align:right;\">";
			$tabla .= $afe_cantidad;
			$tabla .= "</td>";
			$tabla .= "<td style=\"text-align:right;\">";
			$tabla .= $acumulado[$afe_codigo];
			$tabla .= "</td>";
			$tabla .= "</tr>";
		}
		$tabla .= "</table>";

		return $tabla;
	}

	// Genera la afectación (tabla 3) correspondiente a este equipo.
	function afectacion()
	{
		global $adb;

		$flr_id = $this->obtener_id();

		// Limpia posibles registros existentes.
		$consulta = "update vtiger_afectacion afe, vtiger_crmentity e set e.deleted = '1' where e.crmid = afe.afectacionid and e.deleted = '0' and afe.flota_rentaid = '$flr_id'";
		$adb->query($consulta);
//die;

		// Entregas.
		$consulta = "select flr.numero_interno, remd.*, ent.* from vtiger_entregas ent, vtiger_crmentity e, vtiger_remisiones_det remd, vtiger_flota_renta flr where e.crmid = remd.remisiones_detid  and e.deleted = '0' and ent.entregasid = remd.entregasid and flr.flota_rentaid = remd.flota_rentaid and flr.flota_rentaid = '$flr_id'";
//var_dump($consulta);
//die;
		$resultado = $adb->query($consulta);
//$renglon = $adb->fetch_array($resultado);
		while ($renglon = $adb->fetch_array($resultado))
		{
	//echo "<pre>";
	//var_dump($renglon);
	//echo "</pre>";
//die;
			$remd_id = $renglon["remisiones_detid"];
			$flr_id = $renglon["flota_rentaid"];
			$remd_entrega = $renglon["entregasid"];
			$remd_cambio = $renglon["cambiosid"];
			$remd_recoleccion = $renglon["recoleccionesid"];
			$remd_horometro = $renglon["horometro"];
			$remd_combustible = $renglon["combustible"];
			$modulo = "Entregas";
			$crmid = $remd_entrega;
			$remd_cantidad = $renglon["cantidad"];
/************************
			$remd_folio = $renglon["folio"];
			$remd_remision = $renglon["remision"];
			$remd_remd_tipo_operacion = $renglon["remd_tipo_operacion"];
			$remd_producto = $renglon["producto"];
			$remd_numero_interno = $renglon["numero_interno"];
			$remd_numero_serie = $renglon["numero_serie"];
			$remd_observaciones = $renglon["observaciones"];
			$remd_reparacion = $renglon["reparacion"];
************************/

			$afe = new Afectacion;
			$afe->column_fields["assigned_user_id"] = 1;
			$afe->column_fields["modulo"] = $modulo;
			$afe->column_fields["crmid"] = $crmid;
			$afe->column_fields["horometro"] = $remd_horometro;
			$afe->column_fields["combustible"] = $remd_combustible;
			$afe->column_fields["documento"] = $renglon["folio"];
			$afe->column_fields["sucursal"] = $renglon["sucursalesid"];
			$afe->column_fields["cliente"] = $renglon["accountid"];
			$afe->column_fields["obra"] = $obr_id;
			$afe->column_fields["producto"] = $renglon["productid"];
			$afe->column_fields["fecha_efectiva"] = $renglon["fecha_efectiva"];
			$afe->column_fields["hora_efectiva"] = $renglon["hora_efectiva"];
			$afe->column_fields["codigo"] = $renglon["numero_interno"];
			$afe->column_fields["cantidad"] = $renglon["cantidad"];
			$afe->column_fields["numero_interno"] = $renglon["flota_rentaid"];
/**********************
$afe->column_fields["folio"] = $renglon["folio"];
$afe->column_fields["ado_tipo_documento"] = $renglon["ado_tipo_documento"];
$afe->column_fields["proveedor"] = $renglon["proveedor"];
$afe->column_fields["subarrendado"] = $renglon["subarrendado"];
$afe->column_fields["ado_tipo_interno"] = $renglon["ado_tipo_interno"];
$afe->column_fields["almacen"] = $renglon["almacen"];
$afe->column_fields["numero_serie"] = $renglon["numero_serie"];
$afe->column_fields["costo"] = $renglon["costo"];
$afe->column_fields["modulo"] = $renglon["modulo"];
$afe->column_fields["crmid"] = $renglon["crmid"];
$afe->column_fields["horometro"] = $renglon["horometro"];
$afe->column_fields["combustible"] = $renglon["combustible"];
**********************/
			$afe->save("Afectacion");
		}
//die;

		// Cambios.
		$consulta = "select flr.numero_interno, remd.*, cmb.* from vtiger_cambios cmb, vtiger_crmentity e, vtiger_remisiones_det remd, vtiger_flota_renta flr where e.crmid = remd.remisiones_detid and e.deleted = '0' and  cmb.cambiosid = remd.cambiosid and flr.flota_rentaid = remd.flota_rentaid and flr.flota_rentaid = '$flr_id'";
//var_dump($consulta);
		$resultado = $adb->query($consulta);
//$renglon = $adb->fetch_array($resultado);
		while ($renglon = $adb->fetch_array($resultado))
		{
	//echo "<pre>";
	//var_dump($renglon);
	//echo "</pre>";
//die;
			$remd_id = $renglon["remisiones_detid"];
			$remd_entrega = $renglon["entregasid"];
			$remd_cambio = $renglon["cambiosid"];
			$remd_recoleccion = $renglon["recoleccionesid"];
			$remd_horometro = $renglon["horometro"];
			$remd_combustible = $renglon["combustible"];
			$modulo = "Cambios";
			$crmid = $remd_cambio;
			$remd_cantidad = $renglon["cantidad"];
			$remd_sentido = $renglon["remd_sentido"];
			$remd_nivel = $renglon["remd_nivel"];

			$afe = new Afectacion;
			$afe->column_fields["assigned_user_id"] = 1;
			$afe->column_fields["modulo"] = $modulo;
			$afe->column_fields["crmid"] = $crmid;
			$afe->column_fields["horometro"] = $remd_horometro;
			$afe->column_fields["combustible"] = $remd_combustible;
			$afe->column_fields["documento"] = $renglon["folio"];
			$afe->column_fields["sucursal"] = $renglon["sucursalesid"];
			$afe->column_fields["cliente"] = $renglon["accountid"];
			$afe->column_fields["obra"] = $obr_id;
			$afe->column_fields["producto"] = $renglon["productid"];
			$afe->column_fields["fecha_efectiva"] = $renglon["fecha_efectiva"];
			$afe->column_fields["hora_efectiva"] = $renglon["hora_efectiva"];
			$afe->column_fields["codigo"] = $renglon["numero_interno"];
			if ($remd_sentido == "E" && $remd_nivel == "Individual")
			{
				$afe->column_fields["cantidad"] = 1;
			}
			if ($remd_sentido == "R" && $remd_nivel == "Individual")
			{
				$afe->column_fields["cantidad"] = -1;
			}
			$afe->column_fields["numero_interno"] = $renglon["flota_rentaid"];

			$afe->save("Afectacion");
		}


		// Recolecciones.
		$consulta = "select flr.numero_interno, remd.*, rco.* from vtiger_recolecciones rco, vtiger_crmentity e, vtiger_remisiones_det remd, vtiger_flota_renta flr where e.crmid = remd.remisiones_detid and e.deleted = '0' and rco.recoleccionesid = remd.recoleccionesid and flr.flota_rentaid = remd.flota_rentaid and flr.flota_rentaid = '$flr_id'";
//var_dump($consulta);
		$resultado = $adb->query($consulta);
//$renglon = $adb->fetch_array($resultado);
		while ($renglon = $adb->fetch_array($resultado))
		{
	//echo "<pre>";
	//var_dump($renglon);
	//echo "</pre>";
//die;
			$remd_id = $renglon["remisiones_detid"];
			$remd_entrega = $renglon["entregasid"];
			$remd_cambio = $renglon["cambiosid"];
			$remd_recoleccion = $renglon["recoleccionesid"];
			$remd_horometro = $renglon["horometro"];
			$remd_combustible = $renglon["combustible"];
			$modulo = "Recolecciones";
			$crmid = $remd_recoleccion;
			$remd_cantidad = $renglon["cantidad"];

			$afe = new Afectacion;
			$afe->column_fields["assigned_user_id"] = 1;
			$afe->column_fields["modulo"] = $modulo;
			$afe->column_fields["crmid"] = $crmid;
			$afe->column_fields["horometro"] = $remd_horometro;
			$afe->column_fields["combustible"] = $remd_combustible;
			$afe->column_fields["documento"] = $renglon["folio"];
			$afe->column_fields["sucursal"] = $renglon["sucursalesid"];
			$afe->column_fields["cliente"] = $renglon["accountid"];
			$afe->column_fields["obra"] = $obr_id;
			$afe->column_fields["producto"] = $renglon["productid"];
			$afe->column_fields["fecha_efectiva"] = $renglon["fecha_efectiva"];
			$afe->column_fields["hora_efectiva"] = $renglon["hora_efectiva"];
			$afe->column_fields["codigo"] = $renglon["numero_interno"];
			$afe->column_fields["cantidad"] = $renglon["cantidad"] * -1;
			$afe->column_fields["numero_interno"] = $renglon["flota_rentaid"];

			$afe->save("Afectacion");
		}

		// Órdenes de trabajo.
		$consulta = "select flr.numero_interno, ot.ordenes_trabajoid from vtiger_ordenes_trabajo ot, vtiger_crmentity e, vtiger_flota_renta flr where e.crmid = ot.ordenes_trabajoid and e.deleted = '0' and flr.flota_rentaid = ot.flota_rentaid and flr.flota_rentaid = '$flr_id'";
//var_dump($consulta);
		$resultado = $adb->query($consulta);
//$renglon = $adb->fetch_array($resultado);
		while ($renglon = $adb->fetch_array($resultado))
		{
	//echo "<pre>";
	//var_dump($renglon);
	//echo "</pre>";
//die;
			$ot_id = $renglon["ordenes_trabajoid"];

			$ot = new Ordenes_trabajo;
			$ot->retrieve_entity_info($ot_id, "Ordenes_trabajo");
			$ot->afectacion();
		}
	}

	// Genera la tabla de detalles.
	function tabla_equipo_cliente($cli_id = null, $estados_permitidos = array())
	{
		global $adb;
//echo "<pre>";
//var_dump($this->column_fields);
//echo "</pre>";

		$tabla .= "<table style=\"padding-bottom:20px;border-collapse:collapse;border:1px solid #ddd;width:90%\">";
		$tabla .= "<tr>";
//$tabla .= "<th class=\"dvtCellLabel\" style=\"width:10px;text-align:center;\">";
		$tabla .= "<th class=\"dvtCellLabel\">";
		$tabla .= "Elegir";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvtCellLabel\">";
		$tabla .= "N&uacute;mero interno";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvtCellLabel\">";
		$tabla .= "Cliente";
		$tabla .= "</th>";
/**************************************
		$tabla .= "<th class=\"dvtCellLabel\">";
		$tabla .= "Obra";
		$tabla .= "</th>";
****************************************/
		$tabla .= "<th class=\"dvtCellLabel\">";
		$tabla .= "Producto";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvtCellLabel\">";
		$tabla .= "Estatus";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvtCellLabel\">";
		$tabla .= "Existencia";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvtCellLabel\">";
		$tabla .= "N&uacute;mero de serie";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvtCellLabel\">";
		$tabla .= "Observaciones";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvtCellLabel\">";
		$tabla .= "Tipo";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvtCellLabel\">";
		$tabla .= "N&uacute;mero interno cliente";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvtCellLabel\">";
		$tabla .= "Hor&oacute;metro";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvtCellLabel\">";
		$tabla .= "&Uacute;ltimo servicio";
		$tabla .= "</th>";
		$tabla .= "</tr>";

		$consulta = "select flr.*, cli.accountname as cliente, prod.productname as producto from vtiger_flota_renta flr, vtiger_crmentity e, vtiger_account cli, vtiger_products prod where e.crmid = flr.flota_rentaid and e.deleted = '0' and cli.accountid = flr.accountid and prod.productid = flr.productid and flr.numero_interno like '8%'";
		if ($cli_id != "")
		{
			$consulta .= " and flr.accountid = '$cli_id'";
		}

		$resultado = $adb->query($consulta);
		while ($renglon = $adb->fetch_array($resultado))
		{
			$permitido = false;
			$color_texto = "#888";
			//if ($renglon["estado"] == "Entregado")
			if (in_array($renglon["estado"], $estados_permitidos))
			{
				$permitido = true;
				$color_texto = "black";
			}

			$color = ($contador_color % 2)?"#eee":"#fed";

			$tabla .= "<tr style=\"background:$color;color:$color_texto;\">";
			$tabla .= "<td class=\"dvtCellInfo\">";
			//$tabla .= $renglon["folio"];
			if ($permitido)
			{
				$tabla .= "<input type=\"radio\" name=\"captura[flr_id]\" value=\"".$renglon["flota_rentaid"]."\">";
			}
			$tabla .= "</td>";
			$tabla .= "<td class=\"dvtCellInfo\">";
			$tabla .= $renglon["numero_interno"];
			$tabla .= "</td>";
			$tabla .= "<td class=\"dvtCellInfo\">";
			$tabla .= $renglon["cliente"];
			$tabla .= "</td>";
/*************************
			$tabla .= "<td class=\"dvtCellInfo\">";
			$tabla .= $renglon["obra"];
			$tabla .= "</td>";
****************************/
			$tabla .= "<td class=\"dvtCellInfo\">";
			$tabla .= $renglon["producto"];
			$tabla .= "</td>";
			$tabla .= "<td class=\"dvtCellInfo\">";
			$tabla .= $renglon["estado"];
			$tabla .= "</td>";
			$tabla .= "<td class=\"dvtCellInfo\">";
			$tabla .= $renglon["existencia"];
			$tabla .= "</td>";
			$tabla .= "<td class=\"dvtCellInfo\">";
			$tabla .= $renglon["numero_serie"];
			$tabla .= "</td>";
			$tabla .= "<td class=\"dvtCellInfo\">";
			$tabla .= $renglon["observaciones"];
			$tabla .= "</td>";
			$tabla .= "<td class=\"dvtCellInfo\">";
			$tabla .= $renglon["flr_tipo"];
			$tabla .= "</td>";
			$tabla .= "<td class=\"dvtCellInfo\">";
			$tabla .= $renglon["numero_interno_cliente"];
			$tabla .= "</td>";
			$tabla .= "<td class=\"dvtCellInfo\">";
			$tabla .= $renglon["horometro"];
			$tabla .= "</td>";
			$tabla .= "<td class=\"dvtCellInfo\">";
			$tabla .= $renglon["ultimo_servicio"];
			$tabla .= "</td>";
			$tabla .= "</tr>";

			$contador_color++;
		}
		$tabla .= "</table>";
		$tabla .= "<div style=\"height:20px;\">";
		$tabla .= "</div>";

		return $tabla;
	}

	// Calcula la depreciación contable de este equipo.
	function depreciacion_contable($fecha_calculo = "")
	{
		global $adb;

		$flr_id = $this->obtener_id();

		if ($fecha_calculo == "")
		{
			//$fecha_calculo = date("Y-m-d");
//var_dump(date("Y-m-d", strtotime(date("Y-m-01")." - 1 day")));
			$fecha_calculo = date("Y-m-d", strtotime(date("Y-m-01")." - 1 day"));
		}
//var_dump($fecha_calculo);
// Sólo para inicializar por programación.
//$consulta = "update vtiger_flota_renta flr set flr.bajas_flota_rentaid = '' where flr.flota_rentaid = '$flr_id'";
//var_dump($consulta);
//$adb->query($consulta);

		$afr_id = $this->column_fields["alta_flota_renta"];
		$bfr_id = $this->column_fields["baja_flota_renta"];
		$ns_id = $this->column_fields["numero_serie"];
		$flr_costo_mn = $this->column_fields["costo_mn"];

		$afr_fecha_efectiva = "";
		$bfr_fecha_efectiva = "";
		$depreciacion = 0;


		if ($bfr_id == "")
		{
			// Busca una posible baja de flota.
			$consulta = "select bfr.* from vtiger_bajas_flota_renta bfr, vtiger_crmentity e where e.crmid = bfr.bajas_flota_rentaid and e.deleted = '0' and bfr.flota_rentaid = '$flr_id'";
//var_dump($consulta);
			$resultado = $adb->query($consulta);
			$renglon = $adb->fetch_array($resultado);
//echo "<pre>";
//var_dump($renglon);
//echo "</pre>";
//die;
			$bfr_id = $renglon["bajas_flota_rentaid"];
			$bfr_fecha_efectiva = $renglon["fecha_efectiva"];
/************************
	$bfr_folio = $renglon["folio"];
	$bfr_sucursal = $renglon["sucursal"];
	$bfr_subarrendado = $renglon["subarrendado"];
	$bfr_numero_interno = $renglon["numero_interno"];
	$bfr_cantidad = $renglon["cantidad"];
	$bfr_hora_efectiva = $renglon["hora_efectiva"];
	$bfr_observaciones = $renglon["observaciones"];
	$bfr_bloqueado = $renglon["bloqueado"];
************************/

			if ($bfr_id != "")
			{
				$consulta = "update vtiger_flota_renta flr set flr.bajas_flota_rentaid = '$bfr_id' where flr.flota_rentaid = '$flr_id'";
//var_dump($consulta);
				$adb->query($consulta);
			}
		}

		if ($bfr_id != "")
		{
			$bfr = new Bajas_flota_renta;
			$bfr->retrieve_entity_info($bfr_id, "Bajas_flota_renta");
			$bfr_fecha_efectiva = $bfr->column_fields["fecha_efectiva"];
			$fecha_baja_depreciacion = $bfr->column_fields["fecha_efectiva"];
		}

		if (($this->column_fields["fecha_baja_financiera"] != "") && ($this->column_fields["fecha_baja_financiera"] != "0000-00-00"))
		{
			$fecha_baja_depreciacion = $this->column_fields["fecha_baja_financiera"];
		}


		if ($afr_id != "")
		{
			$afr = new Altas_flota_renta;
			$afr->retrieve_entity_info($afr_id, "Altas_flota_renta");
			$afr_fecha_efectiva = $afr->column_fields["fecha_efectiva"];
//var_dump($afr_fecha_efectiva);
			$ano_alta = substr($afr_fecha_efectiva, 0, 4);
			$mes_alta = substr($afr_fecha_efectiva, 5, 2);
			$dia_alta = substr($afr_fecha_efectiva, 8, 2);
//var_dump($ano_alta, $mes_alta, $dia_alta);

			//$ano = date("Y");
			//$mes = date("m");
			//$dia = date("d");
			$ano = substr($fecha_calculo, 0, 4);
			$mes = substr($fecha_calculo, 5, 2);
			$dia = substr($fecha_calculo, 8, 2);

/***************************
			if (($bfr_fecha_efectiva != "") && ($bfr_fecha_efectiva != "0000-00-00"))
			{
				$ano = substr($bfr_fecha_efectiva, 0, 4);
				$mes = substr($bfr_fecha_efectiva, 5, 2);
				$dia = substr($bfr_fecha_efectiva, 8, 2);
			}
***************************/
			if (($fecha_baja_depreciacion != "") && ($fecha_baja_depreciacion != "0000-00-00"))
			{
				$ano = substr($fecha_baja_depreciacion, 0, 4);
				$mes = substr($fecha_baja_depreciacion, 5, 2);
				$dia = substr($fecha_baja_depreciacion, 8, 2);
			}

//var_dump($ano, $mes, $dia);
			if ($mes < $mes_alta)
			{
				$meses = 12 - $mes_alta + $mes;
				$anos = $ano - $ano_alta - 1;
			}
			else
			{
				$meses = $mes - $mes_alta;
				$anos = $ano - $ano_alta;
			}

			if ($dia < $dia_alta)
			{
				$meses--;
			}
//var_dump($anos, $meses);
			//$depreciacion = ($anos * 12) + $meses;
			$depreciacion_meses = ($anos * 12) + $meses;
//var_dump($depreciacion);
		}

		if ($flr_costo_mn == "")
		{
			//$consulta = "select ns.costo from vtiger_numeros_serie ns where ns.numeros_serieid = '$ns_id'";
			$consulta = "select ns.costo_mn from vtiger_numeros_serie ns where ns.numeros_serieid = '$ns_id'";
//var_dump($consulta);
			$resultado = $adb->query($consulta);
			$renglon = $adb->fetch_array($resultado);

			$flr_costo_mn = $renglon["costo_mn"];
		}

		//$porcentaje = 10;
		$porcentaje = $this->porcentaje_depreciacion();
		$meses_totales = ($porcentaje > 0)?((100 / $porcentaje) * 12):0;
		$depreciacion_monto = $depreciacion_meses * ($flr_costo_mn * ($porcentaje / 1200));
		$depreciacion_restante = $flr_costo_mn - $depreciacion_monto;

		if ($depreciacion_monto > $flr_costo_mn)
		{
			$depreciacion_monto = $flr_costo_mn;
			$depreciacion_restante = 0;
		}

		$fecha_final_depreciacion = date("Y-m-d", strtotime("$afr_fecha_efectiva + $meses_totales months"));

		//$consulta = "update vtiger_flota_renta flr set flr.depreciacion_contable = '$depreciacion' where flr.flota_rentaid = '$flr_id'";
		//$consulta = "update vtiger_flota_renta flr set flr.depreciacion_contable_meses = '$depreciacion_meses', flr.depreciacion_contable_monto = '$depreciacion_monto', flr.costo = '$flr_costo', flr.monto_por_depreciar = '$depreciacion_restante', flr.fecha_alta = '$afr_fecha_efectiva', flr.fecha_final_depreciacion = '$fecha_final_depreciacion' where flr.flota_rentaid = '$flr_id'";
		$consulta = "update vtiger_flota_renta flr set flr.depreciacion_contable_meses = '$depreciacion_meses', flr.depreciacion_contable_monto = '$depreciacion_monto', flr.costo_mn = '$flr_costo_mn', flr.monto_por_depreciar = '$depreciacion_restante', flr.fecha_alta = '$afr_fecha_efectiva', flr.fecha_final_depreciacion = '$fecha_final_depreciacion', flr.fecha_baja = '$bfr_fecha_efectiva' where flr.flota_rentaid = '$flr_id'";
//var_dump($consulta);
		$adb->query($consulta);
//echo "<br>";
echo $this->column_fields["numero_interno"];
var_dump($this->column_fields["alta_flota_renta"]);
var_dump($afr_fecha_efectiva);
//var_dump($depreciacion);
echo "<br>";
//die;
	}

	// Obtiene el porcentaje de depreciación de este equipo según su línea.
	function porcentaje_depreciacion()
	{
		$flr_id = $this->obtener_id();

		global $adb;

		$prod = new Products;
		$campo_linea = $prod->personalizado("linea", true);

		$consulta = "select lin.porcentaje_depreciacion from vtiger_lineas lin, vtiger_productcf prod2, vtiger_flota_renta flr, vtiger_crmentity e where e.crmid = flr.flota_rentaid and e.deleted = '0' and flr.flota_rentaid = '$flr_id' and prod2.productid = flr.productid and lin.lineasid = prod2.$campo_linea";
//var_dump($consulta);
//die;
		$resultado = $adb->query($consulta);
		$renglon = $adb->fetch_array($resultado);

		$porcentaje = $renglon["porcentaje_depreciacion"];

		//return 10;
		return $porcentaje;
	}

	// Genera la cédula de depreciación contable
	function cedula_depreciacion($ano_calculo = null, $numero_interno = "")
	{
		global $adb;

		$flr_id = $this->obtener_id();

		$prod = new Products;
		$campo_linea = $prod->personalizado("linea", true);

		$contador_color = 0;
		$i = 1;

		if (is_null($ano_calculo))
		{
			$ano_calculo = date("Y", strtotime("today -1 year"));
		}

		$ano_anterior = $ano_calculo - 1;
	
		$tabla = "<table style=\"width:100%;\">";
		$tabla .= "<tr>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "N&uacute;mero interno";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "N&uacute;mero de serie";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Producto";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Código línea";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Fecha de alta";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "MOI";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Altas";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Bajas";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Neto";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Acumulado $ano_anterior";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Acumulado $ano_calculo";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Por depreciar cierre $ano_calculo";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Porcentaje anual";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Acumulado meses $ano_anterior";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Meses ejercicio $ano_calculo";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Depreciación anual $ano_calculo";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Depreciar hasta";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Fecha de baja";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Meses a depreciar";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Depreciación mensual";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Meses actual";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Depreciado actual";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Por depreciar actual";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Ene $ano_calculo";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Feb $ano_calculo";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Mar $ano_calculo";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Abr $ano_calculo";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "May $ano_calculo";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Jun $ano_calculo";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Jul $ano_calculo";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Ago $ano_calculo";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Sep $ano_calculo";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Oct $ano_calculo";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Nov $ano_calculo";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Dic $ano_calculo";
		$tabla .= "</th>";
		$tabla .= "</tr>";

		//$consulta = "select flr.flota_rentaid, flr.numero_interno, lin.codigo_raiz from vtiger_lineas lin, vtiger_crmentity e, vtiger_productcf prod2, vtiger_flota_renta flr, vtiger_crmentity e2 where e.crmid = lin.lineasid and e.deleted = '0' and prod2.cf_7711 = lin.lineasid and flr.productid = prod2.productid and e2.crmid = flr.flota_rentaid and e2.deleted = '0' and lin.tipo_contable = 'Activo fijo' and flr.flr_tipo = 'Propio'";
		//$consulta = "select flr.flota_rentaid, flr.numero_interno, lin.codigo_raiz from vtiger_lineas lin, vtiger_crmentity e, vtiger_productcf prod2, vtiger_flota_renta flr, vtiger_crmentity e2 where e.crmid = lin.lineasid and e.deleted = '0' and prod2.cf_7711 = lin.lineasid and flr.productid = prod2.productid and e2.crmid = flr.flota_rentaid and e2.deleted = '0' and lin.tipo_contable = 'Activo fijo' and flr.flr_tipo = 'Propio' order by flr.numero_interno";
		//$consulta = "select flr.flota_rentaid, flr.numero_interno, ns.numero_serie, prod.productname, flr.fecha_alta, flr.costo, lin.codigo_raiz from vtiger_lineas lin, vtiger_crmentity e, vtiger_productcf prod2, vtiger_flota_renta flr, vtiger_crmentity e2, vtiger_numeros_serie ns, vtiger_products prod where e.crmid = lin.lineasid and e.deleted = '0' and prod2.cf_7711 = lin.lineasid and flr.productid = prod2.productid and e2.crmid = flr.flota_rentaid and e2.deleted = '0' and ns.numeros_serieid = flr.numeros_serieid and prod.productid = flr.productid and lin.tipo_contable = 'Activo fijo' and flr.flr_tipo = 'Propio' order by flr.numero_interno";
		//$consulta = "select flr.*, ns.numero_serie, prod.productname, lin.codigo_raiz, lin.porcentaje_depreciacion from vtiger_lineas lin, vtiger_crmentity e, vtiger_productcf prod2, vtiger_flota_renta flr, vtiger_crmentity e2, vtiger_numeros_serie ns, vtiger_products prod where e.crmid = lin.lineasid and e.deleted = '0' and prod2.cf_7711 = lin.lineasid and flr.productid = prod2.productid and e2.crmid = flr.flota_rentaid and e2.deleted = '0' and ns.numeros_serieid = flr.numeros_serieid and prod.productid = flr.productid and lin.tipo_contable = 'Activo fijo' and flr.flr_tipo = 'Propio' order by flr.numero_interno";
		//$consulta = "select flr.*, ns.numero_serie, prod.productname, lin.lineasid, lin.codigo_raiz, lin.porcentaje_depreciacion from vtiger_lineas lin, vtiger_crmentity e, vtiger_productcf prod2, vtiger_flota_renta flr, vtiger_crmentity e2, vtiger_numeros_serie ns, vtiger_products prod where e.crmid = lin.lineasid and e.deleted = '0' and prod2.cf_7711 = lin.lineasid and flr.productid = prod2.productid and e2.crmid = flr.flota_rentaid and e2.deleted = '0' and ns.numeros_serieid = flr.numeros_serieid and prod.productid = flr.productid and lin.tipo_contable = 'Activo fijo' and flr.flr_tipo = 'Propio' order by flr.fecha_alta";

		if ($numero_interno != "")
		{
			$filtro_numero_interno = " and flr.numero_interno like '%$numero_interno%'";
		}
		//$consulta = "select flr.*, ns.numero_serie, prod.productname, lin.lineasid, lin.codigo_raiz, lin.porcentaje_depreciacion from vtiger_lineas lin, vtiger_crmentity e, vtiger_productcf prod2, vtiger_flota_renta flr, vtiger_crmentity e2, vtiger_numeros_serie ns, vtiger_products prod where e.crmid = lin.lineasid and e.deleted = '0' and prod2.cf_7711 = lin.lineasid and flr.productid = prod2.productid and e2.crmid = flr.flota_rentaid and e2.deleted = '0' and ns.numeros_serieid = flr.numeros_serieid and prod.productid = flr.productid and lin.tipo_contable = 'Activo fijo' and flr.flr_tipo = 'Propio'$filtro_numero_interno order by flr.fecha_alta";
		$consulta = "select flr.*, ns.numero_serie, prod.productname, lin.lineasid, lin.codigo_raiz, lin.porcentaje_depreciacion from vtiger_lineas lin, vtiger_crmentity e, vtiger_productcf prod2, vtiger_flota_renta flr, vtiger_crmentity e2, vtiger_numeros_serie ns, vtiger_products prod where e.crmid = lin.lineasid and e.deleted = '0' and prod2.$campo_linea = lin.lineasid and flr.productid = prod2.productid and e2.crmid = flr.flota_rentaid and e2.deleted = '0' and ns.numeros_serieid = flr.numeros_serieid and prod.productid = flr.productid and lin.tipo_contable = 'Activo fijo' and flr.flr_tipo in ('Propio', 'Financiera')$filtro_numero_interno order by flr.fecha_alta";
//var_dump($consulta);
//die;
		$resultado = $adb->query($consulta);

		while ($renglon = $adb->fetch_array($resultado))
		{
//var_dump($renglon);
			$lin_id = $renglon["lineasid"];
			$flr_id = $renglon["flota_rentaid"];

	//$flr = new Flota_renta;
	//$flr->retrieve_entity_info($flr_id, "Flota_renta");
	//$flr->depreciacion_contable();


			$flr_id = $renglon["flota_rentaid"];
			$flr_folio = $renglon["folio"];
			$flr_numero_interno_anterior = $renglon["numero_interno_anterior"];
			$flr_numero_interno = $renglon["numero_interno"];
			$flr_cliente = $renglon["cliente"];
			$flr_obra = $renglon["obra"];
			$flr_producto = $renglon["producto"];
			$flr_estado = $renglon["estado"];
			$flr_existencia = $renglon["existencia"];
			//$flr_numero_serie = $renglon["numero_serie"];
			$ns_numero_serie = $renglon["numero_serie"];
			$flr_observaciones = $renglon["observaciones"];
			$flr_flr_tipo = $renglon["flr_tipo"];
			$flr_numero_interno_cliente = $renglon["numero_interno_cliente"];
			$flr_horometro = $renglon["horometro"];
			$flr_ultimo_servicio = $renglon["ultimo_servicio"];
			$flr_horometro_teorico = $renglon["horometro_teorico"];
			$flr_costo_mn = $renglon["costo_mn"];
			$flr_moneda = $renglon["moneda"];
			$flr_tipo_cambio = $renglon["tipo_cambio"];
			$flr_depreciacion_contable_meses = $renglon["depreciacion_contable_meses"];
			$flr_depreciacion_contable_monto = $renglon["depreciacion_contable_monto"];
			$flr_fecha_alta = $renglon["fecha_alta"];
			$flr_fecha_baja = $renglon["fecha_baja"];
			$flr_fecha_baja_financiera = $renglon["fecha_baja_financiera"];
			$flr_monto_por_depreciar = $renglon["monto_por_depreciar"];
			$flr_fecha_final_depreciacion = $renglon["fecha_final_depreciacion"];
			$flr_factura = $renglon["factura"];
			$flr_codigo_general = $renglon["codigo_general"];
			$flr_codigo_flota = $renglon["codigo_flota"];
			$flr_codigo_renta = $renglon["codigo_renta"];
			$flr_codigo_hextra = $renglon["codigo_hextra"];
			$flr_alta_flota_renta = $renglon["alta_flota_renta"];
			$flr_consecutivo_producto = $renglon["consecutivo_producto"];
			$flr_baja_flota_renta = $renglon["baja_flota_renta"];
			$prod_nombre = $renglon["productname"];
			$lin_codigo_raiz = $renglon["codigo_raiz"];
			$lin_porcentaje_depreciacion = $renglon["porcentaje_depreciacion"];
			$depreciacion_mensual = $flr_costo_mn * (($lin_porcentaje_depreciacion / 100) / 12);
			$meses_totales = ($lin_porcentaje_depreciacion > 0)?((100 / $lin_porcentaje_depreciacion) * 12):0;



			if (($flr_fecha_baja_financiera != "") && ($flr_fecha_baja_financiera != "0000-00-00"))
			{
				$flr_fecha_baja = $flr_fecha_baja_financiera;
			}



			$ano_alta = (int)substr($flr_fecha_alta, 0, 4);
			$mes_alta = (int)substr($flr_fecha_alta, 5, 2);
			$ano_baja = (int)substr($flr_fecha_baja, 0, 4);
			$mes_baja = (int)substr($flr_fecha_baja, 5, 2);
//var_dump($ano_alta);
//var_dump($mes_alta);
			if (($ano_alta > $ano_calculo) && ($ano_alta != "") && ($ano_alta != "0000"))
			{
				continue;
			}

			if (($ano_baja < $ano_anterior) && ($ano_baja != "") && ($ano_baja != "0000"))
			{
				continue;
			}

			$moi = "";
			if ($ano_alta != $ano_calculo)
			{
				$moi = $flr_costo_mn;
			}

			$altas = "";
			if ($ano_alta == $ano_calculo)
			{
				$altas = $flr_costo_mn;
			}

			$bajas = "";
			if ($ano_baja == $ano_calculo)
			{
				$bajas = $flr_costo_mn;
			}

			$neto = $moi + $altas - $bajas;




			if (($flr_fecha_baja != "") && ($flr_fecha_baja != "0000-00-00"))
			{
				$fecha_comparar1 = new DateTime($flr_fecha_baja, new DateTimeZone("America/Mexico_City"));
				$fecha_comparar2 = new DateTime("$ano_anterior-12-31", new DateTimeZone("America/Mexico_City"));

				if ($fecha_comparar1 < $fecha_comparar2)
				{
					$acumulado_ano_anterior_meses = $this->meses_depreciacion($flr_fecha_alta, $flr_fecha_baja);
				}
				else
				{
					$acumulado_ano_anterior_meses = $this->meses_depreciacion($flr_fecha_alta, "$ano_anterior-12-31");
				}
			}
			else
			{
				$acumulado_ano_anterior_meses = $this->meses_depreciacion($flr_fecha_alta, "$ano_anterior-12-31");
			}



			//$acumulado_ano_anterior_meses = $this->meses_depreciacion($flr_fecha_alta, "$ano_anterior-12-31");
			$ejercicio_ano_calculo_meses = 12;
//var_dump($ejercicio_ano_calculo_meses);
			if ($ano_alta == $ano_calculo)
			{
				$ejercicio_ano_calculo_meses -= $mes_alta;
			}
//var_dump($ejercicio_ano_calculo_meses);
			if ($ano_baja == $ano_calculo)
			{
				$ejercicio_ano_calculo_meses -= (12 - $mes_baja);
			}
//var_dump($ejercicio_ano_calculo_meses);
//var_dump($ano_baja);
//var_dump($ano_calculo);


			if (($ano_baja < $ano_calculo) && ($ano_baja != "") && ($ano_baja != 0))
			{
				$ejercicio_ano_calculo_meses = 0;
			}
//var_dump($ejercicio_ano_calculo_meses);






			$acumulado_ano_anterior_monto = $acumulado_ano_anterior_meses * $depreciacion_mensual;



			if (($flr_fecha_baja != "") && ($flr_fecha_baja != "0000-00-00"))
			{
				$fecha_comparar1 = new DateTime($flr_fecha_baja, new DateTimeZone("America/Mexico_City"));
				$fecha_comparar2 = new DateTime("$ano_calculo-12-31", new DateTimeZone("America/Mexico_City"));

//var_dump($acumulado_ano_calculo_meses, $depreciacion_mensual);
				if ($fecha_comparar1 < $fecha_comparar2)
				{
//var_dump("<");
					$acumulado_ano_calculo_meses = $this->meses_depreciacion($flr_fecha_alta, $flr_fecha_baja);
				}
				else
				{
//var_dump(">=");
					$acumulado_ano_calculo_meses = $this->meses_depreciacion($flr_fecha_alta, "$ano_calculo-12-31");
				}
			}
			else
			{
				$acumulado_ano_calculo_meses = $this->meses_depreciacion($flr_fecha_alta, "$ano_calculo-12-31");
			}




//var_dump($acumulado_ano_calculo_meses, $depreciacion_mensual);

			//$acumulado_ano_calculo_meses = $this->meses_depreciacion($flr_fecha_alta, "$ano_calculo-12-31");
			$acumulado_ano_calculo_monto = $acumulado_ano_calculo_meses * $depreciacion_mensual;
			$por_depreciar_ano_calculo_monto = $flr_costo_mn - $acumulado_ano_calculo_monto;
			$depreciacion_ano_calculo_monto = $ejercicio_ano_calculo_meses * $depreciacion_mensual;

			// Determina los meses a mostrar.
			for ($contador_meses = 1; $contador_meses <= 12; $contador_meses++)
			{
				$mostrar[$contador_meses] = false;

				// Primero habilita según el alta.
				if ($ano_alta < $ano_calculo)
				{
					$mostrar[$contador_meses] = true;
				}

				if (($ano_alta == $ano_calculo) && ($mes_alta < $contador_meses))
				{
					$mostrar[$contador_meses] = true;
				}

				// Después inhabilita según la baja.
				if (($ano_baja != "") && ($ano_baja != "0000") &&($ano_baja < $ano_calculo))
				{
					$mostrar[$contador_meses] = false;
				}

				if (($ano_baja == $ano_calculo) && ($mes_baja < $contador_meses))
				{
					$mostrar[$contador_meses] = false;
				}
			}

			$color = ($contador_color % 2)?"#eee":"#fec";
	
			$tabla .= "<tr style=\"background:$color;\">";
			$tabla .= "<td style=\"text-align:right;\">";
			$tabla .= "$i.";
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;\">";
			$tabla .= "<a href=\"index.php?module=Flota_renta&action=DetailView&record=$flr_id\">";
			$tabla .= $flr_numero_interno;
			$tabla .= "</a>";
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;\">";
			$tabla .= $ns_numero_serie;
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;\">";
			$tabla .= $prod_nombre;
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;\">";
			$tabla .= "<a href=\"index.php?module=Lineas&action=DetailView&record=$lin_id\">";
			$tabla .= $lin_codigo_raiz;
			$tabla .= "</a>";
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;text-align:right\">";
			$tabla .= $flr_fecha_alta;
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;text-align:right\">";
			$tabla .= number_format($moi, 2);
			$tabla .= "</td>";
			$sum_moi += $moi;
			$tabla .= "<td style=\"padding:0px 8px;text-align:right\">";
			$tabla .= number_format($altas, 2);
			$tabla .= "</td>";
			$sum_altas += $altas;
			$tabla .= "<td style=\"padding:0px 8px;text-align:right\">";
			$tabla .= number_format($bajas, 2);
			$tabla .= "</td>";
			$sum_bajas += $bajas;
			$tabla .= "<td style=\"padding:0px 8px;text-align:right\">";
			$tabla .= number_format($neto, 2);
			$tabla .= "</td>";
			$sum_neto += $neto;
			$tabla .= "<td style=\"padding:0px 8px;text-align:right\">";
			$tabla .= number_format($acumulado_ano_anterior_monto, 2);
			$tabla .= "</td>";
			$sum_acumulado_ano_anterior_monto += $acumulado_ano_anterior_monto;
			$tabla .= "<td style=\"padding:0px 8px;text-align:right\">";
			$tabla .= number_format($acumulado_ano_calculo_monto, 2);
			$tabla .= "</td>";
			$sum_acumulado_ano_calculo_monto += $acumulado_ano_calculo_monto;
			$tabla .= "<td style=\"padding:0px 8px;text-align:right\">";
			$tabla .= number_format($por_depreciar_ano_calculo_monto, 2);
			$tabla .= "</td>";
			$sum_por_depreciar_ano_calculo_monto += $por_depreciar_ano_calculo_monto;
			$tabla .= "<td style=\"padding:0px 8px;text-align:right\">";
			$tabla .= $lin_porcentaje_depreciacion;
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;text-align:right\">";
			$tabla .= $acumulado_ano_anterior_meses;
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;text-align:right\">";
			$tabla .= $ejercicio_ano_calculo_meses;
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;text-align:right\">";
			$tabla .= number_format($depreciacion_ano_calculo_monto, 2);
			$tabla .= "</td>";
			$sum_depreciacion_ano_calculo_monto += $depreciacion_ano_calculo_monto;
			$tabla .= "<td style=\"padding:0px 8px;text-align:right\">";
			$tabla .= $flr_fecha_final_depreciacion;
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;text-align:right\">";
			if (($flr_fecha_baja != "") && ($flr_fecha_baja != "0000-00-00"))
			{
				$tabla .= $flr_fecha_baja;
			}
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;\">";
			$tabla .= $meses_totales;
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;text-align:right\">";
			$tabla .= number_format($depreciacion_mensual, 2);
			$tabla .= "</td>";
			$sum_depreciacion_mensual += $depreciacion_mensual;
			$tabla .= "<td style=\"padding:0px 8px;\">";
			$tabla .= $flr_depreciacion_contable_meses;
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;text-align:right\">";
			$tabla .= number_format($flr_depreciacion_contable_monto, 2);
			$tabla .= "</td>";
			$sum_flr_depreciacion_contable_monto += $flr_depreciacion_contable_monto;
			$tabla .= "<td style=\"padding:0px 8px;text-align:right\">";
			$tabla .= number_format($flr_monto_por_depreciar, 2);
			$tabla .= "</td>";
			$sum_flr_monto_por_depreciar += $flr_monto_por_depreciar;

			$tabla .= "<td style=\"padding:0px 8px;text-align:right\">";
			if ($mostrar[1])
			{
				$tabla .= number_format($depreciacion_mensual, 2);
				$sum_ene += $depreciacion_mensual;
			}
			$tabla .= "</td>";

			$tabla .= "<td style=\"padding:0px 8px;text-align:right\">";
			if ($mostrar[2])
			{
				$tabla .= number_format($depreciacion_mensual, 2);
				$sum_feb += $depreciacion_mensual;
			}
			$tabla .= "</td>";

			$tabla .= "<td style=\"padding:0px 8px;text-align:right\">";
			if ($mostrar[3])
			{
				$tabla .= number_format($depreciacion_mensual, 2);
				$sum_mar += $depreciacion_mensual;
			}
			$tabla .= "</td>";

			$tabla .= "<td style=\"padding:0px 8px;text-align:right\">";
			if ($mostrar[4])
			{
				$tabla .= number_format($depreciacion_mensual, 2);
				$sum_abr += $depreciacion_mensual;
			}
			$tabla .= "</td>";

			$tabla .= "<td style=\"padding:0px 8px;text-align:right\">";
			if ($mostrar[5])
			{
				$tabla .= number_format($depreciacion_mensual, 2);
				$sum_may += $depreciacion_mensual;
			}
			$tabla .= "</td>";

			$tabla .= "<td style=\"padding:0px 8px;text-align:right\">";
			if ($mostrar[6])
			{
				$tabla .= number_format($depreciacion_mensual, 2);
				$sum_jun += $depreciacion_mensual;
			}
			$tabla .= "</td>";

			$tabla .= "<td style=\"padding:0px 8px;text-align:right\">";
			if ($mostrar[7])
			{
				$tabla .= number_format($depreciacion_mensual, 2);
				$sum_jul += $depreciacion_mensual;
			}
			$tabla .= "</td>";

			$tabla .= "<td style=\"padding:0px 8px;text-align:right\">";
			if ($mostrar[8])
			{
				$tabla .= number_format($depreciacion_mensual, 2);
				$sum_ago += $depreciacion_mensual;
			}
			$tabla .= "</td>";

			$tabla .= "<td style=\"padding:0px 8px;text-align:right\">";
			if ($mostrar[9])
			{
				$tabla .= number_format($depreciacion_mensual, 2);
				$sum_sep += $depreciacion_mensual;
			}
			$tabla .= "</td>";

			$tabla .= "<td style=\"padding:0px 8px;text-align:right\">";
			if ($mostrar[10])
			{
				$tabla .= number_format($depreciacion_mensual, 2);
				$sum_oct += $depreciacion_mensual;
			}
			$tabla .= "</td>";

			$tabla .= "<td style=\"padding:0px 8px;text-align:right\">";
			if ($mostrar[11])
			{
				$tabla .= number_format($depreciacion_mensual, 2);
				$sum_nov += $depreciacion_mensual;
			}
			$tabla .= "</td>";

			$tabla .= "<td style=\"padding:0px 8px;text-align:right\">";
			if ($mostrar[12])
			{
				$tabla .= number_format($depreciacion_mensual, 2);
				$sum_dic += $depreciacion_mensual;
			}
			$tabla .= "</td>";

			$tabla .= "</tr>";

			$contador_color++;
			$i++;
		}
	
		$tabla .= "<tr>";
		$tabla .= "<th>";
		$tabla .= "</th>";
		$tabla .= "<th>";
		//$tabla .= "N&uacute;mero interno";
		$tabla .= "</th>";
		$tabla .= "<th>";
		//$tabla .= "N&uacute;mero de serie";
		$tabla .= "</th>";
		$tabla .= "<th>";
		//$tabla .= "Producto";
		$tabla .= "</th>";
		$tabla .= "<th>";
		//$tabla .= "Código línea";
		$tabla .= "</th>";
		$tabla .= "<th>";
		//$tabla .= "Fecha de alta";
		$tabla .= "</th>";
		$tabla .= "<th style=\"text-align:right;\">";
		$tabla .= number_format($sum_moi, 2);
		$tabla .= "</th>";
		$tabla .= "<th style=\"text-align:right;\">";
		$tabla .= number_format($sum_altas, 2);
		$tabla .= "</th>";
		$tabla .= "<th style=\"text-align:right;\">";
		$tabla .= number_format($sum_bajas, 2);
		$tabla .= "</th>";
		$tabla .= "<th style=\"text-align:right;\">";
		$tabla .= number_format($sum_neto, 2);
		$tabla .= "</th>";
		$tabla .= "<th style=\"text-align:right;\">";
		$tabla .= number_format($sum_acumulado_ano_anterior_monto, 2);
		$tabla .= "</th>";
		$tabla .= "<th style=\"text-align:right;\">";
		$tabla .= number_format($sum_acumulado_ano_calculo_monto, 2);
		$tabla .= "</th>";
		$tabla .= "<th style=\"text-align:right;\">";
		$tabla .= number_format($sum_por_depreciar_ano_calculo_monto, 2);
		$tabla .= "</th>";
		$tabla .= "<th>";
		//$tabla .= "Porcentaje anual";
		$tabla .= "</th>";
		$tabla .= "<th>";
		//$tabla .= "Acumulado meses $ano_anterior";
		$tabla .= "</th>";
		$tabla .= "<th>";
		//$tabla .= "Meses ejercicio $ano_calculo";
		$tabla .= "</th>";
		$tabla .= "<th style=\"text-align:right;\">";
		$tabla .= number_format($sum_depreciacion_ano_calculo_monto, 2);
		$tabla .= "</th>";
		$tabla .= "<th>";
		//$tabla .= "Depreciar hasta";
		$tabla .= "</th>";
		$tabla .= "<th>";
		//$tabla .= "Fecha de baja";
		$tabla .= "</th>";
		$tabla .= "<th>";
		//$tabla .= "Meses a depreciar";
		$tabla .= "</th>";
		$tabla .= "<th style=\"text-align:right;\">";
		$tabla .= number_format($sum_depreciacion_mensual, 2);
		$tabla .= "</th>";
		$tabla .= "<th>";
		//$tabla .= "Meses actual";
		$tabla .= "</th>";
		$tabla .= "<th style=\"text-align:right;\">";
		$tabla .= number_format($sum_flr_depreciacion_contable_monto, 2);
		$tabla .= "</th>";
		$tabla .= "<th style=\"text-align:right;\">";
		$tabla .= number_format($sum_flr_monto_por_depreciar, 2);
		$tabla .= "</th>";
		$tabla .= "<th style=\"text-align:right;\">";
		$tabla .= number_format($sum_ene, 2);
		$tabla .= "</th>";
		$tabla .= "<th style=\"text-align:right;\">";
		$tabla .= number_format($sum_feb, 2);
		$tabla .= "</th>";
		$tabla .= "<th style=\"text-align:right;\">";
		$tabla .= number_format($sum_mar, 2);
		$tabla .= "</th>";
		$tabla .= "<th style=\"text-align:right;\">";
		$tabla .= number_format($sum_abr, 2);
		$tabla .= "</th>";
		$tabla .= "<th style=\"text-align:right;\">";
		$tabla .= number_format($sum_may, 2);
		$tabla .= "</th>";
		$tabla .= "<th style=\"text-align:right;\">";
		$tabla .= number_format($sum_jun, 2);
		$tabla .= "</th>";
		$tabla .= "<th style=\"text-align:right;\">";
		$tabla .= number_format($sum_jul, 2);
		$tabla .= "</th>";
		$tabla .= "<th style=\"text-align:right;\">";
		$tabla .= number_format($sum_ago, 2);
		$tabla .= "</th>";
		$tabla .= "<th style=\"text-align:right;\">";
		$tabla .= number_format($sum_sep, 2);
		$tabla .= "</th>";
		$tabla .= "<th style=\"text-align:right;\">";
		$tabla .= number_format($sum_oct, 2);
		$tabla .= "</th>";
		$tabla .= "<th style=\"text-align:right;\">";
		$tabla .= number_format($sum_nov, 2);
		$tabla .= "</th>";
		$tabla .= "<th style=\"text-align:right;\">";
		$tabla .= number_format($sum_dic, 2);
		$tabla .= "</th>";

		$tabla .= "</table>";
	
		return $tabla;
	}

	// Calcula los meses a depreciar entre dos fechas.
	function meses_depreciacion($fecha_alta, $fecha_corte)
	{
		$ano_alta = substr($fecha_alta, 0, 4);
		$mes_alta = substr($fecha_alta, 5, 2);
		$dia_alta = substr($fecha_alta, 8, 2);
//var_dump($ano_alta, $mes_alta, $dia_alta);
		$ano = substr($fecha_corte, 0, 4);
		$mes = substr($fecha_corte, 5, 2);
		$dia = substr($fecha_corte, 8, 2);
//var_dump($ano, $mes, $dia);

		if ($ano < $ano_alta)
		{
			return 0;
		}

		if ($mes < $mes_alta)
		{
			$meses = 12 - $mes_alta + $mes;
			$anos = $ano - $ano_alta - 1;
		}
		else
		{
			$meses = $mes - $mes_alta;
			$anos = $ano - $ano_alta;
		}

		if ($dia < $dia_alta)
		{
			$meses--;
		}
//var_dump($anos, $meses);
		//$depreciacion = ($anos * 12) + $meses;
		$depreciacion_meses = ($anos * 12) + $meses;

		return $depreciacion_meses;
	}

	// Crea o actualiza el registro de este producto en la bd oreja.
	function sincronizar()
	{
		global $adb;

		$flr_id = $this->obtener_id();

		$ore = new Oreja;

		$prod = new Products;
		$campo_linea = $prod->personalizado("linea", true);

		//$consulta = "select flr.codigo_renta as codigo_interno, 'X' as tipo_codigo, concat(flr.codigo_renta, ' RENTA ', lin.nombre) as descripcion_producto, lin.nombre as lin_nombre, lin.tipo_contable, flr.*, prod.*, prod2.* from vtiger_flota_renta flr, vtiger_crmentity e, vtiger_products prod, vtiger_productcf prod2, vtiger_lineas lin where e.crmid = flr.flota_rentaid and e.deleted = '0' and flr.numero_interno not like '8%' and prod.productid = flr.productid and prod2.productid = flr.productid and lin.lineasid = prod2.$campo_linea  group by flr.numero_interno";
		$consulta = "select flr.codigo_renta as codigo_interno, 'X' as tipo_codigo, concat(flr.codigo_renta, ' RENTA ', lin.nombre) as descripcion_producto, lin.nombre as lin_nombre, lin.tipo_contable, flr.*, prod.*, prod2.* from vtiger_flota_renta flr, vtiger_crmentity e, vtiger_products prod, vtiger_productcf prod2, vtiger_lineas lin where e.crmid = flr.flota_rentaid and e.deleted = '0' and flr.numero_interno not like '8%' and prod.productid = flr.productid and prod2.productid = flr.productid and lin.lineasid = prod2.$campo_linea and flr.flota_rentaid = '$flr_id'";
//var_dump($consulta);
//die;
		$resultado = $adb->query($consulta);
		$renglon = $adb->fetch_array($resultado);

		unset($datos);
/*************************
Cuando se agregue la flr a la config se usará esto.
		foreach($config_oreja["productos"] as $campo_destino => $codigo)
		{
			$datos[$campo_destino] = $this->column_fields[$codigo];
		}
**************************/
		//$datos["cIdClienteProveedor"] = $datos["cCodigoCliente"];
// IW3 201711
		//$datos["CCODIGOPRODUCTO"] = $this->column_fields["codigo_renta"];
		$datos["cCodigoProducto"] = $this->column_fields["codigo_renta"];
// IW3 201711
		$datos["CNOMBREPRODUCTO"] = $renglon["descripcion_producto"];
		$datos["CTIPOPRODUCTO"] = 3;
		$datos["CMETODOCOSTEO"] = 7;
		$datos["CCONTROLEXISTENCIA"] = 1;
		$datos["CIMPUESTO1"] = 16;
		$datos["CNOMBREUNIDADBASE"] = "DIA";


		// Segmentos contables que provienen del tipo contable.
		$eqv_valores_visuales_lista = "Activo fijo|Gasto|Equipo ligero";
		$eqv_valores_segmentos_lista["PR03"] = "121410001|601900001|601900001";
		$eqv_valores_segmentos_lista["PR04"] = "0001|0002|0002";
		$valores_visuales = explode("|", $eqv_valores_visuales_lista);
		$valores_segmentos["PR03"] = explode("|", $eqv_valores_segmentos_lista["PR03"]);
		$valores_segmentos["PR04"] = explode("|", $eqv_valores_segmentos_lista["PR04"]);
		for ($i = 0; $i <= (count($valores_visuales) - 1); $i++)
		{
			$abreviaturas[$valores_visuales[$i]] = $valores_interfaz[$i];
			$segmentos_contables[$valores_visuales[$i]]["PR03"] = $valores_segmentos["PR03"][$i];
			$segmentos_contables[$valores_visuales[$i]]["PR04"] = $valores_segmentos["PR04"][$i];
		}

		$datos["CSEGCONTPRODUCTO1"] = "42";
		$datos["CSEGCONTPRODUCTO2"] = "52";
		$datos["CSEGCONTPRODUCTO3"] = $segmentos_contables[html_entity_decode($renglon["tipo_contable"], ENT_QUOTES, "UTF-8")]["PR03"];
		$datos["CSEGCONTPRODUCTO4"] = $segmentos_contables[html_entity_decode($renglon["tipo_contable"], ENT_QUOTES, "UTF-8")]["PR04"];
		$datos["CSEGCONTPRODUCTO5"] = "47";


		//$datos["cCodigoValorClasif1"] = "SER";
		//$datos["cCodigoValorClasif2"] = "SER";
		//$datos["cCodigoValorClasif3"] = "SER";
		$datos["cCodigoValorClasif4"] = "REN";

		$oreja = $this->oreja_conectar();
/**********************
		$datos["cIdDocumento"] = "ER5";
		$datos["cFecha"] = "2015-09-03";
		$datos["cCodigoConcepto"] = "340";
		$datos["cCodigoCteProv"] = "";
**********************/

		// Limpia posibles registros previos.
		//$this->oreja_limpiar($oreja, "Documentos", "cIdDocumento", "ER5");
		//$this->oreja_limpiar($oreja, "Movimientos", "cIdDocumento", "ER5");
		//$this->oreja_limpiar($oreja, "Productos", "CCODIGOPRODUCTO", $datos["CCODIGOPRODUCTO"]);
// IW3 201711
/********************
		$this->oreja_limpiar($oreja, "Productos", "CCODIGOPRODUCTO", $this->column_fields["codigo_flota"]);
		$this->oreja_limpiar($oreja, "Productos", "CCODIGOPRODUCTO", $this->column_fields["codigo_renta"]);
		$this->oreja_limpiar($oreja, "Productos", "CCODIGOPRODUCTO", $this->column_fields["codigo_hextra"]);
*******************/
		$this->oreja_limpiar($oreja, "Productos", "cCodigoProducto", $this->column_fields["codigo_flota"]);
		$this->oreja_limpiar($oreja, "Productos", "cCodigoProducto", $this->column_fields["codigo_renta"]);
		$this->oreja_limpiar($oreja, "Productos", "cCodigoProducto", $this->column_fields["codigo_hextra"]);
// IW3 201711

/****************************
unset($datos["cCodigoValorClasif1"]);
unset($datos["cCodigoValorClasif2"]);
unset($datos["cCodigoValorClasif3"]);
//unset($datos["cCodigoValorClasif4"]);
unset($datos["cCodigoValorClasif5"]);
unset($datos["cCodigoValorClasif6"]);

unset($datos["CSEGCONTPRODUCTO1"]);
unset($datos["CSEGCONTPRODUCTO2"]);
unset($datos["CSEGCONTPRODUCTO3"]);
unset($datos["CSEGCONTPRODUCTO4"]);
unset($datos["CSEGCONTPRODUCTO5"]);
unset($datos["CSEGCONTPRODUCTO6"]);
unset($datos["CSEGCONTPRODUCTO7"]);
*****************************/

		// Transmite los datos.
// IW3 201711
/*************************************
		// Códigos X.
		$this->oreja_transmitir($oreja, "Productos", $datos);

		// Códigos Y.
		$datos["CCODIGOPRODUCTO"] = $this->column_fields["codigo_hextra"];
		$datos["CNOMBREUNIDADBASE"] = "HORA";
		$datos["CNOMBREPRODUCTO"] = $this->column_fields["codigo_hextra"]." HORA EXTRA ".$renglon["lin_nombre"];
		$this->oreja_transmitir($oreja, "Productos", $datos);

		// Código de flota.
		$datos["CCODIGOPRODUCTO"] = $this->column_fields["codigo_flota"];
		//$datos["CNOMBREUNIDADBASE"] = "PIEZA";
		$datos["CNOMBREUNIDADBASE"] = "PZA";
		$datos["CNOMBREPRODUCTO"] = $this->column_fields["codigo_flota"]." ".$renglon["productname"];
		$this->oreja_transmitir($oreja, "Productos", $datos);
************************************/
			unset ($parametros);
			$parametros["crmid"] = $flr_id;
			$parametros["tipo_documento"] = "Flota_renta";
			$parametros["tabla_destino"] = "Productos";
			$parametros["fecha"] = date("Y-m-d", strtotime($datos["cFecha"]));
			$parametros["datos"] = $datos;
			$this->oreja_transmitir($oreja, "Productos", $ore->transformar($parametros));
			unset ($parametros);
// IW3 201711

		$this->oreja_desconectar($oreja);
	}
}
?>
