<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/
require_once('data/CRMEntity.php');
require_once('data/Tracker.php');
require_once("modules/Ordenes_compra_det/Ordenes_compra_det.php");
require_once("modules/Recepciones_mercancia/Recepciones_mercancia.php");
require_once("modules/Recepciones_mercancia_det/Recepciones_mercancia_det.php");
require_once("modules/Sucursales/Sucursales.php");
require_once("modules/Vendors/Vendors.php");

class Ordenes_compra extends CRMEntity {
	var $db, $log; // Used in class functions of CRMEntity

	var $table_name = 'vtiger_ordenes_compra';
	var $table_index= 'ordenes_compraid';
	var $column_fields = Array();

	/** Indicator if this is a custom module or standard module */
	var $IsCustomModule = true;

	/**
	 * Mandatory table for supporting custom fields.
	 */
	var $customFieldTable = Array('vtiger_ordenes_compracf', 'ordenes_compraid');

	/**
	 * Mandatory for Saving, Include tables related to this module.
	 */
	var $tab_name = Array('vtiger_crmentity', 'vtiger_ordenes_compra', 'vtiger_ordenes_compracf');

	/**
	 * Mandatory for Saving, Include tablename and tablekey columnname here.
	 */
	var $tab_name_index = Array(
		'vtiger_crmentity' => 'crmid',
		'vtiger_ordenes_compra'   => 'ordenes_compraid',
	    'vtiger_ordenes_compracf' => 'ordenes_compraid');

	/**
	 * Mandatory for Listing (Related listview)
	 */
	var $list_fields = Array (
		/* Format: Field Label => Array(tablename, columnname) */
		// tablename should not have prefix 'vtiger_'
		'Ordenes_compra Name'=> Array('ordenes_compra', ''),
		'Assigned To' => Array('crmentity','smownerid')
	);
	var $list_fields_name = Array(
		/* Format: Field Label => fieldname */
		'Ordenes_compra Name'=> '',
		'Assigned To' => 'assigned_user_id'
	);

	// Make the field link to detail view from list view (Fieldname)
	var $list_link_field = '';

	// For Popup listview and UI type support
	var $search_fields = Array(
		/* Format: Field Label => Array(tablename, columnname) */
		// tablename should not have prefix 'vtiger_'
		'Ordenes_compra Name'=> Array('ordenes_compra', '')
	);
	var $search_fields_name = Array(
		/* Format: Field Label => fieldname */
		'Ordenes_compra Name'=> ''
	);

	// For Popup window record selection
	var $popup_fields = Array('');

	// Placeholder for sort fields - All the fields will be initialized for Sorting through initSortFields
	var $sortby_fields = Array();

	// For Alphabetical search
	var $def_basicsearch_col = '';

	// Column value to use on detail view record text display
	var $def_detailview_recname = '';

	// Required Information for enabling Import feature
	var $required_fields = Array(''=>1);

	// Callback function list during Importing
	var $special_functions = Array('set_import_assigned_user');

	var $default_order_by = '';
	var $default_sort_order='ASC';
	// Used when enabling/disabling the mandatory fields for the module.
	// Refers to vtiger_field.fieldname values.
	var $mandatory_fields = Array('createdtime', 'modifiedtime', '');
	
	function __construct() {
		global $log, $currentModule;
		$this->column_fields = getColumnFields($currentModule);
		$this->db = PearDatabase::getInstance();
		$this->log = $log;
	}

	function getSortOrder() {
		global $currentModule;

		$sortorder = $this->default_sort_order;
		if($_REQUEST['sorder']) $sortorder = $this->db->sql_escape_string($_REQUEST['sorder']);
		else if($_SESSION[$currentModule.'_Sort_Order']) 
			$sortorder = $_SESSION[$currentModule.'_Sort_Order'];

		return $sortorder;
	}

	function getOrderBy() {
		global $currentModule;
		
		$use_default_order_by = '';		
		if(PerformancePrefs::getBoolean('LISTVIEW_DEFAULT_SORTING', true)) {
			$use_default_order_by = $this->default_order_by;
		}
		
		$orderby = $use_default_order_by;
		if($_REQUEST['order_by']) $orderby = $this->db->sql_escape_string($_REQUEST['order_by']);
		else if($_SESSION[$currentModule.'_Order_By'])
			$orderby = $_SESSION[$currentModule.'_Order_By'];
		return $orderby;
	}

	function save_module($module) {
		$this->actualizar();
	}

	/**
	 * Return query to use based on given modulename, fieldname
	 * Useful to handle specific case handling for Popup
	 */
	function getQueryByModuleField($module, $fieldname, $srcrecord, $query='') {
		// $srcrecord could be empty
	}

	/**
	 * Get list view query (send more WHERE clause condition if required)
	 */
	function getListQuery($module, $usewhere='') {
		$query = "SELECT vtiger_crmentity.*, $this->table_name.*";
		
		// Keep track of tables joined to avoid duplicates
		$joinedTables = array();

		// Select Custom Field Table Columns if present
		if(!empty($this->customFieldTable)) $query .= ", " . $this->customFieldTable[0] . ".* ";

		$query .= " FROM $this->table_name";

		$query .= "	INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index";

		$joinedTables[] = $this->table_name;
		$joinedTables[] = 'vtiger_crmentity';
		
		// Consider custom table join as well.
		if(!empty($this->customFieldTable)) {
			$query .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index";
			$joinedTables[] = $this->customFieldTable[0]; 
		}
		$query .= " LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid";
		$query .= " LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";

		$joinedTables[] = 'vtiger_users';
		$joinedTables[] = 'vtiger_groups';
		
		$linkedModulesQuery = $this->db->pquery("SELECT distinct fieldname, columnname, relmodule FROM vtiger_field" .
				" INNER JOIN vtiger_fieldmodulerel ON vtiger_fieldmodulerel.fieldid = vtiger_field.fieldid" .
				" WHERE uitype='10' AND vtiger_fieldmodulerel.module=?", array($module));
		$linkedFieldsCount = $this->db->num_rows($linkedModulesQuery);
		
		for($i=0; $i<$linkedFieldsCount; $i++) {
			$related_module = $this->db->query_result($linkedModulesQuery, $i, 'relmodule');
			$fieldname = $this->db->query_result($linkedModulesQuery, $i, 'fieldname');
			$columnname = $this->db->query_result($linkedModulesQuery, $i, 'columnname');
			
			$other =  CRMEntity::getInstance($related_module);
			vtlib_setup_modulevars($related_module, $other);
			
			if(!in_array($other->table_name, $joinedTables)) {
				$query .= " LEFT JOIN $other->table_name ON $other->table_name.$other->table_index = $this->table_name.$columnname";
				$joinedTables[] = $other->table_name;
			}
		}

		global $current_user;
		$query .= $this->getNonAdminAccessControlQuery($module,$current_user);
		$query .= "	WHERE vtiger_crmentity.deleted = 0 ".$usewhere;
		return $query;
	}

	/**
	 * Apply security restriction (sharing privilege) query part for List view.
	 */
	function getListViewSecurityParameter($module) {
		global $current_user;
		require('user_privileges/user_privileges_'.$current_user->id.'.php');
		require('user_privileges/sharing_privileges_'.$current_user->id.'.php');

		$sec_query = '';
		$tabid = getTabid($module);

		if($is_admin==false && $profileGlobalPermission[1] == 1 && $profileGlobalPermission[2] == 1 
			&& $defaultOrgSharingPermission[$tabid] == 3) {

				$sec_query .= " AND (vtiger_crmentity.smownerid in($current_user->id) OR vtiger_crmentity.smownerid IN 
					(
						SELECT vtiger_user2role.userid FROM vtiger_user2role 
						INNER JOIN vtiger_users ON vtiger_users.id=vtiger_user2role.userid 
						INNER JOIN vtiger_role ON vtiger_role.roleid=vtiger_user2role.roleid 
						WHERE vtiger_role.parentrole LIKE '".$current_user_parent_role_seq."::%'
					) 
					OR vtiger_crmentity.smownerid IN 
					(
						SELECT shareduserid FROM vtiger_tmp_read_user_sharing_per 
						WHERE userid=".$current_user->id." AND tabid=".$tabid."
					) 
					OR 
						(";
		
					// Build the query based on the group association of current user.
					if(sizeof($current_user_groups) > 0) {
						$sec_query .= " vtiger_groups.groupid IN (". implode(",", $current_user_groups) .") OR ";
					}
					$sec_query .= " vtiger_groups.groupid IN 
						(
							SELECT vtiger_tmp_read_group_sharing_per.sharedgroupid 
							FROM vtiger_tmp_read_group_sharing_per
							WHERE userid=".$current_user->id." and tabid=".$tabid."
						)";
				$sec_query .= ")
				)";
		}
		return $sec_query;
	}

	/**
	 * Create query to export the records.
	 */
	function create_export_query($where)
	{
		global $current_user;
		$thismodule = $_REQUEST['module'];
		
		include("include/utils/ExportUtils.php");

		//To get the Permitted fields query and the permitted fields list
		$sql = getPermittedFieldsQuery($thismodule, "detail_view");
		
		$fields_list = getFieldsListFromQuery($sql);

		$query = "SELECT $fields_list, vtiger_users.user_name AS user_name 
					FROM vtiger_crmentity INNER JOIN $this->table_name ON vtiger_crmentity.crmid=$this->table_name.$this->table_index";

		if(!empty($this->customFieldTable)) {
			$query .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index"; 
		}

		$query .= " LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";
		$query .= " LEFT JOIN vtiger_users ON vtiger_crmentity.smownerid = vtiger_users.id and vtiger_users.status='Active'";
		
		$linkedModulesQuery = $this->db->pquery("SELECT distinct fieldname, columnname, relmodule FROM vtiger_field" .
				" INNER JOIN vtiger_fieldmodulerel ON vtiger_fieldmodulerel.fieldid = vtiger_field.fieldid" .
				" WHERE uitype='10' AND vtiger_fieldmodulerel.module=?", array($thismodule));
		$linkedFieldsCount = $this->db->num_rows($linkedModulesQuery);

		for($i=0; $i<$linkedFieldsCount; $i++) {
			$related_module = $this->db->query_result($linkedModulesQuery, $i, 'relmodule');
			$fieldname = $this->db->query_result($linkedModulesQuery, $i, 'fieldname');
			$columnname = $this->db->query_result($linkedModulesQuery, $i, 'columnname');
			
			$other = CRMEntity::getInstance($related_module);
			vtlib_setup_modulevars($related_module, $other);
			
			$query .= " LEFT JOIN $other->table_name ON $other->table_name.$other->table_index = $this->table_name.$columnname";
		}

		$query .= $this->getNonAdminAccessControlQuery($thismodule,$current_user);
		$where_auto = " vtiger_crmentity.deleted=0";

		if($where != '') $query .= " WHERE ($where) AND $where_auto";
		else $query .= " WHERE $where_auto";

		return $query;
	}

	/**
	 * Initialize this instance for importing.
	 */
	function initImport($module) {
		$this->db = PearDatabase::getInstance();
		$this->initImportableFields($module);
	}

	/**
	 * Create list query to be shown at the last step of the import.
	 * Called From: modules/Import/UserLastImport.php
	 */
	function create_import_query($module) {
		global $current_user;
		$query = "SELECT vtiger_crmentity.crmid, case when (vtiger_users.user_name not like '') then vtiger_users.user_name else vtiger_groups.groupname end as user_name, $this->table_name.* FROM $this->table_name
			INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index
			LEFT JOIN vtiger_users_last_import ON vtiger_users_last_import.bean_id=vtiger_crmentity.crmid
			LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid
			LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid
			WHERE vtiger_users_last_import.assigned_user_id='$current_user->id'
			AND vtiger_users_last_import.bean_type='$module'
			AND vtiger_users_last_import.deleted=0";
		return $query;
	}

	/**
	 * Delete the last imported records.
	 */
	function undo_import($module, $user_id) {
		global $adb;
		$count = 0;
		$query1 = "select bean_id from vtiger_users_last_import where assigned_user_id=? AND bean_type='$module' AND deleted=0";
		$result1 = $adb->pquery($query1, array($user_id)) or die("Error getting last import for undo: ".mysql_error()); 
		while ( $row1 = $adb->fetchByAssoc($result1))
		{
			$query2 = "update vtiger_crmentity set deleted=1 where crmid=?";
			$result2 = $adb->pquery($query2, array($row1['bean_id'])) or die("Error undoing last import: ".mysql_error()); 
			$count++;			
		}
		return $count;
	}
	
	/**
	 * Transform the value while exporting
	 */
	function transform_export_value($key, $value) {
		return parent::transform_export_value($key, $value);
	}

	/**
	 * Function which will set the assigned user id for import record.
	 */
	function set_import_assigned_user()
	{
		global $current_user, $adb;
		$record_user = $this->column_fields["assigned_user_id"];
		
		if($record_user != $current_user->id){
			$sqlresult = $adb->pquery("select id from vtiger_users where id = ? union select groupid as id from vtiger_groups where groupid = ?", array($record_user, $record_user));
			if($this->db->num_rows($sqlresult)!= 1) {
				$this->column_fields["assigned_user_id"] = $current_user->id;
			} else {			
				$row = $adb->fetchByAssoc($sqlresult, -1, false);
				if (isset($row['id']) && $row['id'] != -1) {
					$this->column_fields["assigned_user_id"] = $row['id'];
				} else {
					$this->column_fields["assigned_user_id"] = $current_user->id;
				}
			}
		}
	}
	
	/** 
	 * Function which will give the basic query to find duplicates
	 */
	function getDuplicatesQuery($module,$table_cols,$field_values,$ui_type_arr,$select_cols='') {
		$select_clause = "SELECT ". $this->table_name .".".$this->table_index ." AS recordid, vtiger_users_last_import.deleted,".$table_cols;

		// Select Custom Field Table Columns if present
		if(isset($this->customFieldTable)) $query .= ", " . $this->customFieldTable[0] . ".* ";

		$from_clause = " FROM $this->table_name";

		$from_clause .= "	INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index";

		// Consider custom table join as well.
		if(isset($this->customFieldTable)) {
			$from_clause .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index"; 
		}
		$from_clause .= " LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid
						LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";
		
		$where_clause = "	WHERE vtiger_crmentity.deleted = 0";
		$where_clause .= $this->getListViewSecurityParameter($module);
					
		if (isset($select_cols) && trim($select_cols) != '') {
			$sub_query = "SELECT $select_cols FROM  $this->table_name AS t " .
				" INNER JOIN vtiger_crmentity AS crm ON crm.crmid = t.".$this->table_index;
			// Consider custom table join as well.
			if(isset($this->customFieldTable)) {
				$sub_query .= " LEFT JOIN ".$this->customFieldTable[0]." tcf ON tcf.".$this->customFieldTable[1]." = t.$this->table_index";
			}
			$sub_query .= " WHERE crm.deleted=0 GROUP BY $select_cols HAVING COUNT(*)>1";	
		} else {
			$sub_query = "SELECT $table_cols $from_clause $where_clause GROUP BY $table_cols HAVING COUNT(*)>1";
		}	
		
		
		$query = $select_clause . $from_clause .
					" LEFT JOIN vtiger_users_last_import ON vtiger_users_last_import.bean_id=" . $this->table_name .".".$this->table_index .
					" INNER JOIN (" . $sub_query . ") AS temp ON ".get_on_clause($field_values,$ui_type_arr,$module) .
					$where_clause .
					" ORDER BY $table_cols,". $this->table_name .".".$this->table_index ." ASC";
					
		return $query;		
	}

	/**
	 * Invoked when special actions are performed on the module.
	 * @param String Module name
	 * @param String Event Type (module.postinstall, module.disabled, module.enabled, module.preuninstall)
	 */
	function vtlib_handler($modulename, $event_type) {
		if($event_type == 'module.postinstall') {
			// TODO Handle post installation actions
		} else if($event_type == 'module.disabled') {
			// TODO Handle actions when this module is disabled.
		} else if($event_type == 'module.enabled') {
			// TODO Handle actions when this module is enabled.
		} else if($event_type == 'module.preuninstall') {
			// TODO Handle actions when this module is about to be deleted.
		} else if($event_type == 'module.preupdate') {
			// TODO Handle actions before this module is updated.
		} else if($event_type == 'module.postupdate') {
			// TODO Handle actions after this module is updated.
		}
	}

	/** 
	 * Handle saving related module information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	// function save_related_module($module, $crmid, $with_module, $with_crmid) { }
	
	/**
	 * Handle deleting related module information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function delete_related_module($module, $crmid, $with_module, $with_crmid) { }

	/**
	 * Handle getting related list information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function get_related_list($id, $cur_tab_id, $rel_tab_id, $actions=false) { }

	/**
	 * Handle getting dependents list information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function get_dependents_list($id, $cur_tab_id, $rel_tab_id, $actions=false) { }

	// Genera tabla de captura de detalle.
	function tabla_captura()
	{
		$oc_id = $this->obtener_id();

		global $adb;

		$iteraciones = 30;
		$contador_color = 0;

		// Busca registros de detalle previamente capturados.
		$consulta = "select ocd.*, prod.productname from vtiger_ordenes_compra_det ocd, vtiger_crmentity e, vtiger_products prod where e.crmid = ocd.ordenes_compra_detid and e.deleted = '0' and ocd.ordenes_compraid = '$oc_id' and prod.productid = ocd.productid";
//var_dump($consulta);
		$resultado = $adb->query($consulta);

		$i = 1;

		while ($renglon = $adb->fetch_array($resultado))
		{
//echo "<pre>";
//var_dump($renglon);
//echo "</pre>";
//die;
			$ocd_id = $renglon["ordenes_compra_detid"];
			$ocd_folio = $renglon["folio"];
			$ocd_orden_compra = $renglon["orden_compra"];
			$ocd_producto = $renglon["productid"];
			$ocd_cantidad = $renglon["cantidad"];
			$ocd_precio_lista = $renglon["precio_lista"];
			$ocd_descuento = $renglon["descuento"];
			$ocd_precio = $renglon["precio"];
			$ocd_surtido = $renglon["surtido"];
			$prod_nombre = $renglon["productname"];

			$valores[$i]["ocd_folio"] = $ocd_folio;
			$valores[$i]["ocd_orden_compra"] = $ocd_orden_compra;
			$valores[$i]["ocd_producto"] = $ocd_producto;
			$valores[$i]["ocd_cantidad"] = $ocd_cantidad;
			$valores[$i]["ocd_precio_lista"] = $ocd_precio_lista;
			$valores[$i]["ocd_descuento"] = $ocd_descuento;
			$valores[$i]["ocd_precio"] = $ocd_precio;
			$valores[$i]["ocd_surtido"] = $ocd_surtido;
			$valores[$i]["prod_nombre"] = $prod_nombre;

			$i++;
		}

		$tabla = "<table>";
		$tabla .= "<tr>";
		$tabla .= "<th>";
		$tabla .= "</th>";
		$tabla .= "<th>";
		$tabla .= "Producto";
		$tabla .= "</th>";
		$tabla .= "<th>";
		$tabla .= "Cantidad";
		$tabla .= "</th>";
		$tabla .= "<th>";
		$tabla .= "Precio de lista";
		$tabla .= "</th>";
		$tabla .= "<th>";
		$tabla .= "Descuento";
		$tabla .= "</th>";
		$tabla .= "<th>";
		$tabla .= "Precio";
		$tabla .= "</th>";
		$tabla .= "</tr>";

		for ($i = 1; $i <= $iteraciones; $i++)
		{
			$color = ($contador_color % 2)?"#eee":"#fec";

			$tabla .= "<tr style=\"background:$color;\">";
			$tabla .= "<td style=\"text-align:right;\">";
			$tabla .= "$i.";
			$tabla .= "</td>";
			$tabla .= "<td>";
	
			$nombre_campo = "ocd_producto$i";
			$nombre_display = "ocd_producto{$i}_display";
			$srcmodule = "Ordenes_compra_det";
			$modulo_emergente = "Products";
			$id_registro = $valores[$i]["ocd_producto"];
			$valor_mostrado = $valores[$i]["prod_nombre"];
			//$adicional = "&algo_tipo=".$xyz->column_fields["algorem_tipo"];

$control_relacionado =
"
<input id=\"$nombre_campo\" name=\"$nombre_campo\" type=\"hidden\" value=\"$id_registro\" id=\"$nombre_campo\"> <!-- IdeasWWW --> <input id=\"$nombre_display\" name=\"$nombre_display\" id=\"edit_$nombre_display\" readonly type=\"text\" style=\"border:1px solid #bababa;font-size:11px;width:300px;\" value=\"$valor_mostrado\">&nbsp; <!-- IdeasWWW --> <img src=\"themes/softed/images/select.gif\" tabindex=\"\" alt=\"Select\" title=\"Select\" LANGUAGE=javascript onclick='return window.open(\"index.php?module=$modulo_emergente&action=Popup&html=Popup_picker&form=vtlibPopupView&forfield=$nombre_campo&srcmodule=$srcmodule&forrecord=$forrecord$adicional\",\"test\",\"width=640,height=602,resizable=0,scrollbars=0,top=150,left=200\");' align=\"absmiddle\" style='cursor:hand;cursor:pointer'>&nbsp; <input type=\"image\" src=\"themes/images/clear_field.gif\" alt=\"Clear\" title=\"Clear\" LANGUAGE=javascript onClick=\"this.form.$nombre_campo.value=''; this.form.$nombre_display.value=''; return false;\" align=\"absmiddle\" style='cursor:hand;cursor:pointer'>&nbsp;
";
			$tabla .= $control_relacionado;
			$tabla .= "</td>";
			$tabla .= "<td>";
			$tabla .= "<input type=\"text\" name=\"captura[$i][cantidad]\" style=\"text-align:right;width:50px;\" value=\"".$valores[$i]["ocd_cantidad"]."\">";
			$tabla .= "</td>";
			$tabla .= "<td>";
			$tabla .= "<input type=\"text\" name=\"captura[$i][precio_lista]\" style=\"text-align:right;width:80px;\" value=\"".$valores[$i]["ocd_precio_lista"]."\">";
			$tabla .= "</td>";
			$tabla .= "<td>";
			$tabla .= "<input type=\"text\" name=\"captura[$i][descuento]\" style=\"text-align:right;width:80px;\" value=\"".$valores[$i]["ocd_descuento"]."\">";
			$tabla .= "</td>";
			$tabla .= "<td>";
			$tabla .= "<input type=\"text\" name=\"captura[$i][precio]\" style=\"text-align:right;width:80px;\" value=\"".$valores[$i]["ocd_precio"]."\">";
			$tabla .= "</td>";
			$tabla .= "</tr>";

			$contador_color++;
		}

		$tabla .= "</table>";

		return $tabla;
	}

	// Registra el detalle capturado para esta orden de compra.
	function registrar_detalles($captura)
	{
/*********************************
echo "<pre>";
var_dump($captura);
echo "</pre>";
die;
**********************************/
		$oc_id = $this->obtener_id();

		global $adb;

		// Elimina posibles registros de detalle previamente capturados.
		$consulta = "update vtiger_ordenes_compra_det ocd, vtiger_crmentity e set e.deleted = '1' where e.crmid = ocd.ordenes_compra_detid and e.deleted = '0' and ocd.ordenes_compraid = '$oc_id'";
//var_dump($consulta);
		$adb->query($consulta);

		$iteraciones = 30;

		for ($i = 1; $i <= $iteraciones; $i++)
		{
			$prod_id = $captura[$i]["producto"];
			$cantidad = $captura[$i]["cantidad"];
			$precio_lista = $captura[$i]["precio_lista"];
			$descuento = $captura[$i]["descuento"];
			$precio_lista = $captura[$i]["precio_lista"];
			$descuento = $captura[$i]["descuento"];
			$precio = $captura[$i]["precio"];

			if ($prod_id == "")
			{
				continue;
			}

//var_dump($i);
			$ocd = new Ordenes_compra_det;

			$ocd->column_fields["assigned_user_id"] = 1;
			//$ocd->column_fields["folio"] = $ocd_folio;
			$ocd->column_fields["orden_compra"] = $oc_id;
			$ocd->column_fields["sucursal"] = $this->column_fields["sucursal"];
			$ocd->column_fields["proveedor"] = $this->column_fields["proveedor"];
			$ocd->column_fields["producto"] = $prod_id;
			$ocd->column_fields["cantidad"] = $cantidad;
			$ocd->column_fields["precio_lista"] = $precio_lista;
			$ocd->column_fields["descuento"] = $descuento;
			$ocd->column_fields["precio"] = $precio;

			if ($precio == "")
			{
				$ocd->column_fields["precio"] = $precio_lista;

				if ($descuento != "")
				{
					$elementos = explode("+", $descuento);

					foreach ($elementos as $elemento)
					{
						$ocd->column_fields["precio"] *= (1 - ($elemento / 100));
					}
				}
			}

			//$ocd->column_fields["surtido"] = $ocd_surtido;

			$ocd->save("Ordenes_compra_det");

			$ocd_id = $ocd->obtener_id();
		}
	}

	// Genera tabla de detalles.
	function tabla_detalles($parametros = null)
	{
		$oc_id = $this->obtener_id();
		$oc_moneda = $this->column_fields["moneda"];

		global $adb;

		$contador_color = 0;
		$i = 1;

		$tabla = "<table style=\"width:100%;padding:0px 8px;\">";
		$tabla .= "<tr>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "</th>";
		//$tabla .= "<th class=\"dvInnerHeader\">";
		//$tabla .= "Folio";
		//$tabla .= "</th>";
		//$tabla .= "<th class=\"dvInnerHeader\">";
		//$tabla .= "Orden de compra";
		//$tabla .= "</th>";
		$tabla .= "<th id=\"col-producto\" class=\"dvInnerHeader\">";
		$tabla .= "Producto";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Cantidad";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Precio";
		$tabla .= "</th>";
		if (!$parametros["surtido"]["ocultar"])
		{
			$tabla .= "<th class=\"dvInnerHeader\">";
			$tabla .= "Surtido";
			$tabla .= "</th>";
			$desplazar++;
		}
		if (!$parametros["pendiente"]["ocultar"])
		{
			$tabla .= "<th class=\"dvInnerHeader\">";
			$tabla .= "Pendiente";
			$tabla .= "</th>";
			$desplazar++;
		}
		if (!$parametros["documentos"]["ocultar"])
		{
			$tabla .= "<th class=\"dvInnerHeader\">";
			$tabla .= "Documentos";
			$tabla .= "</th>";
			$desplazar++;
		}
		if (!$parametros["importe"]["ocultar"])
		{
			$tabla .= "<th class=\"dvInnerHeader\">";
			$tabla .= "Importe";
			$tabla .= "</th>";
		}
		$tabla .= "</tr>";

		$consulta = "select ocd.*, prod.productname from vtiger_ordenes_compra_det ocd, vtiger_crmentity e, vtiger_products prod where e.crmid = ocd.ordenes_compra_detid and e.deleted = '0' and ocd.ordenes_compraid = '$oc_id' and prod.productid = ocd.productid";
//var_dump($consulta);
		$resultado = $adb->query($consulta);
		while ($renglon = $adb->fetch_array($resultado))
		{
//echo "<pre>";
//var_dump($renglon);
//echo "</pre>";
//die;
			$ocd_id = $renglon["ordenes_compra_detid"];
			//$ocd_folio = $renglon["folio"];
			//$ocd_orden_compra = $renglon["orden_compra"];
			$ocd_producto = $renglon["producto"];
			$ocd_cantidad = $renglon["cantidad"];
			$ocd_precio = $renglon["precio"];
			$ocd_importe = $ocd_cantidad * $ocd_precio;;
			$ocd_surtido = $renglon["surtido"];
			$ocd_documentos = $renglon["documentos"];
			$prod_nombre = $renglon["productname"];
			$pendiente = $ocd_cantidad - $ocd_surtido;
			$subtotal += $ocd_importe;

			$color = ($contador_color % 2)?"#eee":"#fec";

			$tabla .= "<tr style=\"background:$color;\">";
			$tabla .= "<td style=\"text-align:right;\">";
			$tabla .= "$i.";
			$tabla .= "</td>";
			//$tabla .= "<td style=\"background:$color;padding:0px 8px;\">";
			//$tabla .= $ocd_folio;
			//$tabla .= "</td>";
			//$tabla .= "<td style=\"background:$color;padding:0px 8px;\">";
			//$tabla .= $ocd_orden_compra;
			//$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;\">";
			$tabla .= $prod_nombre;
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;text-align:right;\">";
			$tabla .= $ocd_cantidad;
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;text-align:right;\">";
			$tabla .= number_format($ocd_precio, 2);
			$tabla .= "</td>";
			if (!$parametros["surtido"]["ocultar"])
			{
				$tabla .= "<td style=\"padding:0px 8px;text-align:right;\">";
				$tabla .= $ocd_surtido;
				$tabla .= "</td>";
			}
			if (!$parametros["pendiente"]["ocultar"])
			{
				$tabla .= "<td style=\"padding:0px 8px;text-align:right;\">";
				$tabla .= $pendiente;
				$tabla .= "</td>";
			}
			if (!$parametros["documentos"]["ocultar"])
			{
				$tabla .= "<td style=\"padding:0px 8px;text-align:right;\">";
				$tabla .= $ocd_documentos;
				$tabla .= "</td>";
			}
			if (!$parametros["importe"]["ocultar"])
			{
				$tabla .= "<td style=\"padding:0px 8px;text-align:right;\">";
				$tabla .= number_format($ocd_importe, 2);
				$tabla .= "</td>";
			}
			$tabla .= "</tr>";

			$contador_color++;
			$i++;
		}

		if (!$parametros["importe"]["ocultar"])
		{
			$desplazar += 3;
			$iva = ($subtotal * 0.16);
			$total = $subtotal + $iva;
			$tabla .= "<tr>";
			for ($i = 1; $i <= $desplazar; $i++)
			{
				$tabla .= "<td>";
				$tabla .= "</td>";
			}
			$tabla .= "<td style=\"padding:0px 8px;text-align:right;font-weight:bold;\">";
			$tabla .= "Subtotal ($oc_moneda):";
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;text-align:right;font-weight:bold;\">";
			$tabla .= number_format($subtotal, 2);
			$tabla .= "</td>";
			$tabla .= "</tr>";
			$tabla .= "<tr>";
			for ($i = 1; $i <= $desplazar; $i++)
			{
				$tabla .= "<td>";
				$tabla .= "</td>";
			}
			$tabla .= "<td style=\"padding:0px 8px;text-align:right;font-weight:bold;\">";
			$tabla .= "IVA ($oc_moneda):";
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;text-align:right;font-weight:bold;\">";
			$tabla .= number_format($iva, 2);
			$tabla .= "</td>";
			$tabla .= "</tr>";
			$tabla .= "<tr>";
			for ($i = 1; $i <= $desplazar; $i++)
			{
				$tabla .= "<td>";
				$tabla .= "</td>";
			}
			$tabla .= "<td style=\"padding:0px 8px;text-align:right;font-weight:bold;\">";
			$tabla .= "Total ($oc_moneda):";
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;text-align:right;font-weight:bold;\">";
			$tabla .= number_format($total, 2);
			$tabla .= "</td>";
			$tabla .= "</tr>";
		}
		$tabla .= "</table>";

		return $tabla;
	}

	//Genera una recepción de mercancía a partir de esta orden de compra.
	//function recepcion_mercancia()
	function surtir()
	{
		global $adb;

		$oc_id = $this->obtener_id();

		$this->actualizar();

		$rm = new Recepciones_mercancia;
		$rm->column_fields["assigned_user_id"] = 1;
		//$rm->column_fields["folio"] = $this->column_fields["folio"];
		$rm->column_fields["sucursal"] = $this->column_fields["sucursal"];
		$rm->column_fields["referencia"] = $this->column_fields["referencia"];
		$rm->column_fields["proveedor"] = $this->column_fields["proveedor"];
		$rm->column_fields["tipo_recepcion"] = $this->column_fields["oc_tipo"];
		$rm->column_fields["subarrendado"] = $this->column_fields["subarrendado"];
		$rm->column_fields["dias_subarrendamiento"] = $this->column_fields["dias_subarrendamiento"];
		$rm->column_fields["factura_proveedor"] = $this->column_fields["factura_proveedor"];
		$rm->column_fields["remision_proveedor"] = $this->column_fields["remision_proveedor"];
		$rm->column_fields["fecha_efectiva"] = $this->column_fields["fecha_efectiva"];
		$rm->column_fields["hora"] = $this->column_fields["hora"];
		$rm->column_fields["observaciones"] = $this->column_fields["observaciones"];
		//$rm->column_fields["bloqueado"] = $this->column_fields["bloqueado"];
		//$rm->column_fields["codigos"] = $this->column_fields["codigos"];
		//$rm->column_fields["pedimento"] = $this->column_fields["pedimento"];
		//$rm->column_fields["aduana"] = $this->column_fields["aduana"];
		//$rm->column_fields["fecha_pedimento"] = $this->column_fields["fecha_pedimento"];
		$rm->column_fields["rm_estado"] = "Borrador";

		$rm->save("Recepciones_mercancia");
		$rm->asignar_folio("Recepciones_mercancia", "recepciones_mercancia", "M", "", "Borrador");

		$rm_id = $rm->obtener_id();

		// Genera los registros de detalle con lo que está pendiente
		// por surtir de esta orden de compra.

		$consulta = "select ocd.* from vtiger_ordenes_compra_det ocd, vtiger_crmentity e where e.crmid = ocd.ordenes_compra_detid and e.deleted = '0' and ocd.ordenes_compraid = '$oc_id'";
//var_dump($consulta);
		$resultado = $adb->query($consulta);
		//$renglon = $adb->fetch_array($resultado);
		while ($renglon = $adb->fetch_array($resultado))
		{
//echo "<pre>";
//var_dump($renglon);
//echo "</pre>";
//die;
			$ocd_id = $renglon["ordenes_compra_detid"];
			$ocd_pendiente = $renglon["pendiente"];

			if ($ocd_pendiente <= 0)
			{
				continue;
			}
/************************
	$ocd_folio = $renglon["folio"];
	$ocd_orden_compra = $renglon["orden_compra"];
	$ocd_producto = $renglon["producto"];
	$ocd_cantidad = $renglon["cantidad"];
	$ocd_surtido = $renglon["surtido"];
	$ocd_documentos = $renglon["documentos"];
	$ocd_proveedor = $renglon["proveedor"];
	$ocd_sucursal = $renglon["sucursal"];
	$ocd_precio = $renglon["precio"];
	$ocd_descuento = $renglon["descuento"];
	$ocd_precio_lista = $renglon["precio_lista"];
************************/
			$rmd = new Recepciones_mercancia_det;
			$rmd->column_fields["assigned_user_id"] = 1;
			//$rmd->column_fields["folio"] = $renglon["folio"];
			$rmd->column_fields["recepcion_mercancia"] = $rm_id;
			$rmd->column_fields["producto"] = $renglon["productid"];
			$rmd->column_fields["cantidad"] = $renglon["pendiente"];
			$rmd->column_fields["costo"] = $renglon["precio"];
			$rmd->column_fields["orden_compra"] = $oc_id;
			$rmd->column_fields["ocd"] = $ocd_id;
			$rmd->save("Recepciones_mercancia_det");
		}

		return $rm_id;
	}

	// Emite el documento.
	function emitir()
	{
		global $adb;

		$oc_id = $this->obtener_id();

		// Validaciones.
		if ($this->column_fields["oc_estado"] == "Emitido")
		{
			die ("<h1>ERROR</h1>La orden de compra ya fue emitida.");
		}

		if ($this->column_fields["oc_estado"] != "Borrador")
		{
			die ("<h1>ERROR</h1>La orden de compra sólo puede ser emitida si su estado es borrador.");
		}

		// Bloquea automáticamente el documento.
		$this->bloquear("ordenes_compra");

		$this->asignar_folio("Ordenes_compra", "ordenes_compra", "J");

		$consulta = "update vtiger_ordenes_compra oc set oc.oc_estado = 'Emitido' where oc.ordenes_compraid = '$oc_id'";
		$adb->query($consulta);
	}

	// Actualiza campos calculados, tanto en encabezado como en detalle.
	function actualizar()
	{
		global $adb;

		$oc_id = $this->obtener_id();

		$consulta = "update vtiger_ordenes_compra_det ocd, vtiger_crmentity e set ocd.pendiente = ocd.cantidad - ocd.surtido  where e.crmid = ocd.ordenes_compra_detid and e.deleted = '0' and ocd.ordenes_compraid = '$oc_id'";
//var_dump($consulta);
		$adb->query($consulta);
	}

	// Ejecuta una acción simple.
	function accion($accion)
	{
		switch($accion)
		{
			case "formato_html":
				return $this->formato_html();
			break;
			case "pdf":
				return $this->pdf();
			break;
			default:
				die ("<h1>ERROR</h1>No se especificó la acción a ejecutar.");
			break;
		}
	}

	// Genera formato visual html de la orden de compra.
	function formato_html()
	{
		global $adb;

		$oc_id = $this->obtener_id();
		$oc_folio = $this->column_fields["folio"];
		$oc_fecha = $this->column_fields["fecha_efectiva"];
		$oc_moneda = $this->column_fields["moneda"];
		$oc_referencia = $this->column_fields["referencia"];
		$oc_estado = $this->column_fields["oc_estado"];
		$letrero = ($oc_estado == "Borrador")?"En proceso de autorización":"";
		$elaboro = $this->column_fields["elaboro"];
		$autorizo = $this->column_fields["autorizo"];
		$suc_id = $this->column_fields["sucursal"];
		if ($suc_id != "")
		{
			$suc = new Sucursales;
			$suc->retrieve_entity_info($suc_id, "Sucursales");
			$suc_razon_social = str_replace("\n", "<br>", $suc->column_fields["razon_social"]);
			$suc_domicilio = str_replace("\n", "<br>", $suc->column_fields["domicilio"]);
		}
		$prov_id = $this->column_fields["proveedor"];
		if ($prov_id != "")
		{
			$prov = new Vendors;
			$prov->retrieve_entity_info($prov_id, "Vendors");
			$prov_nombre = str_replace("\n", "<br>", $prov->column_fields["vendorname"]);
		}
		$titulo = "Orden de compra";

		$encabezado_html = file_get_contents("aux/formatos/encabezado_html.php");
		//$prueba = file_get_contents("aux/formatos/prueba.php");
		//$encabezado = str_replace("proveedor", $datos_proveedor, file_get_contents("aux/formatos/encabezado.php"));
		$encabezado = file_get_contents("aux/formatos/encabezado.php");
		$encabezado = str_replace("##oc_folio##", $oc_folio, $encabezado);
		$encabezado = str_replace("##suc_razon_social##", $suc_razon_social, $encabezado);
		$encabezado = str_replace("##suc_domicilio##", $suc_domicilio, $encabezado);
		$encabezado = str_replace("##titulo##", $titulo, $encabezado);
		$encabezado = str_replace("##prov_nombre##", $prov_nombre, $encabezado);
		$encabezado = str_replace("##oc_fecha##", $oc_fecha, $encabezado);
		$encabezado = str_replace("##oc_moneda##", $oc_moneda, $encabezado);
		$encabezado = str_replace("##oc_referencia##", $oc_referencia, $encabezado);
		$encabezado = str_replace("##letrero##", $letrero, $encabezado);
		$encabezado = str_replace("##elaboro##", $elaboro, $encabezado);
		$encabezado = str_replace("##autorizo##", $autorizo, $encabezado);
		$estilo = file_get_contents("aux/formatos/estilo.php");
		$pie_html = file_get_contents("aux/formatos/pie_html.php");

		$parametros["surtido"]["ocultar"] = true;
		$parametros["pendiente"]["ocultar"] = true;
		$parametros["documentos"]["ocultar"] = true;

		$formato = $encabezado_html;
		//$formato .= $prueba;
		$formato .= $estilo;
		$formato .= $encabezado;
		$formato .= $this->tabla_detalles($parametros);
		$formato .= $pie_html;
//var_dump($formato);
//echo $formato;
//die;

		return $formato;
	}

	// Genera PDF.
	function pdf()
	{
		$oc_id = $this->obtener_id();

echo "<script language=\"javascript\">";
echo "document.location = 'pdf.php?record=$oc_id'";
echo "</script>";
	}
}
?>
