<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/
require_once('data/CRMEntity.php');
require_once('data/Tracker.php');
require_once('modules/Periodos/Periodos.php');
require_once('modules/Por_facturar/Por_facturar.php');
require_once('modules/Flota_renta/Flota_renta.php');
require_once('modules/Kardex/Kardex.php');
require_once('modules/Users/Users.php');
require_once('modules/Products/Products.php');
require_once('modules/Remisiones_det/Remisiones_det.php');
require_once("modules/Sucursales/Sucursales.php");

class Entregas extends CRMEntity {
	var $db, $log; // Used in class functions of CRMEntity

	var $table_name = 'vtiger_entregas';
	var $table_index= 'entregasid';
	var $column_fields = Array();

	/** Indicator if this is a custom module or standard module */
	var $IsCustomModule = true;

	/**
	 * Mandatory table for supporting custom fields.
	 */
	var $customFieldTable = Array('vtiger_entregascf', 'entregasid');

	/**
	 * Mandatory for Saving, Include tables related to this module.
	 */
	var $tab_name = Array('vtiger_crmentity', 'vtiger_entregas', 'vtiger_entregascf');

	/**
	 * Mandatory for Saving, Include tablename and tablekey columnname here.
	 */
	var $tab_name_index = Array(
		'vtiger_crmentity' => 'crmid',
		'vtiger_entregas'   => 'entregasid',
	    'vtiger_entregascf' => 'entregasid');

	/**
	 * Mandatory for Listing (Related listview)
	 */
	var $list_fields = Array (
		/* Format: Field Label => Array(tablename, columnname) */
		// tablename should not have prefix 'vtiger_'
		'Entregas Name'=> Array('entregas', 'idv'),
		'Assigned To' => Array('crmentity','smownerid')
	);
	var $list_fields_name = Array(
		/* Format: Field Label => fieldname */
		'Entregas Name'=> 'idv',
		'Assigned To' => 'assigned_user_id'
	);

	// Make the field link to detail view from list view (Fieldname)
	var $list_link_field = 'idv';

	// For Popup listview and UI type support
	var $search_fields = Array(
		/* Format: Field Label => Array(tablename, columnname) */
		// tablename should not have prefix 'vtiger_'
		'Entregas Name'=> Array('entregas', 'idv')
	);
	var $search_fields_name = Array(
		/* Format: Field Label => fieldname */
		'Entregas Name'=> 'idv'
	);

	// For Popup window record selection
	var $popup_fields = Array('idv');

	// Placeholder for sort fields - All the fields will be initialized for Sorting through initSortFields
	var $sortby_fields = Array();

	// For Alphabetical search
	var $def_basicsearch_col = 'idv';

	// Column value to use on detail view record text display
	var $def_detailview_recname = 'idv';

	// Required Information for enabling Import feature
	var $required_fields = Array('idv'=>1);

	// Callback function list during Importing
	var $special_functions = Array('set_import_assigned_user');

	var $default_order_by = 'idv';
	var $default_sort_order='ASC';
	// Used when enabling/disabling the mandatory fields for the module.
	// Refers to vtiger_field.fieldname values.
	var $mandatory_fields = Array('createdtime', 'modifiedtime', 'idv');
	
	function __construct() {
		global $log, $currentModule;
		$this->column_fields = getColumnFields($currentModule);
		$this->db = PearDatabase::getInstance();
		$this->log = $log;
	}

	function getSortOrder() {
		global $currentModule;

		$sortorder = $this->default_sort_order;
		if($_REQUEST['sorder']) $sortorder = $this->db->sql_escape_string($_REQUEST['sorder']);
		else if($_SESSION[$currentModule.'_Sort_Order']) 
			$sortorder = $_SESSION[$currentModule.'_Sort_Order'];

		return $sortorder;
	}

	function getOrderBy() {
		global $currentModule;
		
		$use_default_order_by = '';		
		if(PerformancePrefs::getBoolean('LISTVIEW_DEFAULT_SORTING', true)) {
			$use_default_order_by = $this->default_order_by;
		}
		
		$orderby = $use_default_order_by;
		if($_REQUEST['order_by']) $orderby = $this->db->sql_escape_string($_REQUEST['order_by']);
		else if($_SESSION[$currentModule.'_Order_By'])
			$orderby = $_SESSION[$currentModule.'_Order_By'];
		return $orderby;
	}

	function save_module($module) {
//vd($this->column_fields);
		// Si se está corriendo un apartado de folios no procesa.
		if ($this->column_fields["cliente"] == "" && $this->column_fields["obra"] == "" && $this->column_fields["rem_tipo"] == "")
		{
			return;
		}
//die ("m/E/E.save");

		$ent_id = $this->obtener_id();
//var_dump($ent_id);

		// Validar fecha efectiva.
		if (!$this->validar_fecha_efectiva($ent_id))
		{
			die("<h1>ERROR</h1>La fecha efectiva no puede ser menor a la última remisión de la obra. Consulte el detalle de remisiones de la obra y ajuste la fecha y hora.");
		}

		// Se recargan los campos.
		//$entr_id = $this->obtener_id();
		$entr_id = $ent_id;
		$this->retrieve_entity_info($entr_id, "Entregas");

		// Validaciones.
		if ($this->column_fields["cliente"] == "")
		{
			die("<h1>ERROR</h1>No se capturó el cliente.");
		}

		if ($this->column_fields["obra"] == "")
		{
			die("<h1>ERROR</h1>No se capturó la obra.");
		}

		if (!$this->validar_cliente_obra($this->column_fields["cliente"], $this->column_fields["obra"]))
		{
			die("<h1>ERROR</h1>El cliente y la obra no corresponden o alguno de ellos fue borrado.<br>(m/E/E.s)");
		}

		// Si es una remisión tipo equipo cliente hay que registrar el equipo.
		if ($this->column_fields["rem_tipo"] == "Equipo cliente")
		{
			$this->dirigir("registrar_equipo_cliente");
			die;
		}

		$this->asignar_dueno();
		//$this->column_fields["numeros_internos"] = $this->concatenar_numeros_internos();
		$this->concatenar_numeros_internos("Entregas");
	}

	/**
	 * Return query to use based on given modulename, fieldname
	 * Useful to handle specific case handling for Popup
	 */
	function getQueryByModuleField($module, $fieldname, $srcrecord, $query='') {
		// $srcrecord could be empty
	}

	/**
	 * Get list view query (send more WHERE clause condition if required)
	 */
	function getListQuery($module, $usewhere='') {
		$query = "SELECT vtiger_crmentity.*, $this->table_name.*";
		
		// Keep track of tables joined to avoid duplicates
		$joinedTables = array();

		// Select Custom Field Table Columns if present
		if(!empty($this->customFieldTable)) $query .= ", " . $this->customFieldTable[0] . ".* ";

		$query .= " FROM $this->table_name";

		$query .= "	INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index";

		$joinedTables[] = $this->table_name;
		$joinedTables[] = 'vtiger_crmentity';
		
		// Consider custom table join as well.
		if(!empty($this->customFieldTable)) {
			$query .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index";
			$joinedTables[] = $this->customFieldTable[0]; 
		}
		$query .= " LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid";
		$query .= " LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";

		$joinedTables[] = 'vtiger_users';
		$joinedTables[] = 'vtiger_groups';
		
		$linkedModulesQuery = $this->db->pquery("SELECT distinct fieldname, columnname, relmodule FROM vtiger_field" .
				" INNER JOIN vtiger_fieldmodulerel ON vtiger_fieldmodulerel.fieldid = vtiger_field.fieldid" .
				" WHERE uitype='10' AND vtiger_fieldmodulerel.module=?", array($module));
		$linkedFieldsCount = $this->db->num_rows($linkedModulesQuery);
		
		for($i=0; $i<$linkedFieldsCount; $i++) {
			$related_module = $this->db->query_result($linkedModulesQuery, $i, 'relmodule');
			$fieldname = $this->db->query_result($linkedModulesQuery, $i, 'fieldname');
			$columnname = $this->db->query_result($linkedModulesQuery, $i, 'columnname');
			
			$other =  CRMEntity::getInstance($related_module);
			vtlib_setup_modulevars($related_module, $other);
			
			if(!in_array($other->table_name, $joinedTables)) {
				$query .= " LEFT JOIN $other->table_name ON $other->table_name.$other->table_index = $this->table_name.$columnname";
				$joinedTables[] = $other->table_name;
			}
		}

		global $current_user;
		$query .= $this->getNonAdminAccessControlQuery($module,$current_user);
		$query .= "	WHERE vtiger_crmentity.deleted = 0 ".$usewhere;
		return $query;
	}

	/**
	 * Apply security restriction (sharing privilege) query part for List view.
	 */
	function getListViewSecurityParameter($module) {
		global $current_user;
		require('user_privileges/user_privileges_'.$current_user->id.'.php');
		require('user_privileges/sharing_privileges_'.$current_user->id.'.php');

		$sec_query = '';
		$tabid = getTabid($module);

		if($is_admin==false && $profileGlobalPermission[1] == 1 && $profileGlobalPermission[2] == 1 
			&& $defaultOrgSharingPermission[$tabid] == 3) {

				$sec_query .= " AND (vtiger_crmentity.smownerid in($current_user->id) OR vtiger_crmentity.smownerid IN 
					(
						SELECT vtiger_user2role.userid FROM vtiger_user2role 
						INNER JOIN vtiger_users ON vtiger_users.id=vtiger_user2role.userid 
						INNER JOIN vtiger_role ON vtiger_role.roleid=vtiger_user2role.roleid 
						WHERE vtiger_role.parentrole LIKE '".$current_user_parent_role_seq."::%'
					) 
					OR vtiger_crmentity.smownerid IN 
					(
						SELECT shareduserid FROM vtiger_tmp_read_user_sharing_per 
						WHERE userid=".$current_user->id." AND tabid=".$tabid."
					) 
					OR 
						(";
		
					// Build the query based on the group association of current user.
					if(sizeof($current_user_groups) > 0) {
						$sec_query .= " vtiger_groups.groupid IN (". implode(",", $current_user_groups) .") OR ";
					}
					$sec_query .= " vtiger_groups.groupid IN 
						(
							SELECT vtiger_tmp_read_group_sharing_per.sharedgroupid 
							FROM vtiger_tmp_read_group_sharing_per
							WHERE userid=".$current_user->id." and tabid=".$tabid."
						)";
				$sec_query .= ")
				)";
		}
		return $sec_query;
	}

	/**
	 * Create query to export the records.
	 */
	function create_export_query($where)
	{
		global $current_user;
		$thismodule = $_REQUEST['module'];
		
		include("include/utils/ExportUtils.php");

		//To get the Permitted fields query and the permitted fields list
		$sql = getPermittedFieldsQuery($thismodule, "detail_view");
		
		$fields_list = getFieldsListFromQuery($sql);

		$query = "SELECT $fields_list, vtiger_users.user_name AS user_name 
					FROM vtiger_crmentity INNER JOIN $this->table_name ON vtiger_crmentity.crmid=$this->table_name.$this->table_index";

		if(!empty($this->customFieldTable)) {
			$query .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index"; 
		}

		$query .= " LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";
		$query .= " LEFT JOIN vtiger_users ON vtiger_crmentity.smownerid = vtiger_users.id and vtiger_users.status='Active'";
		
		$linkedModulesQuery = $this->db->pquery("SELECT distinct fieldname, columnname, relmodule FROM vtiger_field" .
				" INNER JOIN vtiger_fieldmodulerel ON vtiger_fieldmodulerel.fieldid = vtiger_field.fieldid" .
				" WHERE uitype='10' AND vtiger_fieldmodulerel.module=?", array($thismodule));
		$linkedFieldsCount = $this->db->num_rows($linkedModulesQuery);

		for($i=0; $i<$linkedFieldsCount; $i++) {
			$related_module = $this->db->query_result($linkedModulesQuery, $i, 'relmodule');
			$fieldname = $this->db->query_result($linkedModulesQuery, $i, 'fieldname');
			$columnname = $this->db->query_result($linkedModulesQuery, $i, 'columnname');
			
			$other = CRMEntity::getInstance($related_module);
			vtlib_setup_modulevars($related_module, $other);
			
			$query .= " LEFT JOIN $other->table_name ON $other->table_name.$other->table_index = $this->table_name.$columnname";
		}

		$query .= $this->getNonAdminAccessControlQuery($thismodule,$current_user);
		$where_auto = " vtiger_crmentity.deleted=0";

		if($where != '') $query .= " WHERE ($where) AND $where_auto";
		else $query .= " WHERE $where_auto";

		return $query;
	}

	/**
	 * Initialize this instance for importing.
	 */
	function initImport($module) {
		$this->db = PearDatabase::getInstance();
		$this->initImportableFields($module);
	}

	/**
	 * Create list query to be shown at the last step of the import.
	 * Called From: modules/Import/UserLastImport.php
	 */
	function create_import_query($module) {
		global $current_user;
		$query = "SELECT vtiger_crmentity.crmid, case when (vtiger_users.user_name not like '') then vtiger_users.user_name else vtiger_groups.groupname end as user_name, $this->table_name.* FROM $this->table_name
			INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index
			LEFT JOIN vtiger_users_last_import ON vtiger_users_last_import.bean_id=vtiger_crmentity.crmid
			LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid
			LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid
			WHERE vtiger_users_last_import.assigned_user_id='$current_user->id'
			AND vtiger_users_last_import.bean_type='$module'
			AND vtiger_users_last_import.deleted=0";
		return $query;
	}

	/**
	 * Delete the last imported records.
	 */
	function undo_import($module, $user_id) {
		global $adb;
		$count = 0;
		$query1 = "select bean_id from vtiger_users_last_import where assigned_user_id=? AND bean_type='$module' AND deleted=0";
		$result1 = $adb->pquery($query1, array($user_id)) or die("Error getting last import for undo: ".mysql_error()); 
		while ( $row1 = $adb->fetchByAssoc($result1))
		{
			$query2 = "update vtiger_crmentity set deleted=1 where crmid=?";
			$result2 = $adb->pquery($query2, array($row1['bean_id'])) or die("Error undoing last import: ".mysql_error()); 
			$count++;			
		}
		return $count;
	}
	
	/**
	 * Transform the value while exporting
	 */
	function transform_export_value($key, $value) {
		return parent::transform_export_value($key, $value);
	}

	/**
	 * Function which will set the assigned user id for import record.
	 */
	function set_import_assigned_user()
	{
		global $current_user, $adb;
		$record_user = $this->column_fields["assigned_user_id"];
		
		if($record_user != $current_user->id){
			$sqlresult = $adb->pquery("select id from vtiger_users where id = ? union select groupid as id from vtiger_groups where groupid = ?", array($record_user, $record_user));
			if($this->db->num_rows($sqlresult)!= 1) {
				$this->column_fields["assigned_user_id"] = $current_user->id;
			} else {			
				$row = $adb->fetchByAssoc($sqlresult, -1, false);
				if (isset($row['id']) && $row['id'] != -1) {
					$this->column_fields["assigned_user_id"] = $row['id'];
				} else {
					$this->column_fields["assigned_user_id"] = $current_user->id;
				}
			}
		}
	}
	
	/** 
	 * Function which will give the basic query to find duplicates
	 */
	function getDuplicatesQuery($module,$table_cols,$field_values,$ui_type_arr,$select_cols='') {
		$select_clause = "SELECT ". $this->table_name .".".$this->table_index ." AS recordid, vtiger_users_last_import.deleted,".$table_cols;

		// Select Custom Field Table Columns if present
		if(isset($this->customFieldTable)) $query .= ", " . $this->customFieldTable[0] . ".* ";

		$from_clause = " FROM $this->table_name";

		$from_clause .= "	INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index";

		// Consider custom table join as well.
		if(isset($this->customFieldTable)) {
			$from_clause .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index"; 
		}
		$from_clause .= " LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid
						LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";
		
		$where_clause = "	WHERE vtiger_crmentity.deleted = 0";
		$where_clause .= $this->getListViewSecurityParameter($module);
					
		if (isset($select_cols) && trim($select_cols) != '') {
			$sub_query = "SELECT $select_cols FROM  $this->table_name AS t " .
				" INNER JOIN vtiger_crmentity AS crm ON crm.crmid = t.".$this->table_index;
			// Consider custom table join as well.
			if(isset($this->customFieldTable)) {
				$sub_query .= " LEFT JOIN ".$this->customFieldTable[0]." tcf ON tcf.".$this->customFieldTable[1]." = t.$this->table_index";
			}
			$sub_query .= " WHERE crm.deleted=0 GROUP BY $select_cols HAVING COUNT(*)>1";	
		} else {
			$sub_query = "SELECT $table_cols $from_clause $where_clause GROUP BY $table_cols HAVING COUNT(*)>1";
		}	
		
		
		$query = $select_clause . $from_clause .
					" LEFT JOIN vtiger_users_last_import ON vtiger_users_last_import.bean_id=" . $this->table_name .".".$this->table_index .
					" INNER JOIN (" . $sub_query . ") AS temp ON ".get_on_clause($field_values,$ui_type_arr,$module) .
					$where_clause .
					" ORDER BY $table_cols,". $this->table_name .".".$this->table_index ." ASC";
					
		return $query;		
	}

	/**
	 * Invoked when special actions are performed on the module.
	 * @param String Module name
	 * @param String Event Type (module.postinstall, module.disabled, module.enabled, module.preuninstall)
	 */
	function vtlib_handler($modulename, $event_type) {
		if($event_type == 'module.postinstall') {
			// TODO Handle post installation actions
		} else if($event_type == 'module.disabled') {
			// TODO Handle actions when this module is disabled.
		} else if($event_type == 'module.enabled') {
			// TODO Handle actions when this module is enabled.
		} else if($event_type == 'module.preuninstall') {
			// TODO Handle actions when this module is about to be deleted.
		} else if($event_type == 'module.preupdate') {
			// TODO Handle actions before this module is updated.
		} else if($event_type == 'module.postupdate') {
			// TODO Handle actions after this module is updated.
		}
	}

	/** 
	 * Handle saving related module information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	// function save_related_module($module, $crmid, $with_module, $with_crmid) { }
	
	/**
	 * Handle deleting related module information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function delete_related_module($module, $crmid, $with_module, $with_crmid) { }

	/**
	 * Handle getting related list information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function get_related_list($id, $cur_tab_id, $rel_tab_id, $actions=false) { }

	/**
	 * Handle getting dependents list information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function get_dependents_list($id, $cur_tab_id, $rel_tab_id, $actions=false) { }

	function procesar($parametros = array())
	{
		require("modules/Entregas/fns/procesar.php");
	}

/********************
	function procesar2()
	{
		// Si se está corriendo un apartado de folios no procesa.
		//return;

		global $adb;

		// Bloquea automáticamente el documento.
		$this->bloquear("entregas");

                $id_entrega = (int)$this->column_fields["record_id"];
                $folio_entrega = $this->column_fields["folio"];

		if ($this->obtener_frecuencia_facturacion() == "")
		{
			die("<h1>ERROR</h1>El cliente no tiene definida su frecuencia de facturación.");
		}

		if ($this->column_fields["sucursal"] == "")
		{
			die("<h1>ERROR</h1>No se capturó la sucursal.");
		}

		$sucursal = new Sucursales;
		$sucursal->retrieve_entity_info($this->column_fields["sucursal"], "Sucursales");

        	for ($i = 1; $i <= 10; $i++)
        	{
//echo "$i<br>";
                	// Obtiene el id del equipo.
                        $id_equipo = $this->column_fields["entrega{$i}_equipo"];
//var_dump($id_equipo);
			$cantidad_entrega = $this->column_fields["entrega{$i}_cantidad"];
			$observaciones = $this->column_fields["entrega{$i}_observaciones"];

                	if ($id_equipo)
                	{
                        	// Transfiere flota de disponible a obra.
                        	$flr = new Flota_renta;
                        	$flr->retrieve_entity_info($id_equipo, "Flota_renta");
				$flr->transferir($this->column_fields["sucursal"],"Disponible", "En obra", $this->column_fields["obra"], $cantidad_entrega, $folio_entrega);

//var_dump($id_equipo);
				// Cierra periodos.
				$fecha_cierre = new DateTime($this->column_fields["fecha_efectiva"]." - 1 day", new DateTimeZone("America/Mexico_City"));
				$flr->cerrar_periodos($this->column_fields["obra"], "acumulado", $folio_entrega, $fecha_cierre->format("Y-m-d"));
//var_dump("fin cerrar");

				// Abre periodos acumulados.
				$flr->abrir_periodos($this->column_fields["sucursal"], $this->column_fields["cliente"], $this->column_fields["obra"], $folio_entrega, $this->column_fields["fecha_efectiva"]);
//var_dump("fin abrir");

				// Genera por facturar.
				$this->facturar();

				// ----------- Ajustar adelantado ----------------

				$individual = $flr->individual();

				if ($individual)
				{
					$flr_id = $id_equipo;
				}
				else
				{
					$registros_flr = $flr->registros_flota($this->column_fields["obra"]);
					$flr_id = $registros_flr["En obra"];
				}

				// Obtiene el periodo recién cerrado (correspondiente al efecto de recoger).
				$consulta = "select per.periodosid from vtiger_periodos per, vtiger_crmentity e where e.crmid = per.periodosid and e.deleted = '0' and per.movimiento_cierre = '$folio_entrega' and per.flota_rentaid = '$flr_id'";
				$resultado = $adb->query($consulta);
//var_dump($consulta);
				$renglon = $adb->fetch_array($resultado);
//var_dump($renglon);
				if ($renglon["periodosid"] != "")
				{
					$per1 = new Periodos;
					$per1->retrieve_entity_info($renglon["periodosid"], "Periodos");

					// Trata de obtener el nuevo periodo abierto (correspondiente al efecto de entregar).
					$consulta = "select per.periodosid from vtiger_periodos per, vtiger_crmentity e where e.crmid = per.periodosid and e.deleted = '0' and per.movimiento_apertura = '$folio_entrega' and per.flota_rentaid = '$flr_id'";
					$resultado = $adb->query($consulta);
//var_dump($consulta);
					$renglon = $adb->fetch_array($resultado);
//var_dump($renglon);
					$per2 = new Periodos;
					$per2_id = $renglon["periodosid"];

					$per1->ajustar_adelantado($per2_id);
				}
				// ----------- Ajustar adelantado ----------------

//var_dump("entrega");
//die;


				// Registra en kardex y existencias.
				unset($parametros);
				$parametros["sucursal"] = $this->column_fields["sucursal"];
				$parametros["almacen"] = $sucursal->column_fields["almacen_flota"];
                                $parametros["tipo_documento"] = "Entrega";
				$parametros["folio"] = $this->column_fields["folio"];
				$parametros["fecha"] = $this->column_fields["fecha_efectiva"];
				$parametros["producto"] = $flr->column_fields["producto"];
                        	$parametros["codigo_articulo"] = $flr->column_fields["numero_interno"];
				$parametros["entradas"] = 0;
				$parametros["salidas"] = 0;
				$this->kardex($parametros);
//die;
			}
		}

		// Genera afectación (tabla 3) y actualiza horómetros.
		$this->afectacion(true);

		// Genera por facturar de flete si así corresponde.
		if (($this->column_fields["flete"] == "1") || ($this->column_fields["flete"] == "on"))
		{
			$this->facturar_servicio("flete", true, "", $this->column_fields["precio_flete"]);
		}
	}
***************/

/*******************
	function procesar()
	{
		$this->procesar2();
		return;

                // La sesión se abre no aquí sino en el programa que manda llamar esta función. De esto depende poder cargar el usuario actual.

                global $current_user, $adb;

                // Carga definiciones de campos personalizados.

                $id_entrega = (int)$this->column_fields["record_id"];
                $folio_entrega = $this->column_fields["folio"];

		// Obtiene la sucursal.
		$sucursal = new Sucursales;
		$sucursal->retrieve_entity_info($this->column_fields["sucursal"], "Sucursales");

		for ($i = 1; $i <= 10; $i++)
		{
			$id_equipo = $this->column_fields["entrega{$i}_equipo"];
			$cantidad_entrega = $this->column_fields["entrega{$i}_cantidad"];

                        if ($id_equipo)
                        {
                                // Actualiza el registro de flota de renta correspondiente.
                                $flota_renta = new Flota_renta;
                                $flota_renta->retrieve_entity_info($id_equipo, "Flota_renta");

				$producto = new Products;
				$producto->retrieve_entity_info($flota_renta->column_fields["producto"], "Products");
				$individual = $producto->individual();

				if ($individual)
				{
                                	$flota_renta->column_fields["estado"] = "En obra";
                                	$flota_renta->column_fields["cliente"] = $this->column_fields["cliente"];
                                	$flota_renta->column_fields["obra"] = $this->column_fields["obra"];
                                	$flota_renta->save("Flota_renta", $id_equipo);
				}
				else
				{
					// Crea o actualiza, según sea el caso, el registro de detalle de flota.
					$flota_renta->detalle($folio_entrega, $cantidad_entrega * -1);
		
					// Actualiza la cantidad del registro de flota.
					$flota_renta->actualizar_cantidad();

					// Busca un posible registro existente de flota en esta obra.
					$consulta = "select flr.flota_rentaid, flr.numeros_serieid from vtiger_flota_renta flr, vtiger_crmentity e where e.crmid = flr.flota_rentaid and e.deleted = '0' and flr.estado = 'En obra' and flr.obrasid = '".$this->column_fields["obra"]."' and flr.numero_interno = '".$flota_renta->column_fields["numero_interno"]."'";
                                	$resultado = $adb->query($consulta);
                                	$renglon = $adb->fetch_array($resultado);

					$id_flr_obra = $renglon["flota_rentaid"];
//var_dump($id_flr_obra);
//die;

                                	$flota_renta_obra = new Flota_renta;
					if ($id_flr_obra != "")
					{
                                		$flota_renta_obra->retrieve_entity_info($id_flr_obra, "Flota_renta");
					}
                                	$flota_renta_obra->column_fields["assigned_user_id"] = $current_user->id;
                                	$flota_renta_obra->column_fields["estado"] = "En obra";
                                	$flota_renta_obra->column_fields["cliente"] = $this->column_fields["cliente"];
                                	$flota_renta_obra->column_fields["obra"] = $this->column_fields["obra"];
                                	$flota_renta_obra->column_fields["numero_interno"] = $flota_renta->column_fields["numero_interno"];
                                	$flota_renta_obra->column_fields["producto"] = $flota_renta->column_fields["producto"];
                                	$flota_renta_obra->save("Flota_renta", $id_flr_obra);
//var_dump($renglon);
//var_dump($consulta);
					// Crea o actualiza, según sea el caso, el registro de detalle de flota.
					$flota_renta_obra->detalle($folio_entrega, $cantidad_entrega);
		
					// Actualiza la cantidad del registro de flota.
					$flota_renta_obra->actualizar_cantidad();
				}
//die;

                                // Crea o actualiza, según sea el caso, el periodo de renta correspondiente.
				$id_flr = ($individual)?$id_equipo:$flota_renta_obra->obtener_id();
				//$consulta = "select per.* from vtiger_periodos per, vtiger_crmentity e where e.crmid = per.periodosid and e.deleted = '0' and per.flota_rentaid = '$id_equipo'";
				//$consulta = "select per.* from vtiger_periodos per, vtiger_crmentity e where e.crmid = per.periodosid and e.deleted = '0' and per.flota_rentaid = '$id_flr'";
				$consulta = "select per.* from vtiger_periodos per, vtiger_crmentity e where e.crmid = per.periodosid and e.deleted = '0' and per.flota_rentaid = '$id_flr' and per.movimiento_apertura = '".$this->column_fields["folio"]."'";
//die ($consulta);
                                $resultado = $adb->query($consulta);
                                $renglon = $adb->fetch_array($resultado);
                                $id_periodo = $renglon["periodosid"];

                                $periodo = new Periodos;
                                if ($id_periodo != "")
                                {
                                        $periodo->retrieve_entity_info($id_periodo, "Periodos");
                                }
                                $periodo->column_fields["estado"] = "Abierto";
                                $periodo->column_fields["assigned_user_id"] = $current_user->id;
                                $periodo->column_fields["sucursal"] = $this->column_fields["sucursal"];
                                $periodo->column_fields["cliente"] = $this->column_fields["cliente"];
                                $periodo->column_fields["obra"] = $this->column_fields["obra"];
                                //$periodo->column_fields["equipo"] = $id_equipo;
                                $periodo->column_fields["equipo"] = $id_flr;
                                $periodo->column_fields["cantidad"] = $cantidad_entrega;
                                $periodo->column_fields["fecha_ini"] = $this->column_fields["fecha_efectiva"];
                                $periodo->column_fields["movimiento_apertura"] = $this->column_fields["folio"];
                                $periodo->save("Periodos", $id_periodo);

				// En caso de que se cobre flete se crea o actualiza el registro por_facturar correspondiente.
				if ($this->column_fields["flete"])
				{
					$consulta = "select pfa.* from vtiger_por_facturar pfa, vtiger_crmentity e where e.crmid = pfa.por_facturarid and e.deleted = '0' and pfa.concepto = 'Flete' and pfa.movimiento = '$folio_entrega'";
                                	$resultado = $adb->query($consulta);
                                	$renglon = $adb->fetch_array($resultado);
                                	$id_por_facturar = $renglon["por_facturarid"];

                                	$pfa = new Por_facturar;
                                	if ($id_por_facturar != "")
                                	{
                                        	$pfa->retrieve_entity_info($id_por_facturar, "Por_facturar");
                                	}
                                	$pfa->column_fields["assigned_user_id"] = $current_user->id;
                                	$pfa->column_fields["sucursal"] = $this->column_fields["sucursal"];
                                	$pfa->column_fields["cliente"] = $this->column_fields["cliente"];
                                	$pfa->column_fields["obra"] = $this->column_fields["obra"];
                                	//$pfa->column_fields["equipo"] = $id_equipo;
                                	$pfa->column_fields["equipo"] = $id_flr;
                                	$pfa->column_fields["concepto"] = "Flete";
                                	$pfa->column_fields["movimiento"] = $this->column_fields["folio"];
                                	$pfa->column_fields["estado"] = "Pendiente";
                                	$pfa->save("Por_facturar", $id_por_facturar);
				}
				else
				{
					// Si no se cobra se elimina cualquier posible registro existente.
					$consulta = "update vtiger_por_facturar pfa, vtiger_crmentity e set e.deleted = '1' where e.crmid = pfa.por_facturarid and e.deleted = '0' and pfa.concepto = 'Flete' and pfa.movimiento = '$folio_entrega'";
					$adb->query($consulta);
				}

                                // En caso de que se cobre reparación se crea o actualiza el registro por_facturar correspondiente.
                                if ($this->column_fields["reparacion"])
                                {
                                        $consulta = "select pfa.* from vtiger_por_facturar pfa, vtiger_crmentity e where e.crmid = pfa.por_facturarid and e.deleted = '0' and pfa.concepto like 'Reparaci%n' and pfa.movimiento = '$folio_entrega'";
                                        $resultado = $adb->query($consulta);
                                        $renglon = $adb->fetch_array($resultado);
                                        $id_por_facturar = $renglon["por_facturarid"];

                                        $pfa = new Por_facturar;
                                        if ($id_por_facturar != "")
                                        {
                                                $pfa->retrieve_entity_info($id_por_facturar, "Por_facturar");
                                        }
                                        $pfa->column_fields["assigned_user_id"] = $current_user->id;
                                        $pfa->column_fields["sucursal"] = $this->column_fields["sucursal"];
                                        $pfa->column_fields["cliente"] = $this->column_fields["cliente"];
                                        $pfa->column_fields["obra"] = $this->column_fields["obra"];
                                        //$pfa->column_fields["equipo"] = $id_equipo;
                                        $pfa->column_fields["equipo"] = $id_flr;
                                        $pfa->column_fields["concepto"] = "Reparación";
                                        $pfa->column_fields["movimiento"] = $this->column_fields["folio"];
                                	$pfa->column_fields["estado"] = "Pendiente";
                                        $pfa->save("Por_facturar", $id_por_facturar);
                                }
                                else
                                {
                                        // Si no se cobra se elimina cualquier posible registro existente.
                                        $consulta = "update vtiger_por_facturar pfa, vtiger_crmentity e set e.deleted = '1' where e.crmid = pfa.por_facturarid and e.deleted = '0' and pfa.concepto like 'Reparaci%n' and pfa.movimiento = '$folio_entrega'";
                                        $adb->query($consulta);
                                }

#*************************************
                                // Crea o actualiza, según sea el caso, el registro de kardex (tanto entradas como salidas quedan en cero pero sirve para ver el historial de movimientos).

                                // Revisa si ya existe el registro.
                                $consulta = "select kdx.* from vtiger_kardex kdx, vtiger_crmentity e where kdx.movimiento = '$folio_entrega' and e.crmid = kdx.kardexid and e.deleted = '0'";
                                $resultado = $adb->query($consulta);
                                $renglon = $adb->fetch_array($resultado);
                                $id_kardex = $renglon["kardexid"];

                                $kardex = new Kardex;
                                if ($id_kardex != "")
                                {
                                        $kardex->retrieve_entity_info($id_kardex, "Kardex");
                                }

                        	$kardex->column_fields["assigned_user_id"] = $current_user->id;
                        	$kardex->column_fields["codigo"] = $flota_renta->column_fields["numero_interno"];
                        	$kardex->column_fields["numero_serie"] = $flota_renta->column_fields["numero_serie"];
                        	$kardex->column_fields["fecha"] = $this->column_fields["fecha_efectiva"];
                        	$kardex->column_fields["tipo_documento"] = "Entrega";
                        	$kardex->column_fields["movimiento"] = $this->column_fields["folio"];
                        	$kardex->column_fields["existencia_inicial"] = 1;
                        	$kardex->column_fields["entradas"] = 0;
                        	$kardex->column_fields["salidas"] = 0;
                        	$kardex->column_fields["existencia_final"] = 1;
                                $kardex->save("Kardex", $id_kardex);
*************************************#
				// Registra en kardex y existencias.
				unset($parametros);
				$parametros["sucursal"] = $this->column_fields["sucursal"];
				$parametros["almacen"] = $sucursal->column_fields["almacen_flota"];
                        	$parametros["tipo_documento"] = "Entrega";
				$parametros["folio"] = $this->column_fields["folio"];
				$parametros["fecha"] = $this->column_fields["fecha_efectiva"];
				$parametros["producto"] = $flota_renta->column_fields["producto"];
                        	$parametros["codigo_articulo"] = $flota_renta->column_fields["numero_interno"];
				$parametros["entradas"] = 0;
				$parametros["salidas"] = 0;
				$this->kardex($parametros);
                        }
		}
	}
***************/

	function registrar_detalles($captura)
	{
		// Limpia detalles de cualquier captura previa.
		$this->limpiar_detalles();

		$suc_id = $this->column_fields["sucursal"];

		if ($suc_id == "")
		{
			die("<h1>ERROR</h1>No se capturó la sucursal.");
		}

		$suc = new Sucursales;
		$suc->retrieve_entity_info($suc_id, "Sucursales");

		//var_dump($captura);
		$iteraciones = 10;

		$rem_id = $this->obtener_id();

		for ($i = 1; $i <= $iteraciones; $i++)
		{
			// Sólo registra si hay información.
			if ($captura[$i]["existencia"] == "")
			{
				continue;
			}

			// Registra detalle a nivel producto.

			$tipo_operacion = "Venta";
			$nivel = "Producto";
			$producto = $captura[$i]["producto"];
			$cantidad = $captura[$i]["cantidad"];
			$exi = new Existencias;
			$exi->retrieve_entity_info($captura[$i]["existencia"], "Existencias");

			$remd = new Remisiones_det;
			$remd->column_fields["assigned_user_id"] = 1;
			$remd->column_fields["entrega"] = $rem_id;
			$remd->column_fields["remd_tipo_operacion"] = $tipo_operacion;
			$remd->column_fields["remd_nivel"] = $nivel;
			$remd->column_fields["producto"] = $producto;
			$remd->column_fields["cantidad"] = $cantidad;
			$remd->save("Remisiones_det");

			// Hace un barrido de los números de serie capturados.
			foreach ($captura[$i]["ns"] as $consecutivo => $ns_id)
			{
				// Registra detalle a nivel individual.

				$nivel = "Individual";
				$cantidad = 1;
				$ns = new Numeros_serie;
				$ns->retrieve_entity_info($ns_id, "Numeros_serie");
				$num_int = $ns->obtener_flr();
				if ($num_int != "")
				{
					$flr = new Flota_renta;
					$flr->retrieve_entity_info($num_int, "Flota_renta");
				}

				$remd = new Remisiones_det;
				$remd->column_fields["assigned_user_id"] = 1;
				$remd->column_fields["entrega"] = $rem_id;
				$remd->column_fields["remd_tipo_operacion"] = $tipo_operacion;
				$remd->column_fields["remd_nivel"] = $nivel;
				$remd->column_fields["producto"] = $producto;
				$remd->column_fields["cantidad"] = $cantidad;
				$remd->column_fields["numero_interno"] = $num_int;
				$remd->column_fields["numero_serie"] = $ns_id;
				$remd->save("Remisiones_det");

				$arreglo_ns[$i][$ns_id] = "on";
				// Afecta número de serie y flota de renta.
				//$ns->estado($estado);
				//$flr->estado($estado);
			}

/***************************************************
			switch ($exi->column_fields["almacen"])
			{
				case 129:
					$codigo_concepto = "Venta nuevo";
					$concepto = "Venta nuevo";
				break;
				case 132:
					$codigo_concepto = "Venta refacciones";
					$concepto = "Venta refacciones";
				break;
				case 65422:
					$codigo_concepto = "Venta usado";
					$concepto = "Venta usado";
				break;
			}
*******************************************************/
			if ($exi->column_fields["almacen"] == $suc->column_fields["almacen_nuevo"])
			{
				$codigo_concepto = "Venta nuevo";
				$concepto = "Venta nuevo";
			}

			if ($exi->column_fields["almacen"] == $suc->column_fields["almacen_refacciones"])
			{
				$codigo_concepto = "Venta refacciones";
				$concepto = "Venta refacciones";
			}

			if ($exi->column_fields["almacen"] == $suc->column_fields["almacen_usado"])
			{
				$codigo_concepto = "Venta usado";
				$concepto = "Venta usado";
			}

/**********************************************************
var_dump($suc->column_fields);
var_dump($exi->column_fields["almacen"]);
var_dump($codigo_concepto);
var_dump($concepto);
die;
*********************************************************/

			// Genera por facturar.
			$parametros["codigo_concepto"] = $codigo_concepto;
			$parametros["concepto"] = $concepto;
			$parametros["cantidad"] = $captura[$i]["cantidad"];
			$parametros["prod_id"] = $captura[$i]["producto"];
			$parametros["ns"] = $arreglo_ns[$i];
			$this->facturar_concepto($parametros);
		}
		//die ("Registrando...");
	}

	// Limpia detalle de cualquier captura previa.
	function limpiar_detalles()
	{
		global $adb;

		$consulta = "update vtiger_remisiones_det remd, vtiger_crmentity e set e.deleted = '1' where e.crmid = remd.remisiones_detid and remd.entregasid = '".$this->obtener_id()."'";
		$adb->query($consulta);
	}

	// Genera tabla de detalles.
	function tabla_detalles()
	{
		global $adb;

		//$tabla = "<table style=\"width:90%;border-collapse:collapse;\">";
		$tabla = "<table>";

		// Encabezado.
		$tabla .= "<tr>";
		//$tabla .= "<th colspan=\"2\" class=\"dvInnerHeader\">";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Cantidad";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Número interno";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Descripción";
		$tabla .= "</th>";
		//$tabla .= "</tr>";
		//$tabla .= "<tr>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Número de serie";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Horómetro";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Combustible";
		$tabla .= "</th>";
		$tabla .= "</tr>";

		// Barrido a nivel producto.
		//$consulta = "select remd.*, prod.productname from vtiger_remisiones_det remd, vtiger_crmentity e, vtiger_products prod where e.crmid = remd.remisiones_detid and e.deleted = '0' and remd.entregasid = '".$this->obtener_id()."' and prod.productid = remd.productid and remd.remd_nivel = 'Producto'";
		$consulta = "select remd.*, prod.productname, flr.numero_interno as num_int, flr.flota_rentaid from vtiger_remisiones_det remd inner join vtiger_crmentity e on e.crmid = remd.remisiones_detid inner join vtiger_products prod on prod.productid = remd.productid left join vtiger_flota_renta flr on flr.flota_rentaid = remd.flota_rentaid where e.deleted = '0' and remd.entregasid = '".$this->obtener_id()."' and remd.remd_nivel = 'Producto'";
//var_dump($consulta);
		$resultado = $adb->query($consulta);
		while ($renglon = $adb->fetch_array($resultado))
		{
			$prod = new Products;
			$prod->retrieve_entity_info($renglon["productid"], "Products");
			$individual = $prod->individual();
			$flr_id = $renglon["flota_rentaid"];

			// Si es un producto de tipo individual muestra la información a ese nivel e ignora la información a nivel producto.

			if (!$individual)
			{
				$color = ($contador_color % 2)?"#eee":"#fed";

				$tabla .= "<tr>";
				//$tabla .= "<td colspan=\"2\" style=\"padding-top:10px;\">";
				$tabla .= "<td style=\"background:$color;text-align:right;padding:0px 8px;\">";
				$tabla .= $renglon["cantidad"];
				$tabla .= "</td>";
				if ($renglon["num_int"] == "")
				{
					$tabla .= "<td style=\"background:$color;\">";
					$tabla .= "</td>";
				}
				else
				{
					$tabla .= "<td style=\"background:$color;padding:0px 8px;\">";
					$tabla .= "<a href=\"index.php?module=Flota_renta&action=DetailView&record=$flr_id\">";
					$tabla .= $renglon["num_int"];
					$tabla .= "</a>";
					$tabla .= "</td>";
				}
				$tabla .= "<td style=\"background:$color;padding:0px 8px;\">";
				$tabla .= $renglon["productname"];
				$tabla .= "</td>";
				$tabla .= "<td style=\"background:$color;\">";
				$tabla .= "</td>";
				$tabla .= "<td style=\"background:$color;\">";
				$tabla .= "</td>";
				$tabla .= "<td style=\"background:$color;\">";
				$tabla .= "</td>";
				$tabla .= "</tr>";

				$contador_color++;
			}

			// Barrido a nivel individual.
			//$consulta2 = "select remd.*, ns.numero_serie as num_serie, flr.numero_interno as num_int from vtiger_remisiones_det remd, vtiger_crmentity e, vtiger_numeros_serie ns, vtiger_flota_renta flr where e.crmid = remd.remisiones_detid and e.deleted = '0' and remd.entregasid = '".$renglon["entregasid"]."' and remd.productid = '".$renglon["productid"]."' and remd.remd_nivel = 'Individual' and ns.numeros_serieid = remd.numeros_serieid and flr.flota_rentaid = remd.flota_rentaid";
			//$consulta2 = "select remd.*, ns.numero_serie as num_serie, ns.numero_interno from vtiger_remisiones_det remd, vtiger_crmentity e, vtiger_numeros_serie ns where e.crmid = remd.remisiones_detid and e.deleted = '0' and remd.entregasid = '".$renglon["entregasid"]."' and remd.productid = '".$renglon["productid"]."' and remd.remd_nivel = 'Individual' and ns.numeros_serieid = remd.numeros_serieid";
			$consulta2 = "select flr.numero_interno, ns.numero_serie, remd.* from vtiger_remisiones_det remd inner join vtiger_crmentity e on e.crmid = remd.remisiones_detid left join vtiger_flota_renta flr on flr.flota_rentaid = remd.flota_rentaid left join vtiger_numeros_serie ns on ns.numeros_serieid = remd.numeros_serieid  where e.deleted = '0' and remd.entregasid = '".$renglon["entregasid"]."' and remd.productid = '".$renglon["productid"]."' and remd.remd_nivel = 'Individual'";
//var_dump($consulta2);
			$resultado2 = $adb->query($consulta2);
			while ($renglon2 = $adb->fetch_array($resultado2))
			{
				$color = ($contador_color % 2)?"#eee":"#fed";
				$flr_id = $renglon2["flota_rentaid"];
				$ns_id = $renglon2["numeros_serieid"];

				$tabla .= "<tr>";
				//$tabla .= "<td class=\"dvtCellInfo\">";
				$tabla .= "<td style=\"background:$color;text-align:right;padding:0px 8px;\">";
				$tabla .= $renglon2["cantidad"];
				$tabla .= "</td>";
				$tabla .= "<td style=\"background:$color;padding:0px 8px;\">";
				$tabla .= "<a href=\"index.php?module=Flota_renta&action=DetailView&record=$flr_id\">";
				$tabla .= $renglon2["numero_interno"];
				$tabla .= "</a>";
				$tabla .= "</td>";
				$tabla .= "<td style=\"background:$color;padding:0px 8px;\">";
				$tabla .= $renglon["productname"];
				$tabla .= "</td>";
				$tabla .= "<td style=\"background:$color;padding:0px 8px;\">";
				//$tabla .= $renglon2["num_serie"];
				$tabla .= $renglon2["numero_serie"];
				$tabla .= "</td>";
				$tabla .= "<td style=\"background:$color;text-align:right;padding:0px 8px;\">";
				$tabla .= $renglon2["horometro"];
				$tabla .= "</td>";
				$tabla .= "<td style=\"background:$color;text-align:right;padding:0px 8px;\">";
				$tabla .= $renglon2["combustible"];
				$tabla .= "</td>";
				$tabla .= "</tr>";

				$contador_color++;
			}
		}

		$tabla .= "</table>";

		return $tabla;
	}

	// Graba detalle de renta a partir de la información recabada con la "pregunta".
	function registrar_detalles_renta($captura)
	{
		global $adb;

		// Limpia detalles de cualquier captura previa.
		$this->limpiar_detalles();

		$rem_id = $this->obtener_id();
/********************
		echo "<pre>";
		var_dump($captura);
		echo "</pre>";
*******************/
		$iteraciones = 10;

		for ($i = 1; $i <= $iteraciones; $i++)
		{
			// Graba en la estructura antigua.
			$consulta = "update vtiger_entregas set entrega{$i}_equipo = '".$captura[$i]["flr_id"]."', entrega{$i}_horometro = '".$captura[$i]["horometro"]."', entrega{$i}_combustible = '".$captura[$i]["combustible"]."', entrega{$i}_cantidad = '".$captura[$i]["cantidad"]."' where entregasid = '".$this->obtener_id()."'";
			$adb->query($consulta);

			// Graba en la estructura nueva.

			// Sólo registra si hay información.
			if ($captura[$i]["flr_id"] == "")
			{
				continue;
			}

			$flr_id = $captura[$i]["flr_id"];

			// Registra detalle a nivel producto.

			//$exi = new Existencias;
			//$exi->retrieve_entity_info($captura[$i]["existencia"], "Existencias");
			$flr = new Flota_renta;
			//$flr->retrieve_entity_info($captura[$i]["flr_id"], "Flota_renta");
			$flr->retrieve_entity_info($flr_id, "Flota_renta");
			$tipo_operacion = "Renta";
			$nivel = "Producto";
			$producto = $flr->column_fields["producto"];
			$individual = $flr->individual();
			$cantidades[$producto] += $captura[$i]["cantidad"];

			$remd = new Remisiones_det;
			if ($remd_ids[$producto] != "")
			{
				$remd->retrieve_entity_info($remd_ids[$producto], "Remisiones_det");
			}
			$remd->column_fields["assigned_user_id"] = 1;
			$remd->column_fields["entrega"] = $rem_id;
			$remd->column_fields["remd_tipo_operacion"] = $tipo_operacion;
			$remd->column_fields["remd_nivel"] = $nivel;
			$remd->column_fields["producto"] = $producto;
			$remd->column_fields["cantidad"] = $cantidades[$producto];
			if (!$individual)
			{
				$remd->column_fields["numero_interno"] = $flr_id;
			}
			$remd->save("Remisiones_det", $remd_ids[$producto]);
			$remd_ids[$producto] = $remd->obtener_id();

			// Registra detalle a nivel individual en caso de artículo individual.
			//if ($flr->individual())
			if ($individual)
			{
				$nivel = "Individual";
				$cantidad = 1;

				$remd = new Remisiones_det;
				$remd->column_fields["assigned_user_id"] = 1;
				$remd->column_fields["entrega"] = $rem_id;
				$remd->column_fields["remd_tipo_operacion"] = $tipo_operacion;
				$remd->column_fields["remd_nivel"] = $nivel;
				$remd->column_fields["producto"] = $producto;
				$remd->column_fields["cantidad"] = $cantidad;
				$remd->column_fields["numero_interno"] = $flr_id;
				$remd->column_fields["numero_serie"] = $flr->column_fields["numero_serie"];
				$remd->column_fields["horometro"] = $captura[$i]["horometro"];
				$remd->column_fields["combustible"] = $captura[$i]["combustible"];
				$remd->save("Remisiones_det");
			}
		}
/*******************
		echo "<pre>";
		var_dump($this->column_fields);
		echo "</pre>";
*******************/
	}

	// Genera la estructura correspondiente usando Remisiones_det a partir de la estructura antigua. 
	function migrar_remd() 
	{ 
		global $adb; 

		$ent_id = $this->obtener_id(); 

		// Genera la variable de captura.

		$iteraciones = 10;
		for ($i = 1; $i <= $iteraciones; $i++)
		{
			$captura[$i]["flr_id"] = $this->column_fields["entrega{$i}_equipo"];
			$captura[$i]["horometro"] = $this->column_fields["entrega{$i}_horometro"];
			$captura[$i]["combustible"] = $this->column_fields["entrega{$i}_combustible"];
			$captura[$i]["cantidad"] = $this->column_fields["entrega{$i}_cantidad"];
		}

		// Registra la captura en estructura de Remisiones_det.
		$this->registrar_detalles_renta($captura);
		$this->retrieve_entity_info($ent_id, "Entregas");
		$this->concatenar_numeros_internos("Entregas");
	}

	// Genera la afectación de esta remisión (tabla 3).
	function afectacion($sobrescribir_horometros = false)
	{
		global $adb;

		$ent_id = $this->obtener_id();
//var_dump($this->column_fields["folio"]);
//die;
		$ent_folio = $this->column_fields["folio"];
		$ent_turno = $this->column_fields["ent_turno"];

		// Limpia posibles registros existentes.
		$consulta = "update vtiger_afectacion afe, vtiger_crmentity e set e.deleted = '1' where e.crmid = afe.afectacionid and e.deleted = '0' and afe.documento = '$ent_folio'";
		$adb->query($consulta);
//die;

		// Entregas.
		$consulta = "select flr.numero_interno, remd.*, ent.* from vtiger_entregas ent, vtiger_crmentity e, vtiger_remisiones_det remd, vtiger_flota_renta flr where e.crmid = remd.remisiones_detid  and e.deleted = '0' and ent.entregasid = '$ent_id' and ent.entregasid = remd.entregasid and flr.flota_rentaid = remd.flota_rentaid";
//var_dump($consulta);
//die;
		$resultado = $adb->query($consulta);
//$renglon = $adb->fetch_array($resultado);
		while ($renglon = $adb->fetch_array($resultado))
		{
	//echo "<pre>";
	//var_dump($renglon);
	//echo "</pre>";
//die;
			$remd_id = $renglon["remisiones_detid"];
			$flr_id = $renglon["flota_rentaid"];
			$remd_entrega = $renglon["entregasid"];
			$remd_cambio = $renglon["cambiosid"];
			$remd_recoleccion = $renglon["recoleccionesid"];
			$remd_horometro = $renglon["horometro"];
			$remd_combustible = $renglon["combustible"];
			$modulo = "Entregas";
			$crmid = $remd_entrega;
			$remd_cantidad = $renglon["cantidad"];
/************************
			$remd_folio = $renglon["folio"];
			$remd_remision = $renglon["remision"];
			$remd_remd_tipo_operacion = $renglon["remd_tipo_operacion"];
			$remd_producto = $renglon["producto"];
			$remd_numero_interno = $renglon["numero_interno"];
			$remd_numero_serie = $renglon["numero_serie"];
			$remd_observaciones = $renglon["observaciones"];
			$remd_reparacion = $renglon["reparacion"];
************************/

			$afe = new Afectacion;
			$afe->column_fields["assigned_user_id"] = 1;
			$afe->column_fields["modulo"] = $modulo;
			$afe->column_fields["crmid"] = $crmid;
			$afe->column_fields["horometro"] = $remd_horometro;
			$afe->column_fields["combustible"] = $remd_combustible;
			$afe->column_fields["documento"] = $renglon["folio"];
			$afe->column_fields["sucursal"] = $renglon["sucursalesid"];
			$afe->column_fields["cliente"] = $renglon["accountid"];
			$afe->column_fields["obra"] = $this->column_fields["obra"];
			$afe->column_fields["producto"] = $renglon["productid"];
			$afe->column_fields["fecha_efectiva"] = $renglon["fecha_efectiva"];
			$afe->column_fields["hora_efectiva"] = $renglon["hora_efectiva"];
			$afe->column_fields["codigo"] = $renglon["numero_interno"];
			$afe->column_fields["cantidad"] = $renglon["cantidad"];
			$afe->column_fields["numero_interno"] = $renglon["flota_rentaid"];
/**********************
$afe->column_fields["folio"] = $renglon["folio"];
$afe->column_fields["ado_tipo_documento"] = $renglon["ado_tipo_documento"];
$afe->column_fields["proveedor"] = $renglon["proveedor"];
$afe->column_fields["subarrendado"] = $renglon["subarrendado"];
$afe->column_fields["ado_tipo_interno"] = $renglon["ado_tipo_interno"];
$afe->column_fields["almacen"] = $renglon["almacen"];
$afe->column_fields["numero_serie"] = $renglon["numero_serie"];
$afe->column_fields["costo"] = $renglon["costo"];
$afe->column_fields["modulo"] = $renglon["modulo"];
$afe->column_fields["crmid"] = $renglon["crmid"];
$afe->column_fields["horometro"] = $renglon["horometro"];
$afe->column_fields["combustible"] = $renglon["combustible"];
**********************/
			$afe->save("Afectacion");

			if ($sobrescribir_horometros)
			{
				$consulta = "update vtiger_flota_renta flr set flr.horometro = '$remd_horometro' where flr.flota_rentaid = '$flr_id'";
				$adb->query($consulta);
			}

			// Actualiza el turno del periodo.
			$consulta = "update vtiger_periodos per, vtiger_crmentity e set per.per_turno = '$ent_turno' where e.crmid = per.periodosid and e.deleted = '0' and per.movimiento_apertura = '$ent_folio'";
			$adb->query($consulta);
		}
//die;
	}

	// Ejecuta un proceso interno. A futuro sería una función general para los documentos.
	function proc($parametros = array())
	{
		$proc = is_array($parametros)?$parametros["proc"]:$parametros;
		$incluir = "modules/Entregas/proc/$proc.php";
		require("clyfn/inc/inc.php");
	}

	// Realiza la entrega de la flota. Inicialmente para partida de equipo acumulado, con visión de cualquier equipo y en un solo barrido para todo el documento.
	function entregar($parametros = array())
	{
		$incluir = "modules/Entregas/fns/entregar.php";
		require("clyfn/inc/inc.php");
	}

	// Actualiza acumulado de flrd para flr_id específico.
	function actualizar_flrd_acumulado($parametros = array())
	{
		$incluir = "modules/Entregas/fns/actualizar_flrd_acumulado.php";
		require("clyfn/inc/inc.php");
	}

	// Inicializa flota de renta de los números internos a entregar (obra y servicio).
	function inicializar_flr($parametros = array())
	{
		$incluir = "modules/Entregas/fns/inicializar_flr.php";
		require("clyfn/inc/inc.php");
	}
}
?>
