<?php
require_once("clyfn.php");
require_once("config.php");
require_once("include/utils/utils.php");
require_once("modules/Ordenes_compra/Ordenes_compra.php");
require_once("modules/Sucursales/Sucursales.php");
require_once("modules/Vendors/Vendors.php");

// Obtiene información.
$oc_id = $_GET["record"];
$oc = new Ordenes_compra;
$oc->retrieve_entity_info($oc_id, "Ordenes_compra");

$oc_folio = $oc->column_fields["folio"];
$oc_fecha_efectiva = $oc->column_fields["fecha_efectiva"];
setlocale(LC_TIME, "es_MX");
$fecha = strftime("%e de %B de %Y", strtotime($oc->column_fields["fecha_efectiva"]));

$suc_id = $oc->column_fields["sucursal"];
$suc = new Sucursales;
$suc->retrieve_entity_info($suc_id, "Sucursales");

$suc_razon_social = $suc->column_fields["razon_social"];
$suc_domicilio = $suc->column_fields["domicilio"];
$suc_domicilio = str_replace("\n", "<br>", $suc->column_fields["domicilio"]);
$suc_ciudad_documentos = $suc->column_fields["ciudad_documentos"];
$remitente = "<b>".$suc->column_fields["razon_social"]."</b><br>".$suc_domicilio;

$prov_id = $oc->column_fields["proveedor"];
$prov = new Vendors;
$prov->retrieve_entity_info($prov_id, "Vendors");
$prov_nombre = $prov->column_fields["vendorname"];

// Prepara contenido.
$elementos_html["logo"] = "<img src=\"logo.jpg\" style=\"width:150px;\">";
$elementos_html["remitente"] = $remitente;
$elementos_html["fecha"] = "$suc_ciudad_documentos a $fecha";
$elementos_html["folio"] = "Orden de compra: $oc_folio";
$elementos_html["dirigido"] = "Proveedor: $prov_nombre";
//$elementos_html["titulo"] = "Orden de compra";

unset($parametros);
$parametros["surtido"]["ocultar"] = true;
$parametros["pendiente"]["ocultar"] = true;
$parametros["documentos"]["ocultar"] = true;
$elementos_html["tabla"] = $oc->tabla_detalles($parametros);

// Prepara estructura.
$estructura["encabezado"]["logo"] = $elementos_html["logo"];
$estructura["encabezado"]["remitente"] = $elementos_html["remitente"];
$estructura["encabezado"]["fecha"] = $elementos_html["fecha"];
$estructura["encabezado"]["folio"] = $elementos_html["folio"];
$estructura["encabezado"]["dirigido"] = $elementos_html["dirigido"];
$estructura["cuerpo"]["titulo"] = $elementos_html["titulo"];
$estructura["cuerpo"]["tabla"] = $elementos_html["tabla"];
$estructura["pie"]["condiciones"] = "";
$estructura["pie"]["despedida"] = "Sin más por el momento nos ponemos a sus órdenes.";
$estructura["pie"]["emisor"] = "";

$formato = new formato($estructura);
$html = $formato->generar();
//$html = $oc->formato_html();
?>
<html>
<head>
<meta charset="utf-8">
<link rel="stylesheet" href="include/style.css" type="text/css" media="all">
<style>
body
{
	padding:20px;
	font-size:16px;
}

tr
{
	background:#fed;
}

th
{
	border:1px solid orange;
	//width:100px;
	padding:5px;
}

td
{
	border-bottom:1px solid #ccc;
	background:#fff;
}

#encabezado
{
	//background:#eef;
	position:relative;
}

#logo
{
	text-align:left;
}

#remitente
{
	text-align:right;
	position:absolute;
	top:0px;
	right:0px;
}

#fecha
{
	text-align:right;
	//padding:40px 20px;
	padding:40px 0px;
}

#folio
{
	text-align:right;
	font-weight:bold;
	font-size:22px;
}

#dirigido
{
	text-align:left;
	padding:10px 0px;
}

#cuerpo
{
	//background:#efe;
}

#titulo
{
	text-align:left;
	padding:10px 0px;
}

#tabla
{
	text-align:center;
	font-size:10px;
}

#condiciones
{
	text-align:left;
	padding:10px 0px;
	font-size:12px;
}

#despedida
{
	text-align:left;
	padding:10px 0px;
}

#emisor
{
	text-align:left;
	padding:10px 0px;
}

#pie
{
	//background:#fee;
}
</style>
<title>
Orden de compra
</title>
</head>
<body>
<? echo $html;?>
</body>
</html>
