<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/
require_once('data/CRMEntity.php');
require_once('data/Tracker.php');
require_once("modules/Accounts/Accounts.php");
require_once("modules/Vendors/Vendors.php");
require_once("modules/Products/Products.php");

class Equivalencias extends CRMEntity {
	var $db, $log; // Used in class functions of CRMEntity

	var $table_name = 'vtiger_equivalencias';
	var $table_index= 'equivalenciasid';
	var $column_fields = Array();

	/** Indicator if this is a custom module or standard module */
	var $IsCustomModule = true;

	/**
	 * Mandatory table for supporting custom fields.
	 */
	var $customFieldTable = Array('vtiger_equivalenciascf', 'equivalenciasid');

	/**
	 * Mandatory for Saving, Include tables related to this module.
	 */
	var $tab_name = Array('vtiger_crmentity', 'vtiger_equivalencias', 'vtiger_equivalenciascf');

	/**
	 * Mandatory for Saving, Include tablename and tablekey columnname here.
	 */
	var $tab_name_index = Array(
		'vtiger_crmentity' => 'crmid',
		'vtiger_equivalencias'   => 'equivalenciasid',
	    'vtiger_equivalenciascf' => 'equivalenciasid');

	/**
	 * Mandatory for Listing (Related listview)
	 */
	var $list_fields = Array (
		/* Format: Field Label => Array(tablename, columnname) */
		// tablename should not have prefix 'vtiger_'
		'Equivalencias Name'=> Array('equivalencias', ''),
		'Assigned To' => Array('crmentity','smownerid')
	);
	var $list_fields_name = Array(
		/* Format: Field Label => fieldname */
		'Equivalencias Name'=> '',
		'Assigned To' => 'assigned_user_id'
	);

	// Make the field link to detail view from list view (Fieldname)
	var $list_link_field = '';

	// For Popup listview and UI type support
	var $search_fields = Array(
		/* Format: Field Label => Array(tablename, columnname) */
		// tablename should not have prefix 'vtiger_'
		'Equivalencias Name'=> Array('equivalencias', '')
	);
	var $search_fields_name = Array(
		/* Format: Field Label => fieldname */
		'Equivalencias Name'=> ''
	);

	// For Popup window record selection
	var $popup_fields = Array('');

	// Placeholder for sort fields - All the fields will be initialized for Sorting through initSortFields
	var $sortby_fields = Array();

	// For Alphabetical search
	var $def_basicsearch_col = '';

	// Column value to use on detail view record text display
	var $def_detailview_recname = '';

	// Required Information for enabling Import feature
	var $required_fields = Array(''=>1);

	// Callback function list during Importing
	var $special_functions = Array('set_import_assigned_user');

	var $default_order_by = '';
	var $default_sort_order='ASC';
	// Used when enabling/disabling the mandatory fields for the module.
	// Refers to vtiger_field.fieldname values.
	var $mandatory_fields = Array('createdtime', 'modifiedtime', '');
	
	function __construct() {
		global $log, $currentModule;
		$this->column_fields = getColumnFields($currentModule);
		$this->db = PearDatabase::getInstance();
		$this->log = $log;
	}

	function getSortOrder() {
		global $currentModule;

		$sortorder = $this->default_sort_order;
		if($_REQUEST['sorder']) $sortorder = $this->db->sql_escape_string($_REQUEST['sorder']);
		else if($_SESSION[$currentModule.'_Sort_Order']) 
			$sortorder = $_SESSION[$currentModule.'_Sort_Order'];

		return $sortorder;
	}

	function getOrderBy() {
		global $currentModule;
		
		$use_default_order_by = '';		
		if(PerformancePrefs::getBoolean('LISTVIEW_DEFAULT_SORTING', true)) {
			$use_default_order_by = $this->default_order_by;
		}
		
		$orderby = $use_default_order_by;
		if($_REQUEST['order_by']) $orderby = $this->db->sql_escape_string($_REQUEST['order_by']);
		else if($_SESSION[$currentModule.'_Order_By'])
			$orderby = $_SESSION[$currentModule.'_Order_By'];
		return $orderby;
	}

	function save_module($module) {
	}

	/**
	 * Return query to use based on given modulename, fieldname
	 * Useful to handle specific case handling for Popup
	 */
	function getQueryByModuleField($module, $fieldname, $srcrecord, $query='') {
		// $srcrecord could be empty
	}

	/**
	 * Get list view query (send more WHERE clause condition if required)
	 */
	function getListQuery($module, $usewhere='') {
		$query = "SELECT vtiger_crmentity.*, $this->table_name.*";
		
		// Keep track of tables joined to avoid duplicates
		$joinedTables = array();

		// Select Custom Field Table Columns if present
		if(!empty($this->customFieldTable)) $query .= ", " . $this->customFieldTable[0] . ".* ";

		$query .= " FROM $this->table_name";

		$query .= "	INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index";

		$joinedTables[] = $this->table_name;
		$joinedTables[] = 'vtiger_crmentity';
		
		// Consider custom table join as well.
		if(!empty($this->customFieldTable)) {
			$query .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index";
			$joinedTables[] = $this->customFieldTable[0]; 
		}
		$query .= " LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid";
		$query .= " LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";

		$joinedTables[] = 'vtiger_users';
		$joinedTables[] = 'vtiger_groups';
		
		$linkedModulesQuery = $this->db->pquery("SELECT distinct fieldname, columnname, relmodule FROM vtiger_field" .
				" INNER JOIN vtiger_fieldmodulerel ON vtiger_fieldmodulerel.fieldid = vtiger_field.fieldid" .
				" WHERE uitype='10' AND vtiger_fieldmodulerel.module=?", array($module));
		$linkedFieldsCount = $this->db->num_rows($linkedModulesQuery);
		
		for($i=0; $i<$linkedFieldsCount; $i++) {
			$related_module = $this->db->query_result($linkedModulesQuery, $i, 'relmodule');
			$fieldname = $this->db->query_result($linkedModulesQuery, $i, 'fieldname');
			$columnname = $this->db->query_result($linkedModulesQuery, $i, 'columnname');
			
			$other =  CRMEntity::getInstance($related_module);
			vtlib_setup_modulevars($related_module, $other);
			
			if(!in_array($other->table_name, $joinedTables)) {
				$query .= " LEFT JOIN $other->table_name ON $other->table_name.$other->table_index = $this->table_name.$columnname";
				$joinedTables[] = $other->table_name;
			}
		}

		global $current_user;
		$query .= $this->getNonAdminAccessControlQuery($module,$current_user);
		$query .= "	WHERE vtiger_crmentity.deleted = 0 ".$usewhere;
		return $query;
	}

	/**
	 * Apply security restriction (sharing privilege) query part for List view.
	 */
	function getListViewSecurityParameter($module) {
		global $current_user;
		require('user_privileges/user_privileges_'.$current_user->id.'.php');
		require('user_privileges/sharing_privileges_'.$current_user->id.'.php');

		$sec_query = '';
		$tabid = getTabid($module);

		if($is_admin==false && $profileGlobalPermission[1] == 1 && $profileGlobalPermission[2] == 1 
			&& $defaultOrgSharingPermission[$tabid] == 3) {

				$sec_query .= " AND (vtiger_crmentity.smownerid in($current_user->id) OR vtiger_crmentity.smownerid IN 
					(
						SELECT vtiger_user2role.userid FROM vtiger_user2role 
						INNER JOIN vtiger_users ON vtiger_users.id=vtiger_user2role.userid 
						INNER JOIN vtiger_role ON vtiger_role.roleid=vtiger_user2role.roleid 
						WHERE vtiger_role.parentrole LIKE '".$current_user_parent_role_seq."::%'
					) 
					OR vtiger_crmentity.smownerid IN 
					(
						SELECT shareduserid FROM vtiger_tmp_read_user_sharing_per 
						WHERE userid=".$current_user->id." AND tabid=".$tabid."
					) 
					OR 
						(";
		
					// Build the query based on the group association of current user.
					if(sizeof($current_user_groups) > 0) {
						$sec_query .= " vtiger_groups.groupid IN (". implode(",", $current_user_groups) .") OR ";
					}
					$sec_query .= " vtiger_groups.groupid IN 
						(
							SELECT vtiger_tmp_read_group_sharing_per.sharedgroupid 
							FROM vtiger_tmp_read_group_sharing_per
							WHERE userid=".$current_user->id." and tabid=".$tabid."
						)";
				$sec_query .= ")
				)";
		}
		return $sec_query;
	}

	/**
	 * Create query to export the records.
	 */
	function create_export_query($where)
	{
		global $current_user;
		$thismodule = $_REQUEST['module'];
		
		include("include/utils/ExportUtils.php");

		//To get the Permitted fields query and the permitted fields list
		$sql = getPermittedFieldsQuery($thismodule, "detail_view");
		
		$fields_list = getFieldsListFromQuery($sql);

		$query = "SELECT $fields_list, vtiger_users.user_name AS user_name 
					FROM vtiger_crmentity INNER JOIN $this->table_name ON vtiger_crmentity.crmid=$this->table_name.$this->table_index";

		if(!empty($this->customFieldTable)) {
			$query .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index"; 
		}

		$query .= " LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";
		$query .= " LEFT JOIN vtiger_users ON vtiger_crmentity.smownerid = vtiger_users.id and vtiger_users.status='Active'";
		
		$linkedModulesQuery = $this->db->pquery("SELECT distinct fieldname, columnname, relmodule FROM vtiger_field" .
				" INNER JOIN vtiger_fieldmodulerel ON vtiger_fieldmodulerel.fieldid = vtiger_field.fieldid" .
				" WHERE uitype='10' AND vtiger_fieldmodulerel.module=?", array($thismodule));
		$linkedFieldsCount = $this->db->num_rows($linkedModulesQuery);

		for($i=0; $i<$linkedFieldsCount; $i++) {
			$related_module = $this->db->query_result($linkedModulesQuery, $i, 'relmodule');
			$fieldname = $this->db->query_result($linkedModulesQuery, $i, 'fieldname');
			$columnname = $this->db->query_result($linkedModulesQuery, $i, 'columnname');
			
			$other = CRMEntity::getInstance($related_module);
			vtlib_setup_modulevars($related_module, $other);
			
			$query .= " LEFT JOIN $other->table_name ON $other->table_name.$other->table_index = $this->table_name.$columnname";
		}

		$query .= $this->getNonAdminAccessControlQuery($thismodule,$current_user);
		$where_auto = " vtiger_crmentity.deleted=0";

		if($where != '') $query .= " WHERE ($where) AND $where_auto";
		else $query .= " WHERE $where_auto";

		return $query;
	}

	/**
	 * Initialize this instance for importing.
	 */
	function initImport($module) {
		$this->db = PearDatabase::getInstance();
		$this->initImportableFields($module);
	}

	/**
	 * Create list query to be shown at the last step of the import.
	 * Called From: modules/Import/UserLastImport.php
	 */
	function create_import_query($module) {
		global $current_user;
		$query = "SELECT vtiger_crmentity.crmid, case when (vtiger_users.user_name not like '') then vtiger_users.user_name else vtiger_groups.groupname end as user_name, $this->table_name.* FROM $this->table_name
			INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index
			LEFT JOIN vtiger_users_last_import ON vtiger_users_last_import.bean_id=vtiger_crmentity.crmid
			LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid
			LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid
			WHERE vtiger_users_last_import.assigned_user_id='$current_user->id'
			AND vtiger_users_last_import.bean_type='$module'
			AND vtiger_users_last_import.deleted=0";
		return $query;
	}

	/**
	 * Delete the last imported records.
	 */
	function undo_import($module, $user_id) {
		global $adb;
		$count = 0;
		$query1 = "select bean_id from vtiger_users_last_import where assigned_user_id=? AND bean_type='$module' AND deleted=0";
		$result1 = $adb->pquery($query1, array($user_id)) or die("Error getting last import for undo: ".mysql_error()); 
		while ( $row1 = $adb->fetchByAssoc($result1))
		{
			$query2 = "update vtiger_crmentity set deleted=1 where crmid=?";
			$result2 = $adb->pquery($query2, array($row1['bean_id'])) or die("Error undoing last import: ".mysql_error()); 
			$count++;			
		}
		return $count;
	}
	
	/**
	 * Transform the value while exporting
	 */
	function transform_export_value($key, $value) {
		return parent::transform_export_value($key, $value);
	}

	/**
	 * Function which will set the assigned user id for import record.
	 */
	function set_import_assigned_user()
	{
		global $current_user, $adb;
		$record_user = $this->column_fields["assigned_user_id"];
		
		if($record_user != $current_user->id){
			$sqlresult = $adb->pquery("select id from vtiger_users where id = ? union select groupid as id from vtiger_groups where groupid = ?", array($record_user, $record_user));
			if($this->db->num_rows($sqlresult)!= 1) {
				$this->column_fields["assigned_user_id"] = $current_user->id;
			} else {			
				$row = $adb->fetchByAssoc($sqlresult, -1, false);
				if (isset($row['id']) && $row['id'] != -1) {
					$this->column_fields["assigned_user_id"] = $row['id'];
				} else {
					$this->column_fields["assigned_user_id"] = $current_user->id;
				}
			}
		}
	}
	
	/** 
	 * Function which will give the basic query to find duplicates
	 */
	function getDuplicatesQuery($module,$table_cols,$field_values,$ui_type_arr,$select_cols='') {
		$select_clause = "SELECT ". $this->table_name .".".$this->table_index ." AS recordid, vtiger_users_last_import.deleted,".$table_cols;

		// Select Custom Field Table Columns if present
		if(isset($this->customFieldTable)) $query .= ", " . $this->customFieldTable[0] . ".* ";

		$from_clause = " FROM $this->table_name";

		$from_clause .= "	INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index";

		// Consider custom table join as well.
		if(isset($this->customFieldTable)) {
			$from_clause .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index"; 
		}
		$from_clause .= " LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid
						LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";
		
		$where_clause = "	WHERE vtiger_crmentity.deleted = 0";
		$where_clause .= $this->getListViewSecurityParameter($module);
					
		if (isset($select_cols) && trim($select_cols) != '') {
			$sub_query = "SELECT $select_cols FROM  $this->table_name AS t " .
				" INNER JOIN vtiger_crmentity AS crm ON crm.crmid = t.".$this->table_index;
			// Consider custom table join as well.
			if(isset($this->customFieldTable)) {
				$sub_query .= " LEFT JOIN ".$this->customFieldTable[0]." tcf ON tcf.".$this->customFieldTable[1]." = t.$this->table_index";
			}
			$sub_query .= " WHERE crm.deleted=0 GROUP BY $select_cols HAVING COUNT(*)>1";	
		} else {
			$sub_query = "SELECT $table_cols $from_clause $where_clause GROUP BY $table_cols HAVING COUNT(*)>1";
		}	
		
		
		$query = $select_clause . $from_clause .
					" LEFT JOIN vtiger_users_last_import ON vtiger_users_last_import.bean_id=" . $this->table_name .".".$this->table_index .
					" INNER JOIN (" . $sub_query . ") AS temp ON ".get_on_clause($field_values,$ui_type_arr,$module) .
					$where_clause .
					" ORDER BY $table_cols,". $this->table_name .".".$this->table_index ." ASC";
					
		return $query;		
	}

	/**
	 * Invoked when special actions are performed on the module.
	 * @param String Module name
	 * @param String Event Type (module.postinstall, module.disabled, module.enabled, module.preuninstall)
	 */
	function vtlib_handler($modulename, $event_type) {
		if($event_type == 'module.postinstall') {
			// TODO Handle post installation actions
		} else if($event_type == 'module.disabled') {
			// TODO Handle actions when this module is disabled.
		} else if($event_type == 'module.enabled') {
			// TODO Handle actions when this module is enabled.
		} else if($event_type == 'module.preuninstall') {
			// TODO Handle actions when this module is about to be deleted.
		} else if($event_type == 'module.preupdate') {
			// TODO Handle actions before this module is updated.
		} else if($event_type == 'module.postupdate') {
			// TODO Handle actions after this module is updated.
		}
	}

	/** 
	 * Handle saving related module information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	// function save_related_module($module, $crmid, $with_module, $with_crmid) { }
	
	/**
	 * Handle deleting related module information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function delete_related_module($module, $crmid, $with_module, $with_crmid) { }

	/**
	 * Handle getting related list information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function get_related_list($id, $cur_tab_id, $rel_tab_id, $actions=false) { }

	/**
	 * Handle getting dependents list information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function get_dependents_list($id, $cur_tab_id, $rel_tab_id, $actions=false) { }

	// Genera la pestaña solicitada de la hoja electrónica.
	function hoja_electronica($pestana_elegida, $codificacion = "UTF-8")
	{
		global $adb;

		$eqv_id = $this->obtener_id();

		// Campos personalizados de sincronización.
		switch ($pestana_elegida)
		{
			case "Clientes":
				$tope = "BG";
				$cli = new Accounts;
				$campo_sincronizar = $cli->personalizado("sincronizar", true);

				// Validaciones.

				if (($campo_sincronizar == "cf_") || ($campo_sincronizar == ""))
				{
					die ("<h1>ERROR</h1>No se ha definido el campo personalizado \"sincronizar\" para la pestaña $pestana_elegida.");
				}
			break;
			case "DireccionesClientes":
				$tope = "F";
				$cli = new Accounts;
				$campo_sincronizar = $cli->personalizado("sincronizar", true);
				$campo_codigo_cliente = $cli->personalizado("mlan", true);

				// Validaciones.

				if (($campo_sincronizar == "cf_") || ($campo_sincronizar == ""))
				{
					die ("<h1>ERROR</h1>No se ha definido el campo personalizado \"sincronizar\" para la pestaña $pestana_elegida.");
				}

				if (($campo_codigo_cliente == "cf_") || ($campo_codigo_cliente == ""))
				{
					die ("<h1>ERROR</h1>No se ha definido el campo personalizado \"mlan\" para la pestaña $pestana_elegida.");
				}
			break;
			case "Proveedores":
				$tope = "AO";
				$prov = new Vendors;
				$campo_sincronizar = $prov->personalizado("sincronizar", true);

				// Validaciones.

				if (($campo_sincronizar == "cf_") || ($campo_sincronizar == ""))
				{
					die ("<h1>ERROR</h1>No se ha definido el campo personalizado \"sincronizar\" para la pestaña $pestana_elegida.");
				}
			break;
			case "DireccionesProveedores":
				$tope = "F";
				$prov = new Vendors;
				$campo_sincronizar = $prov->personalizado("sincronizar", true);
				//$campo_codigo_proveedor = $prov->personalizado("mlan", true);
			break;
			case "Servicios":
				//$tope = "AD";
				$tope = "AT";
				$prod = new Products;
				$campo_sincronizar = $prod->personalizado("sincronizar", true);
				$campo_linea = $prod->personalizado("linea", true);

				// Validaciones.

				if (($campo_sincronizar == "cf_") || ($campo_sincronizar == ""))
				{
					die ("<h1>ERROR</h1>No se ha definido el campo personalizado \"sincronizar\" para la pestaña $pestana_elegida.");
				}

				if (($campo_linea == "cf_") || ($campo_linea == ""))
				{
					die ("<h1>ERROR</h1>No se ha definido el campo personalizado \"linea\" para la pestaña $pestana_elegida.");
				}

				// Para los servicios usa las mismas equivalencias que los productos, pues los servicios son productos que empiezan con 9.
				//$pestana_equivalencias = "Productos";
			break;
			case "ServiciosFlotaRentaX":
				$tope = "AI";
				$prod = new Products;
				$campo_linea = $prod->personalizado("linea", true);

				// Validaciones.

				if (($campo_linea == "cf_") || ($campo_linea == ""))
				{
					die ("<h1>ERROR</h1>No se ha definido el campo personalizado \"linea\" para la pestaña $pestana_elegida.");
				}
				$pestana_equivalencias = "ServiciosFlotaRenta";
			break;
			case "ServiciosFlotaRentaY":
				$tope = "AI";
				$prod = new Products;
				$campo_linea = $prod->personalizado("linea", true);

				// Validaciones.

				if (($campo_linea == "cf_") || ($campo_linea == ""))
				{
					die ("<h1>ERROR</h1>No se ha definido el campo personalizado \"linea\" para la pestaña $pestana_elegida.");
				}
				$pestana_equivalencias = "ServiciosFlotaRenta";
			break;
			case "Productos":
				//$tope = "AH";
				$tope = "AT";
				$prod = new Products;
				$campo_sincronizar = $prod->personalizado("sincronizar", true);
				$campo_linea = $prod->personalizado("linea", true);

				// Validaciones.

				if (($campo_sincronizar == "cf_") || ($campo_sincronizar == ""))
				{
					die ("<h1>ERROR</h1>No se ha definido el campo personalizado \"sincronizar\" para la pestaña $pestana_elegida.");
				}

				if (($campo_linea == "cf_") || ($campo_linea == ""))
				{
					die ("<h1>ERROR</h1>No se ha definido el campo personalizado \"linea\" para la pestaña $pestana_elegida.");
				}
			break;
			case "Almacenes":
				$tope = "C";
				//$prov = new Vendors;
				//$campo_sincronizar = $prov->personalizado("sincronizar", true);
			break;
			case "Agentes":
				$tope = "E";
				//$prov = new Vendors;
				//$campo_sincronizar = $prov->personalizado("sincronizar", true);
			break;
			default:
				$tope = "A";
			break;
		}

		// Obtiene las equivalencias para la pestaña elegida.
		if ($pestana_equivalencias == "")
		{
			$pestana_equivalencias = $pestana_elegida;
		}
		//$consulta = "select eqv.* from vtiger_equivalencias eqv, vtiger_crmentity e where e.crmid = eqv.equivalenciasid and e.deleted = '0' and eqv.pestana_hoja_electronica = '$pestana_elegida' and eqv.activo = '1'";
		$consulta = "select eqv.* from vtiger_equivalencias eqv, vtiger_crmentity e where e.crmid = eqv.equivalenciasid and e.deleted = '0' and eqv.pestana_hoja_electronica = '$pestana_equivalencias' and eqv.activo = '1'";
//var_dump($consulta);
		$resultado = $adb->query($consulta);
		//$renglon = $adb->fetch_array($resultado);
		while ($renglon = $adb->fetch_array($resultado))
		{
/*****************************
echo "<pre>";
var_dump($renglon);
echo "</pre>";
die;
*******************************/
			$eqv_id = $renglon["equivalenciasid"];
			$eqv_campo_destino = $renglon["campo_destino"];
			$eqv_campo_origen_bd = $renglon["campo_origen_bd"];
			$eqv_columna_hoja_electronica = $renglon["columna_hoja_electronica"];
			$eqv_campo_fijo = $renglon["campo_fijo"];
			$eqv_valor_fijo = $renglon["valor_fijo"];
			$eqv_formato = $renglon["eqv_formato"];
			$eqv_personalizado = $renglon["personalizado"];
			$eqv_codigo_personalizado = $renglon["codigo_personalizado"];
			$eqv_modulo_origen_nombre_tecnico = $renglon["modulo_origen_nombre_tecnico"];
			$eqv_valores_visuales_lista = $renglon["valores_visuales_lista"];
			$eqv_valores_interfaz_lista = $renglon["valores_interfaz_lista"];
			$eqv_prefijo = $renglon["prefijo"];
			$eqv_sufijo = $renglon["sufijo"];
//var_dump($eqv_personalizado);

			$equivalencias[$eqv_columna_hoja_electronica]["campo_origen_bd"] = $eqv_campo_origen_bd;
			$equivalencias[$eqv_columna_hoja_electronica]["campo_fijo"] = $eqv_campo_fijo;
			$equivalencias[$eqv_columna_hoja_electronica]["valor_fijo"] = $eqv_valor_fijo;
			$equivalencias[$eqv_columna_hoja_electronica]["prefijo"] = $eqv_prefijo;
			$equivalencias[$eqv_columna_hoja_electronica]["sufijo"] = $eqv_sufijo;
			$equivalencias[$eqv_columna_hoja_electronica]["formato"] = $eqv_formato;
			if ($eqv_personalizado)
			{
				$objeto_modulo = new $eqv_modulo_origen_nombre_tecnico;
				$equivalencias[$eqv_columna_hoja_electronica]["campo_origen_bd"] = $objeto_modulo->personalizado($eqv_codigo_personalizado, true);
			}
			if ($eqv_formato == "abreviatura")
			{
				unset ($abreviaturas);
				$valores_visuales = explode("|", $eqv_valores_visuales_lista);
				$valores_interfaz = explode("|", $eqv_valores_interfaz_lista);

				for ($i = 0; $i <= (count($valores_visuales) - 1); $i++)
				{
					$abreviaturas[$valores_visuales[$i]] = $valores_interfaz[$i];
				}
				//$equivalencias[$eqv_columna_hoja_electronica]["valores_visuales_lista"] = $eqv_valores_visuales_lista;
				//$equivalencias[$eqv_columna_hoja_electronica]["valores_interfaz_lista"] = $eqv_valores_interfaz_lista;
				$equivalencias[$eqv_columna_hoja_electronica]["abreviaturas"] = $abreviaturas;
			}
//var_dump($eqv_campo_destino);
/************************
	$eqv_folio = $renglon["folio"];
	$eqv_modulo_origen = $renglon["modulo_origen"];
	$eqv_campo_origen = $renglon["campo_origen"];
	$eqv_origen = $renglon["origen"];
	$eqv_destino = $renglon["destino"];
	$eqv_tabla_origen_bd = $renglon["tabla_origen_bd"];
	$eqv_modulo_destino = $renglon["modulo_destino"];
	$eqv_modulo_destino_nombre_tecnico = $renglon["modulo_destino_nombre_tecnico"];
	$eqv_campo_destino_bd = $renglon["campo_destino_bd"];
	$eqv_tabla_destino_bd = $renglon["tabla_destino_bd"];
	$eqv_activo = $renglon["activo"];
	$eqv_pestana_hoja_electronica = $renglon["pestana_hoja_electronica"];
************************/

			//$campo_codigo_mlan = $cli->personalizado("mlan", true);
/**************************************
			$campo_sincronizar = $this->personalizado("sincronizar", true);
			$campo_correo1 = $this->personalizado("correo1", true);
			$campo_correo2 = $this->personalizado("correo2", true);
			$campo_correo3 = $this->personalizado("correo3", true);
			$campo_curp = $this->personalizado("curp", true);
			$campo_razon_social = $this->personalizado("razon_social", true);
			$campo_contacto = $this->personalizado("contacto", true);
			$campo_moneda1 = $this->personalizado("moneda1", true);
			$campo_moneda2 = $this->personalizado("moneda2", true);
			$campo_limite_credito = $this->personalizado("limite_credito", true);
			$campo_dias_credito = $this->personalizado("dias_credito", true);
			$campo_numero_exterior_factura = $this->personalizado("numero_exterior_factura", true);
			$campo_numero_interior_factura = $this->personalizado("numero_interior_factura", true);
*************************************/

		}


		//$equivalencias["D"]["formato"] = "fecha_adminpaq";
		//$equivalencias["E"]["campo_fijo"] = 1;
		//$equivalencias["E"]["valor_fijo"] = 2;
/*************************
echo "<pre>";
var_dump($equivalencias);
echo "</pre>";
*************************/

		//$consultas["Clientes"] = "select cli.*, cli2.$campo_codigo_mlan as codigo_mlan, cli2.$campo_correo1 as correo1, cli2.$campo_correo2 as correo2, cli2.$campo_correo3 as correo3, cli2.$campo_curp as curp, cli2.$campo_contacto as contacto, cli2.$campo_razon_social as razon_social, cli2.$campo_moneda1 as moneda1, cli2.$campo_moneda2 as moneda2, cli2.$campo_limite_credito as limite_credito, cli2.$campo_dias_credito as dias_credito, cli2.$campo_numero_exterior_factura as numero_exterior_factura, cli2.$campo_numero_interior_factura as numero_interior_factura, e.smownerid, cli3.* from vtiger_account cli, vtiger_crmentity e, vtiger_accountscf cli2, vtiger_accountbillads cli3 where e.crmid = cli.accountid and e.deleted = '0' and cli2.accountid = cli.accountid and cli2.$campo_sincronizar = '1' and cli3.accountaddressid = cli.accountid";
		$consultas["Clientes"] = "select cli.*, cli2.*, e.*, cli3.* from vtiger_account cli, vtiger_crmentity e, vtiger_accountscf cli2, vtiger_accountbillads cli3 where e.crmid = cli.accountid and e.deleted = '0' and cli2.accountid = cli.accountid and cli2.$campo_sincronizar = '1' and cli3.accountaddressid = cli.accountid";
		$consultas["DireccionesClientes"] = "select cli2.$campo_codigo_cliente as codigo_cliente, obr.nombre, obr.codigo_mlan from vtiger_account cli, vtiger_crmentity e, vtiger_accountscf cli2, vtiger_obras obr, vtiger_crmentity e2 where e.crmid = cli.accountid and e.deleted = '0' and cli2.accountid = cli.accountid and cli2.$campo_sincronizar = '1' and obr.accountid = cli.accountid and e2.crmid = obr.obrasid and e2.deleted = '0' order by cli2.$campo_codigo_cliente";
		$consultas["Proveedores"] = "select prov.*, prov2.*, e.* from vtiger_vendor prov, vtiger_crmentity e, vtiger_vendorcf prov2 where e.crmid = prov.vendorid and e.deleted = '0' and prov2.vendorid = prov.vendorid and prov2.$campo_sincronizar = '1'";
		$consultas["DireccionesProveedores"] = "select prov.*, prov2.*, e.* from vtiger_vendor prov, vtiger_crmentity e, vtiger_vendorcf prov2 where e.crmid = prov.vendorid and e.deleted = '0' and prov2.vendorid = prov.vendorid and prov2.$campo_sincronizar = '1'";
		$consultas["Agentes"] = "select concat(usr.first_name, ' ', usr.last_name) as nombre_agente, usr.* from vtiger_users usr";
		//$consultas["Productos"] = "select prod.*, prod2.* from vtiger_products prod, vtiger_crmentity e, vtiger_productcf prod2 where e.crmid = prod.productid and e.deleted = '0' and prod2.productid = prod.productid and prod2.$campo_sincronizar = '1'";
		$consultas["Productos"] = "select prod.*, prod2.*, fam.codigo as fam_codigo, lin.nombre as lin_nombre, lin.codigo_raiz as lin_codigo_raiz, lin.tipo_contable, e.description from vtiger_products prod, vtiger_crmentity e, vtiger_productcf prod2, vtiger_lineas lin, vtiger_familias fam where e.crmid = prod.productid and e.deleted = '0' and prod2.productid = prod.productid and prod2.$campo_sincronizar = '1' and lin.lineasid = prod2.$campo_linea and fam.familiasid = lin.familiasid and prod.productcode not like '9%'";
		$consultas["Servicios"] = "select prod.*, prod2.*, fam.codigo as fam_codigo, lin.nombre as lin_nombre, lin.codigo_raiz as lin_codigo_raiz, lin.tipo_contable, e.description from vtiger_products prod, vtiger_crmentity e, vtiger_productcf prod2, vtiger_lineas lin, vtiger_familias fam where e.crmid = prod.productid and e.deleted = '0' and prod2.productid = prod.productid and prod2.$campo_sincronizar = '1' and lin.lineasid = prod2.$campo_linea and fam.familiasid = lin.familiasid and prod.productcode like '9%'";
		//$consultas["ServiciosFlotaRentaX"] = "select flr.codigo_renta as codigo_interno, 'X' as tipo_codigo, concat('RENTA ', prod.productname) as descripcion_producto, flr.*, prod.*, prod2.* from vtiger_flota_renta flr, vtiger_crmentity e, vtiger_products prod, vtiger_productcf prod2 where e.crmid = flr.flota_rentaid and e.deleted = '0' and flr.numero_interno not like '8%' and prod.productid = flr.productid and prod2.productid = flr.productid group by flr.numero_interno";
		//$consultas["ServiciosFlotaRentaX"] = "select flr.codigo_renta as codigo_interno, 'X' as tipo_codigo, concat('RENTA ', lin.nombre) as descripcion_producto, lin.nombre as lin_nombre, lin.tipo_contable, flr.*, prod.*, prod2.* from vtiger_flota_renta flr, vtiger_crmentity e, vtiger_products prod, vtiger_productcf prod2, vtiger_lineas lin where e.crmid = flr.flota_rentaid and e.deleted = '0' and flr.numero_interno not like '8%' and prod.productid = flr.productid and prod2.productid = flr.productid and lin.lineasid = prod2.$campo_linea  group by flr.numero_interno";
		$consultas["ServiciosFlotaRentaX"] = "select flr.codigo_renta as codigo_interno, 'X' as tipo_codigo, concat(flr.codigo_renta, ' RENTA ', lin.nombre) as descripcion_producto, lin.nombre as lin_nombre, lin.tipo_contable, flr.*, prod.*, prod2.* from vtiger_flota_renta flr, vtiger_crmentity e, vtiger_products prod, vtiger_productcf prod2, vtiger_lineas lin where e.crmid = flr.flota_rentaid and e.deleted = '0' and flr.numero_interno not like '8%' and prod.productid = flr.productid and prod2.productid = flr.productid and lin.lineasid = prod2.$campo_linea  group by flr.numero_interno";
		//$consultas["ServiciosFlotaRentaY"] = "select flr.codigo_hextra as codigo_interno, 'Y' as tipo_codigo, concat('HORA EXTRA ', lin.nombre) as descripcion_producto, lin.nombre as lin_nombre, lin.tipo_contable, flr.*, prod.*, prod2.* from vtiger_flota_renta flr, vtiger_crmentity e, vtiger_products prod, vtiger_productcf prod2, vtiger_lineas lin where e.crmid = flr.flota_rentaid and e.deleted = '0' and flr.numero_interno not like '8%' and prod.productid = flr.productid and prod2.productid = flr.productid and lin.lineasid = prod2.$campo_linea and lin.hextra = '1' group by flr.numero_interno";
		$consultas["ServiciosFlotaRentaY"] = "select flr.codigo_hextra as codigo_interno, 'Y' as tipo_codigo, concat(flr.codigo_hextra, ' HORA EXTRA ', lin.nombre) as descripcion_producto, lin.nombre as lin_nombre, lin.tipo_contable, flr.*, prod.*, prod2.* from vtiger_flota_renta flr, vtiger_crmentity e, vtiger_products prod, vtiger_productcf prod2, vtiger_lineas lin where e.crmid = flr.flota_rentaid and e.deleted = '0' and flr.numero_interno not like '8%' and prod.productid = flr.productid and prod2.productid = flr.productid and lin.lineasid = prod2.$campo_linea and lin.hextra = '1' group by flr.numero_interno";

		if (!isset($consultas[$pestana_elegida]))
		{
			 die ("<h1>ERROR</h1>No se ha definido internamente la consulta para esta pestaña.");
		}
		$consulta = $consultas[$pestana_elegida];
//var_dump($consulta);
//die;
		$resultado = $adb->query($consulta);
		//$renglon = $adb->fetch_array($resultado);

		$nombre_archivo = "descargas/$pestana_elegida.csv";
		$archivo = fopen($nombre_archivo,"w");

		while ($renglon = $adb->fetch_array($resultado))
		{
/************************
echo "<pre>";
var_dump($renglon);
echo "</pre>";
//die;
			//$usr_id = $renglon["id"];
	$usr_folio = $renglon["folio"];
************************/

			unset($renglon_archivo);
			unset($elementos);

			foreach ($equivalencias as $letra => $equivalencia)
			{
				switch ($equivalencia["formato"])
				{
					case "fecha_adminpaq":
						$datos[$letra] = date("m/d/Y", strtotime($renglon[$equivalencia["campo_origen_bd"]]));
					break;
					case "abreviatura":
						$datos[$letra] = $equivalencia["abreviaturas"][$renglon[$equivalencia["campo_origen_bd"]]];
					break;
					default:
						$datos[$letra] = $renglon[$equivalencia["campo_origen_bd"]];
					break;
				}

				if ($equivalencia["campo_fijo"])
				{
					$datos[$letra] = $equivalencia["valor_fijo"];
				}

/*******************************
echo "<pre>";
var_dump($equivalencia);
echo "</pre>";
die;
*******************************/
				// Agrega un posible prefijo y sufijo.
				$datos[$letra] = $equivalencia["prefijo"].$datos[$letra].$equivalencia["sufijo"];

				// Si el dato viene en blanco y se capturó valor fijo usa el valor fijo.
				// Esto sirve para una inicialización rápida de campos que aún no se ha hecho una captura exhaustiva
				// y que son obligatorios como RFC, por ejemplo.
				if ($datos[$letra] == "" && $equivalencia["valor_fijo"] != "")
				{
					$datos[$letra] = $equivalencia["valor_fijo"];
				}
			}
/***************************
echo "<pre>";
var_dump($datos);
echo "</pre>";
****************************/

			//$tope = "Z";
			//$tope = "AM";

			// Inicializa letras.
			$letra_izquierda = "";
			$letra_derecha = "";

			for ($i = 0; $i <= 26; $i++)
			{
//echo "i:$i;";
				if ($i > 0)
				{
					$letra_izquierda = chr(64 + $i);
				}

				for ($j = 1; $j <= 26; $j++)
				{
//echo "j:$j;";
					$letra_derecha = chr(64 + $j);
					$letra = $letra_izquierda.$letra_derecha;
		
//echo "letra:$letra;<br>";

					//$elementos[] = '"'.$datos[$letra].'"';
					//$elementos[] = '"'.html_entity_decode($datos[$letra], ENT_NOQUOTES, "UTF-8").'"';
					//$elementos[] = '"'.html_entity_decode($datos[$letra], ENT_NOQUOTES, $codificacion).'"';
					$elementos[] = '"'.str_replace('"', '""', html_entity_decode($datos[$letra], ENT_QUOTES, $codificacion)).'"';

					if ($letra == $tope)
					{
						break(2);
					}
				}
			}

//var_dump($elementos);
			$renglon_archivo = implode(",", $elementos);

			echo $renglon_archivo;
			echo "<br>";

			fwrite($archivo, $renglon_archivo."\n");
		}

		fclose($archivo);
	}
}
?>
