<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/
require_once('data/CRMEntity.php');
require_once('data/Tracker.php');
require_once("modules/Sucursales/Sucursales.php");
require_once("modules/Flota_renta/Flota_renta.php");
require_once("modules/Traspasos_det/Traspasos_det.php");
//require_once("modules/Numeros_serie/Numeros_serie.php");
require_once("modules/Lineas/Lineas.php");
require_once("modules/Products/Products.php");
require_once("clyfn.php");

class Traspasos extends CRMEntity {
	var $db, $log; // Used in class functions of CRMEntity

	var $table_name = 'vtiger_traspasos';
	var $table_index= 'traspasosid';
	var $column_fields = Array();

	/** Indicator if this is a custom module or standard module */
	var $IsCustomModule = true;

	/**
	 * Mandatory table for supporting custom fields.
	 */
	var $customFieldTable = Array('vtiger_traspasoscf', 'traspasosid');

	/**
	 * Mandatory for Saving, Include tables related to this module.
	 */
	var $tab_name = Array('vtiger_crmentity', 'vtiger_traspasos', 'vtiger_traspasoscf');

	/**
	 * Mandatory for Saving, Include tablename and tablekey columnname here.
	 */
	var $tab_name_index = Array(
		'vtiger_crmentity' => 'crmid',
		'vtiger_traspasos'   => 'traspasosid',
	    'vtiger_traspasoscf' => 'traspasosid');

	/**
	 * Mandatory for Listing (Related listview)
	 */
	var $list_fields = Array (
		/* Format: Field Label => Array(tablename, columnname) */
		// tablename should not have prefix 'vtiger_'
		//'Traspasos Name'=> Array('traspasos', 'idv'),
		//'Assigned To' => Array('crmentity','smownerid')
		'Traspaso'=> Array('traspasos', 'folio'),
	);
	var $list_fields_name = Array(
		/* Format: Field Label => fieldname */
		//'Traspasos Name'=> 'idv',
		//'Assigned To' => 'assigned_user_id'
		'Traspaso'=> 'folio',
	);

	// Make the field link to detail view from list view (Fieldname)
	//var $list_link_field = 'idv';
	var $list_link_field = 'folio';

	// For Popup listview and UI type support
	var $search_fields = Array(
		/* Format: Field Label => Array(tablename, columnname) */
		// tablename should not have prefix 'vtiger_'
		//'Traspasos Name'=> Array('traspasos', 'idv')
		'Traspaso'=> Array('traspasos', 'folio')
	);
	var $search_fields_name = Array(
		/* Format: Field Label => fieldname */
		//'Traspasos Name'=> 'idv'
		'Traspaso'=> 'folio'
	);

	// For Popup window record selection
	//var $popup_fields = Array('idv');
	var $popup_fields = Array('folio');

	// Placeholder for sort fields - All the fields will be initialized for Sorting through initSortFields
	var $sortby_fields = Array();

	// For Alphabetical search
	//var $def_basicsearch_col = 'idv';
	var $def_basicsearch_col = 'folio';

	// Column value to use on detail view record text display
	//var $def_detailview_recname = 'idv';
	var $def_detailview_recname = 'folio';

	// Required Information for enabling Import feature
	//var $required_fields = Array('idv'=>1);
	var $required_fields = Array('folio'=>1);

	// Callback function list during Importing
	var $special_functions = Array('set_import_assigned_user');

	//var $default_order_by = 'idv';
	var $default_order_by = 'folio';
	var $default_sort_order='ASC';
	// Used when enabling/disabling the mandatory fields for the module.
	// Refers to vtiger_field.fieldname values.
	//var $mandatory_fields = Array('createdtime', 'modifiedtime', 'idv');
	var $mandatory_fields = Array('createdtime', 'modifiedtime', 'folio');
	
	function __construct() {
		global $log, $currentModule;
		$this->column_fields = getColumnFields($currentModule);
		$this->db = PearDatabase::getInstance();
		$this->log = $log;
	}

	function getSortOrder() {
		global $currentModule;

		$sortorder = $this->default_sort_order;
		if($_REQUEST['sorder']) $sortorder = $this->db->sql_escape_string($_REQUEST['sorder']);
		else if($_SESSION[$currentModule.'_Sort_Order']) 
			$sortorder = $_SESSION[$currentModule.'_Sort_Order'];

		return $sortorder;
	}

	function getOrderBy() {
		global $currentModule;
		
		$use_default_order_by = '';		
		if(PerformancePrefs::getBoolean('LISTVIEW_DEFAULT_SORTING', true)) {
			$use_default_order_by = $this->default_order_by;
		}
		
		$orderby = $use_default_order_by;
		if($_REQUEST['order_by']) $orderby = $this->db->sql_escape_string($_REQUEST['order_by']);
		else if($_SESSION[$currentModule.'_Order_By'])
			$orderby = $_SESSION[$currentModule.'_Order_By'];
		return $orderby;
	}

	function save_module($module) {
		$suc_origen_id = $this->column_fields["sucursal_origen"];
		$suc_destino_id = $this->column_fields["sucursal_destino"];

		// Validaciones.

		if ($suc_origen_id == "")
		{
			die ("<h1>ERROR</h1>No se especificó la sucursal origen.");
		}

		if ($suc_destino_id == "")
		{
			die ("<h1>ERROR</h1>No se especificó la sucursal destino.");
		}

		if ($suc_origen_id == $suc_destino_id)
		{
			die ("<h1>ERROR</h1>Las sucursales deben ser distintas.");
		}

		$this->asignar_dueno("tra");
		$this->procesar();
		//$this->dirigir();
	}

	/**
	 * Return query to use based on given modulename, fieldname
	 * Useful to handle specific case handling for Popup
	 */
	function getQueryByModuleField($module, $fieldname, $srcrecord, $query='') {
		// $srcrecord could be empty
	}

	/**
	 * Get list view query (send more WHERE clause condition if required)
	 */
	function getListQuery($module, $usewhere='') {
		$query = "SELECT vtiger_crmentity.*, $this->table_name.*";
		
		// Keep track of tables joined to avoid duplicates
		$joinedTables = array();

		// Select Custom Field Table Columns if present
		if(!empty($this->customFieldTable)) $query .= ", " . $this->customFieldTable[0] . ".* ";

		$query .= " FROM $this->table_name";

		$query .= "	INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index";

		$joinedTables[] = $this->table_name;
		$joinedTables[] = 'vtiger_crmentity';
		
		// Consider custom table join as well.
		if(!empty($this->customFieldTable)) {
			$query .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index";
			$joinedTables[] = $this->customFieldTable[0]; 
		}
		$query .= " LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid";
		$query .= " LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";

		$joinedTables[] = 'vtiger_users';
		$joinedTables[] = 'vtiger_groups';
		
		$linkedModulesQuery = $this->db->pquery("SELECT distinct fieldname, columnname, relmodule FROM vtiger_field" .
				" INNER JOIN vtiger_fieldmodulerel ON vtiger_fieldmodulerel.fieldid = vtiger_field.fieldid" .
				" WHERE uitype='10' AND vtiger_fieldmodulerel.module=?", array($module));
		$linkedFieldsCount = $this->db->num_rows($linkedModulesQuery);
		
		for($i=0; $i<$linkedFieldsCount; $i++) {
			$related_module = $this->db->query_result($linkedModulesQuery, $i, 'relmodule');
			$fieldname = $this->db->query_result($linkedModulesQuery, $i, 'fieldname');
			$columnname = $this->db->query_result($linkedModulesQuery, $i, 'columnname');
			
			$other =  CRMEntity::getInstance($related_module);
			vtlib_setup_modulevars($related_module, $other);
			
			if(!in_array($other->table_name, $joinedTables)) {
				$query .= " LEFT JOIN $other->table_name ON $other->table_name.$other->table_index = $this->table_name.$columnname";
				$joinedTables[] = $other->table_name;
			}
		}

		global $current_user;
		$query .= $this->getNonAdminAccessControlQuery($module,$current_user);
		$query .= "	WHERE vtiger_crmentity.deleted = 0 ".$usewhere;
		return $query;
	}

	/**
	 * Apply security restriction (sharing privilege) query part for List view.
	 */
	function getListViewSecurityParameter($module) {
		global $current_user;
		require('user_privileges/user_privileges_'.$current_user->id.'.php');
		require('user_privileges/sharing_privileges_'.$current_user->id.'.php');

		$sec_query = '';
		$tabid = getTabid($module);

		if($is_admin==false && $profileGlobalPermission[1] == 1 && $profileGlobalPermission[2] == 1 
			&& $defaultOrgSharingPermission[$tabid] == 3) {

				$sec_query .= " AND (vtiger_crmentity.smownerid in($current_user->id) OR vtiger_crmentity.smownerid IN 
					(
						SELECT vtiger_user2role.userid FROM vtiger_user2role 
						INNER JOIN vtiger_users ON vtiger_users.id=vtiger_user2role.userid 
						INNER JOIN vtiger_role ON vtiger_role.roleid=vtiger_user2role.roleid 
						WHERE vtiger_role.parentrole LIKE '".$current_user_parent_role_seq."::%'
					) 
					OR vtiger_crmentity.smownerid IN 
					(
						SELECT shareduserid FROM vtiger_tmp_read_user_sharing_per 
						WHERE userid=".$current_user->id." AND tabid=".$tabid."
					) 
					OR 
						(";
		
					// Build the query based on the group association of current user.
					if(sizeof($current_user_groups) > 0) {
						$sec_query .= " vtiger_groups.groupid IN (". implode(",", $current_user_groups) .") OR ";
					}
					$sec_query .= " vtiger_groups.groupid IN 
						(
							SELECT vtiger_tmp_read_group_sharing_per.sharedgroupid 
							FROM vtiger_tmp_read_group_sharing_per
							WHERE userid=".$current_user->id." and tabid=".$tabid."
						)";
				$sec_query .= ")
				)";
		}
		return $sec_query;
	}

	/**
	 * Create query to export the records.
	 */
	function create_export_query($where)
	{
		global $current_user;
		$thismodule = $_REQUEST['module'];
		
		include("include/utils/ExportUtils.php");

		//To get the Permitted fields query and the permitted fields list
		$sql = getPermittedFieldsQuery($thismodule, "detail_view");
		
		$fields_list = getFieldsListFromQuery($sql);

		$query = "SELECT $fields_list, vtiger_users.user_name AS user_name 
					FROM vtiger_crmentity INNER JOIN $this->table_name ON vtiger_crmentity.crmid=$this->table_name.$this->table_index";

		if(!empty($this->customFieldTable)) {
			$query .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index"; 
		}

		$query .= " LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";
		$query .= " LEFT JOIN vtiger_users ON vtiger_crmentity.smownerid = vtiger_users.id and vtiger_users.status='Active'";
		
		$linkedModulesQuery = $this->db->pquery("SELECT distinct fieldname, columnname, relmodule FROM vtiger_field" .
				" INNER JOIN vtiger_fieldmodulerel ON vtiger_fieldmodulerel.fieldid = vtiger_field.fieldid" .
				" WHERE uitype='10' AND vtiger_fieldmodulerel.module=?", array($thismodule));
		$linkedFieldsCount = $this->db->num_rows($linkedModulesQuery);

		for($i=0; $i<$linkedFieldsCount; $i++) {
			$related_module = $this->db->query_result($linkedModulesQuery, $i, 'relmodule');
			$fieldname = $this->db->query_result($linkedModulesQuery, $i, 'fieldname');
			$columnname = $this->db->query_result($linkedModulesQuery, $i, 'columnname');
			
			$other = CRMEntity::getInstance($related_module);
			vtlib_setup_modulevars($related_module, $other);
			
			$query .= " LEFT JOIN $other->table_name ON $other->table_name.$other->table_index = $this->table_name.$columnname";
		}

		$query .= $this->getNonAdminAccessControlQuery($thismodule,$current_user);
		$where_auto = " vtiger_crmentity.deleted=0";

		if($where != '') $query .= " WHERE ($where) AND $where_auto";
		else $query .= " WHERE $where_auto";

		return $query;
	}

	/**
	 * Initialize this instance for importing.
	 */
	function initImport($module) {
		$this->db = PearDatabase::getInstance();
		$this->initImportableFields($module);
	}

	/**
	 * Create list query to be shown at the last step of the import.
	 * Called From: modules/Import/UserLastImport.php
	 */
	function create_import_query($module) {
		global $current_user;
		$query = "SELECT vtiger_crmentity.crmid, case when (vtiger_users.user_name not like '') then vtiger_users.user_name else vtiger_groups.groupname end as user_name, $this->table_name.* FROM $this->table_name
			INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index
			LEFT JOIN vtiger_users_last_import ON vtiger_users_last_import.bean_id=vtiger_crmentity.crmid
			LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid
			LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid
			WHERE vtiger_users_last_import.assigned_user_id='$current_user->id'
			AND vtiger_users_last_import.bean_type='$module'
			AND vtiger_users_last_import.deleted=0";
		return $query;
	}

	/**
	 * Delete the last imported records.
	 */
	function undo_import($module, $user_id) {
		global $adb;
		$count = 0;
		$query1 = "select bean_id from vtiger_users_last_import where assigned_user_id=? AND bean_type='$module' AND deleted=0";
		$result1 = $adb->pquery($query1, array($user_id)) or die("Error getting last import for undo: ".mysql_error()); 
		while ( $row1 = $adb->fetchByAssoc($result1))
		{
			$query2 = "update vtiger_crmentity set deleted=1 where crmid=?";
			$result2 = $adb->pquery($query2, array($row1['bean_id'])) or die("Error undoing last import: ".mysql_error()); 
			$count++;			
		}
		return $count;
	}
	
	/**
	 * Transform the value while exporting
	 */
	function transform_export_value($key, $value) {
		return parent::transform_export_value($key, $value);
	}

	/**
	 * Function which will set the assigned user id for import record.
	 */
	function set_import_assigned_user()
	{
		global $current_user, $adb;
		$record_user = $this->column_fields["assigned_user_id"];
		
		if($record_user != $current_user->id){
			$sqlresult = $adb->pquery("select id from vtiger_users where id = ? union select groupid as id from vtiger_groups where groupid = ?", array($record_user, $record_user));
			if($this->db->num_rows($sqlresult)!= 1) {
				$this->column_fields["assigned_user_id"] = $current_user->id;
			} else {			
				$row = $adb->fetchByAssoc($sqlresult, -1, false);
				if (isset($row['id']) && $row['id'] != -1) {
					$this->column_fields["assigned_user_id"] = $row['id'];
				} else {
					$this->column_fields["assigned_user_id"] = $current_user->id;
				}
			}
		}
	}
	
	/** 
	 * Function which will give the basic query to find duplicates
	 */
	function getDuplicatesQuery($module,$table_cols,$field_values,$ui_type_arr,$select_cols='') {
		$select_clause = "SELECT ". $this->table_name .".".$this->table_index ." AS recordid, vtiger_users_last_import.deleted,".$table_cols;

		// Select Custom Field Table Columns if present
		if(isset($this->customFieldTable)) $query .= ", " . $this->customFieldTable[0] . ".* ";

		$from_clause = " FROM $this->table_name";

		$from_clause .= "	INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index";

		// Consider custom table join as well.
		if(isset($this->customFieldTable)) {
			$from_clause .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index"; 
		}
		$from_clause .= " LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid
						LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";
		
		$where_clause = "	WHERE vtiger_crmentity.deleted = 0";
		$where_clause .= $this->getListViewSecurityParameter($module);
					
		if (isset($select_cols) && trim($select_cols) != '') {
			$sub_query = "SELECT $select_cols FROM  $this->table_name AS t " .
				" INNER JOIN vtiger_crmentity AS crm ON crm.crmid = t.".$this->table_index;
			// Consider custom table join as well.
			if(isset($this->customFieldTable)) {
				$sub_query .= " LEFT JOIN ".$this->customFieldTable[0]." tcf ON tcf.".$this->customFieldTable[1]." = t.$this->table_index";
			}
			$sub_query .= " WHERE crm.deleted=0 GROUP BY $select_cols HAVING COUNT(*)>1";	
		} else {
			$sub_query = "SELECT $table_cols $from_clause $where_clause GROUP BY $table_cols HAVING COUNT(*)>1";
		}	
		
		
		$query = $select_clause . $from_clause .
					" LEFT JOIN vtiger_users_last_import ON vtiger_users_last_import.bean_id=" . $this->table_name .".".$this->table_index .
					" INNER JOIN (" . $sub_query . ") AS temp ON ".get_on_clause($field_values,$ui_type_arr,$module) .
					$where_clause .
					" ORDER BY $table_cols,". $this->table_name .".".$this->table_index ." ASC";
					
		return $query;		
	}

	/**
	 * Invoked when special actions are performed on the module.
	 * @param String Module name
	 * @param String Event Type (module.postinstall, module.disabled, module.enabled, module.preuninstall)
	 */
	function vtlib_handler($modulename, $event_type) {
		if($event_type == 'module.postinstall') {
			// TODO Handle post installation actions
		} else if($event_type == 'module.disabled') {
			// TODO Handle actions when this module is disabled.
		} else if($event_type == 'module.enabled') {
			// TODO Handle actions when this module is enabled.
		} else if($event_type == 'module.preuninstall') {
			// TODO Handle actions when this module is about to be deleted.
		} else if($event_type == 'module.preupdate') {
			// TODO Handle actions before this module is updated.
		} else if($event_type == 'module.postupdate') {
			// TODO Handle actions after this module is updated.
		}
	}

	/** 
	 * Handle saving related module information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	// function save_related_module($module, $crmid, $with_module, $with_crmid) { }
	
	/**
	 * Handle deleting related module information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function delete_related_module($module, $crmid, $with_module, $with_crmid) { }

	/**
	 * Handle getting related list information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function get_related_list($id, $cur_tab_id, $rel_tab_id, $actions=false) { }

	/**
	 * Handle getting dependents list information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function get_dependents_list($id, $cur_tab_id, $rel_tab_id, $actions=false) { }

	// Procesa el traspaso.
	function procesar()
	{
		global $adb;

		$tra_id = $this->obtener_id();

		// Bloquea el documento.
		$this->bloquear("traspasos");

/*******************************
		$suc_origen_id = $this->column_fields["sucursal_origen"];
		$suc_destino_id = $this->column_fields["sucursal_destino"];
		//$flr_id = $this->column_fields["flota_renta"];
		//$prod_id = $this->column_fields["producto"];
		//$cantidad = $this->column_fields["cantidad"];

//var_dump($this->column_fields);
//die;
		// Validaciones.

		if ($suc_origen_id == "")
		{
			die ("<h1>ERROR</h1>No se especificó la sucursal origen.");
		}

		if ($suc_destino_id == "")
		{
			die ("<h1>ERROR</h1>No se especificó la sucursal destino.");
		}

		if ($suc_origen_id == $suc_destino_id)
		{
			die ("<h1>ERROR</h1>Las sucursales deben ser distintas.");
		}

		if ($flr_id == "" && $prod_id == "")
		{
			die ("<h1>ERROR</h1>Se debe especificar un elemento de flota o un producto a transferir.");
		}

		if ($flr_id != "" && $prod_id != "")
		{
			die ("<h1>ERROR</h1>Se debe especificar un elemento de flota o un producto a transferir pero no ambos.");
		}

		if ($flr_id != "")
		{
			$flr = new Flota_renta;
			$flr->retrieve_entity_info($flr_id, "Flota_renta");

			if ($cantidad > $flr->column_fields["existencia"])
			{
				die ("<h1>ERROR</h1>La cantidad solicitada no puede exceder la existencia.");
			}
		}

		if ($cantidad == "")
		{
			die ("<h1>ERROR</h1>Debe especificar la cantidad.");
		}

		if (!is_numeric($cantidad))
		{
			die ("<h1>ERROR</h1>La cantidad debe ser numérica.");
		}

		if ($cantidad <= 0)
		{
			die ("<h1>ERROR</h1>La cantidad debe ser mayor que 0.");
		}

		$suc_origen = new Sucursales;
		$suc_origen->retrieve_entity_info($suc_origen_id, "Sucursales");
		$cli_origen_id = $suc_origen->column_fields["cliente_mks"];
		$obr_origen_id = $suc_origen->column_fields["obra_mks"];
		$alm_origen_id = $suc_origen->column_fields["almacen_flota"];

		$suc_destino = new Sucursales;
		$suc_destino->retrieve_entity_info($suc_destino_id, "Sucursales");
		$cli_destino_id = $suc_destino->column_fields["cliente_mks"];
		$obr_destino_id = $suc_destino->column_fields["obra_mks"];
		$alm_destino_id = $suc_destino->column_fields["almacen_flota"];

		if ($flr_id != "")
		{
			if ($flr->individual())
			{
				//$consulta = "update vtiger_flota_renta flr set flr.accountid = '$cli_destino_id', flr.obrasid = '$obr_destino_id' where flr.flota_rentaid = '$flr_id'";
				// Actualiza el registro.
				$flr->column_fields["cliente"] = $cli_destino_id;
				$flr->column_fields["obra"] = $obr_destino_id;
				$flr->save("Flota_renta", $flr_id);
			}
			else
			{
				// Genera un nuevo registro.
				$flr->column_fields["cliente"] = $cli_destino_id;
				$flr->column_fields["obra"] = $obr_destino_id;
				$flr->column_fields["existencia"] = $cantidad;
				$flr->save("Flota_renta");
			}

			// Registra en kardex y existencias.

			// Origen.
			unset($parametros);
			$parametros["sucursal"] = $suc_origen_id;
			$parametros["almacen"] = $alm_origen_id;
			$parametros["tipo_documento"] = "Traspaso";
			$parametros["folio"] = $this->column_fields["folio"];
			$parametros["fecha"] = $this->column_fields["fecha_efectiva"];
			if ($flr_id != "")
			{
				$parametros["producto"] = $flr->column_fields["producto"];
			}
			$parametros["codigo_articulo"] = $flr->column_fields["numero_interno"];
			$parametros["entradas"] = 0;
			$parametros["salidas"] = $cantidad;
			$this->kardex($parametros);

			// Destino.
			unset($parametros);
			$parametros["sucursal"] = $suc_destino_id;
			$parametros["almacen"] = $alm_destino_id;
			$parametros["tipo_documento"] = "Traspaso";
			$parametros["folio"] = $this->column_fields["folio"];
			$parametros["fecha"] = $this->column_fields["fecha_efectiva"];
			if ($flr_id != "")
			{
				$parametros["producto"] = $flr->column_fields["producto"];
			}
			$parametros["codigo_articulo"] = $flr->column_fields["numero_interno"];
			$parametros["entradas"] = $cantidad;
			$parametros["salidas"] = 0;
			$this->kardex($parametros);
		}
**************************/
//die;
	}

	// Genera tabla de detalles.
	function tabla_detalles($modo_captura = false)
	{
		$tra_id = $this->obtener_id();

		$tra_estado = $this->column_fields["tra_estado"];
	
		global $adb;
	
		$contador_color = 0;
		$i = 1;
	
		//$tabla = "<table style=\"width:100%;\">";
		$tabla = "<table style=\"\">";
		$tabla .= "<tr>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "</th>";
		//$tabla .= "<th class=\"dvInnerHeader\">";
		//$tabla .= "Folio";
		//$tabla .= "</th>";
		//$tabla .= "<th class=\"dvInnerHeader\">";
		//$tabla .= "Traspaso";
		//$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\" style=\"width:300px;\">";
		$tabla .= "Línea";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\" style=\"width:300px;\">";
		$tabla .= "Producto";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\" style=\"width:40px;\">";
// 20B
		//$tabla .= "Sol.";
		$tabla .= "Cantidad";
		$tabla .= "</th>";
/***************
		$tabla .= "<th class=\"dvInnerHeader\" style=\"width:40px;\">";
		$tabla .= "Aut.";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\" style=\"width:40px;\">";
		$tabla .= "Rec.";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\" style=\"width:40px;\">";
		$tabla .= "Pend.";
		$tabla .= "</th>";
***************/
// 20B
		$tabla .= "<th class=\"dvInnerHeader\" style=\"width:50px;\">";
		$tabla .= "Desglose<br>(NS, NI, Rec.)";
		$tabla .= "</th>";
		if ($modo_captura)
		{
			$tabla .= "<th class=\"dvInnerHeader\" style=\"width:50px;\">";
			$tabla .= "Acciones";
			$tabla .= "</th>";
		}
		$tabla .= "</tr>";
	
		//$consulta = "select trad.* from vtiger_traspasos_det trad, vtiger_crmentity e where e.crmid = trad.traspasos_detid and e.deleted = '0' and trad.traspasosid = '$tra_id'";
		//$consulta = "select trad.*, lin.nombre as lin_nombre from vtiger_traspasos_det trad inner join vtiger_crmentity e on e.crmid = trad.traspasos_detid left join vtiger_lineas lin on lin.lineasid = trad.lineasid where e.deleted = '0' and trad.traspasosid = '$tra_id'";
		$consulta = "select trad.*, lin.nombre as lin_nombre, prod.productname from vtiger_traspasos_det trad inner join vtiger_crmentity e on e.crmid = trad.traspasos_detid left join vtiger_lineas lin on lin.lineasid = trad.lineasid left join vtiger_products prod on prod.productid = trad.productid where e.deleted = '0' and trad.traspasosid = '$tra_id'";
	//var_dump($consulta);
		$resultado = $adb->query($consulta);
		while ($renglon = $adb->fetch_array($resultado))
		{
	//echo "<pre>";
	//var_dump($renglon);
	//echo "</pre>";
	//die;
			$trad_id = $renglon["traspasos_detid"];
			$trad_folio = $renglon["folio"];
			$trad_traspaso = $renglon["traspaso"];
			$trad_producto = $renglon["producto"];
			$trad_cantidad_solicitada = $renglon["cantidad_solicitada"];
			$trad_cantidad_autorizada = $renglon["cantidad_autorizada"];
			$trad_cantidad_recibida = $renglon["cantidad_recibida"];
			$lin_id = $renglon["lineasid"];
			$lin_nombre = $renglon["lin_nombre"];
			$prod_id = $renglon["productid"];
			$prod_nombre = $renglon["productname"];
//var_dump($lin_id);
			$trad = new Traspasos_det;
			$trad->retrieve_entity_info($trad_id, "Traspasos_det");

			// Detecta si este artículo se maneja individual o agrupado.
			if (($lin_id != "") && ($prod_id == ""))
			{
				$lin = new Lineas;
				$lin->retrieve_entity_info($lin_id, "Lineas");
				$individual = $lin->individual();
			}

			if (($lin_id == "") && ($prod_id != ""))
			{
				$prod = new Products;
				$prod->retrieve_entity_info($prod_id, "Products");
				$individual = $prod->individual();
			}

			$color = ($contador_color % 2)?"#eee":"#fec";

			$habilitado["cantidad_solicitada"] = false;
			$habilitado["cantidad_autorizada"] = false;
			$habilitado["cantidad_recibida"] = false;
			$habilitado["linea"] = false;
			$habilitado["producto"] = false;

			if (($tra_estado == "Borrador") && ($modo_captura))
			{
				$habilitado["cantidad_solicitada"] = true;
				$habilitado["linea"] = true;
				$habilitado["producto"] = true;
			}

			if (($tra_estado == "Solicitado") && ($modo_captura))
			{
				$habilitado["cantidad_autorizada"] = true;
			}

			if ((html_entity_decode($tra_estado, ENT_QUOTES, "UTF-8") == "En tránsito") && ($modo_captura))
			{
				$habilitado["cantidad_recibida"] = true;
			}
	
			if (($tra_estado == "Recibido parcial") && ($modo_captura))
			{
				$habilitado["cantidad_recibida"] = true;
			}

			$tabla .= "<tr style=\"background:$color;\">";
			$tabla .= "<td style=\"text-align:right;\">";
			$tabla .= "$i.";
			//$tabla .= "$trad_id.";
			$tabla .= "</td>";
			//$tabla .= "<td style=\"padding:0px 8px;\">";
			//$tabla .= $trad_folio;
			//$tabla .= "</td>";
			//$tabla .= "<td style=\"padding:0px 8px;\">";
			//$tabla .= $trad_traspaso;
			//$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;text-align:center;\">";

			if ($habilitado["linea"])
			{
				unset($parametros);
				//$parametros["nombre_campo"] = "lin$i";
				//$parametros["nombre_display"] = "lin{$i}_display";
				$parametros["nombre_campo"] = "lin$trad_id";
				$parametros["nombre_display"] = "lin{$trad_id}_display";
				$parametros["modulo_emergente"] = "Lineas";
				$parametros["crmid"] = $lin_id;
				$parametros["valor_mostrado"] = $lin_nombre;
				$parametros["ancho"] = 180;

				$tabla .= $this->control_relacionado($parametros);
			}
			else
			{
				$tabla .= $lin_nombre;
			}
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;text-align:center;\">";

			if ($habilitado["producto"])
			{
				unset($parametros);
				//$parametros["nombre_campo"] = "prod$i";
				//$parametros["nombre_display"] = "prod{$i}_display";
				$parametros["nombre_campo"] = "prod$trad_id";
				$parametros["nombre_display"] = "prod{$trad_id}_display";
				$parametros["modulo_emergente"] = "Products";
				$parametros["crmid"] = $prod_id;
				$parametros["valor_mostrado"] = $prod_nombre;
				$parametros["ancho"] = 180;

				$tabla .= $this->control_relacionado($parametros);
			}
			else
			{
				$tabla .= $prod_nombre;
			}
			$tabla .= "</td>";
			if ($habilitado["cantidad_solicitada"])
			{
				$tabla .= "<td style=\"padding:0px 8px;text-align:center;width:40px;\">";
				$tabla .= "<input type=\"text\" name=\"captura[$trad_id][cantidad_solicitada]\" value=\"$trad_cantidad_solicitada\" style=\"width:30px;text-align:right;\">";
				$tabla .= "</td>";
			}
			else
			{
				$tabla .= "<td style=\"padding:0px 8px;width:40px;text-align:right;\">";
				$tabla .= $trad_cantidad_solicitada;
				$tabla .= "</td>";
			}

// 20B
/**************
			if ($habilitado["cantidad_autorizada"])
			{
				$tabla .= "<td style=\"padding:0px 8px;text-align:center;width:40px;\">";
				$tabla .= "<input type=\"text\" name=\"captura[$trad_id][cantidad_autorizada]\" value=\"$trad_cantidad_autorizada\" style=\"width:30px;text-align:right;\">";
				$tabla .= "</td>";
			}
			else
			{
				$tabla .= "<td style=\"padding:0px 8px;width:40px;text-align:right;\">";
				$tabla .= $trad_cantidad_autorizada;
				$tabla .= "</td>";
			}

			$tabla .= "<td style=\"padding:0px 8px;width:40px;text-align:right;\">";
			$tabla .= $trad_cantidad_recibida;
			$tabla .= "</td>";
**************/
// 20B

/*************************************
			if ($habilitado["cantidad_recibida"])
			{
				$tabla .= "<td style=\"padding:0px 8px;text-align:center;width:40px;\">";
				$tabla .= "<input type=\"text\" name=\"captura[$trad_id][cantidad_recibida]\" value=\"".($trad_cantidad_autorizada - $trad_cantidad_recibida)."\" style=\"width:30px;text-align:right;\">";
				$tabla .= "</td>";
			}
			else
			{
				$tabla .= "<td style=\"padding:0px 8px;width:40px;text-align:right;\">";
				//$tabla .= $trad_cantidad_recibida;
				$tabla .= $trad_cantidad_autorizada - $trad_cantidad_recibida;
				$tabla .= "</td>";
			}
************************************/


// 20B
/***************
			$tabla .= "<td style=\"padding:0px 8px;width:40px;text-align:right;\">";
			$tabla .= $trad_cantidad_autorizada - $trad_cantidad_recibida;
			$tabla .= "</td>";
***************/
// 20B

			if ($individual)
			{
				$tabla .= "<td style=\"padding:0px 8px;width:40px;\">";
				$tabla .= $trad->tabla_desglose();
				$tabla .= "</td>";
			}
			else
			{
				$tabla .= "<td style=\"padding:0px 8px;width:40px;text-align:center;\">";
				if (($modo_captura) && ($habilitado["cantidad_recibida"]) && (($trad_cantidad_autorizada - $trad_cantidad_recibida) > 0))
				{
					$tabla .= "<input type=\"text\" name=\"captura[$trad_id][cantidad_recibida]\" value=\"".($trad_cantidad_autorizada - $trad_cantidad_recibida)."\" style=\"width:30px;text-align:right;\">";
				}
				$tabla .= "</td>";
			}

			// Acciones.
			if ($modo_captura)
			{
				$tabla .= "<td style=\"padding:0px 8px;width:50px;text-align:center;\">";
				if ($tra_estado == "Borrador")
				{
					$tabla .= "<a href=\"index.php?module=Traspasos_det&action=eliminar&record=$trad_id\">";
					$tabla .= "Eliminar";
					$tabla .= "</a>";
				}

// 20B
				//if (($tra_estado == "Solicitado") && ($individual))
				if ($individual)
// 20B
				{
					$tabla .= "<a href=\"index.php?module=Traspasos_det&action=registrar_equipos&record=$trad_id\">";
					$tabla .= "Desglose";
					$tabla .= "</a>";
				}

				if ((html_entity_decode($tra_estado, ENT_QUOTES, "UTF-8") == "En tránsito") && ($individual))
				{
					$tabla .= "<a href=\"index.php?module=Traspasos_det&action=registrar_equipos&record=$trad_id&accion=recibir\">";
					$tabla .= "Verificar";
					$tabla .= "</a>";
				}

				if (($tra_estado == "Recibido parcial") && ($individual))
				{
					$tabla .= "<a href=\"index.php?module=Traspasos_det&action=registrar_equipos&record=$trad_id&accion=recibir&parcial=1\">";
					$tabla .= "Verificar";
					$tabla .= "</a>";
				}
				$tabla .= "</td>";
			}

			$tabla .= "</tr>";
	
			$contador_color++;
			$i++;
		}

		// Renglón para agregar.
		if (($tra_estado == "Borrador") && ($modo_captura))
		{
			$color = ($contador_color % 2)?"#eee":"#fec";
			$habilitado["cantidad_solicitada"] = true;

			$trad_id = 0;

			$tabla .= "<tr style=\"background:$color;\">";
			$tabla .= "<td style=\"text-align:right;\">";
			$tabla .= "$i.";
			$tabla .= "</td>";
			//$tabla .= "<td style=\"padding:0px 8px;\">";
			//$tabla .= $trad_folio;
			//$tabla .= "</td>";
			//$tabla .= "<td style=\"padding:0px 8px;\">";
			//$tabla .= $trad_traspaso;
			//$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;text-align:center;\">";

			unset($parametros);
			//$parametros["nombre_campo"] = "lin$i";
			//$parametros["nombre_display"] = "lin{$i}_display";
			$parametros["nombre_campo"] = "lin$trad_id";
			$parametros["nombre_display"] = "lin{$trad_id}_display";
			$parametros["modulo_emergente"] = "Lineas";
			$parametros["ancho"] = 180;

			$tabla .= $this->control_relacionado($parametros);

			$tabla .= $trad_flota_renta;
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;text-align:center;\">";

			unset($parametros);
			//$parametros["nombre_campo"] = "prod$i";
			//$parametros["nombre_display"] = "prod{$i}_display";
			$parametros["nombre_campo"] = "prod$trad_id";
			$parametros["nombre_display"] = "prod{$trad_id}_display";
			$parametros["modulo_emergente"] = "Products";
			$parametros["ancho"] = 180;

			$tabla .= $this->control_relacionado($parametros);

			$tabla .= $trad_producto;
			$tabla .= "</td>";
			//$tabla .= "<td style=\"padding:0px 8px;text-align:center;width:50px;\">";
			//$tabla .= "<input type=\"text\" name=\"captura[0][cantidad_solicitada]\" style=\"width:50px;text-align:right;\">";
			//$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;text-align:center;width:40px;\">";
			if ($habilitado["cantidad_solicitada"])
			{
				$tabla .= "<input type=\"text\" name=\"captura[$trad_id][cantidad_solicitada]\" style=\"width:30px;text-align:right;\">";
			}
			$tabla .= "</td>";
			//$tabla .= "<td style=\"padding:0px 8px;text-align:center;width:50px;\">";
			//$tabla .= "<input type=\"text\" name=\"captura[0][cantidad_autorizada]\" style=\"width:50px;text-align:right;\">";
			//$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;text-align:center;width:40px;\">";
			if ($habilitado["cantidad_autorizada"])
			{
				$tabla .= "<input type=\"text\" name=\"captura[$trad_id][cantidad_autorizada]\" style=\"width:30px;text-align:right;\">";
			}
			$tabla .= "</td>";
			//$tabla .= "<td style=\"padding:0px 8px;text-align:center;width:50px;\">";
			//$tabla .= "<input type=\"text\" name=\"captura[0][cantidad_recibida]\" style=\"width:50px;text-align:right;\">";
			//$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;text-align:center;width:40px;\">";
			if ($habilitado["cantidad_recibida"])
			{
				$tabla .= "<input type=\"text\" name=\"captura[$trad_id][cantidad_recibida]\" style=\"width:30px;text-align:right;\">";
			}
			$tabla .= "</td>";
			$tabla .= "<td>";
			$tabla .= "</td>";
			$tabla .= "<td>";
			$tabla .= "</td>";
			$tabla .= "<td>";
			$tabla .= "</td>";
			$tabla .= "</tr>";

			$contador_color++;
			$i++;
		}
	
		$tabla .= "</table>";

		$tabla .= "<input type=\"hidden\" name=\"iteraciones\" value=\"".($i - 1)."\">";
	
		return $tabla;
	}

	// Registra detalles capturados.
	function registrar_detalles($captura = array())
	{
/**********************
echo "<pre>";
var_dump($captura);
echo "</pre>";
//die;
*********************/
		$tra_id = $this->obtener_id();
		$tra_estado = $this->column_fields["tra_estado"];

		foreach ($captura as $trad_id => $valores)
		{
//var_dump($trad_id);

			$lin_id = $valores["lin_id"];
			$prod_id = $valores["prod_id"];
			$trad_cantidad_solicitada = $valores["cantidad_solicitada"];
			$trad_cantidad_autorizada = $valores["cantidad_autorizada"];
			$trad_cantidad_recibida = $valores["cantidad_recibida"];

			if (($tra_estado == "Borrador") && ($lin_id == "") && ($prod_id == ""))
			{
				if ($trad_id != 0)
				{
					die("<h1>ERROR</h1>Elija la línea o el producto.");
				}

				continue;
			}

			if (($tra_estado == "Borrador") && ($trad_cantidad_solicitada <= 0))
			{
				die ("<h1>ERROR</h1>La cantidad solicitada debe ser mayor que 0.");
			}

			$trad = new Traspasos_det;
			if ($trad_id != 0)
			{
				$trad->retrieve_entity_info($trad_id, "Traspasos_det");
			}
			$trad->column_fields["assigned_user_id"] = 1;
			//$trad->column_fields["folio"] = $trad_folio;
			$trad->column_fields["traspaso"] = $tra_id;

			if ($tra_estado == "Borrador")
			{
				$trad->column_fields["linea"] = $lin_id;
				$trad->column_fields["producto"] = $prod_id;
				$trad->column_fields["cantidad_solicitada"] = $trad_cantidad_solicitada;
			}
			if ($tra_estado == "Solicitado")
			{
				$trad->column_fields["cantidad_autorizada"] = $trad_cantidad_autorizada;
			}
			if (html_entity_decode($tra_estado, ENT_QUOTES, "UTF-8") == "En tránsito")
			{
				$trad->column_fields["cantidad_recibida"] = $trad_cantidad_recibida;
			}
			if ($tra_estado == "Recibido parcial")
			{
				$trad->column_fields["cantidad_recibida"] += $trad_cantidad_recibida;
			}
			if ($trad_id != 0)
			{
				$trad->save("Traspasos_det", $trad_id);
			}
			else
			{
				$trad->save("Traspasos_det");
			}
		}
	}

	// Modifica el estado del documento.
	function estado($tra_estado)
	{
		require("modules/Traspasos/fns/estado.php");
/******************
		global $adb;

		$tra_id = $this->obtener_id();

		$consulta = "update vtiger_traspasos tra set tra.tra_estado = '$tra_estado' where tra.traspasosid = '$tra_id'";
		$adb->query($consulta);
		$this->bloquear("traspasos");
******************/
	}

	// Registra lo que se ha recibido parcialmente para que pueda usarse.
	function recibir_parcial()
	{
//echo "Parcial";
		$tra_id = $this->obtener_id();

		global $adb;

		$consulta = "select trad.* from vtiger_traspasos_det trad, vtiger_crmentity e where e.crmid = trad.traspasos_detid and e.deleted = '0' and trad.traspasosid = '$tra_id'";
//var_dump($consulta);
		$resultado = $adb->query($consulta);
//$renglon = $adb->fetch_array($resultado);
		while ($renglon = $adb->fetch_array($resultado))
		{
//echo "<pre>";
//var_dump($renglon);
//echo "</pre>";
//die;
			$trad_id = $renglon["traspasos_detid"];
			$trad_desglose_equipos = $renglon["desglose_equipos"];
/************************
	$trad_folio = $renglon["folio"];
	$trad_traspaso = $renglon["traspaso"];
	$trad_linea = $renglon["linea"];
	$trad_producto = $renglon["producto"];
	$trad_cantidad_solicitada = $renglon["cantidad_solicitada"];
	$trad_cantidad_autorizada = $renglon["cantidad_autorizada"];
	$trad_cantidad_recibida = $renglon["cantidad_recibida"];
************************/
			if ($trad_desglose_equipos != "")
			{
				$trad = new Traspasos_det;
				$trad->retrieve_entity_info($trad_id, "Traspasos_det");
				$desglose = json_decode(html_entity_decode($trad_desglose_equipos, ENT_QUOTES, "UTF-8"), true);
				if (is_array($desglose["recibido"]))
				{
					$desglose["recibido_parcial"] = $desglose["recibido"];
					$json = json_encode($desglose);

					$trad->column_fields["desglose_equipos"] = $json;
					$trad->save("Traspasos_det", $trad_id);
				}
			}

		}
//die;
	}

	// Procesa el envío (existencias, kardex, estados, etc.).
	function enviar()
	{

		$tra_id = $this->obtener_id();

		global $adb;

		$consulta = "select trad.* from vtiger_traspasos_det trad, vtiger_crmentity e where e.crmid = trad.traspasos_detid and e.deleted = '0' and trad.traspasosid = '$tra_id'";
		//$consulta = "select trad.* from vtiger_traspasos_det trad inner join vtiger_crmentity e on e.crmid = trad.traspasos_detid where e.deleted = '0' and trad.traspasosid = '$tra_id'";
//var_dump($consulta);
		$resultado = $adb->query($consulta);
//$renglon = $adb->fetch_array($resultado);
		while ($renglon = $adb->fetch_array($resultado))
		{
//echo "<pre>";
//var_dump($renglon);
//echo "</pre>";
//die;
			$trad_id = $renglon["traspasos_detid"];
			$trad_desglose_equipos = $renglon["desglose_equipos"];
/************************
	$trad_folio = $renglon["folio"];
	$trad_traspaso = $renglon["traspaso"];
	$trad_linea = $renglon["linea"];
	$trad_producto = $renglon["producto"];
	$trad_cantidad_solicitada = $renglon["cantidad_solicitada"];
	$trad_cantidad_autorizada = $renglon["cantidad_autorizada"];
	$trad_cantidad_recibida = $renglon["cantidad_recibida"];
************************/
			$trad = new Traspasos_det;
			$trad->retrieve_entity_info($trad_id, "Traspasos_det");
			$trad->enviar();
		}
//die;
	}

	// Procesa la recepción (existencias, kardex, estados, etc.).
	function recibir()
	{

		$tra_id = $this->obtener_id();

		global $adb;

		$consulta = "select trad.* from vtiger_traspasos_det trad, vtiger_crmentity e where e.crmid = trad.traspasos_detid and e.deleted = '0' and trad.traspasosid = '$tra_id'";
		//$consulta = "select trad.* from vtiger_traspasos_det trad inner join vtiger_crmentity e on e.crmid = trad.traspasos_detid where e.deleted = '0' and trad.traspasosid = '$tra_id'";
//var_dump($consulta);
		$resultado = $adb->query($consulta);
//$renglon = $adb->fetch_array($resultado);
		while ($renglon = $adb->fetch_array($resultado))
		{
//echo "<pre>";
//var_dump($renglon);
//echo "</pre>";
//die;
			$trad_id = $renglon["traspasos_detid"];
			$trad_desglose_equipos = $renglon["desglose_equipos"];
/************************
	$trad_folio = $renglon["folio"];
	$trad_traspaso = $renglon["traspaso"];
	$trad_linea = $renglon["linea"];
	$trad_producto = $renglon["producto"];
	$trad_cantidad_solicitada = $renglon["cantidad_solicitada"];
	$trad_cantidad_autorizada = $renglon["cantidad_autorizada"];
	$trad_cantidad_recibida = $renglon["cantidad_recibida"];
************************/
			$trad = new Traspasos_det;
			$trad->retrieve_entity_info($trad_id, "Traspasos_det");
			$trad->recibir();
		}
//qdd($consulta);
//die;
	}

	// Realiza una validación de la flota de renta. Está pensado para renta de acumulado.
	function validar_flr($parametros = array())
	{
		require("modules/Traspasos/fns/validar_flr.php");
	}

	// Emite el documento. Es realizar un traspaso directo.
	function emitir($parametros = array())
	{
		require("modules/Traspasos/fns/emitir.php");
	}

	// Actualiza saldos de kardex para código y almacén específicos.
	function actualizar_saldos_kdx($parametros = array())
	{
		require("modules/Traspasos/fns/actualizar_saldos_kdx.php");
	}

	// Actualiza acumulado de flrd para flr y obra específicos.
	function actualizar_flrd_acumulado($parametros = array())
	{
		require("modules/Traspasos/fns/actualizar_flrd_acumulado.php");
	}
}
?>
