<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/
require_once('data/CRMEntity.php');
require_once('data/Tracker.php');

class Reconstruccion extends CRMEntity {
	var $db, $log; // Used in class functions of CRMEntity

	var $table_name = 'vtiger_reconstruccion';
	var $table_index= 'reconstruccionid';
	var $column_fields = Array();

	/** Indicator if this is a custom module or standard module */
	var $IsCustomModule = true;

	/**
	 * Mandatory table for supporting custom fields.
	 */
	var $customFieldTable = Array('vtiger_reconstruccioncf', 'reconstruccionid');

	/**
	 * Mandatory for Saving, Include tables related to this module.
	 */
	var $tab_name = Array('vtiger_crmentity', 'vtiger_reconstruccion', 'vtiger_reconstruccioncf');

	/**
	 * Mandatory for Saving, Include tablename and tablekey columnname here.
	 */
	var $tab_name_index = Array(
		'vtiger_crmentity' => 'crmid',
		'vtiger_reconstruccion'   => 'reconstruccionid',
	    'vtiger_reconstruccioncf' => 'reconstruccionid');

	/**
	 * Mandatory for Listing (Related listview)
	 */
	var $list_fields = Array (
		/* Format: Field Label => Array(tablename, columnname) */
		// tablename should not have prefix 'vtiger_'
		'Reconstruccion Name'=> Array('reconstruccion', ''),
		'Assigned To' => Array('crmentity','smownerid')
	);
	var $list_fields_name = Array(
		/* Format: Field Label => fieldname */
		'Reconstruccion Name'=> '',
		'Assigned To' => 'assigned_user_id'
	);

	// Make the field link to detail view from list view (Fieldname)
	var $list_link_field = '';

	// For Popup listview and UI type support
	var $search_fields = Array(
		/* Format: Field Label => Array(tablename, columnname) */
		// tablename should not have prefix 'vtiger_'
		'Reconstruccion Name'=> Array('reconstruccion', '')
	);
	var $search_fields_name = Array(
		/* Format: Field Label => fieldname */
		'Reconstruccion Name'=> ''
	);

	// For Popup window record selection
	var $popup_fields = Array('');

	// Placeholder for sort fields - All the fields will be initialized for Sorting through initSortFields
	var $sortby_fields = Array();

	// For Alphabetical search
	var $def_basicsearch_col = '';

	// Column value to use on detail view record text display
	var $def_detailview_recname = '';

	// Required Information for enabling Import feature
	var $required_fields = Array(''=>1);

	// Callback function list during Importing
	var $special_functions = Array('set_import_assigned_user');

	var $default_order_by = '';
	var $default_sort_order='ASC';
	// Used when enabling/disabling the mandatory fields for the module.
	// Refers to vtiger_field.fieldname values.
	var $mandatory_fields = Array('createdtime', 'modifiedtime', '');
	
	function __construct() {
		global $log, $currentModule;
		$this->column_fields = getColumnFields($currentModule);
		$this->db = PearDatabase::getInstance();
		$this->log = $log;
	}

	function getSortOrder() {
		global $currentModule;

		$sortorder = $this->default_sort_order;
		if($_REQUEST['sorder']) $sortorder = $this->db->sql_escape_string($_REQUEST['sorder']);
		else if($_SESSION[$currentModule.'_Sort_Order']) 
			$sortorder = $_SESSION[$currentModule.'_Sort_Order'];

		return $sortorder;
	}

	function getOrderBy() {
		global $currentModule;
		
		$use_default_order_by = '';		
		if(PerformancePrefs::getBoolean('LISTVIEW_DEFAULT_SORTING', true)) {
			$use_default_order_by = $this->default_order_by;
		}
		
		$orderby = $use_default_order_by;
		if($_REQUEST['order_by']) $orderby = $this->db->sql_escape_string($_REQUEST['order_by']);
		else if($_SESSION[$currentModule.'_Order_By'])
			$orderby = $_SESSION[$currentModule.'_Order_By'];
		return $orderby;
	}

	function save_module($module) {
	}

	/**
	 * Return query to use based on given modulename, fieldname
	 * Useful to handle specific case handling for Popup
	 */
	function getQueryByModuleField($module, $fieldname, $srcrecord, $query='') {
		// $srcrecord could be empty
	}

	/**
	 * Get list view query (send more WHERE clause condition if required)
	 */
	function getListQuery($module, $usewhere='') {
		$query = "SELECT vtiger_crmentity.*, $this->table_name.*";
		
		// Keep track of tables joined to avoid duplicates
		$joinedTables = array();

		// Select Custom Field Table Columns if present
		if(!empty($this->customFieldTable)) $query .= ", " . $this->customFieldTable[0] . ".* ";

		$query .= " FROM $this->table_name";

		$query .= "	INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index";

		$joinedTables[] = $this->table_name;
		$joinedTables[] = 'vtiger_crmentity';
		
		// Consider custom table join as well.
		if(!empty($this->customFieldTable)) {
			$query .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index";
			$joinedTables[] = $this->customFieldTable[0]; 
		}
		$query .= " LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid";
		$query .= " LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";

		$joinedTables[] = 'vtiger_users';
		$joinedTables[] = 'vtiger_groups';
		
		$linkedModulesQuery = $this->db->pquery("SELECT distinct fieldname, columnname, relmodule FROM vtiger_field" .
				" INNER JOIN vtiger_fieldmodulerel ON vtiger_fieldmodulerel.fieldid = vtiger_field.fieldid" .
				" WHERE uitype='10' AND vtiger_fieldmodulerel.module=?", array($module));
		$linkedFieldsCount = $this->db->num_rows($linkedModulesQuery);
		
		for($i=0; $i<$linkedFieldsCount; $i++) {
			$related_module = $this->db->query_result($linkedModulesQuery, $i, 'relmodule');
			$fieldname = $this->db->query_result($linkedModulesQuery, $i, 'fieldname');
			$columnname = $this->db->query_result($linkedModulesQuery, $i, 'columnname');
			
			$other =  CRMEntity::getInstance($related_module);
			vtlib_setup_modulevars($related_module, $other);
			
			if(!in_array($other->table_name, $joinedTables)) {
				$query .= " LEFT JOIN $other->table_name ON $other->table_name.$other->table_index = $this->table_name.$columnname";
				$joinedTables[] = $other->table_name;
			}
		}

		global $current_user;
		$query .= $this->getNonAdminAccessControlQuery($module,$current_user);
		$query .= "	WHERE vtiger_crmentity.deleted = 0 ".$usewhere;
		return $query;
	}

	/**
	 * Apply security restriction (sharing privilege) query part for List view.
	 */
	function getListViewSecurityParameter($module) {
		global $current_user;
		require('user_privileges/user_privileges_'.$current_user->id.'.php');
		require('user_privileges/sharing_privileges_'.$current_user->id.'.php');

		$sec_query = '';
		$tabid = getTabid($module);

		if($is_admin==false && $profileGlobalPermission[1] == 1 && $profileGlobalPermission[2] == 1 
			&& $defaultOrgSharingPermission[$tabid] == 3) {

				$sec_query .= " AND (vtiger_crmentity.smownerid in($current_user->id) OR vtiger_crmentity.smownerid IN 
					(
						SELECT vtiger_user2role.userid FROM vtiger_user2role 
						INNER JOIN vtiger_users ON vtiger_users.id=vtiger_user2role.userid 
						INNER JOIN vtiger_role ON vtiger_role.roleid=vtiger_user2role.roleid 
						WHERE vtiger_role.parentrole LIKE '".$current_user_parent_role_seq."::%'
					) 
					OR vtiger_crmentity.smownerid IN 
					(
						SELECT shareduserid FROM vtiger_tmp_read_user_sharing_per 
						WHERE userid=".$current_user->id." AND tabid=".$tabid."
					) 
					OR 
						(";
		
					// Build the query based on the group association of current user.
					if(sizeof($current_user_groups) > 0) {
						$sec_query .= " vtiger_groups.groupid IN (". implode(",", $current_user_groups) .") OR ";
					}
					$sec_query .= " vtiger_groups.groupid IN 
						(
							SELECT vtiger_tmp_read_group_sharing_per.sharedgroupid 
							FROM vtiger_tmp_read_group_sharing_per
							WHERE userid=".$current_user->id." and tabid=".$tabid."
						)";
				$sec_query .= ")
				)";
		}
		return $sec_query;
	}

	/**
	 * Create query to export the records.
	 */
	function create_export_query($where)
	{
		global $current_user;
		$thismodule = $_REQUEST['module'];
		
		include("include/utils/ExportUtils.php");

		//To get the Permitted fields query and the permitted fields list
		$sql = getPermittedFieldsQuery($thismodule, "detail_view");
		
		$fields_list = getFieldsListFromQuery($sql);

		$query = "SELECT $fields_list, vtiger_users.user_name AS user_name 
					FROM vtiger_crmentity INNER JOIN $this->table_name ON vtiger_crmentity.crmid=$this->table_name.$this->table_index";

		if(!empty($this->customFieldTable)) {
			$query .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index"; 
		}

		$query .= " LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";
		$query .= " LEFT JOIN vtiger_users ON vtiger_crmentity.smownerid = vtiger_users.id and vtiger_users.status='Active'";
		
		$linkedModulesQuery = $this->db->pquery("SELECT distinct fieldname, columnname, relmodule FROM vtiger_field" .
				" INNER JOIN vtiger_fieldmodulerel ON vtiger_fieldmodulerel.fieldid = vtiger_field.fieldid" .
				" WHERE uitype='10' AND vtiger_fieldmodulerel.module=?", array($thismodule));
		$linkedFieldsCount = $this->db->num_rows($linkedModulesQuery);

		for($i=0; $i<$linkedFieldsCount; $i++) {
			$related_module = $this->db->query_result($linkedModulesQuery, $i, 'relmodule');
			$fieldname = $this->db->query_result($linkedModulesQuery, $i, 'fieldname');
			$columnname = $this->db->query_result($linkedModulesQuery, $i, 'columnname');
			
			$other = CRMEntity::getInstance($related_module);
			vtlib_setup_modulevars($related_module, $other);
			
			$query .= " LEFT JOIN $other->table_name ON $other->table_name.$other->table_index = $this->table_name.$columnname";
		}

		$query .= $this->getNonAdminAccessControlQuery($thismodule,$current_user);
		$where_auto = " vtiger_crmentity.deleted=0";

		if($where != '') $query .= " WHERE ($where) AND $where_auto";
		else $query .= " WHERE $where_auto";

		return $query;
	}

	/**
	 * Initialize this instance for importing.
	 */
	function initImport($module) {
		$this->db = PearDatabase::getInstance();
		$this->initImportableFields($module);
	}

	/**
	 * Create list query to be shown at the last step of the import.
	 * Called From: modules/Import/UserLastImport.php
	 */
	function create_import_query($module) {
		global $current_user;
		$query = "SELECT vtiger_crmentity.crmid, case when (vtiger_users.user_name not like '') then vtiger_users.user_name else vtiger_groups.groupname end as user_name, $this->table_name.* FROM $this->table_name
			INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index
			LEFT JOIN vtiger_users_last_import ON vtiger_users_last_import.bean_id=vtiger_crmentity.crmid
			LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid
			LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid
			WHERE vtiger_users_last_import.assigned_user_id='$current_user->id'
			AND vtiger_users_last_import.bean_type='$module'
			AND vtiger_users_last_import.deleted=0";
		return $query;
	}

	/**
	 * Delete the last imported records.
	 */
	function undo_import($module, $user_id) {
		global $adb;
		$count = 0;
		$query1 = "select bean_id from vtiger_users_last_import where assigned_user_id=? AND bean_type='$module' AND deleted=0";
		$result1 = $adb->pquery($query1, array($user_id)) or die("Error getting last import for undo: ".mysql_error()); 
		while ( $row1 = $adb->fetchByAssoc($result1))
		{
			$query2 = "update vtiger_crmentity set deleted=1 where crmid=?";
			$result2 = $adb->pquery($query2, array($row1['bean_id'])) or die("Error undoing last import: ".mysql_error()); 
			$count++;			
		}
		return $count;
	}
	
	/**
	 * Transform the value while exporting
	 */
	function transform_export_value($key, $value) {
		return parent::transform_export_value($key, $value);
	}

	/**
	 * Function which will set the assigned user id for import record.
	 */
	function set_import_assigned_user()
	{
		global $current_user, $adb;
		$record_user = $this->column_fields["assigned_user_id"];
		
		if($record_user != $current_user->id){
			$sqlresult = $adb->pquery("select id from vtiger_users where id = ? union select groupid as id from vtiger_groups where groupid = ?", array($record_user, $record_user));
			if($this->db->num_rows($sqlresult)!= 1) {
				$this->column_fields["assigned_user_id"] = $current_user->id;
			} else {			
				$row = $adb->fetchByAssoc($sqlresult, -1, false);
				if (isset($row['id']) && $row['id'] != -1) {
					$this->column_fields["assigned_user_id"] = $row['id'];
				} else {
					$this->column_fields["assigned_user_id"] = $current_user->id;
				}
			}
		}
	}
	
	/** 
	 * Function which will give the basic query to find duplicates
	 */
	function getDuplicatesQuery($module,$table_cols,$field_values,$ui_type_arr,$select_cols='') {
		$select_clause = "SELECT ". $this->table_name .".".$this->table_index ." AS recordid, vtiger_users_last_import.deleted,".$table_cols;

		// Select Custom Field Table Columns if present
		if(isset($this->customFieldTable)) $query .= ", " . $this->customFieldTable[0] . ".* ";

		$from_clause = " FROM $this->table_name";

		$from_clause .= "	INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index";

		// Consider custom table join as well.
		if(isset($this->customFieldTable)) {
			$from_clause .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index"; 
		}
		$from_clause .= " LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid
						LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";
		
		$where_clause = "	WHERE vtiger_crmentity.deleted = 0";
		$where_clause .= $this->getListViewSecurityParameter($module);
					
		if (isset($select_cols) && trim($select_cols) != '') {
			$sub_query = "SELECT $select_cols FROM  $this->table_name AS t " .
				" INNER JOIN vtiger_crmentity AS crm ON crm.crmid = t.".$this->table_index;
			// Consider custom table join as well.
			if(isset($this->customFieldTable)) {
				$sub_query .= " LEFT JOIN ".$this->customFieldTable[0]." tcf ON tcf.".$this->customFieldTable[1]." = t.$this->table_index";
			}
			$sub_query .= " WHERE crm.deleted=0 GROUP BY $select_cols HAVING COUNT(*)>1";	
		} else {
			$sub_query = "SELECT $table_cols $from_clause $where_clause GROUP BY $table_cols HAVING COUNT(*)>1";
		}	
		
		
		$query = $select_clause . $from_clause .
					" LEFT JOIN vtiger_users_last_import ON vtiger_users_last_import.bean_id=" . $this->table_name .".".$this->table_index .
					" INNER JOIN (" . $sub_query . ") AS temp ON ".get_on_clause($field_values,$ui_type_arr,$module) .
					$where_clause .
					" ORDER BY $table_cols,". $this->table_name .".".$this->table_index ." ASC";
					
		return $query;		
	}

	/**
	 * Invoked when special actions are performed on the module.
	 * @param String Module name
	 * @param String Event Type (module.postinstall, module.disabled, module.enabled, module.preuninstall)
	 */
	function vtlib_handler($modulename, $event_type) {
		if($event_type == 'module.postinstall') {
			// TODO Handle post installation actions
		} else if($event_type == 'module.disabled') {
			// TODO Handle actions when this module is disabled.
		} else if($event_type == 'module.enabled') {
			// TODO Handle actions when this module is enabled.
		} else if($event_type == 'module.preuninstall') {
			// TODO Handle actions when this module is about to be deleted.
		} else if($event_type == 'module.preupdate') {
			// TODO Handle actions before this module is updated.
		} else if($event_type == 'module.postupdate') {
			// TODO Handle actions after this module is updated.
		}
	}

	/** 
	 * Handle saving related module information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	// function save_related_module($module, $crmid, $with_module, $with_crmid) { }
	
	/**
	 * Handle deleting related module information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function delete_related_module($module, $crmid, $with_module, $with_crmid) { }

	/**
	 * Handle getting related list information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function get_related_list($id, $cur_tab_id, $rel_tab_id, $actions=false) { }

	/**
	 * Handle getting dependents list information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function get_dependents_list($id, $cur_tab_id, $rel_tab_id, $actions=false) { }

	// Presenta una tabla con información previa a la reconstrucción.
	function tabla_reconstruccion($codigo)
	{
		global $adb;

		//$rec_id = $this->obtener_id();

		$contador_color = 0;
		$i = 1;

		$tabla = "<table style=\"width:100%;\">";
		$tabla .= "<tr>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Código";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "RM";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "KDX (RM)";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "AFR";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "KDX (AFR)";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "BFR";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "KDX (BFR)";
		$tabla .= "</th>";
		$tabla .= "</tr>";

/***********************
		$consulta = "select c1.codigo, c1.sum_cantidad as cant_rmd, c2.sum_cantidad as cant_kdx from
(select prod.productcode as codigo, sum(rmd.cantidad) as sum_cantidad from vtiger_recepciones_mercancia_det rmd, vtiger_crmentity e, vtiger_recepciones_mercancia rm, vtiger_products prod where e.crmid = rmd.recepciones_mercancia_detid and e.deleted = '0' and rm.recepciones_mercanciaid = rmd.recepciones_mercanciaid and prod.productid = rmd.productid group by rmd.productid) as c1
left join
(select kdx.codigo, sum(kdx.entradas) as sum_cantidad from vtiger_kardex kdx, vtiger_crmentity e where e.crmid = kdx.kardexid and e.deleted = '0' and kdx.tipo_documento = 'Recepción de mercancía' group by kdx.codigo) as c2
on c2.codigo collate utf8_general_ci = c1.codigo collate utf8_general_ci order by c1.codigo";
*************************/
		$consulta = "select c1.codigo, c1.sum_cantidad as cant_rmd, c2.sum_cantidad as kdx_rmd, c3.sum_cantidad as cant_afr, c4.sum_cantidad as kdx_afr, c5.sum_cantidad as cant_bfr, c6.sum_cantidad as kdx_bfr from
(select prod.productcode as codigo, sum(rmd.cantidad) as sum_cantidad from vtiger_recepciones_mercancia_det rmd, vtiger_crmentity e, vtiger_recepciones_mercancia rm, vtiger_products prod where e.crmid = rmd.recepciones_mercancia_detid and e.deleted = '0' and rm.recepciones_mercanciaid = rmd.recepciones_mercanciaid and prod.productid = rmd.productid group by rmd.productid) as c1
left join
(select kdx.codigo, sum(kdx.entradas) as sum_cantidad from vtiger_kardex kdx, vtiger_crmentity e where e.crmid = kdx.kardexid and e.deleted = '0' and kdx.tipo_documento = 'Recepción de mercancía' group by kdx.codigo) as c2
on c2.codigo collate utf8_general_ci = c1.codigo collate utf8_general_ci
left join
(select prod.productcode as codigo, sum(afr.cantidad) as sum_cantidad from vtiger_altas_flota_renta afr, vtiger_crmentity e, vtiger_products prod where e.crmid = afr.altas_flota_rentaid and e.deleted = '0' and prod.productid = afr.productid group by afr.productid) as c3
on c3.codigo collate utf8_general_ci = c1.codigo collate utf8_general_ci
left join
(select kdx.codigo, sum(kdx.salidas) as sum_cantidad from vtiger_kardex kdx, vtiger_crmentity e where e.crmid = kdx.kardexid and e.deleted = '0' and kdx.tipo_documento = 'Alta a flota de renta' and kdx.salidas > 0 group by kdx.codigo) as c4
on c4.codigo collate utf8_general_ci = c1.codigo collate utf8_general_ci
left join
(select prod.productcode as codigo, sum(bfr.cantidad) as sum_cantidad from vtiger_bajas_flota_renta bfr, vtiger_crmentity e, vtiger_flota_renta flr, vtiger_products prod where e.crmid = bfr.bajas_flota_rentaid and e.deleted = '0' and flr.flota_rentaid = bfr.flota_rentaid and prod.productid = flr.productid group by flr.productid) as c5
on c5.codigo collate utf8_general_ci = c1.codigo collate utf8_general_ci
left join
(select kdx.codigo, sum(kdx.entradas) as sum_cantidad from vtiger_kardex kdx, vtiger_crmentity e where e.crmid = kdx.kardexid and e.deleted = '0' and kdx.tipo_documento = 'Baja de flota de renta' and kdx.entradas > 0 group by kdx.codigo) as c6
on c6.codigo collate utf8_general_ci = c1.codigo collate utf8_general_ci
order by c1.codigo";
//var_dump($consulta);
		$resultado = $adb->query($consulta);
		while ($renglon = $adb->fetch_array($resultado))
		{
/****************
echo "<pre>";
var_dump($renglon);
echo "</pre>";
die;
****************/
			$codigo = $renglon["codigo"];
			$cant_rmd = $renglon["cant_rmd"];
			//$cant_kdx = $renglon["cant_kdx"];
			$kdx_rmd = $renglon["kdx_rmd"];
			$cant_afr = $renglon["cant_afr"];
			$kdx_afr = $renglon["kdx_afr"];
			$cant_bfr = $renglon["cant_bfr"];
			$kdx_bfr = $renglon["kdx_bfr"];

			$color = ($contador_color % 2)?"#eee":"#fec";
			//$color = ($contador_color % 2)?"#eee":"#eef";

			//if ($cant_rmd != $cant_kdx)
			if ($cant_rmd != $kdx_rmd)
			{
				$color = "#fdd";
			}

			if ($cant_afr != $kdx_afr)
			{
				$color = "#fdd";
			}

			if ($cant_bfr != $kdx_bfr)
			{
				$color = "#fdd";
			}

			$tabla .= "<tr style=\"background:$color;\">";
			$tabla .= "<td style=\"text-align:right;\">";
			$tabla .= "$i.";
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;\">";
			$tabla .= "<a href=\"index.php?module=Reconstruccion&action=producto&c=$codigo\">";
			$tabla .= $codigo;
			$tabla .= "</a>";
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;text-align:right;\">";
			$tabla .= $cant_rmd;
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;text-align:right;\">";
			$tabla .= $kdx_rmd;
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;text-align:right;\">";
			$tabla .= $cant_afr;
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;text-align:right;\">";
			$tabla .= $kdx_afr;
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;text-align:right;\">";
			$tabla .= $cant_bfr;
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;text-align:right;\">";
			$tabla .= $kdx_bfr;
			$tabla .= "</td>";
			$tabla .= "</tr>";

			$contador_color++;
			$i++;
		}

		$tabla .= "</table>";

		return $tabla;
	}

	// Presenta una tabla con el desglose de movimientos por código de producto previa a la reconstrucción.
	function tabla_producto($codigo)
	{
		global $adb;

		//$rec_id = $this->obtener_id();

		$contador_color = 0;
		$i = 1;

		$tabla = "<table style=\"width:100%;\">";
		$tabla .= "<tr>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\" colspan=\"4\">";
		$tabla .= "Recepciones de mercancía";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\" colspan=\"3\">";
		$tabla .= "Kardex";
		$tabla .= "</th>";
		$tabla .= "</tr>";
		$tabla .= "<tr>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Folio";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Cantidad";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Fecha efectiva";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Hora";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Folio";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Movimiento";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Cantidad";
		$tabla .= "</th>";
		$tabla .= "</tr>";

		$consulta1 = "select rm.recepciones_mercanciaid, rm.folio, sum(rmd.cantidad), rm.fecha_efectiva, rm.hora from vtiger_recepciones_mercancia_det rmd, vtiger_crmentity e, vtiger_recepciones_mercancia rm, vtiger_products prod where e.crmid = rmd.recepciones_mercancia_detid and e.deleted = '0' and rm.recepciones_mercanciaid = rmd.recepciones_mercanciaid and prod.productid = rmd.productid and prod.productcode = '$codigo' group by rm.folio";

		$consulta2 = "select kdx.idv, kdx.movimiento as folio, kdx.entradas as cantidad from vtiger_kardex kdx, vtiger_crmentity e where e.crmid = kdx.kardexid and e.deleted = '0' and kdx.tipo_documento = 'Recepción de mercancía' and kdx.codigo = '$codigo'";

		$campos = "*";
		$condiciones = "c2.folio = c1.folio";

		$consulta = "select $campos from ($consulta1) as c1 left join ($consulta2) as c2 on $condiciones union select $campos from ($consulta1) as c1 right join ($consulta2) as c2 on $condiciones";
//var_dump($consulta);

		$resultado = $adb->query($consulta);
		while ($renglon = $adb->fetch_array($resultado))
		{
/****************
echo "<pre>";
var_dump($renglon);
echo "</pre>";
die;
****************/
			$rm_id = $renglon[0];
			$rm_folio = $renglon[1];
			$rmd_cantidad = $renglon[2];
			$rm_fecha_efectiva = $renglon[3];
			$rm_hora = $renglon[4];
			$kdx_folio = $renglon[5];
			$kdx_movimiento = $renglon[6];
			$kdx_cantidad = $renglon[7];

			$color = ($contador_color % 2)?"#eee":"#fec";
			//$color = ($contador_color % 2)?"#eee":"#eef";

			if ($rmd_cantidad != $kdx_cantidad)
			{
				$color = "#fdd";
			}

			$tabla .= "<tr style=\"background:$color;\">";
			$tabla .= "<td style=\"text-align:right;\">";
			$tabla .= "$i.";
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;\">";
			$tabla .= "<a href=\"index.php?module=Recepciones_mercancia&action=DetailView&record=$rm_id\">";
			$tabla .= $rm_folio;
			$tabla .= "</a>";
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;text-align:right\">";
			$tabla .= $rmd_cantidad;
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;\">";
			$tabla .= $rm_fecha_efectiva;
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;\">";
			$tabla .= $rm_hora;
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;\">";
			$tabla .= $kdx_folio;
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;\">";
			$tabla .= $kdx_movimiento;
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;text-align:right\">";
			$tabla .= $kdx_cantidad;
			$tabla .= "</td>";
			$tabla .= "</tr>";

			$contador_color++;
			$i++;
		}

		$tabla .= "</table>";

		return $tabla;
	}

	// Devuelve una tabla con un análisis de integridad de las tablas de los módulos
	// vs CRME.
	function integridad_crme()
	{
		$rec_id = $this->obtener_id();
	
		global $adb;
	
		$contador_color = 0;
		$i = 1;
	
		$tabla = "<table style=\"width:100%;\">";
		$tabla .= "<tr>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Módulo";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "En tabla";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Correctos";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Incongruentes";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Nulos";
		$tabla .= "</th>";
		$tabla .= "</tr>";

		$archivo = file("modules/Reconstruccion/integridad_crme.txt");
	
		foreach ($archivo as $renglon_archivo)
		{
/*********************
			if ($renglon_archivo == "")
			{
				continue;
			}
echo "<pre>";
var_dump($renglon);
echo "</pre>";
die;
var_dump($renglon_archivo);
echo "<hr>";
****************/
			$consulta = $renglon_archivo;
			$resultado = $adb->query($consulta);
			$renglon = $adb->fetch_array($resultado);

			$modulo = $renglon["modulo"];
			$cantidad = $renglon["cantidad"];

			$informacion[$modulo][] = $cantidad;
		}

		foreach ($informacion as $modulo => $cantidades)
		{
			$en_tabla = $cantidades[0];
			$correctos = $cantidades[1];
			$incongruentes = $cantidades[2];
			$nulos = $cantidades[3];

			$color = ($contador_color % 2)?"#eee":"#fec";
			//$color = ($contador_color % 2)?"#eee":"#eef";
	
			$tabla .= "<tr style=\"background:$color;\">";
			$tabla .= "<td style=\"text-align:right;\">";
			$tabla .= "$i.";
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;\">";
			$tabla .= $modulo;
			$tabla .= "</td>";
			$tabla .= "<td style=\"text-align:right;\">";
			$tabla .= $en_tabla;
			$tabla .= "</td>";
			$tabla .= "<td style=\"text-align:right;\">";
			$tabla .= $correctos;
			$tabla .= "</td>";
			$tabla .= "<td style=\"text-align:right;\">";
			$tabla .= $incongruentes;
			$tabla .= "</td>";
			$tabla .= "<td style=\"text-align:right;\">";
			$tabla .= $nulos;
			$tabla .= "</td>";
			$tabla .= "</tr>";
	
			$contador_color++;
			$i++;
		}
	
		$tabla .= "</table>";
	
		return $tabla;
	}

	// Corrige incongruencias de integridad de las tablas de los módulos vs CRME.
	function corregir_crme()
	{
		$rec_id = $this->obtener_id();
	
		global $adb;

		$archivo = file("modules/Reconstruccion/corregir_crme.txt");
	
		foreach ($archivo as $renglon_archivo)
		{
/*********************
echo "<pre>";
var_dump($renglon);
echo "</pre>";
die;
var_dump($renglon_archivo);
echo "<hr>";
****************/
			$consulta = $renglon_archivo;
			$resultado = $adb->query($consulta);
		}
	}

	// Devuelve una tabla con la inspección de un código.
	function rep_consulta($parametros)
	{
		$rec_id = $this->obtener_id();
	
		global $adb;
	
		$consulta = $parametros["consulta"];
		$resultado = $adb->query($consulta);
		$i = 0;
		$contador_color = 0;
		while ($renglon = $adb->fetch_array($resultado))
		{
			$color = ($contador_color % 2)?"#eee":"#fec";
			//$color = ($contador_color % 2)?"#eee":"#eef";

			$i++;
			if ($i == 1)
			{
				$numero_columnas = count($renglon) / 2;

				$tabla = "<table style=\"width:100%;\">";
				$tabla .= "<tr>";
				$tabla .= "<th class=\"dvInnerHeader\">";
				$tabla .= "</th>";
				foreach ($renglon as $indice => $columna)
				{
					if (is_numeric($indice))
					{
						continue;
					}
					$tabla .= "<th class=\"dvInnerHeader\">";
					$tabla .= $indice;
					$tabla .= "</th>";
				}
				$tabla .= "</tr>";
			}

			$tabla .= "<tr style=\"background:$color;\">";
			$tabla .= "<td>";
			$tabla .= "$i.";
			$tabla .= "</td>";
			foreach ($renglon as $indice => $columna)
			{
				if (is_numeric($indice))
				{
					continue;
				}
				$tabla .= "<td>";
				$tabla .= $columna;
				$tabla .= "</td>";
			}
			$tabla .= "</tr>";

			$contador_color++;
		}

		if ($i > 0)
		{
			$tabla .= "</table>";
		}

		return $tabla;
	}

	// Genera un reporte de periodos a partir de las remisiones de una obra y un artículo.
	function rep_periodos($parametros = array())
	{
		require("modules/Reconstruccion/fns/rep_periodos.php");
		return $html;
	}

	// Reconstruye los periodos según los parámetros.
	function periodos($parametros = array())
	{
		// Pasos:
		// Hace una copia de izquierda a derecha de lo calculado a lo existente.
		// Borra duplicados.
		// Genera restantes.
		// Elimina desligados.

		global $adb;

		// Hace una copia de izquierda a derecha de lo calculado a lo existente.
		require("modules/Reconstruccion/bd/periodos_vars.php");
vd($consulta);
		require("modules/Reconstruccion/bd/periodos_reconstruir.php");
vd($parametros);
//vd($consulta);
//vd($consulta, true);
		$resultado = $adb->query($consulta) or die(mysql_error()."<hr><pre>$consulta</pre><hr>");
	}
}
?>
