<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/
require_once('data/CRMEntity.php');
require_once('data/Tracker.php');
require_once("modules/Notas_credito_prov_det/Notas_credito_prov_det.php");
require_once("modules/Numeros_serie/Numeros_serie.php");
require_once("modules/Sucursales/Sucursales.php");
require_once("modules/Products/Products.php");

class Notas_credito_proveedor extends CRMEntity {
	var $db, $log; // Used in class functions of CRMEntity

	var $table_name = 'vtiger_notas_credito_proveedor';
	var $table_index= 'notas_credito_proveedorid';
	var $column_fields = Array();

	/** Indicator if this is a custom module or standard module */
	var $IsCustomModule = true;

	/**
	 * Mandatory table for supporting custom fields.
	 */
	var $customFieldTable = Array('vtiger_notas_credito_proveedorcf', 'notas_credito_proveedorid');

	/**
	 * Mandatory for Saving, Include tables related to this module.
	 */
	var $tab_name = Array('vtiger_crmentity', 'vtiger_notas_credito_proveedor', 'vtiger_notas_credito_proveedorcf');

	/**
	 * Mandatory for Saving, Include tablename and tablekey columnname here.
	 */
	var $tab_name_index = Array(
		'vtiger_crmentity' => 'crmid',
		'vtiger_notas_credito_proveedor'   => 'notas_credito_proveedorid',
	    'vtiger_notas_credito_proveedorcf' => 'notas_credito_proveedorid');

	/**
	 * Mandatory for Listing (Related listview)
	 */
	var $list_fields = Array (
		/* Format: Field Label => Array(tablename, columnname) */
		// tablename should not have prefix 'vtiger_'
		'Notas_credito_proveedor Name'=> Array('notas_credito_proveedor', ''),
		'Assigned To' => Array('crmentity','smownerid')
	);
	var $list_fields_name = Array(
		/* Format: Field Label => fieldname */
		'Notas_credito_proveedor Name'=> '',
		'Assigned To' => 'assigned_user_id'
	);

	// Make the field link to detail view from list view (Fieldname)
	var $list_link_field = '';

	// For Popup listview and UI type support
	var $search_fields = Array(
		/* Format: Field Label => Array(tablename, columnname) */
		// tablename should not have prefix 'vtiger_'
		'Notas_credito_proveedor Name'=> Array('notas_credito_proveedor', '')
	);
	var $search_fields_name = Array(
		/* Format: Field Label => fieldname */
		'Notas_credito_proveedor Name'=> ''
	);

	// For Popup window record selection
	var $popup_fields = Array('');

	// Placeholder for sort fields - All the fields will be initialized for Sorting through initSortFields
	var $sortby_fields = Array();

	// For Alphabetical search
	var $def_basicsearch_col = '';

	// Column value to use on detail view record text display
	var $def_detailview_recname = '';

	// Required Information for enabling Import feature
	var $required_fields = Array(''=>1);

	// Callback function list during Importing
	var $special_functions = Array('set_import_assigned_user');

	var $default_order_by = '';
	var $default_sort_order='ASC';
	// Used when enabling/disabling the mandatory fields for the module.
	// Refers to vtiger_field.fieldname values.
	var $mandatory_fields = Array('createdtime', 'modifiedtime', '');
	
	function __construct() {
		global $log, $currentModule;
		$this->column_fields = getColumnFields($currentModule);
		$this->db = PearDatabase::getInstance();
		$this->log = $log;
	}

	function getSortOrder() {
		global $currentModule;

		$sortorder = $this->default_sort_order;
		if($_REQUEST['sorder']) $sortorder = $this->db->sql_escape_string($_REQUEST['sorder']);
		else if($_SESSION[$currentModule.'_Sort_Order']) 
			$sortorder = $_SESSION[$currentModule.'_Sort_Order'];

		return $sortorder;
	}

	function getOrderBy() {
		global $currentModule;
		
		$use_default_order_by = '';		
		if(PerformancePrefs::getBoolean('LISTVIEW_DEFAULT_SORTING', true)) {
			$use_default_order_by = $this->default_order_by;
		}
		
		$orderby = $use_default_order_by;
		if($_REQUEST['order_by']) $orderby = $this->db->sql_escape_string($_REQUEST['order_by']);
		else if($_SESSION[$currentModule.'_Order_By'])
			$orderby = $_SESSION[$currentModule.'_Order_By'];
		return $orderby;
	}

	function save_module($module) {
	}

	/**
	 * Return query to use based on given modulename, fieldname
	 * Useful to handle specific case handling for Popup
	 */
	function getQueryByModuleField($module, $fieldname, $srcrecord, $query='') {
		// $srcrecord could be empty
	}

	/**
	 * Get list view query (send more WHERE clause condition if required)
	 */
	function getListQuery($module, $usewhere='') {
		$query = "SELECT vtiger_crmentity.*, $this->table_name.*";
		
		// Keep track of tables joined to avoid duplicates
		$joinedTables = array();

		// Select Custom Field Table Columns if present
		if(!empty($this->customFieldTable)) $query .= ", " . $this->customFieldTable[0] . ".* ";

		$query .= " FROM $this->table_name";

		$query .= "	INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index";

		$joinedTables[] = $this->table_name;
		$joinedTables[] = 'vtiger_crmentity';
		
		// Consider custom table join as well.
		if(!empty($this->customFieldTable)) {
			$query .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index";
			$joinedTables[] = $this->customFieldTable[0]; 
		}
		$query .= " LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid";
		$query .= " LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";

		$joinedTables[] = 'vtiger_users';
		$joinedTables[] = 'vtiger_groups';
		
		$linkedModulesQuery = $this->db->pquery("SELECT distinct fieldname, columnname, relmodule FROM vtiger_field" .
				" INNER JOIN vtiger_fieldmodulerel ON vtiger_fieldmodulerel.fieldid = vtiger_field.fieldid" .
				" WHERE uitype='10' AND vtiger_fieldmodulerel.module=?", array($module));
		$linkedFieldsCount = $this->db->num_rows($linkedModulesQuery);
		
		for($i=0; $i<$linkedFieldsCount; $i++) {
			$related_module = $this->db->query_result($linkedModulesQuery, $i, 'relmodule');
			$fieldname = $this->db->query_result($linkedModulesQuery, $i, 'fieldname');
			$columnname = $this->db->query_result($linkedModulesQuery, $i, 'columnname');
			
			$other =  CRMEntity::getInstance($related_module);
			vtlib_setup_modulevars($related_module, $other);
			
			if(!in_array($other->table_name, $joinedTables)) {
				$query .= " LEFT JOIN $other->table_name ON $other->table_name.$other->table_index = $this->table_name.$columnname";
				$joinedTables[] = $other->table_name;
			}
		}

		global $current_user;
		$query .= $this->getNonAdminAccessControlQuery($module,$current_user);
		$query .= "	WHERE vtiger_crmentity.deleted = 0 ".$usewhere;
		return $query;
	}

	/**
	 * Apply security restriction (sharing privilege) query part for List view.
	 */
	function getListViewSecurityParameter($module) {
		global $current_user;
		require('user_privileges/user_privileges_'.$current_user->id.'.php');
		require('user_privileges/sharing_privileges_'.$current_user->id.'.php');

		$sec_query = '';
		$tabid = getTabid($module);

		if($is_admin==false && $profileGlobalPermission[1] == 1 && $profileGlobalPermission[2] == 1 
			&& $defaultOrgSharingPermission[$tabid] == 3) {

				$sec_query .= " AND (vtiger_crmentity.smownerid in($current_user->id) OR vtiger_crmentity.smownerid IN 
					(
						SELECT vtiger_user2role.userid FROM vtiger_user2role 
						INNER JOIN vtiger_users ON vtiger_users.id=vtiger_user2role.userid 
						INNER JOIN vtiger_role ON vtiger_role.roleid=vtiger_user2role.roleid 
						WHERE vtiger_role.parentrole LIKE '".$current_user_parent_role_seq."::%'
					) 
					OR vtiger_crmentity.smownerid IN 
					(
						SELECT shareduserid FROM vtiger_tmp_read_user_sharing_per 
						WHERE userid=".$current_user->id." AND tabid=".$tabid."
					) 
					OR 
						(";
		
					// Build the query based on the group association of current user.
					if(sizeof($current_user_groups) > 0) {
						$sec_query .= " vtiger_groups.groupid IN (". implode(",", $current_user_groups) .") OR ";
					}
					$sec_query .= " vtiger_groups.groupid IN 
						(
							SELECT vtiger_tmp_read_group_sharing_per.sharedgroupid 
							FROM vtiger_tmp_read_group_sharing_per
							WHERE userid=".$current_user->id." and tabid=".$tabid."
						)";
				$sec_query .= ")
				)";
		}
		return $sec_query;
	}

	/**
	 * Create query to export the records.
	 */
	function create_export_query($where)
	{
		global $current_user;
		$thismodule = $_REQUEST['module'];
		
		include("include/utils/ExportUtils.php");

		//To get the Permitted fields query and the permitted fields list
		$sql = getPermittedFieldsQuery($thismodule, "detail_view");
		
		$fields_list = getFieldsListFromQuery($sql);

		$query = "SELECT $fields_list, vtiger_users.user_name AS user_name 
					FROM vtiger_crmentity INNER JOIN $this->table_name ON vtiger_crmentity.crmid=$this->table_name.$this->table_index";

		if(!empty($this->customFieldTable)) {
			$query .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index"; 
		}

		$query .= " LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";
		$query .= " LEFT JOIN vtiger_users ON vtiger_crmentity.smownerid = vtiger_users.id and vtiger_users.status='Active'";
		
		$linkedModulesQuery = $this->db->pquery("SELECT distinct fieldname, columnname, relmodule FROM vtiger_field" .
				" INNER JOIN vtiger_fieldmodulerel ON vtiger_fieldmodulerel.fieldid = vtiger_field.fieldid" .
				" WHERE uitype='10' AND vtiger_fieldmodulerel.module=?", array($thismodule));
		$linkedFieldsCount = $this->db->num_rows($linkedModulesQuery);

		for($i=0; $i<$linkedFieldsCount; $i++) {
			$related_module = $this->db->query_result($linkedModulesQuery, $i, 'relmodule');
			$fieldname = $this->db->query_result($linkedModulesQuery, $i, 'fieldname');
			$columnname = $this->db->query_result($linkedModulesQuery, $i, 'columnname');
			
			$other = CRMEntity::getInstance($related_module);
			vtlib_setup_modulevars($related_module, $other);
			
			$query .= " LEFT JOIN $other->table_name ON $other->table_name.$other->table_index = $this->table_name.$columnname";
		}

		$query .= $this->getNonAdminAccessControlQuery($thismodule,$current_user);
		$where_auto = " vtiger_crmentity.deleted=0";

		if($where != '') $query .= " WHERE ($where) AND $where_auto";
		else $query .= " WHERE $where_auto";

		return $query;
	}

	/**
	 * Initialize this instance for importing.
	 */
	function initImport($module) {
		$this->db = PearDatabase::getInstance();
		$this->initImportableFields($module);
	}

	/**
	 * Create list query to be shown at the last step of the import.
	 * Called From: modules/Import/UserLastImport.php
	 */
	function create_import_query($module) {
		global $current_user;
		$query = "SELECT vtiger_crmentity.crmid, case when (vtiger_users.user_name not like '') then vtiger_users.user_name else vtiger_groups.groupname end as user_name, $this->table_name.* FROM $this->table_name
			INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index
			LEFT JOIN vtiger_users_last_import ON vtiger_users_last_import.bean_id=vtiger_crmentity.crmid
			LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid
			LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid
			WHERE vtiger_users_last_import.assigned_user_id='$current_user->id'
			AND vtiger_users_last_import.bean_type='$module'
			AND vtiger_users_last_import.deleted=0";
		return $query;
	}

	/**
	 * Delete the last imported records.
	 */
	function undo_import($module, $user_id) {
		global $adb;
		$count = 0;
		$query1 = "select bean_id from vtiger_users_last_import where assigned_user_id=? AND bean_type='$module' AND deleted=0";
		$result1 = $adb->pquery($query1, array($user_id)) or die("Error getting last import for undo: ".mysql_error()); 
		while ( $row1 = $adb->fetchByAssoc($result1))
		{
			$query2 = "update vtiger_crmentity set deleted=1 where crmid=?";
			$result2 = $adb->pquery($query2, array($row1['bean_id'])) or die("Error undoing last import: ".mysql_error()); 
			$count++;			
		}
		return $count;
	}
	
	/**
	 * Transform the value while exporting
	 */
	function transform_export_value($key, $value) {
		return parent::transform_export_value($key, $value);
	}

	/**
	 * Function which will set the assigned user id for import record.
	 */
	function set_import_assigned_user()
	{
		global $current_user, $adb;
		$record_user = $this->column_fields["assigned_user_id"];
		
		if($record_user != $current_user->id){
			$sqlresult = $adb->pquery("select id from vtiger_users where id = ? union select groupid as id from vtiger_groups where groupid = ?", array($record_user, $record_user));
			if($this->db->num_rows($sqlresult)!= 1) {
				$this->column_fields["assigned_user_id"] = $current_user->id;
			} else {			
				$row = $adb->fetchByAssoc($sqlresult, -1, false);
				if (isset($row['id']) && $row['id'] != -1) {
					$this->column_fields["assigned_user_id"] = $row['id'];
				} else {
					$this->column_fields["assigned_user_id"] = $current_user->id;
				}
			}
		}
	}
	
	/** 
	 * Function which will give the basic query to find duplicates
	 */
	function getDuplicatesQuery($module,$table_cols,$field_values,$ui_type_arr,$select_cols='') {
		$select_clause = "SELECT ". $this->table_name .".".$this->table_index ." AS recordid, vtiger_users_last_import.deleted,".$table_cols;

		// Select Custom Field Table Columns if present
		if(isset($this->customFieldTable)) $query .= ", " . $this->customFieldTable[0] . ".* ";

		$from_clause = " FROM $this->table_name";

		$from_clause .= "	INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index";

		// Consider custom table join as well.
		if(isset($this->customFieldTable)) {
			$from_clause .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index"; 
		}
		$from_clause .= " LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid
						LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";
		
		$where_clause = "	WHERE vtiger_crmentity.deleted = 0";
		$where_clause .= $this->getListViewSecurityParameter($module);
					
		if (isset($select_cols) && trim($select_cols) != '') {
			$sub_query = "SELECT $select_cols FROM  $this->table_name AS t " .
				" INNER JOIN vtiger_crmentity AS crm ON crm.crmid = t.".$this->table_index;
			// Consider custom table join as well.
			if(isset($this->customFieldTable)) {
				$sub_query .= " LEFT JOIN ".$this->customFieldTable[0]." tcf ON tcf.".$this->customFieldTable[1]." = t.$this->table_index";
			}
			$sub_query .= " WHERE crm.deleted=0 GROUP BY $select_cols HAVING COUNT(*)>1";	
		} else {
			$sub_query = "SELECT $table_cols $from_clause $where_clause GROUP BY $table_cols HAVING COUNT(*)>1";
		}	
		
		
		$query = $select_clause . $from_clause .
					" LEFT JOIN vtiger_users_last_import ON vtiger_users_last_import.bean_id=" . $this->table_name .".".$this->table_index .
					" INNER JOIN (" . $sub_query . ") AS temp ON ".get_on_clause($field_values,$ui_type_arr,$module) .
					$where_clause .
					" ORDER BY $table_cols,". $this->table_name .".".$this->table_index ." ASC";
					
		return $query;		
	}

	/**
	 * Invoked when special actions are performed on the module.
	 * @param String Module name
	 * @param String Event Type (module.postinstall, module.disabled, module.enabled, module.preuninstall)
	 */
	function vtlib_handler($modulename, $event_type) {
		if($event_type == 'module.postinstall') {
			// TODO Handle post installation actions
		} else if($event_type == 'module.disabled') {
			// TODO Handle actions when this module is disabled.
		} else if($event_type == 'module.enabled') {
			// TODO Handle actions when this module is enabled.
		} else if($event_type == 'module.preuninstall') {
			// TODO Handle actions when this module is about to be deleted.
		} else if($event_type == 'module.preupdate') {
			// TODO Handle actions before this module is updated.
		} else if($event_type == 'module.postupdate') {
			// TODO Handle actions after this module is updated.
		}
	}

	/** 
	 * Handle saving related module information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	// function save_related_module($module, $crmid, $with_module, $with_crmid) { }
	
	/**
	 * Handle deleting related module information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function delete_related_module($module, $crmid, $with_module, $with_crmid) { }

	/**
	 * Handle getting related list information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function get_related_list($id, $cur_tab_id, $rel_tab_id, $actions=false) { }

	/**
	 * Handle getting dependents list information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function get_dependents_list($id, $cur_tab_id, $rel_tab_id, $actions=false) { }


// Genera tabla de detalles.
function tabla_detalles($modo_captura = false)
{
	$ncp_id = $this->obtener_id();
	$desglose_ns = json_decode(html_entity_decode($this->column_fields["desglose_ns"], ENT_QUOTES, "UTF-8"), true);
//var_dump($desglose_ns);

	global $adb;

	$contador_color = 0;
	$i = 1;

	$tabla = "<table style=\"width:100%;\">";
	$tabla .= "<tr>";
	$tabla .= "<th class=\"dvInnerHeader\">";
	$tabla .= "</th>";
	//$tabla .= "<th class=\"dvInnerHeader\">";
	//$tabla .= "Folio";
	//$tabla .= "</th>";
	//$tabla .= "<th class=\"dvInnerHeader\">";
	//$tabla .= "Nota de cr&eacute;dito de proveedor";
	//$tabla .= "</th>";
	$tabla .= "<th class=\"dvInnerHeader\">";
	$tabla .= "Cantidad";
	$tabla .= "</th>";
	//$tabla .= "<th class=\"dvInnerHeader\">";
	$tabla .= "<th colspan=\"2\" class=\"dvInnerHeader\">";
	$tabla .= "Producto";
	$tabla .= "</th>";
	$tabla .= "<th class=\"dvInnerHeader\">";
	$tabla .= "Costo unitario";
	$tabla .= "</th>";
	$tabla .= "<th class=\"dvInnerHeader\">";
	$tabla .= "Costo";
	$tabla .= "</th>";
	//$tabla .= "<th class=\"dvInnerHeader\">";
	//$tabla .= "Surtido";
	//$tabla .= "</th>";
	//$tabla .= "<th class=\"dvInnerHeader\">";
	//$tabla .= "Recepciones_mercancia_det";
	//$tabla .= "</th>";
	$tabla .= "</tr>";

	$consulta = "select ncpd.*, prod.productname from vtiger_notas_credito_prov_det ncpd, vtiger_crmentity e, vtiger_products prod where e.crmid = ncpd.notas_credito_prov_detid and e.deleted = '0' and ncpd.notas_credito_proveedorid = '$ncp_id' and prod.productid = ncpd.productid";
//var_dump($consulta);
	$resultado = $adb->query($consulta);
	while ($renglon = $adb->fetch_array($resultado))
	{
//echo "<pre>";
//var_dump($renglon);
//echo "</pre>";
//die;
		$ncpd_id = $renglon["notas_credito_prov_detid"];
		$ncpd_folio = $renglon["folio"];
		$ncpd_nota_credito_proveedor = $renglon["nota_credito_proveedor"];
		$ncpd_producto = $renglon["productid"];
		$ncpd_cantidad = $renglon["cantidad"];
		$ncpd_costo = $renglon["costo"];
		$ncpd_surtido = $renglon["surtido"];
		$ncpd_rmd = $renglon["rmd"];
		$ncpd_desglose_costos_ns = $renglon["desglose_costos_ns"];
		$prod_nombre = $renglon["productname"];
		$prod_id = $renglon["productid"];

		$desglose_costos_ns = json_decode(html_entity_decode($ncpd_desglose_costos_ns, ENT_QUOTES, "UTF-8"), true);
//var_dump($desglose_costos_ns);
		$color = ($contador_color % 2)?"#eee":"#fec";

		if (!$modo_captura && $ncpd_cantidad == 0)
		{
			continue;
		}

		$tabla .= "<tr style=\"background:$color;\">";
		$tabla .= "<td style=\"text-align:right;\">";
		$tabla .= "$i.";
		$tabla .= "</td>";
		//$tabla .= "<td style=\"padding:0px 8px;\">";
		//$tabla .= $ncpd_folio;
		//$tabla .= "</td>";
		//$tabla .= "<td style=\"padding:0px 8px;\">";
		//$tabla .= $ncpd_nota_credito_proveedor;
		//$tabla .= "</td>";

		//if ($modo_captura)
		$cuantos = $this->cuantos_ns($prod_id);
		if ($modo_captura && $cuantos == 0)
		{
			$tabla .= "<td style=\"padding:0px 8px;text-align:center;\">";
			$tabla .= "<input type=\"text\" name=\"captura[cantidades][$prod_id][$ncpd_id]\" value=\"$ncpd_cantidad\" style=\"width:50px;text-align:right;\">";
			$tabla .= "</td>";
		}
		else
		{
			$tabla .= "<td style=\"padding:0px 8px;text-align:right;\">";
			$tabla .= $ncpd_cantidad;
			$tabla .= "</td>";
		}
		//$tabla .= "<td style=\"padding:0px 8px;\">";
		$tabla .= "<td colspan=\"2\" style=\"padding:0px 8px;\">";
		$tabla .= $prod_nombre;
		$tabla .= "</td>";
		if ($cuantos == 0)
		{
			if ($modo_captura)
			{
				$tabla .= "<td style=\"padding:0px 8px;text-align:center;\">";
				$tabla .= "<input type=\"text\" name=\"captura[costos][$prod_id][$ncpd_id]\" value=\"$ncpd_costo\" style=\"width:50px;text-align:right;\">";
				$tabla .= "</td>";
			}
			else
			{
				$tabla .= "<td style=\"padding:0px 8px;text-align:right;\">";
				$tabla .= number_format($ncpd_costo, 2);
				$tabla .= "</td>";
			}
			$tabla .= "<td style=\"padding:0px 8px;text-align:right;\">";
			$tabla .= number_format($ncpd_cantidad * $ncpd_costo, 2);
			$tabla .= "</td>";
		}
		else
		{
			$tabla .= "<td style=\"padding:0px 8px;text-align:right;\">";
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;text-align:right;\">";
			if ($ncpd_cantidad > 0)
			{
				$tabla .= number_format($ncpd_costo, 2);
			}
			$tabla .= "</td>";
		}
		//$tabla .= "<td style=\"padding:0px 8px;\">";
		//$tabla .= $ncpd_surtido;
		//$tabla .= "</td>";
		//$tabla .= "<td style=\"padding:0px 8px;\">";
		//$tabla .= $ncpd_rmd;
		//$tabla .= "</td>";
		$tabla .= "</tr>";

		$contador_color++;
		$i++;

		//if (is_array($desglose_ns[$prod_id]))
		if (is_array($desglose_ns[$prod_id]) && !$modo_captura)
		{
			$tabla .= "<tr>";
			$tabla .= "<th>";
			$tabla .= "</th>";
			$tabla .= "<th>";
			$tabla .= "</th>";
			$tabla .= "<th>";
			$tabla .= "Número de serie";
			$tabla .= "</th>";
			$tabla .= "<th>";
			$tabla .= "Número de motor";
			$tabla .= "</th>";
			$tabla .= "</tr>";

			foreach ($desglose_ns[$prod_id] as $ns_id)
			{
				if ($ns_id != "")
				{
					$ns = new Numeros_serie;
					$ns->retrieve_entity_info($ns_id, "Numeros_serie");
					$tabla .= "<tr>";
					$tabla .= "<td>";
					$tabla .= "</td>";
					$tabla .= "<td>";
					$tabla .= "</td>";
					$tabla .= "<td>";
					$tabla .= $ns->column_fields["numero_serie"];
					$tabla .= "</td>";
					$tabla .= "<td>";
					$tabla .= $ns->column_fields["motor"];
					$tabla .= "</td>";
					$tabla .= "<td style=\"text-align:right;\">";
					if ($desglose_costos_ns[$prod_id][$ns_id] != "")
					{
						$tabla .= number_format($desglose_costos_ns[$prod_id][$ns_id], 2);
					}
					else
					{
						$tabla .= number_format($ns->column_fields["costo"], 2);
					}
					$tabla .= "</td>";
					$tabla .= "</tr>";
				}
			}
		}
	}

	$tabla .= "</table>";

	return $tabla;
}

	// Genera tabla de números de serie.
	function tabla_ns()
	{
		$ncp_id = $this->obtener_id();
		$rm_id = $this->column_fields["recepcion_mercancia"];
		$desglose_ns = json_decode(html_entity_decode($this->column_fields["desglose_ns"], ENT_QUOTES, "UTF-8"), true);
//var_dump($desglose_ns);
	
		global $adb;
	
		$contador_color = 0;
		$i = 1;
	
		$tabla = "<table style=\"width:100%;\">";
		$tabla .= "<tr>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "</th>";
		//$tabla .= "<th class=\"dvInnerHeader\">";
		//$tabla .= "Folio";
		//$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "N&uacute;mero de serie";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Producto";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "N&uacute;mero interno";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "N&uacute;mero interno del proveedor";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "N&uacute;mero de motor";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Estado";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Costo";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Moneda";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Tipo de cambio";
		$tabla .= "</th>";
		//$tabla .= "<th class=\"dvInnerHeader\">";
		//$tabla .= "Recepci&oacute;n de mercanc&iacute;a";
		//$tabla .= "</th>";
		//$tabla .= "<th class=\"dvInnerHeader\">";
		//$tabla .= "Consecutivo de este producto";
		//$tabla .= "</th>";
		$tabla .= "</tr>";
	
		//$consulta = "select ns.* from vtiger_numeros_serie ns, vtiger_crmentity e where e.crmid = ns.numeros_serieid and e.deleted = '0' and ns.recepciones_mercanciaid = '$rm_id'";
		//$consulta = "select ns.*, prod.productname from vtiger_numeros_serie ns, vtiger_crmentity e, vtiger_products prod where e.crmid = ns.numeros_serieid and e.deleted = '0' and ns.recepciones_mercanciaid = '$rm_id' and prod.productid = ns.productid";
		$consulta = "select ncpd.desglose_costos_ns, ns.*, prod.productname from vtiger_numeros_serie ns, vtiger_crmentity e, vtiger_products prod, vtiger_notas_credito_prov_det ncpd, vtiger_crmentity e2 where e.crmid = ns.numeros_serieid and e.deleted = '0' and ns.recepciones_mercanciaid = '$rm_id' and prod.productid = ns.productid and e2.crmid = ncpd.notas_credito_prov_detid and e2.deleted = '0' and ncpd.notas_credito_proveedorid = '$ncp_id' and ncpd.productid = ns.productid";
//var_dump($consulta);
//die;
		$resultado = $adb->query($consulta);
		while ($renglon = $adb->fetch_array($resultado))
		{
	//echo "<pre>";
	//var_dump($renglon);
	//echo "</pre>";
	//die;
			$ns_id = $renglon["numeros_serieid"];
			$ns_folio = $renglon["folio"];
			$ns_numero_serie = $renglon["numero_serie"];
			$ns_producto = $renglon["producto"];
			$ns_numero_interno = $renglon["numero_interno"];
			$ns_numero_interno_proveedor = $renglon["numero_interno_proveedor"];
			$ns_motor = $renglon["motor"];
			$ns_estado = $renglon["estado"];
			$ns_costo = $renglon["costo"];
			$ns_moneda = $renglon["moneda"];
			$ns_tipo_cambio = $renglon["tipo_cambio"];
			$ns_recepcion_mercancia = $renglon["recepcion_mercancia"];
			$ns_consecutivo_producto = $renglon["consecutivo_producto"];
			$prod_nombre = $renglon["productname"];
			$prod_id = $renglon["productid"];

			$desglose_costos_ns = json_decode(html_entity_decode($renglon["desglose_costos_ns"], ENT_QUOTES, "UTF-8"), true);
//var_dump($desglose_costos_ns);

			$color = ($contador_color % 2)?"#eee":"#fec";

			$permitido = false;
			$color_texto = "#888";

			if ($ns_estado == "Nuevo" || $ns_estado == "Usado")
			{
				$permitido = true;
				$color_texto = "black";
			}
	
			$tabla .= "<tr style=\"background:$color;color:$color_texto;\">";
			$tabla .= "<td style=\"text-align:right;\">";
			if ($permitido)
			{
				//$tabla .= "<input type=\"checkbox\" name=\"captura[ns][$ns_id]\" value=\"1\">";
				$marcado = (in_array($ns_id, $desglose_ns[$prod_id]))?" checked":"";
				$tabla .= "<input type=\"checkbox\" name=\"captura[ns][$prod_id][$ns_id]\" value=\"1\"$marcado>";
			}
			$tabla .= "</td>";
			$tabla .= "<td style=\"text-align:right;\">";
			$tabla .= "$i.";
			$tabla .= "</td>";
			//$tabla .= "<td style=\"padding:0px 8px;\">";
			//$tabla .= $ns_folio;
			//$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;\">";
			$tabla .= $ns_numero_serie;
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;\">";
			//$tabla .= $ns_producto;
			$tabla .= $prod_nombre;
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;\">";
			$tabla .= $ns_numero_interno;
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;\">";
			$tabla .= $ns_numero_interno_proveedor;
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;\">";
			$tabla .= $ns_motor;
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;\">";
			$tabla .= $ns_estado;
			$tabla .= "</td>";
			//$tabla .= "<td style=\"padding:0px 8px;\">";
			//$tabla .= $ns_costo;
			//$tabla .= "</td>";
//var_dump($desglose_costos_ns[$prod_id][$ns_id]);
			$tabla .= "<td style=\"padding:0px 8px;text-align:center;\">";
			if ($desglose_costos_ns[$prod_id][$ns_id] != "")
			{
				$tabla .= "<input type=\"text\" name=\"captura[costos_ns][$prod_id][$ns_id]\" value=\"".$desglose_costos_ns[$prod_id][$ns_id]."\" style=\"width:50px;text-align:right;\">";
			}
			else
			{
				$tabla .= "<input type=\"text\" name=\"captura[costos_ns][$prod_id][$ns_id]\" value=\"$ns_costo\" style=\"width:50px;text-align:right;\">";
			}
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;\">";
			$tabla .= $ns_moneda;
			$tabla .= "</td>";
			$tabla .= "<td style=\"padding:0px 8px;\">";
			$tabla .= $ns_tipo_cambio;
			$tabla .= "</td>";
			//$tabla .= "<td style=\"padding:0px 8px;\">";
			//$tabla .= $ns_recepcion_mercancia;
			//$tabla .= "</td>";
			//$tabla .= "<td style=\"padding:0px 8px;\">";
			//$tabla .= $ns_consecutivo_producto;
			//$tabla .= "</td>";
			$tabla .= "</tr>";
	
			$contador_color++;
			$i++;
		}
	
		$tabla .= "</table>";
	
		return $tabla;
	}

	// Registra el detalle de números de serie de la ncp.
	function registrar_detalles($cantidades = array(), $costos = array(), $ns = array(), $costos_ns = array())
	{
		global $adb;

		$ncp_id = $this->obtener_id();

		// Inicializa cantidades y costos.
		//$consulta = "update vtiger_notas_credito_prov_det ncpd, vtiger_crmentity e set ncpd.cantidad = '0' where e.crmid = ncpd.notas_credito_prov_detid and e.deleted = '0' and ncpd.notas_credito_proveedorid = '$ncp_id'";
		$consulta = "update vtiger_notas_credito_prov_det ncpd, vtiger_crmentity e set ncpd.cantidad = '0', ncpd.costo = '0' where e.crmid = ncpd.notas_credito_prov_detid and e.deleted = '0' and ncpd.notas_credito_proveedorid = '$ncp_id'";
//var_dump($consulta);
//die;
		$adb->query($consulta);

//var_dump($ns);
		//$json_ns = json_encode($ns);
//var_dump($json_ns);
//var_dump(json_decode($json_ns, true));
		foreach ($cantidades as $prod_id => $valores)
		{
			foreach ($valores as $ncpd_id => $cantidad)
			{
				$consulta = "update vtiger_notas_credito_prov_det ncpd, vtiger_crmentity e set ncpd.cantidad = '$cantidad' where e.crmid = ncpd.notas_credito_prov_detid and e.deleted = '0' and ncpd.notas_credito_prov_detid = '$ncpd_id'";
//var_dump($consulta);
//die;
				$adb->query($consulta);
			}
		}


		foreach ($costos as $prod_id => $valores)
		{
			foreach ($valores as $ncpd_id => $costo)
			{
				$consulta = "update vtiger_notas_credito_prov_det ncpd, vtiger_crmentity e set ncpd.costo = '$costo' where e.crmid = ncpd.notas_credito_prov_detid and e.deleted = '0' and ncpd.notas_credito_prov_detid = '$ncpd_id'";
//var_dump($consulta);
//die;
				$adb->query($consulta);
			}
		}


		foreach ($ns as $prod_id => $valores)
		{
			$cantidad = 0;
			$costo = 0;

			foreach ($valores as $ns_id => $valor)
			{
				$arreglo_ns[$prod_id][] = $ns_id;

				if ($ns_id != "")
				{
					//$ns = new Numeros_serie;
					//$ns->retrieve_entity_info($ns_id, "Numeros_serie");

					$cantidad++;
					//$costo += $ns->column_fields["costo"];
					$costo += $costos_ns[$prod_id][$ns_id];
				}
			}

			$json_costos_ns = json_encode($costos_ns);

			//$consulta = "update vtiger_notas_credito_prov_det ncpd, vtiger_crmentity e set ncpd.cantidad = '$cantidad', ncpd.costo = '$costo' where e.crmid = ncpd.notas_credito_prov_detid and e.deleted = '0' and ncpd.notas_credito_proveedorid = '$ncp_id' and ncpd.productid = '$prod_id'";
			$consulta = "update vtiger_notas_credito_prov_det ncpd, vtiger_crmentity e set ncpd.cantidad = '$cantidad', ncpd.costo = '$costo', ncpd.desglose_costos_ns = '$json_costos_ns' where e.crmid = ncpd.notas_credito_prov_detid and e.deleted = '0' and ncpd.notas_credito_proveedorid = '$ncp_id' and ncpd.productid = '$prod_id'";
			$adb->query($consulta);
		}
//var_dump($arreglo_ns);
		$json_ns = json_encode($arreglo_ns);

		$consulta = "update vtiger_notas_credito_proveedor ncp set ncp.desglose_ns = '$json_ns' where ncp.notas_credito_proveedorid = '$ncp_id'";
		$adb->query($consulta);
	}

	// Emite la nota de crédito de proveedor.
	function emitir()
	{
		global $adb;

		$ncp_id = $this->obtener_id();
		$rm_id = $this->column_fields["recepcion_mercancia"];

		$suc_id = $this->column_fields["sucursal"];
		if ($suc_id == "")
		{
			die ("<h1>ERROR</h1>Esta nota de crédito de proveedor no está asignada a ninguna sucursal.");
		}

		$suc = new Sucursales;
		$suc->retrieve_entity_info($suc_id, "Sucursales");

		// Marca la nota como emitida y bloqueada.
		$consulta = "update vtiger_notas_credito_proveedor set ncp_estado = 'Emitida' where notas_credito_proveedorid = '$ncp_id'";
		$adb->query($consulta);
		$this->bloquear("notas_credito_proveedor");

		// Actualiza totales.
		//$this->totales();

		// Hace un barrido del detalle de la nota de crédito de proveedor.
		//$consulta = "select ncpd.* from vtiger_notas_credito_prov_det ncpd, vtiger_crmentity e where e.crmid = ncpd.notas_credito_prov_detid and e.deleted = '0' and ncpd.notas_credito_proveedorid = '$ncp_id'";
		//$consulta = "select ncpd.*, prod.productname, prod.productcode from vtiger_notas_credito_prov_det ncpd, vtiger_crmentity e, vtiger_products prod where e.crmid = ncpd.notas_credito_prov_detid and e.deleted = '0' and ncpd.notas_credito_proveedorid = '$ncp_id' and prod.productid = ncpd.productid";
		$consulta = "select sum(ncpd.cantidad) as sum_cantidad, ncpd.*, prod.productname, prod.productcode from vtiger_notas_credito_prov_det ncpd, vtiger_crmentity e, vtiger_products prod where e.crmid = ncpd.notas_credito_prov_detid and e.deleted = '0' and ncpd.notas_credito_proveedorid = '$ncp_id' and prod.productid = ncpd.productid group by ncpd.productid";
//var_dump($consulta);
//die;
		$resultado = $adb->query($consulta);
		while ($renglon = $adb->fetch_array($resultado))
		{
//var_dump($renglon["idv"]);

			$ncpd_id = $renglon["notas_credito_prov_detid"];
			$ncpd_folio = $renglon["folio"];
			$ncpd_nota_credito_proveedor = $renglon["nota_credito_proveedor"];
			$ncpd_producto = $renglon["productid"];
			$ncpd_cantidad = $renglon["cantidad"];
			$ncpd_costo = $renglon["costo"];
			$ncpd_surtido = $renglon["surtido"];
			$ncpd_rmd = $renglon["rmd"];
			$prod_nombre = $renglon["productname"];
			$prod_id = $renglon["productid"];
			$prod_codigo = $renglon["productcode"];
			$sum_cantidad = $renglon["sum_cantidad"];

			if ($prod_id == "")
			{
				die ("<h1>ERROR</h1>El registro $ncpd_folio no tiene asignado un producto.");
			}

			$prod = new Products;
			$prod->retrieve_entity_info($prod_id, "Products");

			$alm_id = $prod->obtener_almacen($suc_id);

			// Registra en kardex y existencias.

			$cuantos = $this->cuantos_ns($prod_id);
			if ($cuantos == 0)
			{
				unset($parametros);
				$parametros["sucursal"] = $this->column_fields["sucursal"];
				$parametros["almacen"] = $alm_id;
				$parametros["tipo_documento"] = "Nota de crédito de proveedor";
				$parametros["folio"] = $this->column_fields["folio"];
				$parametros["fecha"] = $this->column_fields["fecha_efectiva"];
				$parametros["producto"] = $prod_id;
				$parametros["codigo_articulo"] = $prod_codigo;
				$parametros["entradas"] = 0;
				//$parametros["salidas"] = $ncpd_cantidad;
				$parametros["salidas"] = $sum_cantidad;
/***********************
echo "<pre>";
var_dump($parametros);
echo "</pre>";
*********************/
				$this->kardex($parametros);
			}
			else
			{
				$consulta = "select ns.estado, count(ns.numeros_serieid) as cuantos from vtiger_numeros_serie ns, vtiger_crmentity e where e.crmid = ns.numeros_serieid and e.deleted = '0' and ns.recepciones_mercanciaid = '$rm_id' and ns.productid = '$prod_id' and ns.estado in ('Nuevo', 'Usado') group by ns.estado";
//var_dump($consulta);
				$resultado = $adb->query($consulta);
				while ($renglon = $adb->fetch_array($resultado))
				{
					$cuantos = (int)$renglon["cuantos"];
					$ns_estado = $renglon["estado"];

					unset($parametros);
					$parametros["sucursal"] = $this->column_fields["sucursal"];
					$parametros["almacen"] = ($ns_estado == "Usado")?$suc->column_fields["almacen_usado"]:$alm_id;
					$parametros["tipo_documento"] = "Nota de crédito de proveedor";
					$parametros["folio"] = $this->column_fields["folio"];
					$parametros["fecha"] = $this->column_fields["fecha_efectiva"];
					$parametros["producto"] = $prod_id;
					$parametros["codigo_articulo"] = $prod_codigo;
					$parametros["entradas"] = 0;
					$parametros["salidas"] = $ncpd_cantidad;
/***********************
echo "<pre>";
var_dump($parametros);
echo "</pre>";
*********************/
					$this->kardex($parametros);
				}
			}
		}

		$desglose_ns = json_decode(html_entity_decode($this->column_fields["desglose_ns"], ENT_QUOTES, "UTF-8"), true);

/*************
echo "<pre>";
var_dump($desglose_ns);
echo "</pre>";
*************/

		foreach ($desglose_ns as $prod_id => $valores)
		{
			foreach ($valores as $ns_id)
			{
//var_dump($ns_id);
				$arreglo_ns[] = "'$ns_id'";
			}
		}
		$lista_ns = implode(",", $arreglo_ns);

		$consulta = "update vtiger_numeros_serie ns set ns.estado = 'NCP', ns.notas_credito_proveedorid = '$ncp_id' where ns.numeros_serieid in ($lista_ns)";
var_dump($consulta);
		$adb->query($consulta);
//die;
	}


	// Detecta cuántos números de serie de este producto están registrados en la recepción de mercancía correspondiente.
	function cuantos_ns($prod_id)
	{
		$ncp_id = $this->obtener_id();
		$rm_id = $this->column_fields["recepcion_mercancia"];

		global $adb;

		$consulta = "select count(ns.numeros_serieid) as cuantos from vtiger_numeros_serie ns, vtiger_crmentity e where e.crmid = ns.numeros_serieid and e.deleted = '0' and ns.recepciones_mercanciaid = '$rm_id' and ns.productid = '$prod_id'";
//var_dump($consulta);
		$resultado = $adb->query($consulta);
		$renglon = $adb->fetch_array($resultado);

		$cuantos = (int)$renglon["cuantos"];

//var_dump($cuantos);
		return $cuantos;
	}
}
?>
