<?php
//var_dump($sucursal, $origen, $destino, $obra, $cantidad, $documento);
global $adb, $current_user;

$id_flota = $this->obtener_id();

// Revisa si este artículo se maneja individual o agrupado. Si es individual se maneja un solo registro de flota y si es agrupado se maneja un registro por cada estado y obra.
$producto = new Products;
$producto->retrieve_entity_info($this->column_fields["producto"], "Products");
$individual = $producto->individual();

if ($individual)
{
	$this->column_fields["estado"] = $destino;

	// Ajusta cliente y obra según corresponda.
	if ($destino == "En obra")
	{
		$obr = new Obras;
		$obr->retrieve_entity_info($obra, "Obras");

		$this->column_fields["cliente"] = $obr->column_fields["cliente"];
		$this->column_fields["obra"] = $obra;
	}
	else
	{
		// Obtiene la sucursal.
		$suc = new Sucursales;
		$suc->retrieve_entity_info($sucursal, "Sucursales");

		$this->column_fields["cliente"] = $suc->column_fields["cliente_mks"];
		$this->column_fields["obra"] = $suc->column_fields["obra_mks"];
	}
	$this->save("Flota_renta", $id_flota);

	// Ajusta estado del número de serie si corresponde hacerlo.
	if(($this->column_fields["numero_serie"] != "") && (($destino == "Usado") || ($destino == "Vendido")))
	{
		$ns = new Numeros_serie;
		$ns->retrieve_entity_info($this->column_fields["numero_serie"], "Numeros_serie");
		$ns->estado($destino);
	}
}
else
{
	// Transfiere cierta cantidad de un artículo de la flota de un estado a otro y equilibra los diferentes registros (disponible, obra o servicio) para que sean congruentes con la existencia de ese código.

	// Obtiene los registros de flota involucrados (disponible, obra y servicio).
	$registros_flr = $this->registros_flota($obra);
//var_dump($registros_flr);

	// Obtiene las instancias de flota correspondientes. Las crea si no existen.
	$flr_origen = new Flota_renta;
	if ($registros_flr[$origen] == "")
	{
		$this->inicializar($sucursal, $origen, $obra);
		$registros_flr = $this->registros_flota($obra);
	}
	$flr_origen->retrieve_entity_info($registros_flr[$origen], "Flota_renta");

	$flr_destino = new Flota_renta;
	if ($registros_flr[$destino] == "")
	{
		$this->inicializar($sucursal, $destino, $obra);
		$registros_flr = $this->registros_flota($obra);
	}
	$flr_destino->retrieve_entity_info($registros_flr[$destino], "Flota_renta");

	// Transfiere la cantidad.
	$flr_origen->detalle($documento, $cantidad * -1);
	$flr_origen->actualizar_cantidad();
	$flr_destino->detalle($documento, $cantidad);
	$flr_destino->actualizar_cantidad();
}
?>
