<?php
/*********************************************************************************
 * The contents of this file are subject to the SugarCRM Public License Version 1.1.2
 * ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.sugarcrm.com/SPL
 * Software distributed under the License is distributed on an  "AS IS"  basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
 * the specific language governing rights and limitations under the License.
 * The Original Code is:  SugarCRM Open Source
 * The Initial Developer of the Original Code is SugarCRM, Inc.
 * Portions created by SugarCRM are Copyright (C) SugarCRM, Inc.;
 * All Rights Reserved.
 * Contributor(s): ______________________________________.
 ********************************************************************************/
/*********************************************************************************
 * $Header: /advent/projects/wesat/vtiger_crm/vtigercrm/data/CRMEntity.php,v 1.16 2005/04/29 04:21:31 mickie Exp $
 * Description:  Defines the base class for all data entities used throughout the
 * application.  The base class including its methods and variables is designed to
 * be overloaded with module-specific methods and variables particular to the
 * module's base entity class.
 ********************************************************************************/

include_once('config.php');
require_once('include/logging.php');
require_once('data/Tracker.php');
require_once('include/utils/utils.php');
require_once('include/utils/UserInfoUtil.php');
require_once("include/Zend/Json.php");
// Ideas WWW.
require_once("modules/Kardex/Kardex.php");
require_once("modules/Existencias/Existencias.php");
require_once("modules/Flota_renta/Flota_renta.php");
require_once("modules/Numeros_serie/Numeros_serie.php");
require_once("modules/Accounts/Accounts.php");
require_once("modules/Periodos/Periodos.php");
require_once("modules/Ordenes_trabajo/Ordenes_trabajo.php");
require_once("modules/Parametros/Parametros.php");
require_once("modules/Products/Products.php");
require_once("modules/Obras/Obras.php");
// Ideas WWW.

class CRMEntity {

	var $ownedby;

	/**
	 * Detect if we are in bulk save mode, where some features can be turned-off
	 * to improve performance.
	 */
	static function isBulkSaveMode() {
		global $VTIGER_BULK_SAVE_MODE;
		if (isset($VTIGER_BULK_SAVE_MODE) && $VTIGER_BULK_SAVE_MODE) {
			return true;
		}
		return false;
	}

	static function getInstance($module) {
		$modName = $module;
		if ($module == 'Calendar' || $module == 'Events') {
			$module = 'Calendar';
			$modName = 'Activity';
		}
		// File access security check
		if (!class_exists($modName)) {
			checkFileAccessForInclusion("modules/$module/$modName.php");
			require_once("modules/$module/$modName.php");
		}
		$focus = new $modName();
		return $focus;
	}

	function saveentity($module, $fileid = '') {
		global $current_user, $adb; //$adb added by raju for mass mailing
		$insertion_mode = $this->mode;

		$columnFields = $this->column_fields;
		$anyValue = false;
		foreach ($columnFields as $value) {
			if(!empty($value)) {
				$anyValue = true;
				break;
			}
		}
		if(!$anyValue) {
			die("<center>" .getTranslatedString('LBL_MANDATORY_FIELD_MISSING')."</center>");
		}

		$this->db->println("TRANS saveentity starts $module");
		$this->db->startTransaction();


		foreach ($this->tab_name as $table_name) {

			if ($table_name == "vtiger_crmentity") {
				$this->insertIntoCrmEntity($module, $fileid);
			} else {
				$this->insertIntoEntityTable($table_name, $module, $fileid);
			}
		}

		//Calling the Module specific save code
		$this->save_module($module);

		$this->db->completeTransaction();
		$this->db->println("TRANS saveentity ends");

		// vtlib customization: Hook provide to enable generic module relation.
		if ($_REQUEST['createmode'] == 'link') {
			$for_module = vtlib_purify($_REQUEST['return_module']);
			$for_crmid = vtlib_purify($_REQUEST['return_id']);
			$with_module = $module;
			$with_crmid = $this->id;

			$on_focus = CRMEntity::getInstance($for_module);

			if ($for_module && $for_crmid && $with_module && $with_crmid) {
				relateEntities($on_focus, $for_module, $for_crmid, $with_module, $with_crmid);
			}
		}
		// END
	}

	function insertIntoAttachment1($id, $module, $filedata, $filename, $filesize, $filetype, $user_id) {
		$date_var = date("Y-m-d H:i:s");
		global $current_user;
		global $adb;
		//global $root_directory;
		global $log;

		$ownerid = $user_id;

		if ($filesize != 0) {
			$data = base64_encode(fread(fopen($filedata, "r"), $filesize));
		}

		$current_id = $adb->getUniqueID("vtiger_crmentity");

		if ($module == 'Emails') {
			$log->info("module is " . $module);
			$idname = 'emailid';
			$tablename = 'emails';
			$descname = 'description';
		} else {
			$idname = 'notesid';
			$tablename = 'notes';
			$descname = 'notecontent';
		}

		$sql = "update $tablename set filename=? where $idname=?";
		$params = array($filename, $id);
		$adb->pquery($sql, $params);

		$sql1 = "insert into vtiger_crmentity (crmid,smcreatorid,smownerid,setype,description,createdtime,modifiedtime) values(?, ?, ?, ?, ?, ?, ?)";
		$params1 = array($current_id, $current_user->id, $ownerid, $module . " Attachment", '', $adb->formatDate($date_var, true), $adb->formatDate($date_var, true));
		$adb->pquery($sql1, $params1);

		$sql2 = "insert into vtiger_attachments(attachmentsid, name, description, type) values(?, ?, ?, ?)";
		$params2 = array($current_id, $filename, '', $filetype);
		$result = $adb->pquery($sql2, $params2);

		//TODO -- instead of put contents in db now we should store the file in harddisk

		$sql3 = 'insert into vtiger_seattachmentsrel values(?, ?)';
		$params3 = array($id, $current_id);
		$adb->pquery($sql3, $params3);
	}

	/**
	 *      This function is used to upload the attachment in the server and save that attachment information in db.
	 *      @param int $id  - entity id to which the file to be uploaded
	 *      @param string $module  - the current module name
	 *      @param array $file_details  - array which contains the file information(name, type, size, tmp_name and error)
	 *      return void
	 */
	function uploadAndSaveFile($id, $module, $file_details) {
		global $log;
		$log->debug("Entering into uploadAndSaveFile($id,$module,$file_details) method.");

		global $adb, $current_user;
		global $upload_badext;

		$date_var = date("Y-m-d H:i:s");

		//to get the owner id
		$ownerid = $this->column_fields['assigned_user_id'];
		if (!isset($ownerid) || $ownerid == '')
			$ownerid = $current_user->id;

		if (isset($file_details['original_name']) && $file_details['original_name'] != null) {
			$file_name = $file_details['original_name'];
		} else {
			$file_name = $file_details['name'];
		}

		$binFile = sanitizeUploadFileName($file_name, $upload_badext);

		$current_id = $adb->getUniqueID("vtiger_crmentity");

		$filename = ltrim(basename(" " . $binFile)); //allowed filename like UTF-8 characters
		$filetype = $file_details['type'];
		$filesize = $file_details['size'];
		$filetmp_name = $file_details['tmp_name'];

		//get the file path inwhich folder we want to upload the file
		$upload_file_path = decideFilePath();

		//upload the file in server
		$upload_status = move_uploaded_file($filetmp_name, $upload_file_path . $current_id . "_" . $binFile);

		$save_file = 'true';
		//only images are allowed for these modules
		if ($module == 'Contacts' || $module == 'Products') {
			$save_file = validateImageFile($file_details);
		}

		if ($save_file == 'true' && $upload_status == 'true') {
			//This is only to update the attached filename in the vtiger_notes vtiger_table for the Notes module
			if ($module == 'Contacts' || $module == 'Products') {
				$sql1 = "insert into vtiger_crmentity (crmid,smcreatorid,smownerid,setype,description,createdtime,modifiedtime) values(?, ?, ?, ?, ?, ?, ?)";
				$params1 = array($current_id, $current_user->id, $ownerid, $module . " Image", $this->column_fields['description'], $adb->formatDate($date_var, true), $adb->formatDate($date_var, true));
			} else {
				$sql1 = "insert into vtiger_crmentity (crmid,smcreatorid,smownerid,setype,description,createdtime,modifiedtime) values(?, ?, ?, ?, ?, ?, ?)";
				$params1 = array($current_id, $current_user->id, $ownerid, $module . " Attachment", $this->column_fields['description'], $adb->formatDate($date_var, true), $adb->formatDate($date_var, true));
			}
			$adb->pquery($sql1, $params1);

			$sql2 = "insert into vtiger_attachments(attachmentsid, name, description, type, path) values(?, ?, ?, ?, ?)";
			$params2 = array($current_id, $filename, $this->column_fields['description'], $filetype, $upload_file_path);
			$result = $adb->pquery($sql2, $params2);

			if ($_REQUEST['mode'] == 'edit') {
				if ($id != '' && $_REQUEST['fileid'] != '') {
					$delquery = 'delete from vtiger_seattachmentsrel where crmid = ? and attachmentsid = ?';
					$delparams = array($id, $_REQUEST['fileid']);
					$adb->pquery($delquery, $delparams);
				}
			}
			if ($module == 'Documents') {
				$query = "delete from vtiger_seattachmentsrel where crmid = ?";
				$qparams = array($id);
				$adb->pquery($query, $qparams);
			}
			if ($module == 'Contacts') {
				$att_sql = "select vtiger_seattachmentsrel.attachmentsid  from vtiger_seattachmentsrel inner join vtiger_crmentity on vtiger_crmentity.crmid=vtiger_seattachmentsrel.attachmentsid where vtiger_crmentity.setype='Contacts Image' and vtiger_seattachmentsrel.crmid=?";
				$res = $adb->pquery($att_sql, array($id));
				$attachmentsid = $adb->query_result($res, 0, 'attachmentsid');
				if ($attachmentsid != '') {
					$delquery = 'delete from vtiger_seattachmentsrel where crmid=? and attachmentsid=?';
					$adb->pquery($delquery, array($id, $attachmentsid));
					$crm_delquery = "delete from vtiger_crmentity where crmid=?";
					$adb->pquery($crm_delquery, array($attachmentsid));
					$sql5 = 'insert into vtiger_seattachmentsrel values(?,?)';
					$adb->pquery($sql5, array($id, $current_id));
				} else {
					$sql3 = 'insert into vtiger_seattachmentsrel values(?,?)';
					$adb->pquery($sql3, array($id, $current_id));
				}
			} else {
				$sql3 = 'insert into vtiger_seattachmentsrel values(?,?)';
				$adb->pquery($sql3, array($id, $current_id));
			}

			return true;
		} else {
			$log->debug("Skip the save attachment process.");
			return false;
		}
	}

	/** Function to insert values in the vtiger_crmentity for the specified module
	 * @param $module -- module:: Type varchar
	 */
	function insertIntoCrmEntity($module, $fileid = '') {
//echo "<pre>";
//var_dump("función:insertIntoCrmEntity, module:$module, fileid:$fileid");
		global $adb;
		global $current_user;
		global $log;

		if ($fileid != '') {
			$this->id = $fileid;
			$this->mode = 'edit';
		}

		$date_var = date("Y-m-d H:i:s");

		$ownerid = $this->column_fields['assigned_user_id'];

		$sql = "select ownedby from vtiger_tab where name=?";
		$res = $adb->pquery($sql, array($module));
		$this->ownedby = $adb->query_result($res, 0, 'ownedby');

		if ($this->ownedby == 1) {
			$log->info("module is =" . $module);
			$ownerid = $current_user->id;
		}
		// Asha - Change ownerid from '' to null since its an integer field.
		// It is empty for modules like Invoice/Quotes/SO/PO which do not have Assigned to field
		if ($ownerid === '')
			$ownerid = 0;

		if ($module == 'Events') {
			$module = 'Calendar';
		}
		if ($this->mode == 'edit') {
			$description_val = from_html($this->column_fields['description'], ($insertion_mode == 'edit') ? true : false);

			require('user_privileges/user_privileges_' . $current_user->id . '.php');
			$tabid = getTabid($module);
			if ($is_admin == true || $profileGlobalPermission[1] == 0 || $profileGlobalPermission[2] == 0) {
				$sql = "update vtiger_crmentity set smownerid=?,modifiedby=?,description=?, modifiedtime=? where crmid=?";
				$params = array($ownerid, $current_user->id, $description_val, $adb->formatDate($date_var, true), $this->id);
			} else {
				$profileList = getCurrentUserProfileList();
				$perm_qry = "SELECT columnname FROM vtiger_field INNER JOIN vtiger_profile2field ON vtiger_profile2field.fieldid = vtiger_field.fieldid INNER JOIN vtiger_def_org_field ON vtiger_def_org_field.fieldid = vtiger_field.fieldid WHERE vtiger_field.tabid = ? AND vtiger_profile2field.visible = 0 AND vtiger_profile2field.readonly = 0 AND vtiger_profile2field.profileid IN (" . generateQuestionMarks($profileList) . ") AND vtiger_def_org_field.visible = 0 and vtiger_field.tablename='vtiger_crmentity' and vtiger_field.displaytype in (1,3) and vtiger_field.presence in (0,2);";
				$perm_result = $adb->pquery($perm_qry, array($tabid, $profileList));
				$perm_rows = $adb->num_rows($perm_result);
				for ($i = 0; $i < $perm_rows; $i++) {
					$columname[] = $adb->query_result($perm_result, $i, "columnname");
				}
				if (is_array($columname) && in_array("description", $columname)) {
					$sql = "update vtiger_crmentity set smownerid=?,modifiedby=?,description=?, modifiedtime=? where crmid=?";
					$params = array($ownerid, $current_user->id, $description_val, $adb->formatDate($date_var, true), $this->id);
				} else {
					$sql = "update vtiger_crmentity set smownerid=?,modifiedby=?, modifiedtime=? where crmid=?";
					$params = array($ownerid, $current_user->id, $adb->formatDate($date_var, true), $this->id);
				}
			}
			$adb->pquery($sql, $params);
			$sql1 = "delete from vtiger_ownernotify where crmid=?";
			$params1 = array($this->id);
			$adb->pquery($sql1, $params1);
			if ($ownerid != $current_user->id) {
				$sql1 = "insert into vtiger_ownernotify values(?,?,?)";
				$params1 = array($this->id, $ownerid, null);
				$adb->pquery($sql1, $params1);
			}
		} else {
			//if this is the create mode and the group allocation is chosen, then do the following
			$current_id = $adb->getUniqueID("vtiger_crmentity");
			$_REQUEST['currentid'] = $current_id;
			if ($current_user->id == '')
				$current_user->id = 0;


			// Customization
			$created_date_var = $adb->formatDate($date_var, true);
			$modified_date_var = $adb->formatDate($date_var, true);

			// Preserve the timestamp
			if (self::isBulkSaveMode()) {
				if (!empty($this->column_fields['createdtime']))
					$created_date_var = $adb->formatDate($this->column_fields['createdtime'], true);
				//NOTE : modifiedtime ignored to support vtws_sync API track changes.
			}
			// END

			$description_val = from_html($this->column_fields['description'], ($insertion_mode == 'edit') ? true : false);
			$sql = "insert into vtiger_crmentity (crmid,smcreatorid,smownerid,setype,description,modifiedby,createdtime,modifiedtime) values(?,?,?,?,?,?,?,?)";
			$params = array($current_id, $current_user->id, $ownerid, $module, $description_val, $current_user->id, $created_date_var, $modified_date_var);
			$adb->pquery($sql, $params);
			$this->id = $current_id;
		}
//var_dump($sql);
	}

	// Function which returns the value based on result type (array / ADODB ResultSet)
	private function resolve_query_result_value($result, $index, $columnname) {
		global $adb;
		if (is_array($result))
			return $result[$index][$columnname];
		else
			return $adb->query_result($result, $index, $columnname);
	}

	/** Function to insert values in the specifed table for the specified module
	 * @param $table_name -- table name:: Type varchar
	 * @param $module -- module:: Type varchar
	 */
	function insertIntoEntityTable($table_name, $module, $fileid = '') {
		global $log;
		global $current_user, $app_strings;
		$log->info("function insertIntoEntityTable " . $module . ' vtiger_table name ' . $table_name);
		global $adb;
		$insertion_mode = $this->mode;

		//Checkin whether an entry is already is present in the vtiger_table to update
		if ($insertion_mode == 'edit') {
			$tablekey = $this->tab_name_index[$table_name];
			// Make selection on the primary key of the module table to check.
			$check_query = "select $tablekey from $table_name where $tablekey=?";
			$check_result = $adb->pquery($check_query, array($this->id));

			$num_rows = $adb->num_rows($check_result);

			if ($num_rows <= 0) {
				$insertion_mode = '';
			}
		}

		$tabid = getTabid($module);
		if ($module == 'Calendar' && $this->column_fields["activitytype"] != null && $this->column_fields["activitytype"] != 'Task') {
			$tabid = getTabid('Events');
		}
		if ($insertion_mode == 'edit') {
			$update = array();
			$update_params = array();
			require('user_privileges/user_privileges_' . $current_user->id . '.php');
			if ($is_admin == true || $profileGlobalPermission[1] == 0 || $profileGlobalPermission[2] == 0) {
				$sql = "select * from vtiger_field where tabid in (" . generateQuestionMarks($tabid) . ") and tablename=? and displaytype in (1,3) and presence in (0,2) group by columnname";
				$params = array($tabid, $table_name);
			} else {
				$profileList = getCurrentUserProfileList();

				if (count($profileList) > 0) {
					$sql = "SELECT *
			  			FROM vtiger_field
			  			INNER JOIN vtiger_profile2field
			  			ON vtiger_profile2field.fieldid = vtiger_field.fieldid
			  			INNER JOIN vtiger_def_org_field
			  			ON vtiger_def_org_field.fieldid = vtiger_field.fieldid
			  			WHERE vtiger_field.tabid = ?
			  			AND vtiger_profile2field.visible = 0 AND vtiger_profile2field.readonly = 0
			  			AND vtiger_profile2field.profileid IN (" . generateQuestionMarks($profileList) . ")
			  			AND vtiger_def_org_field.visible = 0 and vtiger_field.tablename=? and vtiger_field.displaytype in (1,3) and vtiger_field.presence in (0,2) group by columnname";

					$params = array($tabid, $profileList, $table_name);
				} else {
					$sql = "SELECT *
			  			FROM vtiger_field
			  			INNER JOIN vtiger_profile2field
			  			ON vtiger_profile2field.fieldid = vtiger_field.fieldid
			  			INNER JOIN vtiger_def_org_field
			  			ON vtiger_def_org_field.fieldid = vtiger_field.fieldid
			  			WHERE vtiger_field.tabid = ?
			  			AND vtiger_profile2field.visible = 0 AND vtiger_profile2field.readonly = 0
			  			AND vtiger_def_org_field.visible = 0 and vtiger_field.tablename=? and vtiger_field.displaytype in (1,3) and vtiger_field.presence in (0,2) group by columnname";

					$params = array($tabid, $table_name);
				}
			}
		} else {
			$table_index_column = $this->tab_name_index[$table_name];
			if ($table_index_column == 'id' && $table_name == 'vtiger_users') {
				$currentuser_id = $adb->getUniqueID("vtiger_users");
				$this->id = $currentuser_id;
			}
			$column = array($table_index_column);
			$value = array($this->id);
			$sql = "select * from vtiger_field where tabid=? and tablename=? and displaytype in (1,3,4) and vtiger_field.presence in (0,2)";
			$params = array($tabid, $table_name);
		}

		// Attempt to re-use the quer-result to avoid reading for every save operation
		// TODO Need careful analysis on impact ... MEMORY requirement might be more
		static $_privatecache = array();

		$cachekey = "{$insertion_mode}-" . implode(',', $params);

		if (!isset($_privatecache[$cachekey])) {
			$result = $adb->pquery($sql, $params);
			$noofrows = $adb->num_rows($result);

			if (CRMEntity::isBulkSaveMode()) {
				$cacheresult = array();
				for ($i = 0; $i < $noofrows; ++$i) {
					$cacheresult[] = $adb->fetch_array($result);
				}
				$_privatecache[$cachekey] = $cacheresult;
			}
		} else { // Useful when doing bulk save
			$result = $_privatecache[$cachekey];
			$noofrows = count($result);
		}

		for ($i = 0; $i < $noofrows; $i++) {

			$fieldname = $this->resolve_query_result_value($result, $i, "fieldname");
			$columname = $this->resolve_query_result_value($result, $i, "columnname");
			$uitype = $this->resolve_query_result_value($result, $i, "uitype");
			$generatedtype = $this->resolve_query_result_value($result, $i, "generatedtype");
			$typeofdata = $this->resolve_query_result_value($result, $i, "typeofdata");

			$typeofdata_array = explode("~", $typeofdata);
			$datatype = $typeofdata_array[0];

			$ajaxSave = false;
			if (($_REQUEST['file'] == 'DetailViewAjax' && $_REQUEST['ajxaction'] == 'DETAILVIEW'
						&& isset($_REQUEST["fldName"]) && $_REQUEST["fldName"] != $fieldname)
					|| ($_REQUEST['action'] == 'MassEditSave' && !isset($_REQUEST[$fieldname."_mass_edit_check"]))) {
				$ajaxSave = true;
			}

			if ($uitype == 4 && $insertion_mode != 'edit') {
				$fldvalue = '';
				// Bulk Save Mode: Avoid generation of module sequence number, take care later.
				if (!CRMEntity::isBulkSaveMode())
					$fldvalue = $this->setModuleSeqNumber("increment", $module);
				$this->column_fields[$fieldname] = $fldvalue;
			}
			if (isset($this->column_fields[$fieldname])) {
				if ($uitype == 56) {
					if ($this->column_fields[$fieldname] == 'on' || $this->column_fields[$fieldname] == 1) {
						$fldvalue = '1';
					} else {
						$fldvalue = '0';
					}
				} elseif ($uitype == 15 || $uitype == 16) {

					if ($this->column_fields[$fieldname] == $app_strings['LBL_NOT_ACCESSIBLE']) {

						//If the value in the request is Not Accessible for a picklist, the existing value will be replaced instead of Not Accessible value.
						$sql = "select $columname from  $table_name where " . $this->tab_name_index[$table_name] . "=?";
						$res = $adb->pquery($sql, array($this->id));
						$pick_val = $adb->query_result($res, 0, $columname);
						$fldvalue = $pick_val;
					} else {
						$fldvalue = $this->column_fields[$fieldname];
					}
				} elseif ($uitype == 33) {
					if (is_array($this->column_fields[$fieldname])) {
						$field_list = implode(' |##| ', $this->column_fields[$fieldname]);
					} else {
						$field_list = $this->column_fields[$fieldname];
					}
					$fldvalue = $field_list;
				} elseif ($uitype == 5 || $uitype == 6 || $uitype == 23) {
					//Added to avoid function call getDBInsertDateValue in ajax save
					if (isset($current_user->date_format) && !$ajaxSave) {
						$fldvalue = getValidDBInsertDateValue($this->column_fields[$fieldname]);
					} else {
						$fldvalue = $this->column_fields[$fieldname];
					}
				} elseif ($uitype == 7) {
					//strip out the spaces and commas in numbers if given ie., in amounts there may be ,
					$fldvalue = str_replace(",", "", $this->column_fields[$fieldname]); //trim($this->column_fields[$fieldname],",");
				} elseif ($uitype == 26) {
					if (empty($this->column_fields[$fieldname])) {
						$fldvalue = 1; //the documents will stored in default folder
					} else {
						$fldvalue = $this->column_fields[$fieldname];
					}
				} elseif ($uitype == 28) {
					if ($this->column_fields[$fieldname] == null) {
						$fileQuery = $adb->pquery("SELECT filename from vtiger_notes WHERE notesid = ?", array($this->id));
						$fldvalue = null;
						if (isset($fileQuery)) {
							$rowCount = $adb->num_rows($fileQuery);
							if ($rowCount > 0) {
								$fldvalue = $adb->query_result($fileQuery, 0, 'filename');
							}
						}
					} else {
						$fldvalue = $this->column_fields[$fieldname];
					}
				} elseif ($uitype == 8) {
					$this->column_fields[$fieldname] = rtrim($this->column_fields[$fieldname], ',');
					$ids = explode(',', $this->column_fields[$fieldname]);
					$json = new Zend_Json();
					$fldvalue = $json->encode($ids);
				} elseif ($uitype == 12) {

					// Bulk Sae Mode: Consider the FROM email address as specified, if not lookup
					$fldvalue = $this->column_fields[$fieldname];

					if (empty($fldvalue)) {
						$query = "SELECT email1 FROM vtiger_users WHERE id = ?";
						$res = $adb->pquery($query, array($current_user->id));
						$rows = $adb->num_rows($res);
						if ($rows > 0) {
							$fldvalue = $adb->query_result($res, 0, 'email1');
						}
					}
					// END
				} elseif ($uitype == 72 && !$ajaxSave) {
					// Some of the currency fields like Unit Price, Totoal , Sub-total - doesn't need currency conversion during save
					$fldvalue = CurrencyField::convertToDBFormat($this->column_fields[$fieldname], null, true);
				} elseif ($uitype == 71 && !$ajaxSave) {
					$fldvalue = CurrencyField::convertToDBFormat($this->column_fields[$fieldname]);
				} else {
					$fldvalue = $this->column_fields[$fieldname];
				}
				if ($uitype != 33 && $uitype != 8)
					$fldvalue = from_html($fldvalue, ($insertion_mode == 'edit') ? true : false);
			}
			else {
				$fldvalue = '';
			}
			if ($fldvalue == '') {
				$fldvalue = $this->get_column_value($columname, $fldvalue, $fieldname, $uitype, $datatype);
			}

			if ($insertion_mode == 'edit') {
				if ($table_name != 'vtiger_ticketcomments' && $uitype != 4) {
					array_push($update, $columname . "=?");
					array_push($update_params, $fldvalue);
				}
			} else {
				array_push($column, $columname);
				array_push($value, $fldvalue);
			}
		}

		if ($insertion_mode == 'edit') {
			if ($module == 'Potentials') {
				$dbquery = 'select sales_stage from vtiger_potential where potentialid = ?';
				$sales_stage = $adb->query_result($adb->pquery($dbquery, array($this->id)), 0, 'sales_stage');
				if ($sales_stage != $_REQUEST['sales_stage'] && $_REQUEST['sales_stage'] != '') {
					$date_var = date("Y-m-d H:i:s");
					$closingDateField = new DateTimeField($this->column_fields['closingdate']);
					$closingdate = ($_REQUEST['ajxaction'] == 'DETAILVIEW') ? $this->column_fields['closingdate'] : $closingDateField->getDBInsertDateValue();
					$sql = "insert into vtiger_potstagehistory values(?,?,?,?,?,?,?,?)";
					$params = array('', $this->id, $this->column_fields['amount'], decode_html($sales_stage), $this->column_fields['probability'], 0, $adb->formatDate($closingdate, true), $adb->formatDate($date_var, true));
					$adb->pquery($sql, $params);
				}
			} elseif ($module == 'PurchaseOrder' || $module == 'SalesOrder' || $module == 'Quotes' || $module == 'Invoice') {
				//added to update the history for PO, SO, Quotes and Invoice
				$history_field_array = Array(
					"PurchaseOrder" => "postatus",
					"SalesOrder" => "sostatus",
					"Quotes" => "quotestage",
					"Invoice" => "invoicestatus"
				);

				$inventory_module = $module;

				if ($_REQUEST['ajxaction'] == 'DETAILVIEW') {//if we use ajax edit
					if ($inventory_module == "PurchaseOrder")
						$relatedname = getVendorName($this->column_fields['vendor_id']);
					else
						$relatedname = getAccountName($this->column_fields['account_id']);

					$total = $this->column_fields['hdnGrandTotal'];
				}
				else {//using edit button and save
					if ($inventory_module == "PurchaseOrder")
						$relatedname = $_REQUEST["vendor_name"];
					else
						$relatedname = $_REQUEST["account_name"];

					$total = $_REQUEST['total'];
				}

				if ($this->column_fields["$history_field_array[$inventory_module]"] == $app_strings['LBL_NOT_ACCESSIBLE']) {

					//If the value in the request is Not Accessible for a picklist, the existing value will be replaced instead of Not Accessible value.
					$his_col = $history_field_array[$inventory_module];
					$his_sql = "select $his_col from  $this->table_name where " . $this->table_index . "=?";
					$his_res = $adb->pquery($his_sql, array($this->id));
					$status_value = $adb->query_result($his_res, 0, $his_col);
					$stat_value = $status_value;
				} else {
					$stat_value = $this->column_fields["$history_field_array[$inventory_module]"];
				}
				$oldvalue = getSingleFieldValue($this->table_name, $history_field_array[$inventory_module], $this->table_index, $this->id);
				if ($this->column_fields["$history_field_array[$inventory_module]"] != '' && $oldvalue != $stat_value) {
					addInventoryHistory($inventory_module, $this->id, $relatedname, $total, $stat_value);
				}
			}
			//Check done by Don. If update is empty the the query fails
			if (count($update) > 0) {
				$sql1 = "update $table_name set " . implode(",", $update) . " where " . $this->tab_name_index[$table_name] . "=?";
				array_push($update_params, $this->id);
				$adb->pquery($sql1, $update_params);
			}
		} else {
			$sql1 = "insert into $table_name(" . implode(",", $column) . ") values(" . generateQuestionMarks($value) . ")";
//var_dump($column);
//var_dump($value);
			$adb->pquery($sql1, $value);
		}
//echo "<pre>";
//var_dump($sql1);
	}

	/** Function to delete a record in the specifed table
	 * @param $table_name -- table name:: Type varchar
	 * The function will delete a record .The id is obtained from the class variable $this->id and the columnname got from $this->tab_name_index[$table_name]
	 */
	function deleteRelation($table_name) {
		global $adb;
		$check_query = "select * from $table_name where " . $this->tab_name_index[$table_name] . "=?";
		$check_result = $adb->pquery($check_query, array($this->id));
		$num_rows = $adb->num_rows($check_result);

		if ($num_rows == 1) {
			$del_query = "DELETE from $table_name where " . $this->tab_name_index[$table_name] . "=?";
			$adb->pquery($del_query, array($this->id));
		}
	}

	/** Function to attachment filename of the given entity
	 * @param $notesid -- crmid:: Type Integer
	 * The function will get the attachmentsid for the given entityid from vtiger_seattachmentsrel table and get the attachmentsname from vtiger_attachments table
	 * returns the 'filename'
	 */
	function getOldFileName($notesid) {
		global $log;
		$log->info("in getOldFileName  " . $notesid);
		global $adb;
		$query1 = "select * from vtiger_seattachmentsrel where crmid=?";
		$result = $adb->pquery($query1, array($notesid));
		$noofrows = $adb->num_rows($result);
		if ($noofrows != 0)
			$attachmentid = $adb->query_result($result, 0, 'attachmentsid');
		if ($attachmentid != '') {
			$query2 = "select * from vtiger_attachments where attachmentsid=?";
			$filename = $adb->query_result($adb->pquery($query2, array($attachmentid)), 0, 'name');
		}
		return $filename;
	}

// Code included by Jaguar - Ends

	/** Function to retrive the information of the given recordid ,module
	 * @param $record -- Id:: Type Integer
	 * @param $module -- module:: Type varchar
	 * This function retrives the information from the database and sets the value in the class columnfields array
	 */
	function retrieve_entity_info($record, $module) {
//echo "<pre>";
//var_dump($record);
//var_dump($module);
		global $adb, $log, $app_strings;
		$result = Array();
		foreach ($this->tab_name_index as $table_name => $index) {
			$result[$table_name] = $adb->pquery("select * from $table_name where $index=?", array($record));
			$isRecordDeleted = $adb->query_result($result["vtiger_crmentity"], 0, "deleted");
			if ($isRecordDeleted !== 0 && $isRecordDeleted !== '0') {
				//die("<br><br><center>" . $app_strings['LBL_RECORD_DELETE'] . " <a href='javascript:window.history.back()'>" . $app_strings['LBL_GO_BACK'] . ".</a></center>");
				die("<br><br><center>" . $app_strings['LBL_RECORD_DELETE'] . "(record:$record, module:$module) <a href='javascript:window.history.back()'>" . $app_strings['LBL_GO_BACK'] . ".</a></center>");
			}
		}

		/* Prasad: Fix for ticket #4595 */
		if (isset($this->table_name)) {
			$mod_index_col = $this->tab_name_index[$this->table_name];
			if ($adb->query_result($result[$this->table_name], 0, $mod_index_col) == '')
				die("<br><br><center>" . $app_strings['LBL_RECORD_NOT_FOUND'] .
// IdeasWWW
" (data/CRMEntity.php línea:723, record:$record, module:$module) ".
// IdeasWWW
						". <a href='javascript:window.history.back()'>" . $app_strings['LBL_GO_BACK'] . ".</a></center>");
		}

		// Lookup in cache for information
		$cachedModuleFields = VTCacheUtils::lookupFieldInfo_Module($module);

		if ($cachedModuleFields === false) {
			$tabid = getTabid($module);

			// Let us pick up all the fields first so that we can cache information
			$sql1 = "SELECT fieldname, fieldid, fieldlabel, columnname, tablename, uitype, typeofdata, presence
    	FROM vtiger_field WHERE tabid=?";

			// NOTE: Need to skip in-active fields which we will be done later.
			$result1 = $adb->pquery($sql1, array($tabid));
			$noofrows = $adb->num_rows($result1);

			if ($noofrows) {
				while ($resultrow = $adb->fetch_array($result1)) {
					// Update information to cache for re-use
					VTCacheUtils::updateFieldInfo(
							$tabid, $resultrow['fieldname'], $resultrow['fieldid'], $resultrow['fieldlabel'], $resultrow['columnname'], $resultrow['tablename'], $resultrow['uitype'], $resultrow['typeofdata'], $resultrow['presence']
					);
				}
			}

			// Get only active field information
			$cachedModuleFields = VTCacheUtils::lookupFieldInfo_Module($module);
		}

		if ($cachedModuleFields) {
			foreach ($cachedModuleFields as $fieldname => $fieldinfo) {
				$fieldcolname = $fieldinfo['columnname'];
				$tablename = $fieldinfo['tablename'];
				$fieldname = $fieldinfo['fieldname'];

				// To avoid ADODB execption pick the entries that are in $tablename
				// (ex. when we don't have attachment for troubletickets, $result[vtiger_attachments]
				// will not be set so here we should not retrieve)
				if (isset($result[$tablename])) {
					$fld_value = $adb->query_result($result[$tablename], 0, $fieldcolname);
				} else {
					$adb->println("There is no entry for this entity $record ($module) in the table $tablename");
					$fld_value = "";
				}
				$this->column_fields[$fieldname] = $fld_value;
			}
		}
		if ($module == 'Users') {
			for ($i = 0; $i < $noofrows; $i++) {
				$fieldcolname = $adb->query_result($result1, $i, "columnname");
				$tablename = $adb->query_result($result1, $i, "tablename");
				$fieldname = $adb->query_result($result1, $i, "fieldname");
				$fld_value = $adb->query_result($result[$tablename], 0, $fieldcolname);
				$this->$fieldname = $fld_value;
			}
		}

		$this->column_fields["record_id"] = $record;
		$this->column_fields["record_module"] = $module;
	}

	/** Function to saves the values in all the tables mentioned in the class variable $tab_name for the specified module
	 * @param $module -- module:: Type varchar
	 */
	function save($module_name, $fileid = '') {
		global $log;
		$log->debug("module name is " . $module_name);

		//Event triggering code
		require_once("include/events/include.inc");
		global $adb;

		$em = new VTEventsManager($adb);
		// Initialize Event trigger cache
		$em->initTriggerCache();
		$entityData = VTEntityData::fromCRMEntity($this);

		$em->triggerEvent("vtiger.entity.beforesave.modifiable", $entityData);
		$em->triggerEvent("vtiger.entity.beforesave", $entityData);
		$em->triggerEvent("vtiger.entity.beforesave.final", $entityData);
		//Event triggering code ends
		//GS Save entity being called with the modulename as parameter
		$this->saveentity($module_name, $fileid);

		//Event triggering code
		$em->triggerEvent("vtiger.entity.aftersave", $entityData);
		$em->triggerEvent("vtiger.entity.aftersave.final", $entityData);
		//Event triggering code ends
	}

	function process_list_query($query, $row_offset, $limit = -1, $max_per_page = -1) {
		global $list_max_entries_per_page;
		$this->log->debug("process_list_query: " . $query);
		if (!empty($limit) && $limit != -1) {
			$result = & $this->db->limitQuery($query, $row_offset + 0, $limit, true, "Error retrieving $this->object_name list: ");
		} else {
			$result = & $this->db->query($query, true, "Error retrieving $this->object_name list: ");
		}

		$list = Array();
		if ($max_per_page == -1) {
			$max_per_page = $list_max_entries_per_page;
		}
		$rows_found = $this->db->getRowCount($result);

		$this->log->debug("Found $rows_found " . $this->object_name . "s");

		$previous_offset = $row_offset - $max_per_page;
		$next_offset = $row_offset + $max_per_page;

		if ($rows_found != 0) {

			// We have some data.

			for ($index = $row_offset, $row = $this->db->fetchByAssoc($result, $index); $row && ($index < $row_offset + $max_per_page || $max_per_page == -99); $index++, $row = $this->db->fetchByAssoc($result, $index)) {


				foreach ($this->list_fields as $entry) {

					foreach ($entry as $key => $field) { // this will be cycled only once
						if (isset($row[$field])) {
							$this->column_fields[$this->list_fields_names[$key]] = $row[$field];


							$this->log->debug("$this->object_name({$row['id']}): " . $field . " = " . $this->$field);
						} else {
							$this->column_fields[$this->list_fields_names[$key]] = "";
						}
					}
				}


				//$this->db->println("here is the bug");


				$list[] = clone($this); //added by Richie to support PHP5
			}
		}

		$response = Array();
		$response['list'] = $list;
		$response['row_count'] = $rows_found;
		$response['next_offset'] = $next_offset;
		$response['previous_offset'] = $previous_offset;

		return $response;
	}

	function process_full_list_query($query) {
		$this->log->debug("CRMEntity:process_full_list_query");
		$result = & $this->db->query($query, false);
		//$this->log->debug("CRMEntity:process_full_list_query: result is ".$result);


		if ($this->db->getRowCount($result) > 0) {

			//	$this->db->println("process_full mid=".$this->table_index." mname=".$this->module_name);
			// We have some data.
			while ($row = $this->db->fetchByAssoc($result)) {
				$rowid = $row[$this->table_index];

				if (isset($rowid))
					$this->retrieve_entity_info($rowid, $this->module_name);
				else
					$this->db->println("rowid not set unable to retrieve");



				//clone function added to resolvoe PHP5 compatibility issue in Dashboards
				//If we do not use clone, while using PHP5, the memory address remains fixed but the
				//data gets overridden hence all the rows that come in bear the same value. This in turn
//provides a wrong display of the Dashboard graphs. The data is erroneously shown for a specific month alone
//Added by Richie
				$list[] = clone($this); //added by Richie to support PHP5
			}
		}

		if (isset($list))
			return $list;
		else
			return null;
	}

	/** This function should be overridden in each module.  It marks an item as deleted.
	 * If it is not overridden, then marking this type of item is not allowed
	 * Portions created by SugarCRM are Copyright (C) SugarCRM, Inc..
	 * All Rights Reserved..
	 * Contributor(s): ______________________________________..
	 */
	function mark_deleted($id) {
		global $current_user;
		$date_var = date("Y-m-d H:i:s");
		$query = "UPDATE vtiger_crmentity set deleted=1,modifiedtime=?,modifiedby=? where crmid=?";
		$this->db->pquery($query, array($this->db->formatDate($date_var, true), $current_user->id, $id), true, "Error marking record deleted: ");
	}

	function retrieve_by_string_fields($fields_array, $encode = true) {
		$where_clause = $this->get_where($fields_array);

		$query = "SELECT * FROM $this->table_name $where_clause";
		$this->log->debug("Retrieve $this->object_name: " . $query);
		$result = & $this->db->requireSingleResult($query, true, "Retrieving record $where_clause:");
		if (empty($result)) {
			return null;
		}

		$row = $this->db->fetchByAssoc($result, -1, $encode);

		foreach ($this->column_fields as $field) {
			if (isset($row[$field])) {
				$this->$field = $row[$field];
			}
		}
		return $this;
	}

	// this method is called during an import before inserting a bean
	// define an associative array called $special_fields
	// the keys are user defined, and don't directly map to the bean's vtiger_fields
	// the value is the method name within that bean that will do extra
	// processing for that vtiger_field. example: 'full_name'=>'get_names_from_full_name'

	function process_special_fields() {
		foreach ($this->special_functions as $func_name) {
			if (method_exists($this, $func_name)) {
				$this->$func_name();
			}
		}
	}

	/**
	 * Function to check if the custom vtiger_field vtiger_table exists
	 * return true or false
	 */
	function checkIfCustomTableExists($tablename) {
		global $adb;
		$query = "select * from " . $adb->sql_escape_string($tablename);
		$result = $this->db->pquery($query, array());
		$testrow = $this->db->num_fields($result);
		if ($testrow > 1) {
			$exists = true;
		} else {
			$exists = false;
		}
		return $exists;
	}

	/**
	 * function to construct the query to fetch the custom vtiger_fields
	 * return the query to fetch the custom vtiger_fields
	 */
	function constructCustomQueryAddendum($tablename, $module) {
		global $adb;
		$tabid = getTabid($module);
		$sql1 = "select columnname,fieldlabel from vtiger_field where generatedtype=2 and tabid=? and vtiger_field.presence in (0,2)";
		$result = $adb->pquery($sql1, array($tabid));
		$numRows = $adb->num_rows($result);
		$sql3 = "select ";
		for ($i = 0; $i < $numRows; $i++) {
			$columnName = $adb->query_result($result, $i, "columnname");
			$fieldlabel = $adb->query_result($result, $i, "fieldlabel");
			//construct query as below
			if ($i == 0) {
				$sql3 .= $tablename . "." . $columnName . " '" . $fieldlabel . "'";
			} else {
				$sql3 .= ", " . $tablename . "." . $columnName . " '" . $fieldlabel . "'";
			}
		}
		if ($numRows > 0) {
			$sql3 = $sql3 . ',';
		}
		return $sql3;
	}

	/**
	 * This function returns a full (ie non-paged) list of the current object type.
	 * Portions created by SugarCRM are Copyright (C) SugarCRM, Inc..
	 * All Rights Reserved..
	 * Contributor(s): ______________________________________..
	 */
	function get_full_list($order_by = "", $where = "") {
		$this->log->debug("get_full_list:  order_by = '$order_by' and where = '$where'");
		$query = $this->create_list_query($order_by, $where);
		return $this->process_full_list_query($query);
	}

	/**
	 * Track the viewing of a detail record.  This leverages get_summary_text() which is object specific
	 * params $user_id - The user that is viewing the record.
	 * Portions created by SugarCRM are Copyright (C) SugarCRM, Inc..
	 * All Rights Reserved..
	 * Contributor(s): ______________________________________..
	 */
	function track_view($user_id, $current_module, $id = '') {
		$this->log->debug("About to call vtiger_tracker (user_id, module_name, item_id)($user_id, $current_module, $this->id)");

		$tracker = new Tracker();
		$tracker->track_view($user_id, $current_module, $id, '');
	}

	/**
	 * Function to get the column value of a field when the field value is empty ''
	 * @param $columnname -- Column name for the field
	 * @param $fldvalue -- Input value for the field taken from the User
	 * @param $fieldname -- Name of the Field
	 * @param $uitype -- UI type of the field
	 * @return Column value of the field.
	 */
	function get_column_value($columnname, $fldvalue, $fieldname, $uitype, $datatype = '') {
		global $log;
		$log->debug("Entering function get_column_value ($columnname, $fldvalue, $fieldname, $uitype, $datatype='')");

		// Added for the fields of uitype '57' which has datatype mismatch in crmentity table and particular entity table
		if ($uitype == 57 && $fldvalue == '') {
			return 0;
		}
		if (is_uitype($uitype, "_date_") && $fldvalue == '') {
			return null;
		}
		if ($datatype == 'I' || $datatype == 'N' || $datatype == 'NN') {
			return 0;
		}
		$log->debug("Exiting function get_column_value");
		return $fldvalue;
	}

	/**
	 * Function to make change to column fields, depending on the current user's accessibility for the fields
	 */
	function apply_field_security() {
		global $current_user, $currentModule;

		require_once('include/utils/UserInfoUtil.php');
		foreach ($this->column_fields as $fieldname => $fieldvalue) {
			$reset_value = false;
			if (getFieldVisibilityPermission($currentModule, $current_user->id, $fieldname) != '0')
				$reset_value = true;

			if ($fieldname == "record_id" || $fieldname == "record_module")
				$reset_value = false;

			/*
			  if (isset($this->additional_column_fields) && in_array($fieldname, $this->additional_column_fields) == true)
			  $reset_value = false;
			 */

			if ($reset_value == true)
				$this->column_fields[$fieldname] = "";
		}
	}

	/**
	 * Function invoked during export of module record value.
	 */
	function transform_export_value($key, $value) {
		// NOTE: The sub-class can override this function as required.
		return $value;
	}

	/**
	 * Function to initialize the importable fields array, based on the User's accessibility to the fields
	 */
	function initImportableFields($module) {
		global $current_user, $adb;
		require_once('include/utils/UserInfoUtil.php');

		$skip_uitypes = array('4'); // uitype 4 is for Mod numbers
		// Look at cache if the fields information is available.
		$cachedModuleFields = VTCacheUtils::lookupFieldInfo_Module($module);

		if ($cachedModuleFields === false) {
			getColumnFields($module); // This API will initialize the cache as well
			// We will succeed now due to above function call
			$cachedModuleFields = VTCacheUtils::lookupFieldInfo_Module($module);
		}

		$colf = Array();

		if ($cachedModuleFields) {
			foreach ($cachedModuleFields as $fieldinfo) {
				// Skip non-supported fields
				if (in_array($fieldinfo['uitype'], $skip_uitypes)) {
					continue;
				} else {
					$colf[$fieldinfo['fieldname']] = $fieldinfo['uitype'];
				}
			}
		}

		foreach ($colf as $key => $value) {
			if (getFieldVisibilityPermission($module, $current_user->id, $key, 'readwrite') == '0')
				$this->importable_fields[$key] = $value;
		}
	}

	/** Function to initialize the required fields array for that particular module */
	function initRequiredFields($module) {
		global $adb;

		$tabid = getTabId($module);
		$sql = "select * from vtiger_field where tabid= ? and typeofdata like '%M%' and uitype not in ('53','70') and vtiger_field.presence in (0,2)";
		$result = $adb->pquery($sql, array($tabid));
		$numRows = $adb->num_rows($result);
		for ($i = 0; $i < $numRows; $i++) {
			$fieldName = $adb->query_result($result, $i, "fieldname");
			$this->required_fields[$fieldName] = 1;
		}
	}

	/** Function to delete an entity with given Id */
	function trash($module, $id) {
		global $log, $current_user, $adb;

		require_once("include/events/include.inc");
		$em = new VTEventsManager($adb);

		// Initialize Event trigger cache
		$em->initTriggerCache();

		$entityData = VTEntityData::fromEntityId($adb, $id);

		$em->triggerEvent("vtiger.entity.beforedelete", $entityData);

		$this->mark_deleted($id);
		$this->unlinkDependencies($module, $id);

		require_once('include/freetag/freetag.class.php');
		$freetag = new freetag();
		$freetag->delete_all_object_tags_for_user($current_user->id, $id);

		$sql_recentviewed = 'DELETE FROM vtiger_tracker WHERE user_id = ? AND item_id = ?';
		$this->db->pquery($sql_recentviewed, array($current_user->id, $id));

		$em->triggerEvent("vtiger.entity.afterdelete", $entityData);
	}

	/** Function to unlink all the dependent entities of the given Entity by Id */
	function unlinkDependencies($module, $id) {
		global $log;

		$fieldRes = $this->db->pquery('SELECT tabid, tablename, columnname FROM vtiger_field WHERE fieldid IN (
			SELECT fieldid FROM vtiger_fieldmodulerel WHERE relmodule=?)', array($module));
		$numOfFields = $this->db->num_rows($fieldRes);
		for ($i = 0; $i < $numOfFields; $i++) {
			$tabId = $this->db->query_result($fieldRes, $i, 'tabid');
			$tableName = $this->db->query_result($fieldRes, $i, 'tablename');
			$columnName = $this->db->query_result($fieldRes, $i, 'columnname');

			$relatedModule = vtlib_getModuleNameById($tabId);
			$focusObj = CRMEntity::getInstance($relatedModule);

			//Backup Field Relations for the deleted entity
			$relQuery = "SELECT $focusObj->table_index FROM $tableName WHERE $columnName=?";
			$relResult = $this->db->pquery($relQuery, array($id));
			$numOfRelRecords = $this->db->num_rows($relResult);
			if ($numOfRelRecords > 0) {
				$recordIdsList = array();
				for ($k = 0; $k < $numOfRelRecords; $k++) {
					$recordIdsList[] = $this->db->query_result($relResult, $k, $focusObj->table_index);
				}
				$params = array($id, RB_RECORD_UPDATED, $tableName, $columnName, $focusObj->table_index, implode(",", $recordIdsList));
				$this->db->pquery('INSERT INTO vtiger_relatedlists_rb VALUES (?,?,?,?,?,?)', $params);
			}
		}
	}

	/** Function to unlink an entity with given Id from another entity */
	function unlinkRelationship($id, $return_module, $return_id) {
		global $log, $currentModule;

		$query = 'DELETE FROM vtiger_crmentityrel WHERE (crmid=? AND relmodule=? AND relcrmid=?) OR (relcrmid=? AND module=? AND crmid=?)';
		$params = array($id, $return_module, $return_id, $id, $return_module, $return_id);
		$this->db->pquery($query, $params);

		$fieldRes = $this->db->pquery('SELECT tabid, tablename, columnname FROM vtiger_field WHERE fieldid IN (
			SELECT fieldid FROM vtiger_fieldmodulerel WHERE module=? AND relmodule=?)', array($currentModule, $return_module));
		$numOfFields = $this->db->num_rows($fieldRes);
		for ($i = 0; $i < $numOfFields; $i++) {
			$tabId = $this->db->query_result($fieldRes, $i, 'tabid');
			$tableName = $this->db->query_result($fieldRes, $i, 'tablename');
			$columnName = $this->db->query_result($fieldRes, $i, 'columnname');

			$relatedModule = vtlib_getModuleNameById($tabId);
			$focusObj = CRMEntity::getInstance($relatedModule);

			$updateQuery = "UPDATE $tableName SET $columnName=? WHERE $columnName=? AND $focusObj->table_index=?";
			$updateParams = array(null, $return_id, $id);
			$this->db->pquery($updateQuery, $updateParams);
		}
	}

	/** Function to restore a deleted record of specified module with given crmid
	 * @param $module -- module name:: Type varchar
	 * @param $entity_ids -- list of crmids :: Array
	 */
	function restore($module, $id) {
		global $current_user, $adb;

		$this->db->println("TRANS restore starts $module");
		$this->db->startTransaction();

		$date_var = date("Y-m-d H:i:s");
		$query = 'UPDATE vtiger_crmentity SET deleted=0,modifiedtime=?,modifiedby=? WHERE crmid = ?';
		$this->db->pquery($query, array($this->db->formatDate($date_var, true), $current_user->id, $id), true, "Error restoring records :");
		//Restore related entities/records
		$this->restoreRelatedRecords($module, $id);

		//Event triggering code
		require_once("include/events/include.inc");
		global $adb;
		$em = new VTEventsManager($adb);

		// Initialize Event trigger cache
		$em->initTriggerCache();

		$this->id = $id;
		$entityData = VTEntityData::fromCRMEntity($this);
		//Event triggering code
		$em->triggerEvent("vtiger.entity.afterrestore", $entityData);
		//Event triggering code ends

		$this->db->completeTransaction();
		$this->db->println("TRANS restore ends");
	}

	/** Function to restore all the related records of a given record by id */
	function restoreRelatedRecords($module, $record) {

		$result = $this->db->pquery('SELECT * FROM vtiger_relatedlists_rb WHERE entityid = ?', array($record));
		$numRows = $this->db->num_rows($result);
		for ($i = 0; $i < $numRows; $i++) {
			$action = $this->db->query_result($result, $i, "action");
			$rel_table = $this->db->query_result($result, $i, "rel_table");
			$rel_column = $this->db->query_result($result, $i, "rel_column");
			$ref_column = $this->db->query_result($result, $i, "ref_column");
			$related_crm_ids = $this->db->query_result($result, $i, "related_crm_ids");

			if (strtoupper($action) == RB_RECORD_UPDATED) {
				$related_ids = explode(",", $related_crm_ids);
				if ($rel_table == 'vtiger_crmentity' && $rel_column == 'deleted') {
					$sql = "UPDATE $rel_table set $rel_column = 0 WHERE $ref_column IN (" . generateQuestionMarks($related_ids) . ")";
					$this->db->pquery($sql, array($related_ids));
				} else {
					$sql = "UPDATE $rel_table set $rel_column = ? WHERE $rel_column = 0 AND $ref_column IN (" . generateQuestionMarks($related_ids) . ")";
					$this->db->pquery($sql, array($record, $related_ids));
				}
			} elseif (strtoupper($action) == RB_RECORD_DELETED) {
				if ($rel_table == 'vtiger_seproductrel') {
					$sql = "INSERT INTO $rel_table($rel_column, $ref_column, 'setype') VALUES (?,?,?)";
					$this->db->pquery($sql, array($record, $related_crm_ids, $module));
				} else {
					$sql = "INSERT INTO $rel_table($rel_column, $ref_column) VALUES (?,?)";
					$this->db->pquery($sql, array($record, $related_crm_ids));
				}
			}
		}

		//Clean up the the backup data also after restoring
		$this->db->pquery('DELETE FROM vtiger_relatedlists_rb WHERE entityid = ?', array($record));
	}

	/**
	 * Function to initialize the sortby fields array
	 */
	function initSortByField($module) {
		global $adb, $log;
		$log->debug("Entering function initSortByField ($module)");
		// Define the columnname's and uitype's which needs to be excluded
		$exclude_columns = Array('parent_id', 'quoteid', 'vendorid', 'access_count');
		$exclude_uitypes = Array();

		$tabid = getTabId($module);
		if ($module == 'Calendar') {
			$tabid = array('9', '16');
		}
		$sql = "SELECT columnname FROM vtiger_field " .
				" WHERE (fieldname not like '%\_id' OR fieldname in ('assigned_user_id'))" .
				" AND tabid in (" . generateQuestionMarks($tabid) . ") and vtiger_field.presence in (0,2)";
		$params = array($tabid);
		if (count($exclude_columns) > 0) {
			$sql .= " AND columnname NOT IN (" . generateQuestionMarks($exclude_columns) . ")";
			array_push($params, $exclude_columns);
		}
		if (count($exclude_uitypes) > 0) {
			$sql .= " AND uitype NOT IN (" . generateQuestionMarks($exclude_uitypes) . ")";
			array_push($params, $exclude_uitypes);
		}
		$result = $adb->pquery($sql, $params);
		$num_rows = $adb->num_rows($result);
		for ($i = 0; $i < $num_rows; $i++) {
			$columnname = $adb->query_result($result, $i, 'columnname');
			if (in_array($columnname, $this->sortby_fields))
				continue;
			else
				$this->sortby_fields[] = $columnname;
		}
		if ($tabid == 21 or $tabid == 22)
			$this->sortby_fields[] = 'crmid';
		$log->debug("Exiting initSortByField");
	}

	/* Function to set the Sequence string and sequence number starting value */

	function setModuleSeqNumber($mode, $module, $req_str = '', $req_no = '') {
		global $adb;
		//when we configure the invoice number in Settings this will be used
		if ($mode == "configure" && $req_no != '') {
			$check = $adb->pquery("select cur_id from vtiger_modentity_num where semodule=? and prefix = ?", array($module, $req_str));
			if ($adb->num_rows($check) == 0) {
				$numid = $adb->getUniqueId("vtiger_modentity_num");
				$active = $adb->pquery("select num_id from vtiger_modentity_num where semodule=? and active=1", array($module));
				$adb->pquery("UPDATE vtiger_modentity_num SET active=0 where num_id=?", array($adb->query_result($active, 0, 'num_id')));

				$adb->pquery("INSERT into vtiger_modentity_num values(?,?,?,?,?,?)", array($numid, $module, $req_str, $req_no, $req_no, 1));
				return true;
			} else if ($adb->num_rows($check) != 0) {
				$num_check = $adb->query_result($check, 0, 'cur_id');
				if ($req_no < $num_check) {
					return false;
				} else {
					$adb->pquery("UPDATE vtiger_modentity_num SET active=0 where active=1 and semodule=?", array($module));
					$adb->pquery("UPDATE vtiger_modentity_num SET cur_id=?, active = 1 where prefix=? and semodule=?", array($req_no, $req_str, $module));
					return true;
				}
			}
		} else if ($mode == "increment") {
			//when we save new invoice we will increment the invoice id and write
			$check = $adb->pquery("select cur_id,prefix from vtiger_modentity_num where semodule=? and active = 1", array($module));
			$prefix = $adb->query_result($check, 0, 'prefix');
			$curid = $adb->query_result($check, 0, 'cur_id');
			$prev_inv_no = $prefix . $curid;
			$strip = strlen($curid) - strlen($curid + 1);
			if ($strip < 0)
				$strip = 0;
			$temp = str_repeat("0", $strip);
			$req_no.= $temp . ($curid + 1);
			$adb->pquery("UPDATE vtiger_modentity_num SET cur_id=? where cur_id=? and active=1 AND semodule=?", array($req_no, $curid, $module));
			return decode_html($prev_inv_no);
		}
	}

	// END

	/* Function to check if module sequence numbering is configured for the given module or not */
	function isModuleSequenceConfigured($module) {
		$adb = PearDatabase::getInstance();
		$result = $adb->pquery('SELECT 1 FROM vtiger_modentity_num WHERE semodule = ? AND active = 1', array($module));
		if ($result && $adb->num_rows($result) > 0) {
			return true;
		}
		return false;
	}

	/* Function to get the next module sequence number for a given module */

	function getModuleSeqInfo($module) {
		global $adb;
		$check = $adb->pquery("select cur_id,prefix from vtiger_modentity_num where semodule=? and active = 1", array($module));
		$prefix = $adb->query_result($check, 0, 'prefix');
		$curid = $adb->query_result($check, 0, 'cur_id');
		return array($prefix, $curid);
	}

	// END

	/* Function to check if the mod number already exits */
	function checkModuleSeqNumber($table, $column, $no) {
		global $adb;
		$result = $adb->pquery("select " . $adb->sql_escape_string($column) .
				" from " . $adb->sql_escape_string($table) .
				" where " . $adb->sql_escape_string($column) . " = ?", array($no));

		$num_rows = $adb->num_rows($result);

		if ($num_rows > 0)
			return true;
		else
			return false;
	}

	// END

	function updateMissingSeqNumber($module) {
		global $log, $adb;
		$log->debug("Entered updateMissingSeqNumber function");

		vtlib_setup_modulevars($module, $this);

		if (!$this->isModuleSequenceConfigured($module))
			return;

		$tabid = getTabid($module);
		$fieldinfo = $adb->pquery("SELECT * FROM vtiger_field WHERE tabid = ? AND uitype = 4", Array($tabid));

		$returninfo = Array();

		if ($fieldinfo && $adb->num_rows($fieldinfo)) {
			// TODO: We assume the following for module sequencing field
			// 1. There will be only field per module
			// 2. This field is linked to module base table column
			$fld_table = $adb->query_result($fieldinfo, 0, 'tablename');
			$fld_column = $adb->query_result($fieldinfo, 0, 'columnname');

			if ($fld_table == $this->table_name) {
				$records = $adb->query("SELECT $this->table_index AS recordid FROM $this->table_name " .
						"WHERE $fld_column = '' OR $fld_column is NULL");

				if ($records && $adb->num_rows($records)) {
					$returninfo['totalrecords'] = $adb->num_rows($records);
					$returninfo['updatedrecords'] = 0;

					$modseqinfo = $this->getModuleSeqInfo($module);
					$prefix = $modseqinfo[0];
					$cur_id = $modseqinfo[1];

					$old_cur_id = $cur_id;
					while ($recordinfo = $adb->fetch_array($records)) {
						$value = "$prefix" . "$cur_id";
						$adb->pquery("UPDATE $fld_table SET $fld_column = ? WHERE $this->table_index = ?", Array($value, $recordinfo['recordid']));
						$cur_id += 1;
						$returninfo['updatedrecords'] = $returninfo['updatedrecords'] + 1;
					}
					if ($old_cur_id != $cur_id) {
						$adb->pquery("UPDATE vtiger_modentity_num set cur_id=? where semodule=? and active=1", Array($cur_id, $module));
					}
				}
			} else {
				$log->fatal("Updating Missing Sequence Number FAILED! REASON: Field table and module table mismatching.");
			}
		}
		return $returninfo;
	}

	/* Generic function to get attachments in the related list of a given module */

	function get_attachments($id, $cur_tab_id, $rel_tab_id, $actions = false) {

		global $currentModule, $app_strings, $singlepane_view;
		$this_module = $currentModule;
		$parenttab = getParentTab();

		$related_module = vtlib_getModuleNameById($rel_tab_id);
		$other = CRMEntity::getInstance($related_module);

		// Some standard module class doesn't have required variables
		// that are used in the query, they are defined in this generic API
		vtlib_setup_modulevars($related_module, $other);

		$singular_modname = vtlib_toSingular($related_module);
		$button = '';
		if ($actions) {
			if (is_string($actions))
				$actions = explode(',', strtoupper($actions));
			if (in_array('SELECT', $actions) && isPermitted($related_module, 4, '') == 'yes') {
				$button .= "<input title='" . getTranslatedString('LBL_SELECT') . " " . getTranslatedString($related_module) . "' class='crmbutton small edit' type='button' onclick=\"return window.open('index.php?module=$related_module&return_module=$currentModule&action=Popup&popuptype=detailview&select=enable&form=EditView&form_submit=false&recordid=$id&parenttab=$parenttab','test','width=640,height=602,resizable=0,scrollbars=0');\" value='" . getTranslatedString('LBL_SELECT') . " " . getTranslatedString($related_module) . "'>&nbsp;";
			}
			if (in_array('ADD', $actions) && isPermitted($related_module, 1, '') == 'yes') {
				$button .= "<input type='hidden' name='createmode' id='createmode' value='link' />" .
						"<input title='" . getTranslatedString('LBL_ADD_NEW') . " " . getTranslatedString($singular_modname) . "' class='crmbutton small create'" .
						" onclick='this.form.action.value=\"EditView\";this.form.module.value=\"$related_module\"' type='submit' name='button'" .
						" value='" . getTranslatedString('LBL_ADD_NEW') . " " . getTranslatedString($singular_modname) . "'>&nbsp;";
			}
		}

		// To make the edit or del link actions to return back to same view.
		if ($singlepane_view == 'true')
			$returnset = "&return_module=$this_module&return_action=DetailView&return_id=$id";
		else
			$returnset = "&return_module=$this_module&return_action=CallRelatedList&return_id=$id";

		$userNameSql = getSqlForNameInDisplayFormat(array('first_name'=>'vtiger_users.first_name',
														'last_name' => 'vtiger_users.last_name'), 'Users');
		$query = "select case when (vtiger_users.user_name not like '') then $userNameSql else vtiger_groups.groupname end as user_name," .
				"'Documents' ActivityType,vtiger_attachments.type  FileType,crm2.modifiedtime lastmodified,vtiger_crmentity.modifiedtime,
				vtiger_seattachmentsrel.attachmentsid attachmentsid, vtiger_notes.notesid crmid,
				vtiger_notes.notecontent description,vtiger_notes.*
				from vtiger_notes
				inner join vtiger_senotesrel on vtiger_senotesrel.notesid= vtiger_notes.notesid
				inner join vtiger_crmentity on vtiger_crmentity.crmid= vtiger_notes.notesid and vtiger_crmentity.deleted=0
				inner join vtiger_crmentity crm2 on crm2.crmid=vtiger_senotesrel.crmid
				LEFT JOIN vtiger_groups
				ON vtiger_groups.groupid = vtiger_crmentity.smownerid
				left join vtiger_seattachmentsrel  on vtiger_seattachmentsrel.crmid =vtiger_notes.notesid
				left join vtiger_attachments on vtiger_seattachmentsrel.attachmentsid = vtiger_attachments.attachmentsid
				left join vtiger_users on vtiger_crmentity.smownerid= vtiger_users.id
				where crm2.crmid=" . $id;

		$return_value = GetRelatedList($this_module, $related_module, $other, $query, $button, $returnset);

		if ($return_value == null)
			$return_value = Array();
		$return_value['CUSTOM_BUTTON'] = $button;
		return $return_value;
	}

	/**
	 * For Record View Notification
	 */
	function isViewed($crmid = false) {
		if (!$crmid) {
			$crmid = $this->id;
		}
		if ($crmid) {
			global $adb;
			$result = $adb->pquery("SELECT viewedtime,modifiedtime,smcreatorid,smownerid,modifiedby FROM vtiger_crmentity WHERE crmid=?", Array($crmid));
			$resinfo = $adb->fetch_array($result);

			$lastviewed = $resinfo['viewedtime'];
			$modifiedon = $resinfo['modifiedtime'];
			$smownerid = $resinfo['smownerid'];
			$smcreatorid = $resinfo['smcreatorid'];
			$modifiedby = $resinfo['modifiedby'];

			if ($modifiedby == '0' && ($smownerid == $smcreatorid)) {
				/** When module record is created * */
				return true;
			} else if ($smownerid == $modifiedby) {
				/** Owner and Modifier as same. * */
				return true;
			} else if ($lastviewed && $modifiedon) {
				/** Lastviewed and Modified time is available. */
				if ($this->__timediff($modifiedon, $lastviewed) > 0)
					return true;
			}
		}
		return false;
	}

	function __timediff($d1, $d2) {
		list($t1_1, $t1_2) = explode(' ', $d1);
		list($t1_y, $t1_m, $t1_d) = explode('-', $t1_1);
		list($t1_h, $t1_i, $t1_s) = explode(':', $t1_2);

		$t1 = mktime($t1_h, $t1_i, $t1_s, $t1_m, $t1_d, $t1_y);

		list($t2_1, $t2_2) = explode(' ', $d2);
		list($t2_y, $t2_m, $t2_d) = explode('-', $t2_1);
		list($t2_h, $t2_i, $t2_s) = explode(':', $t2_2);

		$t2 = mktime($t2_h, $t2_i, $t2_s, $t2_m, $t2_d, $t2_y);

		if ($t1 == $t2)
			return 0;
		return $t2 - $t1;
	}

	function markAsViewed($userid) {
		global $adb;
		$adb->pquery("UPDATE vtiger_crmentity set viewedtime=? WHERE crmid=? AND smownerid=?", Array(date('Y-m-d H:i:s', time()), $this->id, $userid));
	}

	/**
	 * Save the related module record information. Triggered from CRMEntity->saveentity method or updateRelations.php
	 * @param String This module name
	 * @param Integer This module record number
	 * @param String Related module name
	 * @param mixed Integer or Array of related module record number
	 */
	function save_related_module($module, $crmid, $with_module, $with_crmid) {
		global $adb;
		if (!is_array($with_crmid))
			$with_crmid = Array($with_crmid);
		foreach ($with_crmid as $relcrmid) {

			if ($with_module == 'Documents') {
				$checkpresence = $adb->pquery("SELECT crmid FROM vtiger_senotesrel WHERE crmid = ? AND notesid = ?", Array($crmid, $relcrmid));
				// Relation already exists? No need to add again
				if ($checkpresence && $adb->num_rows($checkpresence))
					continue;

				$adb->pquery("INSERT INTO vtiger_senotesrel(crmid, notesid) VALUES(?,?)", array($crmid, $relcrmid));
			} else {
				$checkpresence = $adb->pquery("SELECT crmid FROM vtiger_crmentityrel WHERE
					crmid = ? AND module = ? AND relcrmid = ? AND relmodule = ?", Array($crmid, $module, $relcrmid, $with_module));
				// Relation already exists? No need to add again
				if ($checkpresence && $adb->num_rows($checkpresence))
					continue;

				$adb->pquery("INSERT INTO vtiger_crmentityrel(crmid, module, relcrmid, relmodule) VALUES(?,?,?,?)", Array($crmid, $module, $relcrmid, $with_module));
			}
		}
	}

	/**
	 * Delete the related module record information. Triggered from updateRelations.php
	 * @param String This module name
	 * @param Integer This module record number
	 * @param String Related module name
	 * @param mixed Integer or Array of related module record number
	 */
	function delete_related_module($module, $crmid, $with_module, $with_crmid) {
		global $adb;
		if (!is_array($with_crmid))
			$with_crmid = Array($with_crmid);
		foreach ($with_crmid as $relcrmid) {

			if ($with_module == 'Documents') {
				$adb->pquery("DELETE FROM vtiger_senotesrel WHERE crmid=? AND notesid=?", Array($crmid, $relcrmid));
			} else {
				$adb->pquery("DELETE FROM vtiger_crmentityrel WHERE (crmid=? AND module=? AND relcrmid=? AND relmodule=?) OR (relcrmid=? AND relmodule=? AND crmid=? AND module=?)",
					Array($crmid, $module, $relcrmid, $with_module,$crmid, $module, $relcrmid, $with_module));
			}
		}
	}

	/**
	 * Default (generic) function to handle the related list for the module.
	 * NOTE: Vtiger_Module::setRelatedList sets reference to this function in vtiger_relatedlists table
	 * if function name is not explicitly specified.
	 */
	function get_related_list($id, $cur_tab_id, $rel_tab_id, $actions = false) {

		global $currentModule, $app_strings, $singlepane_view;

		$parenttab = getParentTab();

		$related_module = vtlib_getModuleNameById($rel_tab_id);
		$other = CRMEntity::getInstance($related_module);

		// Some standard module class doesn't have required variables
		// that are used in the query, they are defined in this generic API
		vtlib_setup_modulevars($currentModule, $this);
		vtlib_setup_modulevars($related_module, $other);

		$singular_modname = 'SINGLE_' . $related_module;

		$button = '';
		if ($actions) {
			if (is_string($actions))
				$actions = explode(',', strtoupper($actions));
			if (in_array('SELECT', $actions) && isPermitted($related_module, 4, '') == 'yes') {
				$button .= "<input title='" . getTranslatedString('LBL_SELECT') . " " . getTranslatedString($related_module) . "' class='crmbutton small edit' " .
						" type='button' onclick=\"return window.open('index.php?module=$related_module&return_module=$currentModule&action=Popup&popuptype=detailview&select=enable&form=EditView&form_submit=false&recordid=$id&parenttab=$parenttab','test','width=640,height=602,resizable=0,scrollbars=0');\"" .
						" value='" . getTranslatedString('LBL_SELECT') . " " . getTranslatedString($related_module, $related_module) . "'>&nbsp;";
			}
			if (in_array('ADD', $actions) && isPermitted($related_module, 1, '') == 'yes') {
				$button .= "<input type='hidden' name='createmode' id='createmode' value='link' />" .
						"<input title='" . getTranslatedString('LBL_ADD_NEW') . " " . getTranslatedString($singular_modname) . "' class='crmbutton small create'" .
						" onclick='this.form.action.value=\"EditView\";this.form.module.value=\"$related_module\"' type='submit' name='button'" .
						" value='" . getTranslatedString('LBL_ADD_NEW') . " " . getTranslatedString($singular_modname, $related_module) . "'>&nbsp;";
			}
		}

		// To make the edit or del link actions to return back to same view.
		if ($singlepane_view == 'true')
			$returnset = "&return_module=$currentModule&return_action=DetailView&return_id=$id";
		else
			$returnset = "&return_module=$currentModule&return_action=CallRelatedList&return_id=$id";

		$query = "SELECT vtiger_crmentity.*, $other->table_name.*";

		$userNameSql = getSqlForNameInDisplayFormat(array('first_name'=>'vtiger_users.first_name',
														'last_name' => 'vtiger_users.last_name'), 'Users');
		$query .= ", CASE WHEN (vtiger_users.user_name NOT LIKE '') THEN $userNameSql ELSE vtiger_groups.groupname END AS user_name";

		$more_relation = '';
		if (!empty($other->related_tables)) {
			foreach ($other->related_tables as $tname => $relmap) {
				$query .= ", $tname.*";

				// Setup the default JOIN conditions if not specified
				if (empty($relmap[1]))
					$relmap[1] = $other->table_name;
				if (empty($relmap[2]))
					$relmap[2] = $relmap[0];
				$more_relation .= " LEFT JOIN $tname ON $tname.$relmap[0] = $relmap[1].$relmap[2]";
			}
		}

		$query .= " FROM $other->table_name";
		$query .= " INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $other->table_name.$other->table_index";
		$query .= " INNER JOIN vtiger_crmentityrel ON (vtiger_crmentityrel.relcrmid = vtiger_crmentity.crmid OR vtiger_crmentityrel.crmid = vtiger_crmentity.crmid)";
		$query .= $more_relation;
		$query .= " LEFT  JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid";
		$query .= " LEFT  JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";
		$query .= " WHERE vtiger_crmentity.deleted = 0 AND (vtiger_crmentityrel.crmid = $id OR vtiger_crmentityrel.relcrmid = $id)";
		$return_value = GetRelatedList($currentModule, $related_module, $other, $query, $button, $returnset);

		if ($return_value == null)
			$return_value = Array();
		$return_value['CUSTOM_BUTTON'] = $button;

		return $return_value;
	}

	/**
	 * Default (generic) function to handle the dependents list for the module.
	 * NOTE: UI type '10' is used to stored the references to other modules for a given record.
	 * These dependent records can be retrieved through this function.
	 * For eg: A trouble ticket can be related to an Account or a Contact.
	 * From a given Contact/Account if we need to fetch all such dependent trouble tickets, get_dependents_list function can be used.
	 */
	function get_dependents_list($id, $cur_tab_id, $rel_tab_id, $actions = false) {

		global $currentModule, $app_strings, $singlepane_view, $current_user;

		$parenttab = getParentTab();

		$related_module = vtlib_getModuleNameById($rel_tab_id);
		$other = CRMEntity::getInstance($related_module);

		// Some standard module class doesn't have required variables
		// that are used in the query, they are defined in this generic API
		vtlib_setup_modulevars($currentModule, $this);
		vtlib_setup_modulevars($related_module, $other);

		$singular_modname = 'SINGLE_' . $related_module;

		$button = '';

		// To make the edit or del link actions to return back to same view.
		if ($singlepane_view == 'true')
			$returnset = "&return_module=$currentModule&return_action=DetailView&return_id=$id";
		else
			$returnset = "&return_module=$currentModule&return_action=CallRelatedList&return_id=$id";

		$return_value = null;
		$dependentFieldSql = $this->db->pquery("SELECT tabid, fieldname, columnname FROM vtiger_field WHERE uitype='10' AND" .
				" fieldid IN (SELECT fieldid FROM vtiger_fieldmodulerel WHERE relmodule=? AND module=?)", array($currentModule, $related_module));
		$numOfFields = $this->db->num_rows($dependentFieldSql);

		if ($numOfFields > 0) {
			$dependentColumn = $this->db->query_result($dependentFieldSql, 0, 'columnname');
			$dependentField = $this->db->query_result($dependentFieldSql, 0, 'fieldname');

			$button .= '<input type="hidden" name="' . $dependentColumn . '" id="' . $dependentColumn . '" value="' . $id . '">';
			$button .= '<input type="hidden" name="' . $dependentColumn . '_type" id="' . $dependentColumn . '_type" value="' . $currentModule . '">';
			if ($actions) {
				if (is_string($actions))
					$actions = explode(',', strtoupper($actions));
				if (in_array('ADD', $actions) && isPermitted($related_module, 1, '') == 'yes'
						&& getFieldVisibilityPermission($related_module, $current_user->id, $dependentField, 'readwrite') == '0') {
					$button .= "<input title='" . getTranslatedString('LBL_ADD_NEW') . " " . getTranslatedString($singular_modname, $related_module) . "' class='crmbutton small create'" .
							" onclick='this.form.action.value=\"EditView\";this.form.module.value=\"$related_module\"' type='submit' name='button'" .
							" value='" . getTranslatedString('LBL_ADD_NEW') . " " . getTranslatedString($singular_modname, $related_module) . "'>&nbsp;";
				}
			}

			$query = "SELECT vtiger_crmentity.*, $other->table_name.*";

			$userNameSql = getSqlForNameInDisplayFormat(array('first_name'=>'vtiger_users.first_name',
														'last_name' => 'vtiger_users.last_name'), 'Users');
			$query .= ", CASE WHEN (vtiger_users.user_name NOT LIKE '') THEN $userNameSql ELSE vtiger_groups.groupname END AS user_name";

			$more_relation = '';
			if (!empty($other->related_tables)) {
				foreach ($other->related_tables as $tname => $relmap) {
					$query .= ", $tname.*";

					// Setup the default JOIN conditions if not specified
					if (empty($relmap[1]))
						$relmap[1] = $other->table_name;
					if (empty($relmap[2]))
						$relmap[2] = $relmap[0];
					$more_relation .= " LEFT JOIN $tname ON $tname.$relmap[0] = $relmap[1].$relmap[2]";
				}
			}

			$query .= " FROM $other->table_name";
			$query .= " INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $other->table_name.$other->table_index";
			$query .= " INNER  JOIN $this->table_name   ON $this->table_name.$this->table_index = $other->table_name.$dependentColumn";
			$query .= $more_relation;
			$query .= " LEFT  JOIN vtiger_users        ON vtiger_users.id = vtiger_crmentity.smownerid";
			$query .= " LEFT  JOIN vtiger_groups       ON vtiger_groups.groupid = vtiger_crmentity.smownerid";

			$query .= " WHERE vtiger_crmentity.deleted = 0 AND $this->table_name.$this->table_index = $id";

			$return_value = GetRelatedList($currentModule, $related_module, $other, $query, $button, $returnset);
		}
		if ($return_value == null)
			$return_value = Array();
		$return_value['CUSTOM_BUTTON'] = $button;

		return $return_value;
	}

	/**
	 * Move the related records of the specified list of id's to the given record.
	 * @param String This module name
	 * @param Array List of Entity Id's from which related records need to be transfered
	 * @param Integer Id of the the Record to which the related records are to be moved
	 */
	function transferRelatedRecords($module, $transferEntityIds, $entityId) {
		global $adb, $log;
		$log->debug("Entering function transferRelatedRecords ($module, $transferEntityIds, $entityId)");
		foreach ($transferEntityIds as $transferId) {

			// Pick the records related to the entity to be transfered, but do not pick the once which are already related to the current entity.
			$relatedRecords = $adb->pquery("SELECT relcrmid, relmodule FROM vtiger_crmentityrel WHERE crmid=? AND module=?" .
					" AND relcrmid NOT IN (SELECT relcrmid FROM vtiger_crmentityrel WHERE crmid=? AND module=?)", array($transferId, $module, $entityId, $module));
			$numOfRecords = $adb->num_rows($relatedRecords);
			for ($i = 0; $i < $numOfRecords; $i++) {
				$relcrmid = $adb->query_result($relatedRecords, $i, 'relcrmid');
				$relmodule = $adb->query_result($relatedRecords, $i, 'relmodule');
				$adb->pquery("UPDATE vtiger_crmentityrel SET crmid=? WHERE relcrmid=? AND relmodule=? AND crmid=? AND module=?", array($entityId, $relcrmid, $relmodule, $transferId, $module));
			}

			// Pick the records to which the entity to be transfered is related, but do not pick the once to which current entity is already related.
			$parentRecords = $adb->pquery("SELECT crmid, module FROM vtiger_crmentityrel WHERE relcrmid=? AND relmodule=?" .
					" AND crmid NOT IN (SELECT crmid FROM vtiger_crmentityrel WHERE relcrmid=? AND relmodule=?)", array($transferId, $module, $entityId, $module));
			$numOfRecords = $adb->num_rows($parentRecords);
			for ($i = 0; $i < $numOfRecords; $i++) {
				$parcrmid = $adb->query_result($parentRecords, $i, 'crmid');
				$parmodule = $adb->query_result($parentRecords, $i, 'module');
				$adb->pquery("UPDATE vtiger_crmentityrel SET relcrmid=? WHERE crmid=? AND module=? AND relcrmid=? AND relmodule=?", array($entityId, $parcrmid, $parmodule, $transferId, $module));
			}
		}
		$log->debug("Exiting transferRelatedRecords...");
	}

	/*
	 * Function to get the primary query part of a report for which generateReportsQuery Doesnt exist in module
	 * @param - $module Primary module name
	 * returns the query string formed on fetching the related data for report for primary module
	 */

	function generateReportsQuery($module) {
		global $adb;
		$primary = CRMEntity::getInstance($module);

		vtlib_setup_modulevars($module, $primary);
		$moduletable = $primary->table_name;
		$moduleindex = $primary->table_index;
		$modulecftable = $primary->customFieldTable[0];
		$modulecfindex = $primary->customFieldTable[1];

		if (isset($modulecftable)) {
			$cfquery = "inner join $modulecftable as $modulecftable on $modulecftable.$modulecfindex=$moduletable.$moduleindex";
		} else {
			$cfquery = '';
		}
		$query = "from $moduletable $cfquery
	        inner join vtiger_crmentity on vtiger_crmentity.crmid=$moduletable.$moduleindex
			left join vtiger_groups as vtiger_groups" . $module . " on vtiger_groups" . $module . ".groupid = vtiger_crmentity.smownerid
            left join vtiger_users as vtiger_users" . $module . " on vtiger_users" . $module . ".id = vtiger_crmentity.smownerid
			left join vtiger_users as vtiger_lastModifiedBy" . $module . " on vtiger_lastModifiedBy" . $module . ".id = vtiger_crmentity.modifiedby
			left join vtiger_groups on vtiger_groups.groupid = vtiger_crmentity.smownerid
            left join vtiger_users on vtiger_users.id = vtiger_crmentity.smownerid";

		$fields_query = $adb->pquery("SELECT vtiger_field.fieldname,vtiger_field.tablename,vtiger_field.fieldid from vtiger_field INNER JOIN vtiger_tab on vtiger_tab.name = ? WHERE vtiger_tab.tabid=vtiger_field.tabid AND vtiger_field.uitype IN (10) and vtiger_field.presence in (0,2)", array($module));

		if ($adb->num_rows($fields_query) > 0) {
			for ($i = 0; $i < $adb->num_rows($fields_query); $i++) {
				$field_name = $adb->query_result($fields_query, $i, 'fieldname');
				$field_id = $adb->query_result($fields_query, $i, 'fieldid');
				$tab_name = $adb->query_result($fields_query, $i, 'tablename');
				$ui10_modules_query = $adb->pquery("SELECT relmodule FROM vtiger_fieldmodulerel WHERE fieldid=?", array($field_id));

				if ($adb->num_rows($ui10_modules_query) > 0) {
					$query.= " left join vtiger_crmentity as vtiger_crmentityRel$module$field_id on vtiger_crmentityRel$module$field_id.crmid = $tab_name.$field_name and vtiger_crmentityRel$module$field_id.deleted=0";
					for ($j = 0; $j < $adb->num_rows($ui10_modules_query); $j++) {
						$rel_mod = $adb->query_result($ui10_modules_query, $j, 'relmodule');
						$rel_obj = CRMEntity::getInstance($rel_mod);
						vtlib_setup_modulevars($rel_mod, $rel_obj);

						$rel_tab_name = $rel_obj->table_name;
						$rel_tab_index = $rel_obj->table_index;
						$query.= " left join $rel_tab_name as " . $rel_tab_name . "Rel$module$field_id on " . $rel_tab_name . "Rel$module$field_id.$rel_tab_index = vtiger_crmentityRel$module$field_id.crmid";
					}
				}
			}
		}
		return $query;
	}

	/*
	 * Function to get the secondary query part of a report for which generateReportsSecQuery Doesnt exist in module
	 * @param - $module primary module name
	 * @param - $secmodule secondary module name
	 * returns the query string formed on fetching the related data for report for secondary module
	 */

	function generateReportsSecQuery($module, $secmodule) {
		global $adb;
		$secondary = CRMEntity::getInstance($secmodule);

		vtlib_setup_modulevars($secmodule, $secondary);

		$tablename = $secondary->table_name;
		$tableindex = $secondary->table_index;
		$modulecftable = $secondary->customFieldTable[0];
		$modulecfindex = $secondary->customFieldTable[1];

		if (isset($modulecftable)) {
			$cfquery = "left join $modulecftable as $modulecftable on $modulecftable.$modulecfindex=$tablename.$tableindex";
		} else {
			$cfquery = '';
		}

		$query = $this->getRelationQuery($module, $secmodule, "$tablename", "$tableindex");
		$query .=" 	left join vtiger_crmentity as vtiger_crmentity$secmodule on vtiger_crmentity$secmodule.crmid = $tablename.$tableindex AND vtiger_crmentity$secmodule.deleted=0
					$cfquery
					left join vtiger_groups as vtiger_groups" . $secmodule . " on vtiger_groups" . $secmodule . ".groupid = vtiger_crmentity$secmodule.smownerid
		            left join vtiger_users as vtiger_users" . $secmodule . " on vtiger_users" . $secmodule . ".id = vtiger_crmentity$secmodule.smownerid
   left join vtiger_users as vtiger_lastModifiedBy" . $secmodule . " on vtiger_lastModifiedBy" . $secmodule . ".id = vtiger_crmentity" . $secmodule . ".modifiedby";

		$fields_query = $adb->pquery("SELECT vtiger_field.fieldname,vtiger_field.tablename,vtiger_field.fieldid from vtiger_field INNER JOIN vtiger_tab on vtiger_tab.name = ? WHERE vtiger_tab.tabid=vtiger_field.tabid AND vtiger_field.uitype IN (10) and vtiger_field.presence in (0,2)", array($secmodule));

		if ($adb->num_rows($fields_query) > 0) {
			for ($i = 0; $i < $adb->num_rows($fields_query); $i++) {
				$field_name = $adb->query_result($fields_query, $i, 'fieldname');
				$field_id = $adb->query_result($fields_query, $i, 'fieldid');
				$tab_name = $adb->query_result($fields_query, $i, 'tablename');
				$ui10_modules_query = $adb->pquery("SELECT relmodule FROM vtiger_fieldmodulerel WHERE fieldid=?", array($field_id));

				if ($adb->num_rows($ui10_modules_query) > 0) {
					$query.= " left join vtiger_crmentity as vtiger_crmentityRel$secmodule$i on vtiger_crmentityRel$secmodule$i.crmid = $tab_name.$field_name and vtiger_crmentityRel$secmodule$i.deleted=0";
					for ($j = 0; $j < $adb->num_rows($ui10_modules_query); $j++) {
						$rel_mod = $adb->query_result($ui10_modules_query, $j, 'relmodule');
						$rel_obj = CRMEntity::getInstance($rel_mod);
						vtlib_setup_modulevars($rel_mod, $rel_obj);

						$rel_tab_name = $rel_obj->table_name;
						$rel_tab_index = $rel_obj->table_index;
						$query.= " left join $rel_tab_name as " . $rel_tab_name . "Rel$secmodule on " . $rel_tab_name . "Rel$secmodule.$rel_tab_index = vtiger_crmentityRel$secmodule$i.crmid";
					}
				}
			}
		}

		return $query;
	}

	/*
	 * Function to get the security query part of a report
	 * @param - $module primary module name
	 * returns the query string formed on fetching the related data for report for security of the module
	 */

	function getListViewSecurityParameter($module) {
		$tabid = getTabid($module);
		global $current_user;
		if ($current_user) {
			require('user_privileges/user_privileges_' . $current_user->id . '.php');
			require('user_privileges/sharing_privileges_' . $current_user->id . '.php');
		}
		$sec_query .= " and (vtiger_crmentity.smownerid in($current_user->id) or vtiger_crmentity.smownerid in(select vtiger_user2role.userid from vtiger_user2role inner join vtiger_users on vtiger_users.id=vtiger_user2role.userid inner join vtiger_role on vtiger_role.roleid=vtiger_user2role.roleid where vtiger_role.parentrole like '" . $current_user_parent_role_seq . "::%') or vtiger_crmentity.smownerid in(select shareduserid from vtiger_tmp_read_user_sharing_per where userid=" . $current_user->id . " and tabid=" . $tabid . ") or (";

		if (sizeof($current_user_groups) > 0) {
			$sec_query .= " vtiger_groups.groupid in (" . implode(",", $current_user_groups) . ") or ";
		}
		$sec_query .= " vtiger_groups.groupid in(select vtiger_tmp_read_group_sharing_per.sharedgroupid from vtiger_tmp_read_group_sharing_per where userid=" . $current_user->id . " and tabid=" . $tabid . "))) ";
		return $sec_query;
	}

	/*
	 * Function to get the security query part of a report
	 * @param - $module primary module name
	 * returns the query string formed on fetching the related data for report for security of the module
	 */

	function getSecListViewSecurityParameter($module) {
		$tabid = getTabid($module);
		global $current_user;
		if ($current_user) {
			require('user_privileges/user_privileges_' . $current_user->id . '.php');
			require('user_privileges/sharing_privileges_' . $current_user->id . '.php');
		}
		$sec_query .= " and (vtiger_crmentity$module.smownerid in($current_user->id) or vtiger_crmentity$module.smownerid in(select vtiger_user2role.userid from vtiger_user2role inner join vtiger_users on vtiger_users.id=vtiger_user2role.userid inner join vtiger_role on vtiger_role.roleid=vtiger_user2role.roleid where vtiger_role.parentrole like '" . $current_user_parent_role_seq . "::%') or vtiger_crmentity$module.smownerid in(select shareduserid from vtiger_tmp_read_user_sharing_per where userid=" . $current_user->id . " and tabid=" . $tabid . ") or (";

		if (sizeof($current_user_groups) > 0) {
			$sec_query .= " vtiger_groups$module.groupid in (" . implode(",", $current_user_groups) . ") or ";
		}
		$sec_query .= " vtiger_groups$module.groupid in(select vtiger_tmp_read_group_sharing_per.sharedgroupid from vtiger_tmp_read_group_sharing_per where userid=" . $current_user->id . " and tabid=" . $tabid . "))) ";
		return $sec_query;
	}

	/*
	 * Function to get the relation query part of a report
	 * @param - $module primary module name
	 * @param - $secmodule secondary module name
	 * returns the query string formed on relating the primary module and secondary module
	 */

	function getRelationQuery($module, $secmodule, $table_name, $column_name) {
		$tab = getRelationTables($module, $secmodule);

		foreach ($tab as $key => $value) {
			$tables[] = $key;
			$fields[] = $value;
		}
		$pritablename = $tables[0];
		$sectablename = $tables[1];
		$prifieldname = $fields[0][0];
		$secfieldname = $fields[0][1];
		$tmpname = $pritablename . 'tmp' . $secmodule;
		$condition = "";
		if (!empty($tables[1]) && !empty($fields[1])) {
			$condvalue = $tables[1] . "." . $fields[1];
			$condition = "$pritablename.$prifieldname=$condvalue";
		} else {
			$condvalue = $table_name . "." . $column_name;
			$condition = "$pritablename.$secfieldname=$condvalue";
		}
		$secQuery = "select $table_name.* from $table_name inner join vtiger_crmentity on " .
				"vtiger_crmentity.crmid=$table_name.$column_name and vtiger_crmentity.deleted=0";
		$query = '';
		if ($pritablename == 'vtiger_crmentityrel') {
			$condition = "($table_name.$column_name={$tmpname}.{$secfieldname} " .
					"OR $table_name.$column_name={$tmpname}.{$prifieldname})";
			$query = " left join vtiger_crmentityrel as $tmpname ON ($condvalue={$tmpname}.{$secfieldname} " .
					"OR $condvalue={$tmpname}.{$prifieldname}) ";
		} elseif (strripos($pritablename, 'rel') === (strlen($pritablename) - 3)) {
			$instance = self::getInstance($module);
			$sectableindex = $instance->tab_name_index[$sectablename];
			$condition = "$table_name.$column_name=$tmpname.$secfieldname";
			$query = " left join $pritablename as $tmpname ON ($sectablename.$sectableindex=$tmpname.$prifieldname)";
			if($secmodule == 'Calendar'){
				$condition .= " AND $table_name.activitytype != 'Emails'";
			}else if($secmodule == 'Leads'){
				$condition .= " AND $table_name.converted = 0";
			}

		}

		$query .= " left join ($secQuery) as $table_name on {$condition}";

		return $query;
	}

	/** END * */

	/**
	 * This function handles the import for uitype 10 fieldtype
	 * @param string $module - the current module name
	 * @param string fieldname - the related to field name
	 */
	function add_related_to($module, $fieldname) {
		global $adb, $imported_ids, $current_user;

		$related_to = $this->column_fields[$fieldname];

		if (empty($related_to)) {
			return false;
		}

		//check if the field has module information; if not get the first module
		if (!strpos($related_to, "::::")) {
			$module = getFirstModule($module, $fieldname);
			$value = $related_to;
		} else {
			//check the module of the field
			$arr = array();
			$arr = explode("::::", $related_to);
			$module = $arr[0];
			$value = $arr[1];
		}

		$focus1 = CRMEntity::getInstance($module);

		$entityNameArr = getEntityField($module);
		$entityName = $entityNameArr['fieldname'];
		$query = "SELECT vtiger_crmentity.deleted, $focus1->table_name.*
					FROM $focus1->table_name
					INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid=$focus1->table_name.$focus1->table_index
						where $entityName=? and vtiger_crmentity.deleted=0";
		$result = $adb->pquery($query, array($value));

		if (!isset($this->checkFlagArr[$module])) {
			$this->checkFlagArr[$module] = (isPermitted($module, 'EditView', '') == 'yes');
		}

		if ($adb->num_rows($result) > 0) {
			//record found
			$focus1->id = $adb->query_result($result, 0, $focus1->table_index);
		} elseif ($this->checkFlagArr[$module]) {
			//record not found; create it
			$focus1->column_fields[$focus1->list_link_field] = $value;
			$focus1->column_fields['assigned_user_id'] = $current_user->id;
			$focus1->column_fields['modified_user_id'] = $current_user->id;
			$focus1->save($module);

			$last_import = new UsersLastImport();
			$last_import->assigned_user_id = $current_user->id;
			$last_import->bean_type = $module;
			$last_import->bean_id = $focus1->id;
			$last_import->save();
		} else {
			//record not found and cannot create
			$this->column_fields[$fieldname] = "";
			return false;
		}
		if (!empty($focus1->id)) {
			$this->column_fields[$fieldname] = $focus1->id;
			return true;
		} else {
			$this->column_fields[$fieldname] = "";
			return false;
		}
	}

	/**
	 * To keep track of action of field filtering and avoiding doing more than once.
	 *
	 * @var Array
	 */
	protected $__inactive_fields_filtered = false;

	/**
	 * Filter in-active fields based on type
	 *
	 * @param String $module
	 */
	function filterInactiveFields($module) {
		if ($this->__inactive_fields_filtered) {
			return;
		}

		global $adb, $mod_strings;

		// Look for fields that has presence value NOT IN (0,2)
		$cachedModuleFields = VTCacheUtils::lookupFieldInfo_Module($module, array('1'));
		if ($cachedModuleFields === false) {
			// Initialize the fields calling suitable API
			getColumnFields($module);
			$cachedModuleFields = VTCacheUtils::lookupFieldInfo_Module($module, array('1'));
		}

		$hiddenFields = array();

		if ($cachedModuleFields) {
			foreach ($cachedModuleFields as $fieldinfo) {
				$fieldLabel = $fieldinfo['fieldlabel'];
				// NOTE: We should not translate the label to enable field diff based on it down
				$fieldName = $fieldinfo['fieldname'];
				$tableName = str_replace("vtiger_", "", $fieldinfo['tablename']);
				$hiddenFields[$fieldLabel] = array($tableName => $fieldName);
			}
		}

		if (isset($this->list_fields)) {
			$this->list_fields = array_diff_assoc($this->list_fields, $hiddenFields);
		}

		if (isset($this->search_fields)) {
			$this->search_fields = array_diff_assoc($this->search_fields, $hiddenFields);
		}

		// To avoid re-initializing everytime.
		$this->__inactive_fields_filtered = true;
	}

	/** END * */
	function buildSearchQueryForFieldTypes($uitypes, $value) {
		global $adb;

		if (!is_array($uitypes))
			$uitypes = array($uitypes);
		$module = get_class($this);

		$cachedModuleFields = VTCacheUtils::lookupFieldInfo_Module($module);
		if ($cachedModuleFields === false) {
			getColumnFields($module); // This API will initialize the cache as well
			// We will succeed now due to above function call
			$cachedModuleFields = VTCacheUtils::lookupFieldInfo_Module($module);
		}

		$lookuptables = array();
		$lookupcolumns = array();
		foreach ($cachedModuleFields as $fieldinfo) {
			if (in_array($fieldinfo['uitype'], $uitypes)) {
				$lookuptables[] = $fieldinfo['tablename'];
				$lookupcolumns[] = $fieldinfo['columnname'];
			}
		}

		$entityfields = getEntityField($module);
		$querycolumnnames = implode(',', $lookupcolumns);
		$entitycolumnnames = $entityfields['fieldname'];
		$query = "select crmid as id, $querycolumnnames, $entitycolumnnames as name ";
		$query .= " FROM $this->table_name ";
		$query .=" INNER JOIN vtiger_crmentity ON $this->table_name.$this->table_index = vtiger_crmentity.crmid AND deleted = 0 ";

		//remove the base table
		$LookupTable = array_unique($lookuptables);
		$indexes = array_keys($LookupTable, $this->table_name);
		if (!empty($indexes)) {
			foreach ($indexes as $index) {
				unset($LookupTable[$index]);
			}
		}
		foreach ($LookupTable as $tablename) {
			$query .= " INNER JOIN $tablename
						on $this->table_name.$this->table_index = $tablename." . $this->tab_name_index[$tablename];
		}
		if (!empty($lookupcolumns)) {
			$query .=" WHERE ";
			$i = 0;
			$columnCount = count($lookupcolumns);
			foreach ($lookupcolumns as $columnname) {
				if (!empty($columnname)) {
					if ($i == 0 || $i == ($columnCount))
						$query .= sprintf("%s = '%s'", $columnname, $value);
					else
						$query .= sprintf(" OR %s = '%s'", $columnname, $value);
					$i++;
				}
			}
		}
		return $query;
	}

	/**
	 *
	 * @param String $tableName
	 * @return String
	 */
	public function getJoinClause($tableName) {
		if (strripos($tableName, 'rel') === (strlen($tableName) - 3)) {
			return 'LEFT JOIN';
		} else {
			return 'INNER JOIN';
		}
	}

	/**
	 *
	 * @param <type> $module
	 * @param <type> $user
	 * @param <type> $parentRole
	 * @param <type> $userGroups
	 */
	function getNonAdminAccessQuery($module, $user, $parentRole, $userGroups) {
		$query = $this->getNonAdminUserAccessQuery($user, $parentRole, $userGroups);
		if (!empty($module)) {
			$moduleAccessQuery = $this->getNonAdminModuleAccessQuery($module, $user);
			if (!empty($moduleAccessQuery)) {
				$query .= " UNION $moduleAccessQuery";
			}
		}
		return $query;
	}

	/**
	 *
	 * @param <type> $user
	 * @param <type> $parentRole
	 * @param <type> $userGroups
	 */
	function getNonAdminUserAccessQuery($user, $parentRole, $userGroups) {
		$query = "(SELECT $user->id as id) UNION (SELECT vtiger_user2role.userid AS userid FROM " .
				"vtiger_user2role INNER JOIN vtiger_users ON vtiger_users.id=vtiger_user2role.userid " .
				"INNER JOIN vtiger_role ON vtiger_role.roleid=vtiger_user2role.roleid WHERE " .
				"vtiger_role.parentrole like '$parentRole::%')";
		if (count($userGroups) > 0) {
			$query .= " UNION (SELECT groupid FROM vtiger_groups where" .
					" groupid in (" . implode(",", $userGroups) . "))";
		}
		return $query;
	}

	/**
	 *
	 * @param <type> $module
	 * @param <type> $user
	 */
	function getNonAdminModuleAccessQuery($module, $user) {
		require('user_privileges/sharing_privileges_' . $user->id . '.php');
		$tabId = getTabid($module);
		$sharingRuleInfoVariable = $module . '_share_read_permission';
		$sharingRuleInfo = $$sharingRuleInfoVariable;
		$sharedTabId = null;
		$query = '';
		if (!empty($sharingRuleInfo) && (count($sharingRuleInfo['ROLE']) > 0 ||
				count($sharingRuleInfo['GROUP']) > 0)) {
			$query = " (SELECT shareduserid FROM vtiger_tmp_read_user_sharing_per " .
					"WHERE userid=$user->id AND tabid=$tabId) UNION (SELECT " .
					"vtiger_tmp_read_group_sharing_per.sharedgroupid FROM " .
					"vtiger_tmp_read_group_sharing_per WHERE userid=$user->id AND tabid=$tabId)";
		}
		return $query;
	}

	/**
	 *
	 * @param <type> $module
	 * @param <type> $user
	 * @param <type> $parentRole
	 * @param <type> $userGroups
	 */
	protected function setupTemporaryTable($tableName, $tabId, $user, $parentRole, $userGroups) {
		$module = null;
		if (!empty($tabId)) {
			$module = getTabModuleName($tabId);
		}
		$query = $this->getNonAdminAccessQuery($module, $user, $parentRole, $userGroups);
		$query = "create temporary table IF NOT EXISTS $tableName(id int(11) primary key) ignore " .
				$query;
		$db = PearDatabase::getInstance();
		$result = $db->pquery($query, array());
		if (is_object($result)) {
			return true;
		}
		return false;
	}

	/**
	 *
	 * @param String $module - module name for which query needs to be generated.
	 * @param Users $user - user for which query needs to be generated.
	 * @return String Access control Query for the user.
	 */
	function getNonAdminAccessControlQuery($module, $user, $scope = '') {
//var_dump("getNonAdminAccessControlQuery(mod, usr, scope):", $module, $user, $scope);
//var_dump("getNonAdminAccessControlQuery(mod, scope):", $module, $scope);
		require('user_privileges/user_privileges_' . $user->id . '.php');
		require('user_privileges/sharing_privileges_' . $user->id . '.php');
		$query = ' ';
		$tabId = getTabid($module);
		if ($is_admin == false && $profileGlobalPermission[1] == 1 && $profileGlobalPermission[2]
				== 1 && $defaultOrgSharingPermission[$tabId] == 3) {
			$tableName = 'vt_tmp_u' . $user->id;
			$sharingRuleInfoVariable = $module . '_share_read_permission';
			$sharingRuleInfo = $$sharingRuleInfoVariable;
			$sharedTabId = null;
			if (!empty($sharingRuleInfo) && (count($sharingRuleInfo['ROLE']) > 0 ||
					count($sharingRuleInfo['GROUP']) > 0)) {
				$tableName = $tableName . '_t' . $tabId;
				$sharedTabId = $tabId;
			} elseif ($module == 'Calendar' || !empty($scope)) {
				$tableName .= '_t' . $tabId;
			}
			$this->setupTemporaryTable($tableName, $sharedTabId, $user, $current_user_parent_role_seq, $current_user_groups);
			$query = " INNER JOIN $tableName $tableName$scope ON $tableName$scope.id = " .
					"vtiger_crmentity$scope.smownerid ";
		}
		return $query;
	}

	public function listQueryNonAdminChange($query, $scope = '') {
		//make the module base table as left hand side table for the joins,
		//as mysql query optimizer puts crmentity on the left side and considerably slow down
		$query = preg_replace('/\s+/', ' ', $query);
		if (strripos($query, ' WHERE ') !== false) {
			vtlib_setup_modulevars($module, $this);
			$query = str_ireplace(' where ', " WHERE $this->table_name.$this->table_index > 0  AND ", $query);
		}
		return $query;
	}

	/*
	 * Function to get the relation tables for related modules
	 * @param String $secmodule - $secmodule secondary module name
	 * @return Array returns the array with table names and fieldnames storing relations
	 * between module and this module
	 */

	function setRelationTables($secmodule) {
		$rel_tables = array(
			"Documents" => array("vtiger_senotesrel" => array("crmid", "notesid"),
				$this->table_name => $this->table_index),
		);
		return $rel_tables[$secmodule];
	}

	/**
	 * Function to clear the fields which needs to be saved only once during the Save of the record
	 * For eg: Comments of HelpDesk should be saved only once during one save of a Trouble Ticket
	 */
	function clearSingletonSaveFields() {
		return;
	}

	/**
	 * Function to track when a new record is linked to a given record
	 */
	function trackLinkedInfo($module, $crmid, $with_module, $with_crmid) {
		global $current_user;
		$adb = PearDatabase::getInstance();
		$currentTime = date('Y-m-d H:i:s');

		$adb->pquery('UPDATE vtiger_crmentity SET modifiedtime = ?, modifiedby = ? WHERE crmid = ?', array($currentTime, $current_user->id, $crmid));
	}

	/**
	 * Function to get sort order
	 * return string  $sorder    - sortorder string either 'ASC' or 'DESC'
	 */
	function getSortOrder() {
		global $log,$currentModule;
		$log->debug("Entering getSortOrder() method ...");
		if (isset($_REQUEST['sorder']))
			$sorder = $this->db->sql_escape_string($_REQUEST['sorder']);
		else
			$sorder = (($_SESSION[$currentModule . '_Sort_Order'] != '') ? ($_SESSION[$currentModule . '_Sort_Order']) : ($this->default_sort_order));
		$log->debug("Exiting getSortOrder() method ...");
		return $sorder;
	}

	/**
	 * Function to get order by
	 * return string  $order_by    - fieldname(eg: 'accountname')
	 */
	function getOrderBy() {
		global $log, $currentModule;
		$log->debug("Entering getOrderBy() method ...");

		$use_default_order_by = '';
		if (PerformancePrefs::getBoolean('LISTVIEW_DEFAULT_SORTING', true)) {
			$use_default_order_by = $this->default_order_by;
		}

		if (isset($_REQUEST['order_by']))
			$order_by = $this->db->sql_escape_string($_REQUEST['order_by']);
		else
			$order_by = (($_SESSION[$currentModule.'_Order_By'] != '') ? ($_SESSION[$currentModule.'_Order_By']) : ($use_default_order_by));
		$log->debug("Exiting getOrderBy method ...");
		return $order_by;
	}

	// Mike Crowe Mod --------------------------------------------------------

	/**
	 * Function to Listview buttons
	 * return array  $list_buttons - for module (eg: 'Accounts')
	 */
	function getListButtons($app_strings) {
		$list_buttons = Array();

		if (isPermitted($currentModule, 'Delete', '') == 'yes')
			$list_buttons['del'] = $app_strings[LBL_MASS_DELETE];
		if (isPermitted($currentModule, 'EditView', '') == 'yes') {
			$list_buttons['mass_edit'] = $app_strings[LBL_MASS_EDIT];
			// Mass Edit could be used to change the owner as well!
			//$list_buttons['c_owner'] = $app_strings[LBL_CHANGE_OWNER];
		}
		return $list_buttons;
	}

	/**
	 * Function to track when a record is unlinked to a given record
	 */
	function trackUnLinkedInfo($module, $crmid, $with_module, $with_crmid) {
		global $current_user;
		$adb = PearDatabase::getInstance();
		$currentTime = date('Y-m-d H:i:s');

		$adb->pquery('UPDATE vtiger_crmentity SET modifiedtime = ?, modifiedby = ? WHERE crmid = ?', array($currentTime, $current_user->id, $crmid));
	}

	//function kardex($sucursal, $almacen, $tipo_documento, $folio, $fecha, $producto, $codigo_articulo, $entradas, $salidas)
	function kardex($parametros)
	{
		// Obtiene parámetros.
		$sucursal = $parametros["sucursal"];
		$almacen = $parametros["almacen"];
		$tipo_documento = $parametros["tipo_documento"];
		$folio = $parametros["folio"];
		$fecha = $parametros["fecha"];
		$producto = $parametros["producto"];
		$codigo_articulo = $parametros["codigo_articulo"];
		$entradas = $parametros["entradas"];
		$salidas = $parametros["salidas"];

		global $adb,$current_user;

		// Obtiene dueño de los registros.

		// Carga configuración de dueños predeterminados y obtiene el de kdxexi.
		require("duenos.php");
		//$dueno = $duenos["kdxexi"];
		$criterio = "kdxexi";

		$suc_id = $parametros["sucursal"];
		$dueno = $duenos[$suc_id][$criterio];
//var_dump($suc_id);
//var_dump($dueno);
		if ($dueno == "")
		{
			$dueno = $duenos[$criterio];
			if ($dueno == "")
			{
				$dueno = "1";
			}
		}

		// Revisa si ya existe el registro.
		$consulta = "select kdx.* from vtiger_kardex kdx, vtiger_crmentity e where kdx.movimiento = '$folio' and e.crmid = kdx.kardexid and e.deleted = '0' and kdx.codigo = '$codigo_articulo' and kdx.almacenesid = '$almacen'";
/******************************
echo "<pre>";
var_dump($consulta);
die;
*******************************/
		$resultado = $adb->query($consulta);
		$renglon = $adb->fetch_array($resultado);
		$id_kardex = $renglon["kardexid"];
                $kardex = new Kardex;
                if ($id_kardex != "")
                {
                	$kardex->retrieve_entity_info($id_kardex, "Kardex");
                }   
		$kardex = new Kardex;
		//$kardex->column_fields["assigned_user_id"] = $current_user->id;
		$kardex->column_fields["assigned_user_id"] = $dueno;
		$kardex->column_fields["sucursal"] = $sucursal;
		$kardex->column_fields["almacen"] = $almacen;
		$kardex->column_fields["tipo_documento"] = $tipo_documento;
		$kardex->column_fields["movimiento"] = $folio;
		$kardex->column_fields["producto"] = $producto;
		$kardex->column_fields["codigo"] = $codigo_articulo;
		$kardex->column_fields["fecha"] = $fecha;
		$kardex->column_fields["entradas"] = $entradas;
		$kardex->column_fields["salidas"] = $salidas;
		$kardex->save("Kardex", $id_kardex);
		//die("hola kardex");

		// Crea o actualiza, según sea el caso, el registro de existencias.
		// Revisa si ya existe el registro.
		$consulta = "select exi.* from vtiger_existencias exi, vtiger_crmentity e where e.crmid = exi.existenciasid and e.deleted = '0' and exi.codigo_producto = '$codigo_articulo' and exi.almacenesid = '$almacen'";
		//var_dump($consulta);
		//die;
		$resultado = $adb->query($consulta);
		$renglon = $adb->fetch_array($resultado);
		$id_exi = $renglon["existenciasid"];                          
		$exi = new Existencias;
		if ($id_exi != "")
		{
			$exi->retrieve_entity_info($id_exi, "Existencias");
		}
		//$exi->column_fields["assigned_user_id"] = $current_user->id;
		$exi->column_fields["assigned_user_id"] = $dueno;
		$exi->column_fields["sucursal"] = $sucursal;
		$exi->column_fields["almacen"] = $almacen;
		$exi->column_fields["producto"] = $producto;
		$exi->column_fields["codigo_producto"] = $codigo_articulo;
		$exi->column_fields["cantidad"] = 0;
		$exi->save("Existencias", $id_exi);

		// Calcula cantidades reconstruyendo a partir de la fecha efectiva de la recepción.
		$exi->calcular($fecha, $almacen);
	}

	function obtener_id()
	{
		// Unifica el id de la entidad.
		// Vtiger tiene un comportamiento un tanto extraño, pues guarda el id de una entidad en dos variables difefentes: $this->id o $this->column_fields["record_id"] .
		$id = ((int)$this->id > 0)?(int)$this->id:(int)$this->column_fields["record_id"];

		return $id;
	}

	function asignar_dueno($criterio = "obra")
	{
		// Asigna el dueño del registro de acuerdo a quien tiene asignada la obra. Hecho originalmente para remisiones.
		
		global $adb;

//var_dump($criterio);
		// Carga configuración de dueños predeterminados.
		require("duenos.php");

		switch ($criterio)
		{
			case "obra":
				// Obtiene el dueño de la obra.
				$consulta = "select e.smownerid from vtiger_crmentity e where e.crmid = '".$this->column_fields["obra"]."'";
//var_dump($consulta);
				$resultado = $adb->query($consulta);
				$renglon = $adb->fetch_array($resultado);
				$dueno = $renglon["smownerid"];;
			break;
			case "cliente":
				// Obtiene el dueño del registro del cliente.
				$consulta = "select e.smownerid from vtiger_crmentity e where e.crmid = '".$this->column_fields["cliente"]."'";
//var_dump($consulta);
				$resultado = $adb->query($consulta);
				$renglon = $adb->fetch_array($resultado);
				$dueno = $renglon["smownerid"];;
			break;
/********************
			case "flota":
				$dueno = $duenos["flota"];
			break;
			case "servicio":
				$dueno = $duenos["servicio"];
			break;
			case "kdxexi":
				$dueno = $duenos["kdxexi"];
			break;
*********************/
			default:
				$suc_id = $this->column_fields["sucursal"];
				$obr_id = $this->column_fields["obra"];
				if (($suc_id == "") && ($obr_id != ""))
				{
					$obr = new Obras;
					$obr->retrieve_entity_info($obr_id, "Obras");
					$suc_id = $obr->column_fields["sucursal"];
				}
				$dueno = $duenos[$suc_id][$criterio];
//var_dump($suc_id);
//var_dump($dueno);
				if ($dueno == "")
				{
					$dueno = $duenos[$criterio];
					if ($dueno == "")
					{
						$dueno = "1";
					}
				}
			break;
		}
//var_dump($renglon);
//var_dump($this->obtener_id());
		$id = $this->obtener_id();
		$consulta = "update vtiger_crmentity e set e.smownerid = '$dueno' where e.crmid = '$id'";
//var_dump($consulta);
//die;
		$adb->query($consulta);
	}

	function concatenar_numeros_internos($modulo)
	{
		global $adb;

		for ($i = 1; $i <= 10; $i++)
		{
			if ($this->column_fields["entrega{$i}_equipo"] != "")
			{
				$flr = new Flota_renta;
				$flr->retrieve_entity_info($this->column_fields["entrega{$i}_equipo"], "Flota_renta");
				//$codigos[] = $flr->column_fields["numero_interno"];
				$codigos[] = $flr->column_fields["numero_interno"].":".$this->column_fields["entrega{$i}_cantidad"];
			}

			if ($this->column_fields["recoger{$i}_equipo"] != "")
			{
				$flr = new Flota_renta;
				$flr->retrieve_entity_info($this->column_fields["recoger{$i}_equipo"], "Flota_renta");
				//$codigos[] = $flr->column_fields["numero_interno"];
				$codigos[] = $flr->column_fields["numero_interno"].":".$this->column_fields["recoger{$i}_cantidad"];
			}
		}

		if (is_array($codigos))
		{
			$numeros_internos = implode(" ", $codigos);
		}

		switch($modulo)
		{
			case "Entregas":
				$consulta = "update vtiger_entregas set numeros_internos = '$numeros_internos' where entregasid = '".$this->obtener_id()."'";
				$adb->query($consulta);
			break;
			case "Cambios":
				$consulta = "update vtiger_cambios set numeros_internos = '$numeros_internos' where cambiosid = '".$this->obtener_id()."'";
				$adb->query($consulta);
			break;
			case "Recolecciones":
				$consulta = "update vtiger_recolecciones set numeros_internos = '$numeros_internos' where recoleccionesid = '".$this->obtener_id()."'";
				$adb->query($consulta);
			break;
		}
//var_dump($consulta);
//die;
	}

	function obtener_frecuencia_facturacion()
	{
		if ($this->column_fields["cliente"] != "")
		{
			$cliente = new Accounts;
			$cliente->retrieve_entity_info($this->column_fields["cliente"], "Accounts");
			$frecuencia_facturacion = $cliente->personalizado("frecuencia_facturacion");
		}

		return $frecuencia_facturacion;
	}

	function facturar()
	{
		// Factura periodos.
		$this->facturar_periodos();

		// Factura servicios.
		$servicios[] = "flete";
		$servicios[] = "reparacion";

		foreach ($servicios as $servicio)
		{
			$this->facturar_servicio($servicio);
		}
	}

	function facturar_periodos()
	{
		global $adb, $current_user;

		$consulta = "select per.periodosid, per.idv from vtiger_periodos per, vtiger_crmentity e where e.crmid = per.periodosid and e.deleted = '0' and per.movimiento_cierre = '".$this->column_fields["folio"]."'";
		//var_dump($consulta);
		$resultado = $adb->query($consulta);
		while ($renglon = $adb->fetch_array($resultado))
		{
			//echo "<br>".$renglon["idv"];
			$per = new Periodos;
			$per->retrieve_entity_info($renglon["periodosid"], "Periodos");
			$per->limpiar_por_facturar();
			$per->facturar($per->column_fields["fecha_fin"], true);
		}
	}

	//function facturar_servicio($servicio, $forzar = false, $flr_id = "")
	function facturar_servicio($servicio, $forzar = false, $flr_id = "", $precio_unitario = "")
	{
		require("config_cor.php");

		global $adb, $current_user;

		$codigos["flete"] = "Flete";
		$codigos["reparacion"] = "Reparaci%n";

		$etiquetas["flete"] = "Flete";
		$etiquetas["reparacion"] = "Reparación";

		//$productos["flete"] = 4169;
		//$productos["reparacion"] = 4173;

		$productos["flete"] = $config_cor["flete"];
		$productos["reparacion"] = $config_cor["reparacion"];

		if (($this->column_fields[$servicio]) || $forzar)
		{
			if ($flr_id == "")
			{
				$consulta = "select pfa.* from vtiger_por_facturar pfa, vtiger_crmentity e where e.crmid = pfa.por_facturarid and e.deleted = '0' and pfa.concepto like '".$codigos[$servicio]."' and pfa.movimiento = '".$this->column_fields["folio"]."'";
			}
			else
			{
				$consulta = "select pfa.* from vtiger_por_facturar pfa, vtiger_crmentity e where e.crmid = pfa.por_facturarid and e.deleted = '0' and pfa.concepto like '".$codigos[$servicio]."' and pfa.movimiento = '".$this->column_fields["folio"]."' and pfa.flota_rentaid = '$flr_id'";
			}
//var_dump($consulta);
//die;
       			$resultado = $adb->query($consulta);
			$renglon = $adb->fetch_array($resultado);
			$id_por_facturar = $renglon["por_facturarid"];

			$pfa = new Por_facturar;
			if ($id_por_facturar != "")
			{
			$pfa->retrieve_entity_info($id_por_facturar, "Por_facturar");
			}
			$pfa->column_fields["assigned_user_id"] = $current_user->id;
			$pfa->column_fields["sucursal"] = $this->column_fields["sucursal"];
			$pfa->column_fields["cliente"] = $this->column_fields["cliente"];
			$pfa->column_fields["obra"] = $this->column_fields["obra"];
			$pfa->column_fields["cantidad"] = 1;
			$pfa->column_fields["concepto"] = $etiquetas[$servicio];
			$pfa->column_fields["producto"] = $productos[$servicio];
			if ($flr_id != "")
			{
				$pfa->column_fields["equipo"] = $flr_id;
			}
			if ($precio_unitario != "")
			{
				$pfa->column_fields["precio_unitario_fac"] = $precio_unitario;
			}
			$pfa->column_fields["producto"] = $productos[$servicio];
			$pfa->column_fields["movimiento"] = $this->column_fields["folio"];
			$pfa->column_fields["estado"] = "Pendiente";
			$pfa->save("Por_facturar", $id_por_facturar);
		}
		else
		{
			// Si no se cobra se elimina cualquier posible registro existente.
			$consulta = "update vtiger_por_facturar pfa, vtiger_crmentity e set e.deleted = '1' where e.crmid = pfa.por_facturarid and e.deleted = '0' and pfa.concepto like '".$codigos[$servicio]."' and pfa.movimiento = '".$this->column_fields["folio"]."'";
			//var_dump($consulta);
			$adb->query($consulta);
		}
	}

	// Factura cualquier concepto. Pensado para poder facturar cualquier producto o servicio.
	function facturar_concepto($parametros)
	{
/**************************
echo "<pre>";
var_dump($parametros);
echo "</pre>";
die;
*************************/
		global $adb;

		// Parámetros:
		// codigo_concepto (para hacer búsquedas en SQL, puede llevar %).
		// concepto (etiqueta que aparecerá en el pfa, permite acentos).
		// cantidad
		// prod_id (crmid del producto a registrar).
		// ns (arreglo con los crmid de los ns en caso de existir).
		// flr (crmid del registro de flota relacionado en caso de producto agrupado).

		// Si hay números de serie hace un barrido para generarle a c/u un pfa.
		if (is_array($parametros["ns"]))
		{
			foreach ($parametros["ns"] as $ns_id => $valor_on)
			{
				// Busca un posible registro existente.
				$consulta = "select pfa.* from vtiger_por_facturar pfa, vtiger_crmentity e where e.crmid = pfa.por_facturarid and e.deleted = '0' and pfa.concepto like '".$parametros["codigo_concepto"]."' and pfa.movimiento = '".$this->column_fields["folio"]."' and pfa.numeros_serieid = '$ns_id'";
       				$resultado = $adb->query($consulta);
				$renglon = $adb->fetch_array($resultado);
				$id_por_facturar = $renglon["por_facturarid"];

				$pfa = new Por_facturar;
				if ($id_por_facturar != "")
				{
					$pfa->retrieve_entity_info($id_por_facturar, "Por_facturar");
				}
				$pfa->column_fields["assigned_user_id"] = 1;
				$pfa->column_fields["sucursal"] = $this->column_fields["sucursal"];
				$pfa->column_fields["cliente"] = $this->column_fields["cliente"];
				$pfa->column_fields["obra"] = $this->column_fields["obra"];
				$pfa->column_fields["producto"] = $parametros["prod_id"];
				$pfa->column_fields["cantidad"] = 1;
				$pfa->column_fields["concepto"] = $parametros["concepto"];
				$pfa->column_fields["movimiento"] = $this->column_fields["folio"];
				$pfa->column_fields["estado"] = "Pendiente";
				$pfa->column_fields["numero_serie"] = $ns_id;
				$ns = new Numeros_serie;
				$ns->retrieve_entity_info($ns_id, "Numeros_serie");
				$pfa->column_fields["equipo"] = $ns->obtener_flr();
				$pfa->save("Por_facturar", $id_por_facturar);
			}
		}
		else
		{
			// Busca un posible registro existente.
			$consulta = "select pfa.* from vtiger_por_facturar pfa, vtiger_crmentity e where e.crmid = pfa.por_facturarid and e.deleted = '0' and pfa.concepto like '".$parametros["codigo_concepto"]."' and pfa.movimiento = '".$this->column_fields["folio"]."' and pfa.productid = '".$parametros["prod_id"]."'";
       			$resultado = $adb->query($consulta);
			$renglon = $adb->fetch_array($resultado);
			$id_por_facturar = $renglon["por_facturarid"];

			$pfa = new Por_facturar;
			if ($id_por_facturar != "")
			{
				$pfa->retrieve_entity_info($id_por_facturar, "Por_facturar");
			}
			$pfa->column_fields["assigned_user_id"] = 1;
			$pfa->column_fields["sucursal"] = $this->column_fields["sucursal"];
			$pfa->column_fields["cliente"] = $this->column_fields["cliente"];
			$pfa->column_fields["obra"] = $this->column_fields["obra"];
			$pfa->column_fields["producto"] = $parametros["prod_id"];
			// Guarda número interno si había (caso agrupados).
			$pfa->column_fields["equipo"] = $this->flr_usado($parametros["prod_id"]);
			$pfa->column_fields["cantidad"] = $parametros["cantidad"];
			$pfa->column_fields["concepto"] = $parametros["concepto"];
			$pfa->column_fields["movimiento"] = $this->column_fields["folio"];
			$pfa->column_fields["estado"] = "Pendiente";
			$pfa->save("Por_facturar", $id_por_facturar);
		}
	}

	// Genera un por_facturar de saldo a favor.
	function facturar_saldo_favor($monto)
	{
		$par = new Parametros;
		$id_sf = $par->valor("id_saldo_favor");

		$pfa = new Por_facturar;
		$pfa->column_fields["assigned_user_id"] = 1;
		$pfa->column_fields["sucursal"] = $this->column_fields["sucursal"];
		$pfa->column_fields["cliente"] = $this->column_fields["cliente"];
		$pfa->column_fields["obra"] = $this->column_fields["obra"];
		//$pfa->column_fields["producto"] = 163903;
		$pfa->column_fields["producto"] = $id_sf;
		$pfa->column_fields["cantidad"] = 1;
		$pfa->column_fields["precio_unitario_fac"] = $monto;
		$pfa->column_fields["concepto"] = "Saldo a favor";
		$pfa->column_fields["movimiento"] = $this->column_fields["folio"];
		$pfa->column_fields["estado"] = "Pendiente";
		$pfa->save("Por_facturar");

		$pfa_id = $pfa->obtener_id();
		return $pfa_id;
	}


	function afectar_ot($id_flota, $cantidad, $observaciones, $cargo = 0, $parametros = null)
	{
		global $adb, $current_user;

		$suc_id = $parametros["sucursal"];
		$cli_id = $parametros["cliente"];
		$obr_id = $parametros["obra"];

		$flr = new Flota_renta;
		$flr->retrieve_entity_info($id_flota, "Flota_renta");

		$ot_tipo = "Propio";

		if (substr($flr->column_fields["numero_interno"], 0, 1) == "6")
		{
			$ot_tipo = "Subarrendado";
		}

		if (substr($flr->column_fields["numero_interno"], 0, 1) == "8")
		{
			$ot_tipo = "Cliente";
		}

		// Revisa si este artículo se maneja individual o agrupado. Si es individual se maneja un solo registro de flota y si es agrupado se maneja un registro por cada estado y obra.
		$producto = new Products;
		$producto->retrieve_entity_info($flr->column_fields["producto"], "Products");
		$individual = $producto->individual();

		if ($individual)
		{
			$id_flr = $id_flota;
		}
		else
		{
			$registros_flr = $flr->registros_flota();
			$id_flr = $registros_flr["En servicio"];
		}

		// Crea o actualiza, según sea el caso, la correspondiente orden de trabajo.
		$consulta = "select ot.ordenes_trabajoid from vtiger_ordenes_trabajo ot, vtiger_crmentity e where e.crmid = ot.ordenes_trabajoid and e.deleted = '0' and ot.movimiento = '".$this->column_fields["folio"]."' and ot.flota_rentaid = '$id_flr'";
//var_dump($consulta);
		$resultado = $adb->query($consulta);
		$renglon = $adb->fetch_array($resultado);
		$id_ot = $renglon["ordenes_trabajoid"];

		// Si la orden de trabajo ya está cerrada no afecta nada.
		if (strpos($renglon["estado"], "Cerrad") !== false)
		{
			return;
		}

		$ot = new Ordenes_trabajo;

		if ($id_ot != "")
		{
               		$ot->retrieve_entity_info($id_ot, "Ordenes_trabajo");
		}

		$ot->column_fields["assigned_user_id"] = $current_user->id;
		if ($suc_id == "")
		{
			$ot->column_fields["sucursal"] = $this->column_fields["sucursal"];
		}
		else
		{
			$ot->column_fields["sucursal"] = $suc_id;
		}
		if ($cli_id == "")
		{
			$ot->column_fields["cliente"] = $this->column_fields["cliente"];
		}
		else
		{
			$ot->column_fields["cliente"] = $cli_id;
		}
		if ($obr_id == "")
		{
			$ot->column_fields["obra"] = $this->column_fields["obra"];
		}
		else
		{
			$ot->column_fields["obra"] = $obr_id;
		}
               	$ot->column_fields["equipo"] = $id_flr;
		$ot->column_fields["cantidad"] = $cantidad;
		$ot->column_fields["estado"] = "Abierto";
		$ot->column_fields["fecha_ini"] = $this->column_fields["fecha_efectiva"];
		$ot->column_fields["movimiento"] = $this->column_fields["folio"];
		$ot->column_fields["observaciones"] = $observaciones;
		$ot->column_fields["cargo"] = $cargo;
		$ot->column_fields["ot_tipo"] = $ot_tipo;
//var_dump($ot->column_fields);
		$ot->save("Ordenes_trabajo", $id_ot);
		if ($ot->column_fields["folio"] == "")
		{
			$ot->asignar_folio();
		}
	}

	function fecha_efectiva($folio)
	{
		// Busca la fecha efectiva de un documento a partir de su folio.

		global $adb, $current_user;

		$codigos[] = "entregas";
		$codigos[] = "recolecciones";
		$codigos[] = "cambios";

		foreach ($codigos as $codigo)
		{
			$consulta = "select doc.fecha_efectiva, doc.hora_efectiva from vtiger_$codigo doc, vtiger_crmentity e where e.crmid = doc.{$codigo}id and e.deleted = '0' and doc.folio = '$folio'";
			$resultado = $adb->query($consulta);
			$renglon = $adb->fetch_array($resultado);

			if ($renglon["fecha_efectiva"] != "")
			{
				//$fecha_efectiva = $renglon["fecha_efectiva"];
				$fecha_efectiva["fecha"] = $renglon["fecha_efectiva"];
				$fecha_efectiva["hora"] = $renglon["hora_efectiva"];
				break;
			}
		}

		return $fecha_efectiva;
	}

	function valores_documento($folio)
	{
		// Busca un documento a partir de su folio y devuelve sus valores.

		global $adb, $current_user;

		$codigos[] = "entregas";
		$codigos[] = "recolecciones";
		$codigos[] = "cambios";

		foreach ($codigos as $codigo)
		{
			$consulta = "select doc.* from vtiger_$codigo doc, vtiger_crmentity e where e.crmid = doc.{$codigo}id and e.deleted = '0' and doc.folio = '$folio'";
			$resultado = $adb->query($consulta);
			$renglon = $adb->fetch_array($resultado);

			if ($renglon["folio"] != "")
			{
				$valores_documento = $renglon;
				break;
			}
		}

		return $valores_documento;
	}

	// Bloquea el documento.
	function bloquear($codigo)
	{
		global $adb;

		$id = $this->obtener_id();

		$consulta = "update vtiger_$codigo set bloqueado = '1' where {$codigo}id = '$id'";
//var_dump($consulta);
//die;
		$adb->query($consulta);
	}

	function asignar_folio($modulo, $codigo_modulo, $codigo_documento, $suc_id = null, $tipo = "")
	{
		global $adb;

        	//$codigo_modulo = "Altas_flota_renta";
        	//$codigo_modulo = "altas_flota_renta";
        	//$codigo_documento = "A";
/*****************************
echo "<pre>";
var_dump($this->id);
var_dump($this->column_fields);
die;
**************************/
		$crmid = $this->obtener_id();

        	$sucursal = new Sucursales;
        	if ($suc_id == "")
		{
			$suc_id = $this->column_fields["sucursal"];
		}
        	//$sucursal->retrieve_entity_info($this->column_fields["sucursal"], "Sucursales");
        	$sucursal->retrieve_entity_info($suc_id, "Sucursales");
        	$block_folios = new Blocks_folios;

		if ($tipo == "Borrador")
		{
			$consulta = "select blk.* from vtiger_blocks_folios blk, vtiger_crmentity e where e.crmid = blk.blocks_foliosid and e.deleted = '0' and blk.sucursalesid = '$suc_id' and blk.blk_tipo = 'Borrador' and blk.blk_documento = '$modulo'";
//var_dump($consulta);
//die;
			$resultado = $adb->query($consulta);
			$renglon = $adb->fetch_array($resultado);
//echo "<pre>";
//var_dump($renglon);
//echo "</pre>";
//die;
			$blk_id = $renglon["blocks_foliosid"];
			if ($blk_id == "")
			{
				die ("<h1>ERROR</h1>No se encontró block de tipo borrador para este documento.");
			}

       			$block_folios->retrieve_entity_info($blk_id, "Blocks_folios");
		}
		else
		{
			if ($this->column_fields["subarrendado"])
			{
        			$block_folios->retrieve_entity_info($sucursal->column_fields[$codigo_modulo."_subarrendado"], "Blocks_folios");
//var_dump("sub");
			}
			else
			{
        			$block_folios->retrieve_entity_info($sucursal->column_fields[$codigo_modulo], "Blocks_folios");
//var_dump("normal");
			}
		}
        	//$this->column_fields["folio"] = $sucursal->column_fields["prefijo"].$codigo_documento.$block_folios->column_fields["prefijo"].str_pad($block_folios->column_fields["folio"], 6, "0", STR_PAD_LEFT);
        	$folio = $sucursal->column_fields["prefijo"].$codigo_documento.$block_folios->column_fields["prefijo"].str_pad($block_folios->column_fields["folio"], 6, "0", STR_PAD_LEFT);
        	$this->column_fields["folio"] = $folio;
        	$block_folios->column_fields["folio"]++;
//die;
        	$block_folios->save("Blocks_folios", $block_folios->column_fields["record_id"]);
		//$this->save($modulo, $this->id);
		$this->save($modulo, $crmid);

		//$consulta = "update vtiger_$codigo_modulo set folio = '$folio' where {$codigo_modulo}_id = '".$this->id."'";
		//$adb->query($consulta);

		return $folio;
	}

	// Obtiene el registro de flota con estado "Usado" para un producto agrupado.
	function flr_usado($prod_id)
	{
		$prod = new Products;
		$prod->retrieve_entity_info($prod_id, "Products");

		return $prod->flr_usado();
	}

	// Valida que cliente y obra correspondan.
	function validar_cliente_obra($cli_id, $obr_id)
	{
		global $adb;

		$consulta = "select count(obr.obrasid) as existe from vtiger_obras obr, vtiger_account cli, vtiger_crmentity e, vtiger_crmentity e2 where e.crmid = obr.obrasid and e.deleted = '0' and e2.crmid = cli.accountid and e2.deleted = '0' and obr.obrasid = '$obr_id' and obr.accountid = cli.accountid and cli.accountid = '$cli_id'";
		//var_dump($consulta);
		$resultado = $adb->query($consulta);
		$renglon = $adb->fetch_array($resultado);

		return $renglon["existe"];
	}

	// Devuelve el valor de un campo personalizado o su nombre en la base de datos. 
	function personalizado($codigo, $nombre_campo = false) 
	{ 
		global $adb; 

		$modulo = $this->column_fields["record_module"];
		if ($modulo == "")
		{
			$modulo = get_class($this);
		}
//var_dump($modulo);

		$consulta = "select cpe.* from vtiger_campos_personalizados cpe, vtiger_crmentity e where e.crmid = cpe.campos_personalizadosid and e.deleted = '0' and cpe.modulo = '$modulo' and cpe.codigo = '$codigo'"; 
		//var_dump($consulta); 
		$resultado = $adb->query($consulta); 
		$renglon = $adb->fetch_array($resultado); 

		if ($nombre_campo)
		{
			$valor = "cf_".$renglon["numero"]; 
		}
		else
		{
			$valor = $this->column_fields["cf_".$renglon["numero"]]; 
		}

		return $valor;
	}

	// Actualiza los campos indicados mediante API.
	function actualizar($parametros)
	{
		$crmid = $this->obtener_id();
		$modulo = $this->column_fields["record_module"];
		if ($modulo == "")
		{
			$modulo = get_class($this);
		}

		foreach ($parametros as $campo => $valor)
		{
			$this->column_fields[$campo] = $valor;
		}
		$this->save($modulo, $crmid);
	}

	// Dirige el navegador a la pantalla solicitada.
	function dirigir($accion = "DetailView", $crmid = "", $modulo = "", $parametros = null)
	{
		if ($crmid == "")
		{
			$crmid = $this->obtener_id();
		}

		if ($modulo == "")
		{
			global $currentModule;
			$modulo = $currentModule;
		}

		if (is_array($parametros))
		{
			foreach ($parametros as $parametro => $valor)
			{
				$cadena_parametros .= "&$parametro=$valor";
			}
		}

		echo "<script language=\"javascript\">";
		//echo "document.location = 'index.php?module=$return_module&action=$return_action&record=$return_id'";
		//echo "document.location = 'index.php?module=$modulo&action=$accion&record=$crmid'";
		echo "document.location = 'index.php?module=$modulo&action=$accion&record=$crmid$cadena_parametros'";
		echo "</script>";
	}

	// Elimina el registro actual.
	function eliminar()
	{
		global $adb;

		$consulta = "update vtiger_crmentity e set e.deleted = '1' where e.crmid = '".$this->obtener_id()."'";
		$adb->query($consulta);
	}

	// Obtiene la abreviatura para realizar la interfaz con el sistema administrativo.
	// Devuelve un arreglo con las abreviaturas correspondientes a un campo (pensando en rendimiento de la sincronización).
	function abreviaturas($campo, $modulo = "")
	{
		global $adb;

		if ($modulo == "")
		{
			global $currentModule;
			$modulo = $currentModule;
		}
//var_dump($modulo);

		$consulta = "select eqv.* from vtiger_equivalencias eqv, vtiger_crmentity e where e.crmid = eqv.equivalenciasid and e.deleted = '0' and eqv.modulo_origen_nombre_tecnico = '$modulo' and eqv.campo_origen = '$campo'";
//var_dump($consulta);
		$resultado = $adb->query($consulta);
		$renglon = $adb->fetch_array($resultado);
//echo "<pre>";
//var_dump($renglon);
//echo "</pre>";
//die;
		$eqv_id = $renglon["equivalenciasid"];
		$eqv_valores_visuales_lista = $renglon["valores_visuales_lista"];
		$eqv_valores_interfaz_lista = $renglon["valores_interfaz_lista"];

		$valores_visuales = explode("|", $eqv_valores_visuales_lista);
		$valores_interfaz = explode("|", $eqv_valores_interfaz_lista);

		for ($i = 0; $i <= (count($valores_visuales) - 1); $i++)
		{
			$abreviaturas[$valores_visuales[$i]] = $valores_interfaz[$i];
		}
/************************
	$eqv_folio = $renglon["folio"];
	$eqv_modulo_origen = $renglon["modulo_origen"];
	$eqv_campo_origen = $renglon["campo_origen"];
	$eqv_origen = $renglon["origen"];
	$eqv_destino = $renglon["destino"];
	$eqv_modulo_origen_nombre_tecnico = $renglon["modulo_origen_nombre_tecnico"];
	$eqv_campo_origen_bd = $renglon["campo_origen_bd"];
	$eqv_tabla_origen_bd = $renglon["tabla_origen_bd"];
	$eqv_modulo_destino = $renglon["modulo_destino"];
	$eqv_modulo_destino_nombre_tecnico = $renglon["modulo_destino_nombre_tecnico"];
	$eqv_campo_destino = $renglon["campo_destino"];
	$eqv_campo_destino_bd = $renglon["campo_destino_bd"];
	$eqv_tabla_destino_bd = $renglon["tabla_destino_bd"];
	$eqv_activo = $renglon["activo"];
************************/
//echo "<pre>";
//var_dump($abreviaturas);
//echo "</pre>";
//die;

		return $abreviaturas;
	}

	// Devuelve un arreglo con los campos column_fields del módulo.
	function arreglo_column_fields()
	{
		global $adb;

		$modulo = $this->column_fields["record_module"];
//var_dump($modulo);
		if ($modulo == "")
		{
			$modulo = get_class($this);
		}
//var_dump($modulo);
//var_dump($this->column_fields);

		//if (is_array($this->column_fields))
		if (count($this->column_fields) > 0)
		{
			foreach ($this->column_fields as $codigo => $valor)
			{
				$valor = $codigo;

				if (substr($codigo, 0, 3) == "cf_")
				{
					$consulta = "select cpe.* from vtiger_campos_personalizados cpe, vtiger_crmentity e where e.crmid = cpe.campos_personalizadosid and e.deleted = '0' and cpe.modulo = '$modulo' and concat('cf_', cpe.numero) = '$codigo'"; 
//var_dump($consulta); 
					$resultado = $adb->query($consulta); 
					$renglon = $adb->fetch_array($resultado); 

					if ($renglon["codigo"] != "")
					{
						$valor = $renglon["codigo"];
					}

					if (substr($valor, 0, 3) == "cf_")
					{
						$consulta = "select vtf.* from vtiger_field vtf where vtf.fieldname = '$valor'";
						$resultado = $adb->query($consulta);
						$renglon = $adb->fetch_array($resultado);
						$valor .= " (".$renglon["fieldlabel"].")";
					}
				}

				//echo "$codigo:$valor<br>";
				$arreglo_column_fields[$codigo] = $valor;
			}
		}
		else
		{
			if (file_exists("modules/$modulo/{$modulo}_config.php"))
			{
				require("modules/$modulo/{$modulo}_config.php");
//var_dump($bloques);

				foreach ($bloques as $blq_id => $valores)
				{
					//var_dump($blq_id);
					foreach ($bloques[$blq_id]["campos"] as $codigo => $valores2)
					{
						//var_dump($codigo);
						//var_dump($valores2["etiqueta"]);

						if ($valores2["etiqueta"] != "")
						{
							$arreglo_column_fields[$codigo] = $valores2["etiqueta"];
						}
						else
						{
							$arreglo_column_fields[$codigo] = $codigo;
						}
					}
				}
			}
		}

		header("Content-Type: application/json");
		echo json_encode($arreglo_column_fields);
	}

	// Se conecta a la oreja.
	function oreja_conectar()
	{
		require("oreja_config.php");
		$mysqli = new mysqli($oreja_config["servidor"], $oreja_config["usuario"], $oreja_config["contrasena"], $oreja_config["bd"]);

		// verificar la conexión
		if ($mysqli->connect_errno) 
		{
    			printf("Conexión fallida: %s\n", $mysqli->connect_error);
    			exit();
		}

		return $mysqli;
	}

	// Se desconecta de la oreja.
	function oreja_desconectar($oreja)
	{
		// cerrar la conexión
		$oreja->close();
	}

	// Transmite información a la oreja.
	function oreja_transmitir($oreja, $tabla, $datos = array())
	{
//var_dump("oreja_transmitir");
		foreach ($datos as $campo => $valor)
		{
			$campos[] = $campo;
			$valores[] = "'$valor'";
		}
		$lista_campos = implode(", ", $campos);
		$lista_valores = implode(", ", $valores);

		$consulta = "insert into $tabla ($lista_campos) values($lista_valores)";
/*************
echo "<pre>";
var_dump($consulta);
echo "</pre>";
die;
**************/
		$oreja->query($consulta);
	}

	// Elimina información de la oreja.
	function oreja_limpiar($oreja, $tabla, $campo_id, $valor)
	{
		$consulta = "delete from $tabla where $campo_id = '$valor'";
		$oreja->query($consulta);
	}

	// Obtiene el almacén a utilizar en la oreja.
	function oreja_almacen($documento = "", $prod_id = "", $suc_numero = "01", $concepto = "", $codigo = "")
	{
		require("oreja_config.php");

		global $adb;

		//$almacenes = "";
		$prod = new Products;
		$campo_linea = $prod->personalizado("linea", true);

		$consulta = "select lin.tipo_contable, fam.almacen_recibir, fam.codigo as fam_codigo from vtiger_products prod, vtiger_crmentity e, vtiger_lineas lin, vtiger_familias fam, vtiger_productcf prod2 where e.crmid = prod.productid and e.deleted = '0' and lin.lineasid = prod2.$campo_linea and fam.familiasid = lin.familiasid and prod2.productid = prod.productid and prod.productid = '$prod_id'";
//var_dump($consulta);
//die;
		$resultado = $adb->query($consulta);
		$renglon = $adb->fetch_array($resultado);

		$tipo_contable = $renglon["tipo_contable"];
		$almacen_recibir = $renglon["almacen_recibir"];
		$fam_codigo = $renglon["fam_codigo"];

		if ($documento == "RM")
		{
			if (strpos($almacen_recibir, "Nuevo") !== false)
			{
				//$almacen = "01NVO";
				$almacen = "{$suc_numero}NVO";
			}
			if (strpos($almacen_recibir, "Refacc") !== false)
			{
				//$almacen = "01REF";
				$almacen = "{$suc_numero}REF";
			}
			if (strpos($almacen_recibir, "Herramientas") !== false)
			{
				//$almacen = "01HER";
				$almacen = "{$suc_numero}HER";
			}
			if (strpos($almacen_recibir, "Previs") !== false)
			{
				//$almacen = "01PRE";
				$almacen = "{$suc_numero}PRE";
			}
			if ($tipo_contable == "Equipo ligero")
			{
				$almacen .= "L";
			}
		}

		if ($documento == "AFRS")
		{
			if (strpos($almacen_recibir, "Nuevo") !== false)
			{
				//$almacen = "01NVO";
				$almacen = "{$suc_numero}NVO";
			}
			if ($tipo_contable == "Equipo ligero")
			{
				$almacen .= "L";
			}
		}

		if ($documento == "AFRE")
		{
			if (strpos($almacen_recibir, "Nuevo") !== false)
			{
				//$almacen = "01REN";
				$almacen = "{$suc_numero}REN";
			}
			if ($tipo_contable == "Equipo ligero")
			{
				$almacen .= "L";
			}
		}

		if ($documento == "BFRS")
		{
			if (strpos($almacen_recibir, "Nuevo") !== false)
			{
				//$almacen = "01REN";
				$almacen = "{$suc_numero}REN";
			}
			if ($tipo_contable == "Equipo ligero")
			{
				$almacen .= "L";
			}
		}

		if ($documento == "BFRE")
		{
			if (strpos($almacen_recibir, "Nuevo") !== false)
			{
				//$almacen = "01USA";
				$almacen = "{$suc_numero}USA";
			}
			if ($tipo_contable == "Equipo ligero")
			{
				$almacen .= "L";
			}
		}

		if ($documento == "FRP")
		{
			//$almacen = "01CRE";
			$almacen = "{$suc_numero}CRE";
		}

		if ($documento == "FRS")
		{
			//$almacen = "01CRS";
			$almacen = "{$suc_numero}CRS";
		}

		if ($documento == "FSM")
		{
			//$almacen = "01SER";
			$almacen = "{$suc_numero}SER";
		}

		if ($documento == "FSR")
		{
			//$almacen = "01SER";
			$almacen = "{$suc_numero}SER";
		}

		if ($documento == "FVN")
		{
			if (strpos($almacen_recibir, "Nuevo") !== false)
			{
				//$almacen = "01NVO";
				$almacen = "{$suc_numero}NVO";
			}
			if (strpos($almacen_recibir, "Refacc") !== false)
			{
				//$almacen = "01REF";
				$almacen = "{$suc_numero}REF";
			}
			if (strpos($almacen_recibir, "Herramientas") !== false)
			{
				//$almacen = "01HER";
				$almacen = "{$suc_numero}HER";
			}
			if (strpos($almacen_recibir, "Previs") !== false)
			{
				//$almacen = "01PRE";
				$almacen = "{$suc_numero}PRE";
			}
			if ($tipo_contable == "Equipo ligero")
			{
				$almacen .= "L";
			}
		}

		if ($documento == "FVAF")
		{
			//$almacen = "01VAC";
			$almacen = "{$suc_numero}VAC";
		}

		if ($documento == "FVR")
		{
			//$almacen = "01REF";
			$almacen = "{$suc_numero}REF";
		}

		if ($documento == "FVU")
		{
			if (strpos($almacen_recibir, "Nuevo") !== false)
			{
				//$almacen = "01USA";
				$almacen = "{$suc_numero}USA";
			}
			if (strpos($almacen_recibir, "Refacc") !== false)
			{
				//$almacen = "01REF";
				$almacen = "{$suc_numero}REF";
			}
			if (strpos($almacen_recibir, "Herramientas") !== false)
			{
				//$almacen = "01HER";
				$almacen = "{$suc_numero}HER";
			}
			if (strpos($almacen_recibir, "Previs") !== false)
			{
				//$almacen = "01PRE";
				$almacen = "{$suc_numero}PRE";
			}
			if ($tipo_contable == "Equipo ligero")
			{
				$almacen .= "L";
			}
		}

		if ($documento == "FVAR")
		{
//var_dump($concepto);
			if ($concepto == "Renta de equipo")
			{
				$almacen = "{$suc_numero}CRE";
			}

			if ($concepto == "Venta refacciones")
			{
				$almacen = "{$suc_numero}REF";
			}

			if ($concepto == "Flete")
			{
				$almacen = "{$suc_numero}SER";
			}

			if ($concepto == "Venta nuevo")
			{
				if (strpos($almacen_recibir, "Nuevo") !== false)
				{
					$almacen = "{$suc_numero}NVO";
				}
				if (strpos($almacen_recibir, "Refacc") !== false)
				{
					$almacen = "{$suc_numero}REF";
				}
				if (strpos($almacen_recibir, "Herramientas") !== false)
				{
					$almacen = "{$suc_numero}HER";
				}
				if (strpos($almacen_recibir, "Previs") !== false)
				{
					$almacen = "{$suc_numero}PRE";
				}
				if ($tipo_contable == "Equipo ligero")
				{
					$almacen .= "L";
				}
			}

			if ($concepto == "Venta usado")
			{
				if (strpos($almacen_recibir, "Nuevo") !== false)
				{
					$almacen = "{$suc_numero}USA";
				}
				if (strpos($almacen_recibir, "Refacc") !== false)
				{
					$almacen = "{$suc_numero}REF";
				}
				if (strpos($almacen_recibir, "Herramientas") !== false)
				{
					$almacen = "{$suc_numero}HER";
				}
				if (strpos($almacen_recibir, "Previs") !== false)
				{
					$almacen = "{$suc_numero}PRE";
				}
				if ($tipo_contable == "Equipo ligero")
				{
					$almacen .= "L";
				}
			}

			if (strpos($concepto, "Reparaci") !== false)
			{
				$almacen = "{$suc_numero}REP";
			}

			if ($oreja_config["almacen_especifico"][$codigo] != "")
			{
				$almacen = $suc_numero.$oreja_config["almacen_especifico"][$codigo];
			}
		}

		if ($fam_codigo == "Servicio")
		{
			//$almacen = "01SER";
			$almacen = "{$suc_numero}SER";
		}

		return $almacen;
	}

	// Genera una lista desplegable de sucursales.
	function desplegable_sucursales($nombre)
	{
		global $adb;

		$desplegable = "<select name=\"$nombre\">";
		$desplegable .= "<option value=\"$suc_prefijo\">";
		$desplegable .= "-- Sin asignar --";
		$desplegable .= "</option>";

		$consulta = "select suc.* from vtiger_sucursales suc, vtiger_crmentity e where e.crmid = suc.sucursalesid and e.deleted = '0'";
		//var_dump($consulta);
		$resultado = $adb->query($consulta);
		//$renglon = $adb->fetch_array($resultado);
		while ($renglon = $adb->fetch_array($resultado))
		{
//echo "<pre>";
//var_dump($renglon);
//echo "</pre>";
//die;
			$suc_id = $renglon["sucursalesid"];
			$suc_nombre = $renglon["nombre"];
			$suc_prefijo = $renglon["prefijo"];

			//$desplegable .= "<option value=\"$suc_prefijo\">";
			$desplegable .= "<option value=\"$suc_id\">";
			$desplegable .= "$suc_prefijo ($suc_nombre)";
			$desplegable .= "</option>";
/************************
	$suc_folio = $renglon["folio"];
	$suc_cliente_mks = $renglon["cliente_mks"];
	$suc_obra_mks = $renglon["obra_mks"];
	$suc_domicilio = $renglon["domicilio"];
	$suc_razon_social = $renglon["razon_social"];
	$suc_ciudad_documentos = $renglon["ciudad_documentos"];
	$suc_almacen_nuevo = $renglon["almacen_nuevo"];
	$suc_almacen_flota = $renglon["almacen_flota"];
	$suc_almacen_codigos = $renglon["almacen_codigos"];
	$suc_almacen_refacciones = $renglon["almacen_refacciones"];
	$suc_almacen_herramientas = $renglon["almacen_herramientas"];
	$suc_almacen_servicios = $renglon["almacen_servicios"];
	$suc_almacen_prevision = $renglon["almacen_prevision"];
	$suc_almacen_usado = $renglon["almacen_usado"];
	$suc_recepciones_mercancia = $renglon["recepciones_mercancia"];
	$suc_recepciones_mercancia_subarrendado = $renglon["recepciones_mercancia_subarrendado"];
	$suc_altas_flota_renta = $renglon["altas_flota_renta"];
	$suc_altas_flota_renta_subarrendado = $renglon["altas_flota_renta_subarrendado"];
	$suc_bajas_flota_renta = $renglon["bajas_flota_renta"];
	$suc_bajas_flota_renta_subarrendado = $renglon["bajas_flota_renta_subarrendado"];
	$suc_entregas = $renglon["entregas"];
	$suc_cambios = $renglon["cambios"];
	$suc_recolecciones = $renglon["recolecciones"];
	$suc_ordenes_trabajo = $renglon["ordenes_trabajo"];
	$suc_facturas = $renglon["facturas"];
	$suc_notas_credito = $renglon["notas_credito"];
	$suc_ensambles = $renglon["ensambles"];
	$suc_traspasos = $renglon["traspasos"];
	$suc_salidas_especiales = $renglon["salidas_especiales"];
	$suc_salidas_especiales_subarrendado = $renglon["salidas_especiales_subarrendado"];
	$suc_cotizaciones = $renglon["cotizaciones"];
	$suc_inventario_fisico = $renglon["inventario_fisico"];
	$suc_ordenes_compra = $renglon["ordenes_compra"];
	$suc_notas_credito_proveedor = $renglon["notas_credito_proveedor"];
	$suc_notas_credito_proveedor_subarrendado = $renglon["notas_credito_proveedor_subarrendado"];
************************/
		}

		$desplegable .= "</select>";

		return $desplegable;
	}

	// Devuelve el menú personalizado.
	function menu_personalizado()
	{
		require("modules/Settings/menu_config.php");

//var_dump($config);
		$menu = "<ul>";
		if (is_array($config["raiz"]["opciones"]))
		{
			foreach ($config["raiz"]["opciones"] as $opcion => $valores)
			{
				$menu .= "<li>";
				$menu .= $opcion;
				$menu .= "</li>";
			}
		}
		$menu .= "</ul>";

		return $menu;
	}

	// Genera un control de tipo relacionado.
	function control_relacionado($parametros = array())
	{
/***************************
//$nombre_campo = "lin$i";
$nombre_campo = "lin";
//$nombre_display = "lin{$i}_display";
$nombre_display = "lin_display";
$srcmodule = "";
$modulo_emergente = "Lineas";
$id_registro = "";
$valor_mostrado = "";
//$adicional = "&algo_tipo=".$xyz->column_fields["algorem_tipo"];
***************************/
		$nombre_campo = $parametros["nombre_campo"];
		$nombre_display = $parametros["nombre_display"];
		$modulo_emergente = $parametros["modulo_emergente"];
		$srcmodule = $parametros["srcmodule"];
		//$id_registro = $parametros["id_registro"];
		$id_registro = $parametros["crmid"];
		$valor_mostrado = $parametros["valor_mostrado"];
		$ancho = ($parametros["ancho"] != "")?$parametros["ancho"]:250;

		$control_relacionado =
"
<input id=\"$nombre_campo\" name=\"$nombre_campo\" type=\"hidden\" value=\"$id_registro\" id=\"$nombre_campo\"> <!-- IdeasWWW --> <input id=\"$nombre_display\" name=\"$nombre_display\" id=\"edit_$nombre_display\" readonly type=\"text\" style=\"border:1px solid #bababa;font-size:11px;width:{$ancho}px;\" value=\"$valor_mostrado\">&nbsp; <!-- IdeasWWW --> <img src=\"themes/softed/images/select.gif\" tabindex=\"\" alt=\"Select\" title=\"Select\" LANGUAGE=javascript onclick='return window.open(\"index.php?module=$modulo_emergente&action=Popup&html=Popup_picker&form=vtlibPopupView&forfield=$nombre_campo&srcmodule=$srcmodule&forrecord=$forrecord$adicional\",\"test\",\"width=640,height=602,resizable=0,scrollbars=0,top=150,left=200\");' align=\"absmiddle\" style='cursor:hand;cursor:pointer'>&nbsp; <input type=\"image\" src=\"themes/images/clear_field.gif\" alt=\"Clear\" title=\"Clear\" LANGUAGE=javascript onClick=\"this.form.$nombre_campo.value=''; this.form.$nombre_display.value=''; return false;\" align=\"absmiddle\" style='cursor:hand;cursor:pointer'>&nbsp;
";

		return $control_relacionado;
	}

	// Obtiene el tipo de cambio o lo graba para una fecha específica.
	function tipo_cambio($fecha, $moneda, $valor = null)
	{
		global $adb;
		
		if (is_null($valor))
		{
			$consulta = "select tc.* from vtiger_tipos_cambio tc, vtiger_crmentity e where e.crmid = tc.tipos_cambioid and e.deleted = '0' and tc.fecha = '$fecha' and tc.tc_moneda = '$moneda'";
//var_dump($consulta);
			$resultado = $adb->query($consulta);
			$renglon = $adb->fetch_array($resultado);
//echo "<pre>";
//var_dump($renglon);
//echo "</pre>";
//die;
			$tc_id = $renglon["tipos_cambioid"];
			$tc_tipo_cambio = $renglon["tipo_cambio"];
		}
/************************
	$tc_folio = $renglon["folio"];
	$tc_fecha = $renglon["fecha"];
	$tc_tc_moneda = $renglon["tc_moneda"];
************************/

		return $tc_tipo_cambio;
	}

	// Valida la fecha efectiva de una remisión.
	function validar_fecha_efectiva($descartar_id = '')
	{
		$obr_id = $this->column_fields["obra"];

		if ($obr_id == "")
		{
			die ("<h1>ERROR</h1>No se puede dejar la obra en blanco. (d/crme)");
		}

		$obr = new Obras;
		$obr->retrieve_entity_info($obr_id, "Obras");

		$ultima_remision = $obr->ultima_remision($descartar_id);
//var_dump($ultima_remision);
		// Si no hay remisiones anteriores entonces la fecha es válida.
		if ($ultima_remision["folio"] === null)
		{
			return true;
		}

		$fecha = $this->column_fields["fecha_efectiva"];
		$hora = $this->column_fields["hora_efectiva"];

		$fechador_rem_actual = new DateTime("$fecha $hora", new DateTimeZone("America/Mexico_City"));
		$fechador_rem_ultima = new DateTime($ultima_remision["fecha"]." ".$ultima_remision["hora"], new DateTimeZone("America/Mexico_City"));

//var_dump($fechador_rem_actual->format("Y-m-d H:i:s"));
//var_dump($fechador_rem_ultima->format("Y-m-d H:i:s"));
//var_dump(($fechador_rem_actual <= $fechador_rem_ultima));
		$fecha_valida = ($fechador_rem_actual <= $fechador_rem_ultima)?false:true;

//var_dump($fecha_valida);
//die;
		return $fecha_valida;
	}

	// Decodifica los valores de campos, especialmente column_fields, para comparar.
	function decodificar($valores)
	{
		if (is_array($valores))
		{
			foreach ($valores as $indice => $valor)
			{
				$decodificados[$indice] = html_entity_decode($valor, ENT_QUOTES, "UTF-8");
			}
		}
		else
		{
			$decodificados = html_entity_decode($valores, ENT_QUOTES, "UTF-8");
		}

		return $decodificados;
	}

	// Decodifica haciendo además reemplazos de símbolos.
	function decodificar2($valores)
	{
		//$decodificados = html_entity_decode($valores, ENT_QUOTES, "UTF-8");
		//$decodificados = $valores;
		$decodificados = html_entity_decode($valores, ENT_QUOTES, "ISO-8859-15");
		$decodificados = str_replace('Ã¡', 'á', $decodificados);
		$decodificados = str_replace('Ã©', 'é', $decodificados);
		$decodificados = str_replace('Ã³', 'ó', $decodificados);
		$decodificados = str_replace('Ãº', 'ú', $decodificados);
		$decodificados = str_replace('Ã±', 'ñ', $decodificados);
		$decodificados = str_replace('Ã¼', 'ü', $decodificados);
		$decodificados = str_replace('Ã‰', 'É', $decodificados);
		$decodificados = str_replace('Ã“', 'Ó', $decodificados);
		$decodificados = str_replace('Ãš', 'Ú', $decodificados);
		$decodificados = str_replace('Ã‘', 'Ñ', $decodificados);
		$decodificados = str_replace('Ãœ', 'Ü', $decodificados);
		$decodificados = str_replace('Ã­', 'í', $decodificados);

		return $decodificados;
	}
}
?>
